/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.tile;

import com.google.common.collect.Lists;
import java.util.List;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.block.entity.CustomRenderBoundingBox;
import net.blay09.mods.balm.api.container.BalmContainerProvider;
import net.blay09.mods.balm.api.container.CombinedContainer;
import net.blay09.mods.balm.api.container.ContainerUtils;
import net.blay09.mods.balm.api.container.DefaultContainer;
import net.blay09.mods.balm.api.container.SubContainer;
import net.blay09.mods.balm.api.energy.BalmEnergyStorageProvider;
import net.blay09.mods.balm.api.energy.EnergyStorage;
import net.blay09.mods.balm.api.menu.BalmMenuProvider;
import net.blay09.mods.balm.api.provider.BalmProvider;
import net.blay09.mods.balm.common.BalmBlockEntity;
import net.blay09.mods.cookingforblockheads.CookingForBlockheadsConfig;
import net.blay09.mods.cookingforblockheads.ModSounds;
import net.blay09.mods.cookingforblockheads.api.capability.DefaultKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.capability.IKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.capability.IKitchenSmeltingProvider;
import net.blay09.mods.cookingforblockheads.api.event.OvenCookedEvent;
import net.blay09.mods.cookingforblockheads.block.ModBlocks;
import net.blay09.mods.cookingforblockheads.block.OvenBlock;
import net.blay09.mods.cookingforblockheads.compat.Compat;
import net.blay09.mods.cookingforblockheads.menu.OvenMenu;
import net.blay09.mods.cookingforblockheads.registry.CookingRegistry;
import net.blay09.mods.cookingforblockheads.tile.IMutableNameable;
import net.blay09.mods.cookingforblockheads.tile.ModBlockEntities;
import net.blay09.mods.cookingforblockheads.tile.util.DoorAnimator;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3414;
import net.minecraft.class_3913;
import net.minecraft.class_3956;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.Nullable;

public class OvenBlockEntity
extends BalmBlockEntity
implements IKitchenSmeltingProvider,
BalmMenuProvider,
IMutableNameable,
BalmContainerProvider,
BalmEnergyStorageProvider,
CustomRenderBoundingBox {
    private static final int COOK_TIME = 200;
    private final DefaultContainer container = new DefaultContainer(20){

        public boolean method_5437(int slot, class_1799 itemStack) {
            if (slot < 3) {
                return !OvenBlockEntity.this.getSmeltingResult(itemStack).method_7960();
            }
            if (slot == 3) {
                return OvenBlockEntity.isItemFuel(itemStack);
            }
            return true;
        }

        public void slotChanged(int slot) {
            if (slot >= 7 && slot < 16) {
                OvenBlockEntity.this.slotCookTime[slot - 7] = 0;
            }
            OvenBlockEntity.this.isDirty = true;
            OvenBlockEntity.this.method_5431();
        }
    };
    private final class_3913 dataAccess = new class_3913(){

        public int method_17390(int id) {
            if (id == 0) {
                return OvenBlockEntity.this.furnaceBurnTime;
            }
            if (id == 1) {
                return OvenBlockEntity.this.currentItemBurnTime;
            }
            if (id >= 2 && id <= 11) {
                return OvenBlockEntity.this.slotCookTime[id - 2];
            }
            return 0;
        }

        public void method_17391(int id, int value) {
            if (id == 0) {
                OvenBlockEntity.this.furnaceBurnTime = value;
            } else if (id == 1) {
                OvenBlockEntity.this.currentItemBurnTime = value;
            } else if (id >= 2 && id <= 11) {
                OvenBlockEntity.this.slotCookTime[id - 2] = value;
            }
        }

        public int method_17389() {
            return 11;
        }
    };
    private final EnergyStorage energyStorage = new EnergyStorage(10000){

        public int fill(int maxReceive, boolean simulate) {
            if (!simulate) {
                OvenBlockEntity.this.method_5431();
            }
            return super.fill(maxReceive, simulate);
        }

        public int drain(int maxExtract, boolean simulate) {
            if (!simulate) {
                OvenBlockEntity.this.method_5431();
            }
            return super.drain(maxExtract, simulate);
        }
    };
    private final SubContainer inputContainer = new SubContainer((class_1263)this.container, 0, 3);
    private final SubContainer fuelContainer = new SubContainer((class_1263)this.container, 3, 4);
    private final SubContainer outputContainer = new SubContainer((class_1263)this.container, 4, 7);
    private final SubContainer processingContainer = new SubContainer((class_1263)this.container, 7, 16);
    private final SubContainer toolsContainer = new SubContainer((class_1263)this.container, 16, 20);
    private final DefaultKitchenItemProvider itemProvider = new DefaultKitchenItemProvider((class_1263)new CombinedContainer(new class_1263[]{this.toolsContainer, this.outputContainer}));
    private final DoorAnimator doorAnimator = new DoorAnimator((class_2586)this, 1, 2);
    private class_2561 customName;
    private boolean isFirstTick = true;
    public int[] slotCookTime = new int[9];
    public int furnaceBurnTime;
    public int currentItemBurnTime;
    private boolean isDirty;
    private boolean hasPowerUpgrade;
    private class_2350 facing;
    private final class_1263 singleSlotRecipeWrapper = new DefaultContainer(1);

    public OvenBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)ModBlockEntities.oven.get(), pos, state);
        this.doorAnimator.setSoundEventOpen((class_3414)ModSounds.ovenOpen.get());
        this.doorAnimator.setSoundEventClose((class_3414)ModSounds.ovenClose.get());
    }

    public boolean method_11004(int id, int type) {
        return this.doorAnimator.receiveClientEvent(id, type) || super.method_11004(id, type);
    }

    public static void clientTick(class_1937 level, class_2338 pos, class_2680 state, OvenBlockEntity blockEntity) {
        blockEntity.clientTick(level, pos, state);
    }

    public void clientTick(class_1937 level, class_2338 pos, class_2680 state) {
        this.doorAnimator.update();
    }

    public static void serverTick(class_1937 level, class_2338 pos, class_2680 state, OvenBlockEntity blockEntity) {
        blockEntity.serverTick(level, pos, state);
    }

    public void serverTick(class_1937 level, class_2338 pos, class_2680 state) {
        if (this.isFirstTick && state.method_26204() == ModBlocks.oven) {
            this.facing = (class_2350)state.method_11654((class_2769)OvenBlock.FACING);
            this.isFirstTick = false;
        }
        if (this.isDirty) {
            this.sync();
            this.isDirty = false;
        }
        boolean hasChanged = false;
        int burnPotential = 200 - this.furnaceBurnTime;
        if (this.hasPowerUpgrade && burnPotential > 0 && this.shouldConsumeFuel()) {
            this.furnaceBurnTime += this.energyStorage.drain(burnPotential, false);
        }
        if (this.furnaceBurnTime > 0) {
            --this.furnaceBurnTime;
        }
        if (!level.field_9236) {
            class_1799 itemStack;
            if (this.furnaceBurnTime == 0 && this.shouldConsumeFuel()) {
                for (int i = 0; i < this.fuelContainer.method_5439(); ++i) {
                    class_1799 fuelItem = this.fuelContainer.method_5438(i);
                    if (fuelItem.method_7960()) continue;
                    this.currentItemBurnTime = this.furnaceBurnTime = (int)Math.max(1.0, (double)OvenBlockEntity.getBurnTime(fuelItem) * CookingForBlockheadsConfig.getActive().ovenFuelTimeMultiplier);
                    if (this.furnaceBurnTime == 0) break;
                    class_1799 containerItem = Balm.getHooks().getCraftingRemainingItem(fuelItem);
                    fuelItem.method_7934(1);
                    if (fuelItem.method_7960()) {
                        this.fuelContainer.method_5447(i, containerItem);
                    }
                    hasChanged = true;
                    break;
                }
            }
            int firstEmptySlot = -1;
            int firstTransferSlot = -1;
            for (int i = 0; i < this.processingContainer.method_5439(); ++i) {
                itemStack = this.processingContainer.method_5438(i);
                if (!itemStack.method_7960()) {
                    if (this.slotCookTime[i] != -1) {
                        class_1799 smeltingResult;
                        double maxCookTime = 200.0 * CookingForBlockheadsConfig.getActive().ovenCookTimeMultiplier;
                        if ((double)this.slotCookTime[i] >= maxCookTime && firstTransferSlot == -1) {
                            firstTransferSlot = i;
                            continue;
                        }
                        if (this.furnaceBurnTime > 0) {
                            int n = i;
                            this.slotCookTime[n] = this.slotCookTime[n] + 1;
                        }
                        if (!((double)this.slotCookTime[i] >= maxCookTime) || (smeltingResult = this.getSmeltingResult(itemStack)).method_7960()) continue;
                        class_1799 resultStack = smeltingResult.method_7972();
                        this.processingContainer.method_5447(i, resultStack);
                        Balm.getEvents().fireEvent((Object)new OvenCookedEvent(level, this.field_11867, resultStack));
                        this.slotCookTime[i] = -1;
                        if (firstTransferSlot != -1) continue;
                        firstTransferSlot = i;
                        continue;
                    }
                    if (firstTransferSlot != -1) continue;
                    firstTransferSlot = i;
                    continue;
                }
                if (firstEmptySlot != -1) continue;
                firstEmptySlot = i;
            }
            if (firstTransferSlot != -1) {
                class_1799 transferStack = this.processingContainer.method_5438(firstTransferSlot);
                transferStack = ContainerUtils.insertItemStacked((class_1263)this.outputContainer, (class_1799)transferStack, (boolean)false);
                this.processingContainer.method_5447(firstTransferSlot, transferStack);
                if (transferStack.method_7960()) {
                    this.slotCookTime[firstTransferSlot] = 0;
                }
                hasChanged = true;
            }
            if (firstEmptySlot != -1) {
                for (int j = 0; j < this.inputContainer.method_5439(); ++j) {
                    itemStack = this.inputContainer.method_5438(j);
                    if (itemStack.method_7960()) continue;
                    this.processingContainer.method_5447(firstEmptySlot, itemStack.method_7971(1));
                    if (itemStack.method_7947() > 0) break;
                    this.inputContainer.method_5447(j, class_1799.field_8037);
                    break;
                }
            }
        }
        if (hasChanged) {
            this.method_5431();
        }
    }

    public class_1799 getSmeltingResult(class_1799 itemStack) {
        class_1799 result = CookingRegistry.getSmeltingResult(itemStack);
        if (!result.method_7960()) {
            return result;
        }
        this.singleSlotRecipeWrapper.method_5447(0, itemStack);
        class_1860 recipe = this.field_11863.method_8433().method_8132(class_3956.field_17546, this.singleSlotRecipeWrapper, this.field_11863).orElse(null);
        if (recipe != null && !(result = recipe.method_8110(this.field_11863.method_30349())).method_7960() && result.method_7909().method_19263()) {
            return result;
        }
        if (!result.method_7960() && CookingRegistry.isNonFoodRecipe(result)) {
            return result;
        }
        return class_1799.field_8037;
    }

    public static boolean isItemFuel(class_1799 itemStack) {
        if (CookingForBlockheadsConfig.getActive().ovenRequiresCookingOil) {
            return itemStack.method_31573(Compat.getCookingOilTag());
        }
        return OvenBlockEntity.getBurnTime(itemStack) > 0;
    }

    protected static int getBurnTime(class_1799 itemStack) {
        if (itemStack.method_7960()) {
            return 0;
        }
        if (CookingForBlockheadsConfig.getActive().ovenRequiresCookingOil && itemStack.method_31573(Compat.getCookingOilTag())) {
            return 800;
        }
        return Balm.getHooks().getBurnTime(itemStack);
    }

    private boolean shouldConsumeFuel() {
        for (int i = 0; i < this.processingContainer.method_5439(); ++i) {
            class_1799 cookingStack = this.processingContainer.method_5438(i);
            if (cookingStack.method_7960() || this.slotCookTime[i] == -1) continue;
            return true;
        }
        return false;
    }

    public void method_11014(class_2487 tagCompound) {
        super.method_11014(tagCompound);
        this.container.deserialize(tagCompound.method_10562("ItemHandler"));
        this.furnaceBurnTime = tagCompound.method_10568("BurnTime");
        this.currentItemBurnTime = tagCompound.method_10568("CurrentItemBurnTime");
        this.slotCookTime = tagCompound.method_10561("CookTimes");
        if (this.slotCookTime.length != 9) {
            this.slotCookTime = new int[9];
        }
        this.hasPowerUpgrade = tagCompound.method_10577("HasPowerUpgrade");
        this.energyStorage.setEnergy(tagCompound.method_10550("EnergyStored"));
        if (tagCompound.method_10573("CustomName", 8)) {
            this.customName = class_2561.class_2562.method_10877((String)tagCompound.method_10558("CustomName"));
        }
    }

    public void method_11007(class_2487 tag) {
        super.method_11007(tag);
        tag.method_10566("ItemHandler", (class_2520)this.container.serialize());
        tag.method_10575("BurnTime", (short)this.furnaceBurnTime);
        tag.method_10575("CurrentItemBurnTime", (short)this.currentItemBurnTime);
        tag.method_10539("CookTimes", ArrayUtils.clone((int[])this.slotCookTime));
        tag.method_10556("HasPowerUpgrade", this.hasPowerUpgrade);
        tag.method_10569("EnergyStored", this.energyStorage.getEnergy());
        if (this.customName != null) {
            tag.method_10582("CustomName", class_2561.class_2562.method_10867((class_2561)this.customName));
        }
        if (tag.method_10573("IsForcedOpen", 1)) {
            this.doorAnimator.setForcedOpen(tag.method_10577("IsForcedOpen"));
        }
        if (tag.method_10573("NumPlayersUsing", 1)) {
            this.doorAnimator.setNumPlayersUsing(tag.method_10571("NumPlayersUsing"));
        }
    }

    public void writeUpdateTag(class_2487 tag) {
        this.method_11007(tag);
        tag.method_10556("IsForcedOpen", this.doorAnimator.isForcedOpen());
        tag.method_10567("NumPlayersUsing", (byte)this.doorAnimator.getNumPlayersUsing());
    }

    public boolean hasPowerUpgrade() {
        return this.hasPowerUpgrade;
    }

    public void setHasPowerUpgrade(boolean hasPowerUpgrade) {
        this.hasPowerUpgrade = hasPowerUpgrade;
        class_2680 state = this.field_11863.method_8320(this.field_11867);
        if (state.method_28498((class_2769)OvenBlock.POWERED)) {
            this.field_11863.method_8501(this.field_11867, (class_2680)state.method_11657((class_2769)OvenBlock.POWERED, (Comparable)Boolean.valueOf(hasPowerUpgrade)));
        }
        this.method_5431();
    }

    public boolean isBurning() {
        return this.furnaceBurnTime > 0;
    }

    public float getBurnTimeProgress() {
        if (this.currentItemBurnTime == 0 && this.furnaceBurnTime > 0) {
            return 1.0f;
        }
        return (float)this.furnaceBurnTime / (float)this.currentItemBurnTime;
    }

    public float getCookProgress(int i) {
        return (float)this.slotCookTime[i] / (float)(200.0 * CookingForBlockheadsConfig.getActive().ovenCookTimeMultiplier);
    }

    @Override
    public class_1799 smeltItem(class_1799 itemStack) {
        return ContainerUtils.insertItemStacked((class_1263)this.inputContainer, (class_1799)itemStack, (boolean)false);
    }

    public DoorAnimator getDoorAnimator() {
        return this.doorAnimator;
    }

    public class_1799 getToolItem(int i) {
        return this.toolsContainer.method_5438(i);
    }

    public void setToolItem(int i, class_1799 itemStack) {
        this.toolsContainer.method_5447(i, itemStack);
    }

    public class_1263 getContainer(class_2350 side) {
        if (CookingForBlockheadsConfig.getActive().disallowOvenAutomation) {
            return null;
        }
        if (side == null) {
            return this.getInternalContainer();
        }
        return switch (side) {
            case class_2350.field_11036 -> this.inputContainer;
            case class_2350.field_11033 -> this.outputContainer;
            default -> this.fuelContainer;
        };
    }

    public List<BalmProvider<?>> getProviders() {
        return Lists.newArrayList((Object[])new BalmProvider[]{new BalmProvider(IKitchenItemProvider.class, (Object)this.itemProvider), new BalmProvider(IKitchenSmeltingProvider.class, (Object)this)});
    }

    public class_1263 getInputContainer() {
        return this.inputContainer;
    }

    public class_1263 getFuelContainer() {
        return this.fuelContainer;
    }

    public class_2350 getFacing() {
        return this.facing == null ? class_2350.field_11043 : this.facing;
    }

    @Nullable
    public class_1703 createMenu(int i, class_1661 playerInventory, class_1657 playerEntity) {
        return new OvenMenu(i, playerInventory, this);
    }

    public class_238 getRenderBoundingBox() {
        return new class_238(this.field_11867.method_10069(-1, 0, -1), this.field_11867.method_10069(2, 1, 2));
    }

    public class_2561 method_5477() {
        return this.customName != null ? this.customName : this.getDefaultName();
    }

    @Override
    public void setCustomName(class_2561 customName) {
        this.customName = customName;
        this.method_5431();
    }

    public boolean method_16914() {
        return this.customName != null;
    }

    @Nullable
    public class_2561 method_5797() {
        return this.customName;
    }

    public class_2561 method_5476() {
        return this.method_5477();
    }

    @Override
    public class_2561 getDefaultName() {
        return class_2561.method_43471((String)"container.cookingforblockheads.oven");
    }

    public class_1263 getInternalContainer() {
        return this.container;
    }

    public class_1263 getContainer() {
        if (CookingForBlockheadsConfig.getActive().disallowOvenAutomation) {
            return null;
        }
        return this.container;
    }

    public class_3913 getContainerData() {
        return this.dataAccess;
    }

    public EnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }
}

