/*
 * Decompiled with CFR 0.152.
 */
package appeng.api.upgrades;

import appeng.api.upgrades.IUpgradeInventory;
import appeng.core.localization.GuiText;
import appeng.core.localization.Tooltips;
import appeng.items.materials.EnergyCardItem;
import appeng.items.materials.UpgradeCardItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public final class Upgrades {
    private static final Map<class_1792, List<Association>> ASSOCIATIONS = new IdentityHashMap<class_1792, List<Association>>();
    private static final Map<class_1792, List<class_2561>> UPGRADE_CARD_TOOLTIP_LINES = new IdentityHashMap<class_1792, List<class_2561>>();

    private Upgrades() {
    }

    public static synchronized void add(class_1935 upgradeCard, class_1935 upgradableObject, int maxSupported) {
        Upgrades.add(upgradeCard, upgradableObject, maxSupported, null);
    }

    public static synchronized void add(class_1935 upgradeCard, class_1935 upgradableObject, int maxSupported, @Nullable String tooltipGroup) {
        class_2248 block;
        class_1792 item = upgradableObject.method_8389();
        if (item instanceof class_1747) {
            class_1747 blockItem = (class_1747)item;
            block = blockItem.method_7711();
        } else {
            block = null;
        }
        class_5250 translatedTooltipGroup = tooltipGroup != null ? class_2561.method_43471((String)tooltipGroup) : null;
        Association association = new Association(upgradeCard.method_8389(), item, block, maxSupported, (class_2561)translatedTooltipGroup);
        ASSOCIATIONS.computeIfAbsent(association.upgradeCard(), ignored -> new ArrayList()).add(association);
        UPGRADE_CARD_TOOLTIP_LINES.remove(association.upgradeCard());
    }

    public static synchronized int getMaxInstallable(class_1935 card, class_1935 upgradableItem) {
        List<Association> associations = ASSOCIATIONS.get(card.method_8389());
        if (associations == null) {
            return 0;
        }
        for (Association association : associations) {
            if (association.upgradableItem() != upgradableItem.method_8389()) continue;
            return association.maxCount();
        }
        return 0;
    }

    public static int getEnergyCardMultiplier(IUpgradeInventory upgrades) {
        int multiplier = 0;
        for (class_1799 card : upgrades) {
            class_1792 class_17922 = card.method_7909();
            if (!(class_17922 instanceof EnergyCardItem)) continue;
            EnergyCardItem ec = (EnergyCardItem)class_17922;
            multiplier += ec.getEnergyMultiplier();
        }
        return multiplier;
    }

    public static class_1792 createUpgradeCardItem(class_1792.class_1793 p) {
        return new UpgradeCardItem(p);
    }

    public static boolean isUpgradeCardItem(class_1935 card) {
        return card.method_8389() instanceof UpgradeCardItem;
    }

    public static boolean isUpgradeCardItem(class_1799 stack) {
        return stack.method_7909() instanceof UpgradeCardItem;
    }

    public static synchronized List<class_2561> getTooltipLinesForCard(class_1935 card) {
        return UPGRADE_CARD_TOOLTIP_LINES.computeIfAbsent(card.method_8389(), Upgrades::createTooltipLinesForCard);
    }

    public static synchronized List<class_2561> getTooltipLinesForMachine(class_1935 upgradableItemLike) {
        class_1792 upgradableItem = upgradableItemLike.method_8389();
        ArrayList<class_2561> result = new ArrayList<class_2561>();
        block0: for (List<Association> cardAssociations : ASSOCIATIONS.values()) {
            for (Association association : cardAssociations) {
                if (association.upgradableItem() != upgradableItem) continue;
                result.add((class_2561)GuiText.CompatibleUpgrade.text(association.upgradeCard().method_7848(), association.maxCount()).method_27692(class_124.field_1080));
                continue block0;
            }
        }
        return result;
    }

    private static List<class_2561> createTooltipLinesForCard(class_1792 card) {
        ArrayList<Association> associations = new ArrayList<Association>(ASSOCIATIONS.getOrDefault(card, Collections.emptyList()));
        associations.sort(Comparator.comparingInt(o -> o.maxCount));
        ArrayList<class_2561> supportedTooltipLines = new ArrayList<class_2561>(associations.size());
        HashSet<class_2561> namesAdded = new HashSet<class_2561>();
        for (int i = 0; i < associations.size(); ++i) {
            class_5250 base;
            Association association = (Association)associations.get(i);
            class_2561 name = association.upgradableItem().method_7848();
            if (association.tooltipGroup() != null && namesAdded.contains(association.tooltipGroup())) continue;
            if (association.tooltipGroup() != null) {
                for (int j = i + 1; j < associations.size(); ++j) {
                    class_2561 otherGroup = ((Association)associations.get(j)).tooltipGroup();
                    if (!association.tooltipGroup().equals(otherGroup)) continue;
                    name = association.tooltipGroup();
                    break;
                }
            }
            if (!namesAdded.add(name)) continue;
            class_5250 main = base = name.method_27661().method_27696(Tooltips.NORMAL_TOOLTIP_TEXT);
            if (association.maxCount() > 1) {
                main = Tooltips.of(new class_2561[]{base, Tooltips.of(" ("), Tooltips.ofUnformattedNumber(association.maxCount()), Tooltips.of(")")});
            }
            supportedTooltipLines.add((class_2561)main);
        }
        return supportedTooltipLines;
    }

    private record Association(class_1792 upgradeCard, class_1792 upgradableItem, @Nullable class_2248 upgradableBlock, int maxCount, @Nullable class_2561 tooltipGroup) {
    }
}

