/*
 * Decompiled with CFR 0.152.
 */
package net.adventurez.entity;

import java.util.EnumSet;
import net.adventurez.entity.ShamanEntity;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1588;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;

public abstract class SpellCastingEntity
extends class_1588 {
    private static final class_2940<Byte> SPELL = class_2945.method_12791(SpellCastingEntity.class, (class_2941)class_2943.field_13319);
    protected int spellTicks;
    private Spell spell = Spell.NONE;

    public SpellCastingEntity(class_1299<? extends class_1588> entityType, class_1937 world) {
        super(entityType, world);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(SPELL, (Object)0);
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.spellTicks = tag.method_10550("SpellTicks");
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10569("SpellTicks", this.spellTicks);
    }

    public boolean isSpellcasting() {
        if (this.method_37908().method_8608()) {
            return (Byte)this.field_6011.method_12789(SPELL) > 0;
        }
        return this.spellTicks > 0;
    }

    public void setSpell(Spell spell) {
        this.spell = spell;
        this.field_6011.method_12778(SPELL, (Object)((byte)spell.id));
    }

    protected Spell getSpell() {
        return !this.method_37908().method_8608() ? this.spell : Spell.byId(((Byte)this.field_6011.method_12789(SPELL)).byteValue());
    }

    protected void method_5958() {
        super.method_5958();
        if (this.spellTicks > 0) {
            --this.spellTicks;
        }
    }

    public void method_5773() {
        super.method_5773();
        if (this.method_37908().method_8608() && this.isSpellcasting() && !(this instanceof ShamanEntity)) {
            Spell spell = this.getSpell();
            double d = spell.particleVelocity[0];
            double e = spell.particleVelocity[1];
            double f = spell.particleVelocity[2];
            float g = this.field_6283 * ((float)Math.PI / 180) + class_3532.method_15362((float)((float)this.field_6012 * 0.6662f)) * 0.25f;
            float h = class_3532.method_15362((float)g);
            float i = class_3532.method_15374((float)g);
            this.method_37908().method_8406((class_2394)class_2398.field_11226, this.method_23317() + (double)h * 0.92, this.method_23318() + 2.32, this.method_23321() + (double)i * 0.92, d, e, f);
        }
    }

    protected int getSpellTicks() {
        return this.spellTicks;
    }

    protected abstract class_3414 getCastSpellSound();

    public static enum Spell {
        NONE(0, 0.0, 0.0, 0.0),
        SUMMON_PUPPET(1, 0.01, 0.01, 0.015),
        WITHERING(2, 0.01, 0.01, 0.015),
        SHIELD(3, 0.01, 0.01, 0.01),
        TELEPORT(4, 0.005, 0.005, 0.015),
        THUNDERBOLT(5, 0.015, 0.015, 0.015);

        private final int id;
        private final double[] particleVelocity;

        private Spell(int id, double particleVelocityX, double particleVelocityY, double particleVelocityZ) {
            this.id = id;
            this.particleVelocity = new double[]{particleVelocityX, particleVelocityY, particleVelocityZ};
        }

        public static Spell byId(int id) {
            for (Spell spell : Spell.values()) {
                if (id != spell.id) continue;
                return spell;
            }
            return NONE;
        }
    }

    public class LookAtTargetGoal
    extends class_1352 {
        public LookAtTargetGoal() {
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            return SpellCastingEntity.this.getSpellTicks() > 0;
        }

        public void method_6269() {
            super.method_6269();
            SpellCastingEntity.this.field_6189.method_6340();
        }

        public void method_6270() {
            super.method_6270();
            SpellCastingEntity.this.setSpell(Spell.NONE);
        }

        public void method_6268() {
            if (SpellCastingEntity.this.method_5968() != null) {
                SpellCastingEntity.this.method_5988().method_6226((class_1297)SpellCastingEntity.this.method_5968(), (float)SpellCastingEntity.this.method_5986(), (float)SpellCastingEntity.this.method_5978());
            }
        }
    }

    public abstract class CastSpellGoal
    extends class_1352 {
        protected int spellCooldown;
        protected int startTime;

        protected CastSpellGoal() {
        }

        public boolean method_6264() {
            class_1309 livingEntity = SpellCastingEntity.this.method_5968();
            if (livingEntity != null && livingEntity.method_5805()) {
                if (SpellCastingEntity.this.isSpellcasting()) {
                    return false;
                }
                return SpellCastingEntity.this.field_6012 >= this.startTime;
            }
            return false;
        }

        public boolean method_6266() {
            class_1309 livingEntity = SpellCastingEntity.this.method_5968();
            return livingEntity != null && livingEntity.method_5805() && this.spellCooldown > 0;
        }

        public void method_6269() {
            this.spellCooldown = this.getInitialCooldown();
            SpellCastingEntity.this.spellTicks = this.getSpellTicks();
            this.startTime = SpellCastingEntity.this.field_6012 + this.startTimeDelay();
            class_3414 soundEvent = this.getSoundPrepare();
            if (soundEvent != null) {
                SpellCastingEntity.this.method_5783(soundEvent, 1.0f, 1.0f);
            }
            SpellCastingEntity.this.setSpell(this.getSpell());
        }

        public void method_6268() {
            --this.spellCooldown;
            if (this.spellCooldown == 0) {
                this.castSpell();
                SpellCastingEntity.this.method_5783(SpellCastingEntity.this.getCastSpellSound(), 1.0f, 1.0f);
            }
        }

        protected abstract void castSpell();

        protected int getInitialCooldown() {
            return 20;
        }

        protected abstract int getSpellTicks();

        protected abstract int startTimeDelay();

        @Nullable
        protected abstract class_3414 getSoundPrepare();

        protected abstract Spell getSpell();
    }
}

