/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories;

import io.wispforest.accessories.AccessoriesInternals;
import io.wispforest.accessories.api.events.AllowEntityModificationCallback;
import io.wispforest.accessories.client.AccessoriesMenu;
import io.wispforest.accessories.compat.AccessoriesConfig;
import io.wispforest.accessories.criteria.AccessoryChangedCriterion;
import io.wispforest.accessories.impl.AccessoriesTags;
import io.wispforest.accessories.mixin.CriteriaTriggersAccessor;
import java.util.function.Consumer;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigHolder;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_239;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.class_3966;
import net.minecraft.class_6025;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class Accessories {
    @ApiStatus.Internal
    public static class_1928.class_4313<class_1928.class_4310> RULE_KEEP_ACCESSORY_INVENTORY = null;
    public static final String MODID = "accessories";
    @Nullable
    public static ConfigHolder<AccessoriesConfig> CONFIG_HOLDER = null;
    public static class_3917<AccessoriesMenu> ACCESSORIES_MENU_TYPE;
    public static AccessoryChangedCriterion ACCESSORY_EQUIPPED;
    public static AccessoryChangedCriterion ACCESSORY_UNEQUIPPED;

    public static class_2960 of(String path) {
        return new class_2960(MODID, path);
    }

    public static String translation(String path) {
        return "accessories." + path;
    }

    public static AccessoriesConfig getConfig() {
        if (CONFIG_HOLDER == null) {
            return null;
        }
        return (AccessoriesConfig)CONFIG_HOLDER.getConfig();
    }

    public static void setAndSaveConfig(Consumer<AccessoriesConfig> consumer) {
        consumer.accept(Accessories.getConfig());
        CONFIG_HOLDER.save();
    }

    public static boolean attemptOpenScreenPlayer(class_3222 player) {
        class_239 result = class_1675.method_49998((class_1297)player, e -> e instanceof class_1309, (double)(player.method_7337() ? 4.5 : 4.0));
        if (!(result instanceof class_3966)) {
            return false;
        }
        class_3966 entityHitResult = (class_3966)result;
        Accessories.openAccessoriesMenu((class_1657)player, (class_1309)entityHitResult.method_17782());
        return true;
    }

    public static void openAccessoriesMenu(class_1657 player, @Nullable class_1309 targetEntity) {
        Accessories.openAccessoriesMenu(player, targetEntity, null);
    }

    public static void openAccessoriesMenu(class_1657 player, @Nullable class_1309 targetEntity, @Nullable class_1799 carriedStack) {
        TriState result;
        if (targetEntity != null && !(result = ((AllowEntityModificationCallback)AllowEntityModificationCallback.EVENT.invoker()).allowModifications(targetEntity, player, null)).orElse(false)) {
            return;
        }
        AccessoriesInternals.openAccessoriesMenu(player, targetEntity, carriedStack);
    }

    public static void init() {
        CONFIG_HOLDER = AutoConfig.register(AccessoriesConfig.class, JanksonConfigSerializer::new);
        AllowEntityModificationCallback.EVENT.register((target, player, reference) -> {
            class_6025 ownableEntity;
            boolean isOwnersPet;
            class_1299 type = target.method_5864();
            if (type.method_20210(AccessoriesTags.MODIFIABLE_ENTITY_BLACKLIST)) {
                return TriState.FALSE;
            }
            boolean bl = isOwnersPet = target instanceof class_6025 && (ownableEntity = (class_6025)target).method_35057().equals((Object)player);
            if (isOwnersPet || type.method_20210(AccessoriesTags.MODIFIABLE_ENTITY_WHITELIST)) {
                return TriState.TRUE;
            }
            return TriState.DEFAULT;
        });
    }

    public static void registerCriteria() {
        ACCESSORY_EQUIPPED = CriteriaTriggersAccessor.accessories$callRegister(new AccessoryChangedCriterion(Accessories.of("equip_accessory")));
        ACCESSORY_UNEQUIPPED = CriteriaTriggersAccessor.accessories$callRegister(new AccessoryChangedCriterion(Accessories.of("unequip_accessory")));
    }

    public static void registerMenuType() {
        ACCESSORIES_MENU_TYPE = AccessoriesInternals.registerMenuType(Accessories.of("accessories_menu"), AccessoriesMenu::of);
    }
}

