/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.utils;

import com.gregtechceu.gtceu.utils.FluidKey;
import com.gregtechceu.gtceu.utils.ItemStackHashStrategy;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.lowdraglib.side.fluid.IFluidTransfer;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Object2LongLinkedOpenHashMap;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.class_1799;

public final class GTHashMaps {
    private GTHashMaps() {
    }

    @Nonnull
    public static Object2IntMap<class_1799> fromItemHandler(@Nonnull IItemTransfer inputs) {
        return GTHashMaps.fromItemHandler(inputs, false);
    }

    @Nonnull
    public static Object2IntMap<class_1799> fromItemHandler(@Nonnull IItemTransfer inputs, boolean linked) {
        Object2IntMap<class_1799> map = GTHashMaps.createItemStackMap(linked);
        for (int i = 0; i < inputs.getSlots(); ++i) {
            class_1799 stack = inputs.getStackInSlot(i);
            if (stack.method_7960()) continue;
            map.put((Object)stack.method_7972(), map.getInt((Object)stack) + stack.method_7947());
        }
        return map;
    }

    @Nonnull
    public static Object2IntMap<class_1799> fromItemStackCollection(@Nonnull Iterable<class_1799> inputs) {
        return GTHashMaps.fromItemStackCollection(inputs, false);
    }

    @Nonnull
    public static Object2IntMap<class_1799> fromItemStackCollection(@Nonnull Iterable<class_1799> inputs, boolean linked) {
        Object2IntMap<class_1799> map = GTHashMaps.createItemStackMap(linked);
        for (class_1799 stack : inputs) {
            if (stack.method_7960()) continue;
            map.put((Object)stack.method_7972(), map.getInt((Object)stack) + stack.method_7947());
        }
        return map;
    }

    @Nonnull
    private static Object2IntMap<class_1799> createItemStackMap(boolean linked) {
        ItemStackHashStrategy strategy = ItemStackHashStrategy.comparingAllButCount();
        return linked ? new Object2IntLinkedOpenCustomHashMap((Hash.Strategy)strategy) : new Object2IntOpenCustomHashMap((Hash.Strategy)strategy);
    }

    public static Map<FluidKey, Long> fromFluidHandler(IFluidTransfer fluidInputs) {
        Object2LongLinkedOpenHashMap map = new Object2LongLinkedOpenHashMap();
        for (int i = 0; i < fluidInputs.getTanks(); ++i) {
            FluidStack fluidStack = fluidInputs.getFluidInTank(i);
            if (fluidStack == FluidStack.empty() || fluidStack.getAmount() <= 0L) continue;
            FluidKey key = new FluidKey(fluidStack);
            map.put((Object)key, map.getLong((Object)key) + fluidStack.getAmount());
        }
        return map;
    }

    public static Map<FluidKey, Long> fromFluidCollection(Collection<FluidStack> fluidInputs) {
        Object2LongLinkedOpenHashMap map = new Object2LongLinkedOpenHashMap();
        for (FluidStack fluidStack : fluidInputs) {
            if (fluidStack == null || fluidStack.getAmount() <= 0L) continue;
            FluidKey key = new FluidKey(fluidStack);
            map.put((Object)key, map.getLong((Object)key) + fluidStack.getAmount());
        }
        return map;
    }
}

