/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.rei.recipe;

import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.integration.rei.recipe.GTRecipeDisplay;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ItemStackTexture;
import com.lowdragmc.lowdraglib.rei.IGui2Renderer;
import com.lowdragmc.lowdraglib.rei.ModularUIDisplayCategory;
import com.lowdragmc.lowdraglib.utils.Size;
import java.util.function.Function;
import javax.annotation.Nonnull;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_7923;

public class GTRecipeTypeDisplayCategory
extends ModularUIDisplayCategory<GTRecipeDisplay> {
    public static final Function<GTRecipeType, CategoryIdentifier<GTRecipeDisplay>> CATEGORIES = class_156.method_34866(recipeType -> CategoryIdentifier.of((class_2960)recipeType.registryName));
    private final GTRecipeType recipeType;
    private final Renderer icon;
    private final Size size;

    public GTRecipeTypeDisplayCategory(GTRecipeType recipeType) {
        this.recipeType = recipeType;
        Size size = recipeType.getJEISize();
        this.size = new Size(size.width + 8, size.height + 8);
        this.icon = recipeType.getIconSupplier() != null ? IGui2Renderer.toDrawable((IGuiTexture)new ItemStackTexture(new class_1799[]{recipeType.getIconSupplier().get()})) : IGui2Renderer.toDrawable((IGuiTexture)new ItemStackTexture(new class_1799[]{class_1802.field_8077.method_7854()}));
    }

    public CategoryIdentifier<? extends GTRecipeDisplay> getCategoryIdentifier() {
        return CATEGORIES.apply(this.recipeType);
    }

    public int getDisplayHeight() {
        return this.getSize().height;
    }

    public int getDisplayWidth(GTRecipeDisplay display) {
        return this.getSize().width;
    }

    @Nonnull
    public class_2561 getTitle() {
        return class_2561.method_43471((String)this.recipeType.registryName.method_42094());
    }

    public static void registerDisplays(DisplayRegistry registry) {
        for (class_3956 recipeType : class_7923.field_41188) {
            if (!(recipeType instanceof GTRecipeType)) continue;
            GTRecipeType gtRecipeType = (GTRecipeType)recipeType;
            registry.registerRecipeFiller(GTRecipe.class, (class_3956)gtRecipeType, GTRecipeDisplay::new);
        }
    }

    public static void registerWorkStations(CategoryRegistry registry) {
        for (GTRecipeType gtRecipeType : GTRegistries.RECIPE_TYPES) {
            for (MachineDefinition machine : GTRegistries.MACHINES) {
                if (machine.getRecipeTypes() == null) continue;
                for (GTRecipeType type : machine.getRecipeTypes()) {
                    if (type != gtRecipeType) continue;
                    registry.addWorkstations(CATEGORIES.apply(gtRecipeType), new EntryStack[]{EntryStacks.of((class_1799)machine.asStack())});
                }
            }
        }
    }

    public Renderer getIcon() {
        return this.icon;
    }

    public Size getSize() {
        return this.size;
    }
}

