/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.ae2.util;

import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import com.google.common.collect.Lists;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.integration.ae2.gui.widget.AEConfigWidget;
import com.gregtechceu.gtceu.integration.ae2.machine.MEInputHatchPartMachine;
import com.gregtechceu.gtceu.integration.ae2.util.AEConfigSlot;
import com.gregtechceu.gtceu.integration.ae2.util.ExportOnlyAESlot;
import com.gregtechceu.gtceu.integration.ae2.util.IConfigurableSlot;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.lowdragmc.lowdraglib.gui.ingredient.Target;
import com.lowdragmc.lowdraglib.gui.util.DrawerHelper;
import com.lowdragmc.lowdraglib.gui.util.TextFormattingUtil;
import com.lowdragmc.lowdraglib.side.fluid.FluidActionResult;
import com.lowdragmc.lowdraglib.side.fluid.FluidHelper;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.lowdraglib.side.fluid.FluidTransferHelper;
import com.lowdragmc.lowdraglib.side.fluid.IFluidTransfer;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3611;
import net.minecraft.class_768;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public class AEFluidConfigSlot
extends AEConfigSlot {
    public static final int LOAD_PHANTOM_FLUID_STACK_FROM_NBT = 13;

    public AEFluidConfigSlot(int x, int y, AEConfigWidget widget, int index) {
        super(new Position(x, y), new Size(18, 36), widget, index);
    }

    public void drawInBackground(@NotNull class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        String amountStr;
        FluidStack stack;
        AEFluidKey key;
        AEKey aEKey;
        super.drawInBackground(graphics, mouseX, mouseY, partialTicks);
        Position position = this.getPosition();
        IConfigurableSlot slot = this.parentWidget.getDisplay(this.index);
        GenericStack config = slot.getConfig();
        GenericStack stock = slot.getStock();
        GuiTextures.FLUID_SLOT.draw(graphics, mouseX, mouseY, (float)position.x, (float)position.y, 18, 18);
        GuiTextures.FLUID_SLOT.draw(graphics, mouseX, mouseY, (float)position.x, (float)(position.y + 18), 18, 18);
        GuiTextures.CONFIG_ARROW.draw(graphics, mouseX, mouseY, (float)position.x, (float)position.y, 18, 18);
        if (this.select) {
            GuiTextures.SELECT_BOX.draw(graphics, mouseX, mouseY, (float)position.x, (float)position.y, 18, 18);
        }
        int stackX = position.x + 1;
        int stackY = position.y + 1;
        if (config != null) {
            FluidStack fluidStack;
            aEKey = config.what();
            if (aEKey instanceof AEFluidKey) {
                key = (AEFluidKey)aEKey;
                fluidStack = FluidStack.create((class_3611)key.getFluid(), (long)config.amount(), (class_2487)key.getTag());
            } else {
                fluidStack = FluidStack.empty();
            }
            stack = fluidStack;
            DrawerHelper.drawFluidForGui((class_332)graphics, (FluidStack)stack, (long)config.amount(), (int)stackX, (int)stackY, (int)17, (int)17);
            amountStr = TextFormattingUtil.formatLongToCompactString((long)config.amount(), (int)4) + "mB";
            DrawerHelper.drawStringFixedCorner((class_332)graphics, (String)amountStr, (float)(stackX + 17), (float)(stackY + 17), (int)0xFFFFFF, (boolean)true, (float)0.5f);
        }
        if (stock != null) {
            FluidStack fluidStack;
            aEKey = stock.what();
            if (aEKey instanceof AEFluidKey) {
                key = (AEFluidKey)aEKey;
                fluidStack = FluidStack.create((class_3611)key.getFluid(), (long)stock.amount(), (class_2487)key.getTag());
            } else {
                fluidStack = FluidStack.empty();
            }
            stack = fluidStack;
            DrawerHelper.drawFluidForGui((class_332)graphics, (FluidStack)stack, (long)stock.amount(), (int)stackX, (int)(stackY + 18), (int)17, (int)17);
            amountStr = TextFormattingUtil.formatLongToCompactString((long)stock.amount(), (int)4) + "mB";
            DrawerHelper.drawStringFixedCorner((class_332)graphics, (String)amountStr, (float)(stackX + 17), (float)(stackY + 18 + 17), (int)0xFFFFFF, (boolean)true, (float)0.5f);
        }
        if (this.mouseOverConfig(mouseX, mouseY)) {
            AEFluidConfigSlot.drawSelectionOverlay(graphics, stackX, stackY, 16, 16);
        } else if (this.mouseOverStock(mouseX, mouseY)) {
            AEFluidConfigSlot.drawSelectionOverlay(graphics, stackX, stackY + 18, 16, 16);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.mouseOverConfig(mouseX, mouseY)) {
            if (button == 1) {
                this.parentWidget.disableAmount();
                this.writeClientAction(1000, buf -> {});
            } else if (button == 0) {
                class_1799 hold = this.gui.getModularUIContainer().method_34255();
                FluidStack fluid = FluidTransferHelper.getFluidContained((class_1799)hold);
                if (fluid != null) {
                    this.writeClientAction(1001, buf -> {
                        buf.method_10812(class_7923.field_41173.method_10221((Object)fluid.getFluid()));
                        buf.method_10791(fluid.getAmount());
                    });
                }
                this.parentWidget.enableAmount(this.index);
                this.select = true;
            }
            return true;
        }
        if (this.mouseOverStock(mouseX, mouseY) && button == 0) {
            GenericStack stack = this.parentWidget.getDisplay(this.index).getStock();
            if (stack != null) {
                this.writeClientAction(1003, buf -> buf.writeBoolean(AEFluidConfigSlot.isShiftDown()));
            }
            return true;
        }
        return false;
    }

    public void handleClientAction(int id, class_2540 buffer) {
        boolean isShiftKeyDown;
        int clickResult;
        FluidStack fluid;
        super.handleClientAction(id, buffer);
        IConfigurableSlot slot = this.parentWidget.getConfig(this.index);
        if (id == 1000) {
            slot.setConfig(null);
            this.parentWidget.disableAmount();
            this.writeUpdateInfo(1000, buf -> {});
        }
        if (id == 1001) {
            fluid = FluidStack.create((class_3611)((class_3611)class_7923.field_41173.method_10223(buffer.method_10810())), (long)buffer.method_10792());
            slot.setConfig(new GenericStack((AEKey)AEFluidKey.of((class_3611)fluid.getFluid()), fluid.getAmount()));
            this.parentWidget.enableAmount(this.index);
            if (fluid != FluidStack.empty()) {
                this.writeUpdateInfo(1001, buf -> {
                    buf.method_10812(class_7923.field_41173.method_10221((Object)fluid.getFluid()));
                    buf.method_10791(fluid.getAmount());
                });
            }
        }
        if (id == 1002 && slot.getConfig() != null) {
            int amt = buffer.readInt();
            slot.setConfig(ExportOnlyAESlot.copy(slot.getConfig(), amt));
            this.writeUpdateInfo(1002, buf -> buf.writeInt(amt));
        }
        if (id == 1003 && slot.getStock() != null && (clickResult = this.tryClickContainer(isShiftKeyDown = buffer.readBoolean())) >= 0) {
            this.writeUpdateInfo(1003, buf -> buf.method_10804(clickResult));
        }
        if (id == 13) {
            fluid = FluidStack.loadFromTag((class_2487)buffer.method_10798());
            slot.setConfig(new GenericStack((AEKey)AEFluidKey.of((class_3611)fluid.getFluid()), fluid.getAmount()));
            this.parentWidget.enableAmount(this.index);
            if (fluid != FluidStack.empty()) {
                this.writeUpdateInfo(1001, buf -> {
                    buf.method_10812(class_7923.field_41173.method_10221((Object)fluid.getFluid()));
                    buf.method_10791(fluid.getAmount());
                });
            }
        }
    }

    public void readUpdateInfo(int id, class_2540 buffer) {
        AEKey aEKey;
        super.readUpdateInfo(id, buffer);
        IConfigurableSlot slot = this.parentWidget.getDisplay(this.index);
        if (id == 1000) {
            slot.setConfig(null);
        }
        if (id == 1001) {
            FluidStack fluid = FluidStack.create((class_3611)((class_3611)class_7923.field_41173.method_10223(buffer.method_10810())), (long)buffer.method_10792());
            slot.setConfig(new GenericStack((AEKey)AEFluidKey.of((class_3611)fluid.getFluid()), fluid.getAmount()));
        }
        if (id == 1002 && slot.getConfig() != null) {
            int amt = buffer.readInt();
            slot.setConfig(ExportOnlyAESlot.copy(slot.getConfig(), amt));
        }
        if (id == 1003 && slot.getStock() != null && (aEKey = slot.getStock().what()) instanceof AEFluidKey) {
            GenericStack stack1;
            AEFluidKey key = (AEFluidKey)aEKey;
            class_1799 currentStack = this.gui.getModularUIContainer().method_34255();
            int newStackSize = buffer.method_10816();
            currentStack.method_7939(newStackSize);
            this.gui.getModularUIContainer().method_34254(currentStack);
            FluidStack stack = FluidStack.create((class_3611)key.getFluid(), (long)slot.getStock().amount());
            if (key.hasTag()) {
                stack.setTag(key.getTag().method_10553());
            }
            slot.setStock((stack1 = ExportOnlyAESlot.copy(slot.getStock(), Math.max(0L, slot.getStock().amount() - stack.getAmount()))).amount() == 0L ? null : stack1);
        }
    }

    @Override
    public List<Target> getPhantomTargets(Object ingredient) {
        if (GTUtil.getFluidFromContainer(ingredient) == null) {
            return Collections.emptyList();
        }
        final class_768 rectangle = this.toRectangleBox();
        rectangle.method_35783(rectangle.method_3320() / 2);
        return Lists.newArrayList((Object[])new Target[]{new Target(){

            @Nonnull
            public class_768 getArea() {
                return rectangle;
            }

            public void accept(@Nonnull Object ingredient) {
                FluidStack stack = GTUtil.getFluidFromContainer(ingredient);
                if (stack != null) {
                    class_2487 compound = stack.saveToTag(new class_2487());
                    AEFluidConfigSlot.this.writeClientAction(13, buf -> buf.method_10794(compound));
                }
            }
        }});
    }

    public boolean mouseWheelMove(double mouseX, double mouseY, double wheelDelta) {
        long amt;
        FluidStack fluid;
        IConfigurableSlot slot = this.parentWidget.getDisplay(this.index);
        class_768 rectangle = this.toRectangleBox();
        rectangle.method_35783(rectangle.method_3320() / 2);
        if (slot.getConfig() == null || wheelDelta == 0.0 || !rectangle.method_3318((int)mouseX, (int)mouseY)) {
            return false;
        }
        AEKey aEKey = slot.getConfig().what();
        if (aEKey instanceof AEFluidKey) {
            AEFluidKey fluidKey = (AEFluidKey)aEKey;
            v0 = FluidStack.create((class_3611)fluidKey.getFluid(), (long)slot.getConfig().amount(), (class_2487)fluidKey.getTag());
        } else {
            v0 = fluid = FluidStack.empty();
        }
        if (AEFluidConfigSlot.isCtrlDown()) {
            amt = wheelDelta > 0.0 ? fluid.getAmount() * 2L : fluid.getAmount() / 2L;
        } else {
            long l = amt = wheelDelta > 0.0 ? fluid.getAmount() + 1L : fluid.getAmount() - 1L;
        }
        if (amt > 0L && amt < 0x80000000L) {
            int finalAmt = (int)amt;
            this.writeClientAction(1002, buf -> buf.writeInt(finalAmt));
            return true;
        }
        return false;
    }

    private int tryClickContainer(boolean isShiftKeyDown) {
        int maxAttempts;
        MEInputHatchPartMachine.ExportOnlyAEFluid fluid;
        MEInputHatchPartMachine.ExportOnlyAEFluid fluidTank;
        IConfigurableSlot iConfigurableSlot = this.parentWidget.getConfig(this.index);
        MEInputHatchPartMachine.ExportOnlyAEFluid exportOnlyAEFluid = fluidTank = iConfigurableSlot instanceof MEInputHatchPartMachine.ExportOnlyAEFluid ? (fluid = (MEInputHatchPartMachine.ExportOnlyAEFluid)iConfigurableSlot) : null;
        if (fluidTank == null) {
            return -1;
        }
        class_1657 player = this.gui.entityPlayer;
        class_1799 currentStack = this.gui.getModularUIContainer().method_34255();
        IFluidTransfer handler = FluidTransferHelper.getFluidTransfer((class_1657)this.gui.entityPlayer, (class_1703)this.gui.getModularUIContainer());
        if (handler == null) {
            return -1;
        }
        int n = maxAttempts = isShiftKeyDown ? currentStack.method_7947() : 1;
        if (fluidTank.getFluidAmount() > 0L) {
            FluidActionResult result;
            boolean performedFill = false;
            FluidStack initialFluid = fluidTank.getFluid();
            for (int i = 0; i < maxAttempts && (result = FluidTransferHelper.tryFillContainer((class_1799)currentStack, (IFluidTransfer)fluidTank, (int)Integer.MAX_VALUE, null, (boolean)false)).isSuccess(); ++i) {
                class_1799 remainingStack = FluidTransferHelper.tryFillContainer((class_1799)currentStack, (IFluidTransfer)fluidTank, (int)Integer.MAX_VALUE, null, (boolean)true).getResult();
                currentStack.method_7934(1);
                performedFill = true;
                if (remainingStack.method_7960() || player.method_7270(remainingStack)) continue;
                class_2248.method_9577((class_1937)player.method_37908(), (class_2338)player.method_23312(), (class_1799)remainingStack);
                break;
            }
            if (performedFill) {
                class_3414 soundevent = FluidHelper.getFillSound((FluidStack)initialFluid);
                if (soundevent != null) {
                    player.method_37908().method_43128(null, player.method_19538().field_1352, player.method_19538().field_1351 + 0.5, player.method_19538().field_1350, soundevent, class_3419.field_15245, 1.0f, 1.0f);
                }
                this.gui.getModularUIContainer().method_34254(currentStack);
                return currentStack.method_7947();
            }
        }
        return -1;
    }
}

