/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.ae2.gui.widget;

import appeng.api.stacks.GenericStack;
import com.gregtechceu.gtceu.integration.ae2.util.AEConfigSlot;
import com.gregtechceu.gtceu.integration.ae2.util.AmountSetSlot;
import com.gregtechceu.gtceu.integration.ae2.util.IConfigurableSlot;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import net.minecraft.class_2540;

public abstract class AEConfigWidget
extends WidgetGroup {
    protected final IConfigurableSlot[] config;
    protected IConfigurableSlot[] cached;
    protected Int2ObjectMap<IConfigurableSlot> changeMap = new Int2ObjectOpenHashMap();
    protected IConfigurableSlot[] displayList;
    protected AmountSetSlot amountSetWidget;
    protected static final int UPDATE_ID = 1000;

    public AEConfigWidget(int x, int y, IConfigurableSlot[] config) {
        super(new Position(x, y), new Size(config.length / 2 * 18, 74));
        this.config = config;
        this.init();
        this.amountSetWidget = new AmountSetSlot(80, -40, this);
        this.addWidget(this.amountSetWidget);
        this.addWidget((Widget)this.amountSetWidget.getAmountText());
        this.amountSetWidget.setVisible(false);
        this.amountSetWidget.getAmountText().setVisible(false);
    }

    public void enableAmount(int slotIndex) {
        this.amountSetWidget.setSlotIndex(slotIndex);
        this.amountSetWidget.setVisible(true);
        this.amountSetWidget.getAmountText().setVisible(true);
    }

    public void disableAmount() {
        this.amountSetWidget.setSlotIndex(-1);
        this.amountSetWidget.setVisible(false);
        this.amountSetWidget.getAmountText().setVisible(false);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.amountSetWidget.isVisible() && this.amountSetWidget.getAmountText().mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        for (Widget w : this.widgets) {
            if (!(w instanceof AEConfigSlot)) continue;
            AEConfigSlot slot = (AEConfigSlot)w;
            slot.setSelect(false);
        }
        this.disableAmount();
        return super.mouseClicked(mouseX, mouseY, button);
    }

    abstract void init();

    public void detectAndSendChanges() {
        super.detectAndSendChanges();
        this.changeMap.clear();
        for (int index = 0; index < this.config.length; ++index) {
            IConfigurableSlot newSlot = this.config[index];
            IConfigurableSlot oldSlot = this.cached[index];
            GenericStack nConfig = newSlot.getConfig();
            GenericStack nStock = newSlot.getStock();
            GenericStack oConfig = oldSlot.getConfig();
            GenericStack oStock = oldSlot.getStock();
            if (this.areAEStackCountsEqual(nConfig, oConfig) && this.areAEStackCountsEqual(nStock, oStock)) continue;
            this.changeMap.put(index, (Object)newSlot.copy());
            this.cached[index] = this.config[index].copy();
            this.gui.holder.markAsDirty();
        }
        if (!this.changeMap.isEmpty()) {
            this.writeUpdateInfo(1000, buf -> {
                buf.method_10804(this.changeMap.size());
                IntIterator intIterator = this.changeMap.keySet().iterator();
                while (intIterator.hasNext()) {
                    int index = (Integer)intIterator.next();
                    GenericStack sConfig = ((IConfigurableSlot)this.changeMap.get(index)).getConfig();
                    GenericStack sStock = ((IConfigurableSlot)this.changeMap.get(index)).getStock();
                    buf.method_10804(index);
                    if (sConfig != null) {
                        buf.writeBoolean(true);
                        GenericStack.writeBuffer((GenericStack)sConfig, (class_2540)buf);
                    } else {
                        buf.writeBoolean(false);
                    }
                    if (sStock != null) {
                        buf.writeBoolean(true);
                        GenericStack.writeBuffer((GenericStack)sStock, (class_2540)buf);
                        continue;
                    }
                    buf.writeBoolean(false);
                }
            });
        }
    }

    public void readUpdateInfo(int id, class_2540 buffer) {
        super.readUpdateInfo(id, buffer);
        if (id == 1000) {
            int size = buffer.method_10816();
            for (int i = 0; i < size; ++i) {
                int index = buffer.method_10816();
                IConfigurableSlot slot = this.displayList[index];
                if (buffer.readBoolean()) {
                    slot.setConfig(GenericStack.readBuffer((class_2540)buffer));
                } else {
                    slot.setConfig(null);
                }
                if (buffer.readBoolean()) {
                    slot.setStock(GenericStack.readBuffer((class_2540)buffer));
                    continue;
                }
                slot.setStock(null);
            }
        }
    }

    public final IConfigurableSlot getConfig(int index) {
        return this.config[index];
    }

    public final IConfigurableSlot getDisplay(int index) {
        return this.displayList[index];
    }

    protected final boolean areAEStackCountsEqual(GenericStack s1, GenericStack s2) {
        if (s2 == s1) {
            return true;
        }
        if (s1 != null && s2 != null) {
            return s1.amount() == s2.amount() && s1.what().matches(s2);
        }
        return false;
    }
}

