/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.WidgetUtils;
import com.gregtechceu.gtceu.api.gui.widget.PredicatedButtonWidget;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.RecipeCondition;
import com.gregtechceu.gtceu.api.recipe.RecipeHelper;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gregtechceu.gtceu.utils.CycleFluidStorage;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.lowdragmc.lowdraglib.gui.compass.CompassManager;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.ProgressWidget;
import com.lowdragmc.lowdraglib.gui.widget.SlotWidget;
import com.lowdragmc.lowdraglib.gui.widget.TankWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.lowdragmc.lowdraglib.utils.CycleItemStackHandler;
import com.lowdragmc.lowdraglib.utils.LocalizationUtils;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1856;
import net.minecraft.class_2561;
import net.minecraft.class_310;

public class GTRecipeWidget
extends WidgetGroup {
    public GTRecipeWidget(GTRecipe recipe) {
        super(0, 0, recipe.recipeType.getJEISize().width, recipe.recipeType.getJEISize().height);
        this.setClientSideWidget();
        ArrayList<Content> inputStackContents = new ArrayList<Content>();
        inputStackContents.addAll(recipe.getInputContents(ItemRecipeCapability.CAP));
        inputStackContents.addAll(recipe.getTickInputContents(ItemRecipeCapability.CAP));
        List inputStacks = inputStackContents.stream().map(content -> content.content).map(ItemRecipeCapability.CAP::of).map(class_1856::method_8105).map(Arrays::stream).map(Stream::toList).collect(Collectors.toList());
        while (inputStacks.size() < recipe.recipeType.getMaxInputs(ItemRecipeCapability.CAP)) {
            inputStacks.add(null);
        }
        ArrayList<Content> outputStackContents = new ArrayList<Content>();
        outputStackContents.addAll(recipe.getOutputContents(ItemRecipeCapability.CAP));
        outputStackContents.addAll(recipe.getTickOutputContents(ItemRecipeCapability.CAP));
        List outputStacks = outputStackContents.stream().map(content -> content.content).map(ItemRecipeCapability.CAP::of).map(class_1856::method_8105).map(Arrays::stream).map(Stream::toList).collect(Collectors.toList());
        while (outputStacks.size() < recipe.recipeType.getMaxOutputs(ItemRecipeCapability.CAP)) {
            outputStacks.add(null);
        }
        ArrayList<Content> inputFluidContents = new ArrayList<Content>();
        inputFluidContents.addAll(recipe.getInputContents(FluidRecipeCapability.CAP));
        inputFluidContents.addAll(recipe.getTickInputContents(FluidRecipeCapability.CAP));
        List<List<FluidStack>> inputFluids = inputFluidContents.stream().map(content -> content.content).map(FluidRecipeCapability.CAP::of).map(FluidIngredient::getStacks).map(Arrays::stream).map(Stream::toList).collect(Collectors.toList());
        while (inputFluids.size() < recipe.recipeType.getMaxInputs(FluidRecipeCapability.CAP)) {
            inputFluids.add(null);
        }
        ArrayList<Content> outputFluidContents = new ArrayList<Content>();
        outputFluidContents.addAll(recipe.getOutputContents(FluidRecipeCapability.CAP));
        outputFluidContents.addAll(recipe.getTickOutputContents(FluidRecipeCapability.CAP));
        List<List<FluidStack>> outputFluids = outputFluidContents.stream().map(content -> content.content).map(FluidRecipeCapability.CAP::of).map(FluidIngredient::getStacks).map(Arrays::stream).map(Stream::toList).collect(Collectors.toList());
        while (outputFluids.size() < recipe.recipeType.getMaxOutputs(FluidRecipeCapability.CAP)) {
            outputFluids.add(null);
        }
        WidgetGroup group = recipe.recipeType.createUITemplate(ProgressWidget.JEIProgress, (IItemTransfer)new CycleItemStackHandler(inputStacks), (IItemTransfer)new CycleItemStackHandler(outputStacks), new CycleFluidStorage(inputFluids), new CycleFluidStorage(outputFluids));
        WidgetUtils.widgetByIdForEach(group, "^%s_[0-9]+$".formatted(ItemRecipeCapability.CAP.slotName(IO.IN)), SlotWidget.class, slot -> {
            int index = WidgetUtils.widgetIdIndex((Widget)slot);
            if (index >= 0 && index < inputStackContents.size()) {
                Content content = (Content)inputStackContents.get(index);
                slot.setXEIChance(content.chance);
                slot.setOverlay(content.createOverlay(index >= recipe.getInputContents(ItemRecipeCapability.CAP).size()));
                slot.setOnAddedTooltips((w, tooltips) -> {
                    float chance = content.chance;
                    if (chance < 1.0f) {
                        tooltips.add(chance == 0.0f ? class_2561.method_43471((String)"gtceu.gui.content.chance_0") : class_2561.method_43469((String)"gtceu.gui.content.chance_1", (Object[])new Object[]{String.format("%.1f", Float.valueOf(chance * 100.0f)) + "%"}));
                        if (content.tierChanceBoost > 0.0f) {
                            tooltips.add(class_2561.method_43469((String)"gtceu.gui.content.tier_boost", (Object[])new Object[]{String.format("%.1f", Float.valueOf(content.tierChanceBoost * 100.0f)) + "%"}));
                        }
                    }
                    if (index >= recipe.getInputContents(ItemRecipeCapability.CAP).size()) {
                        tooltips.add(class_2561.method_43471((String)"gtceu.gui.content.per_tick"));
                    }
                });
            }
        });
        WidgetUtils.widgetByIdForEach(group, "^%s_[0-9]+$".formatted(ItemRecipeCapability.CAP.slotName(IO.OUT)), SlotWidget.class, slot -> {
            int index = WidgetUtils.widgetIdIndex((Widget)slot);
            if (index >= 0 && index < outputStackContents.size()) {
                Content content = (Content)outputStackContents.get(index);
                slot.setXEIChance(content.chance);
                slot.setOverlay(content.createOverlay(index >= recipe.getOutputContents(ItemRecipeCapability.CAP).size()));
                slot.setOnAddedTooltips((w, tooltips) -> {
                    float chance = content.chance;
                    if (chance < 1.0f) {
                        tooltips.add(chance == 0.0f ? class_2561.method_43471((String)"gtceu.gui.content.chance_0") : class_2561.method_43469((String)"gtceu.gui.content.chance_1", (Object[])new Object[]{String.format("%.1f", Float.valueOf(chance * 100.0f)) + "%"}));
                        if (content.tierChanceBoost > 0.0f) {
                            tooltips.add(class_2561.method_43469((String)"gtceu.gui.content.tier_boost", (Object[])new Object[]{String.format("%.1f", Float.valueOf(content.tierChanceBoost * 100.0f)) + "%"}));
                        }
                    }
                    if (index >= recipe.getOutputContents(ItemRecipeCapability.CAP).size()) {
                        tooltips.add(class_2561.method_43471((String)"gtceu.gui.content.per_tick"));
                    }
                });
            }
        });
        WidgetUtils.widgetByIdForEach(group, "^%s_[0-9]+$".formatted(FluidRecipeCapability.CAP.slotName(IO.IN)), TankWidget.class, tank -> {
            int index = WidgetUtils.widgetIdIndex((Widget)tank);
            if (index >= 0 && index < inputFluidContents.size()) {
                Content content = (Content)inputFluidContents.get(index);
                tank.setXEIChance(content.chance);
                tank.setOverlay(content.createOverlay(index >= recipe.getInputContents(FluidRecipeCapability.CAP).size()));
                tank.setOnAddedTooltips((w, tooltips) -> {
                    float chance = content.chance;
                    if (chance < 1.0f) {
                        tooltips.add(chance == 0.0f ? class_2561.method_43471((String)"gtceu.gui.content.chance_0") : class_2561.method_43469((String)"gtceu.gui.content.chance_1", (Object[])new Object[]{String.format("%.1f", Float.valueOf(chance * 100.0f)) + "%"}));
                        if (content.tierChanceBoost > 0.0f) {
                            tooltips.add(class_2561.method_43469((String)"gtceu.gui.content.tier_boost", (Object[])new Object[]{String.format("%.1f", Float.valueOf(content.tierChanceBoost * 100.0f)) + "%"}));
                        }
                    }
                    if (index >= recipe.getInputContents(FluidRecipeCapability.CAP).size()) {
                        tooltips.add(class_2561.method_43471((String)"gtceu.gui.content.per_tick"));
                    }
                });
            }
        });
        WidgetUtils.widgetByIdForEach(group, "^%s_[0-9]+$".formatted(FluidRecipeCapability.CAP.slotName(IO.OUT)), TankWidget.class, tank -> {
            int index = WidgetUtils.widgetIdIndex((Widget)tank);
            if (index >= 0 && index < outputFluidContents.size()) {
                Content content = (Content)outputFluidContents.get(index);
                tank.setXEIChance(content.chance);
                tank.setOverlay(content.createOverlay(index >= recipe.getOutputContents(FluidRecipeCapability.CAP).size()));
                tank.setOnAddedTooltips((w, tooltips) -> {
                    float chance = content.chance;
                    if (chance < 1.0f) {
                        tooltips.add(chance == 0.0f ? class_2561.method_43471((String)"gtceu.gui.content.chance_0") : class_2561.method_43469((String)"gtceu.gui.content.chance_1", (Object[])new Object[]{String.format("%.1f", Float.valueOf(chance * 100.0f)) + "%"}));
                        if (content.tierChanceBoost > 0.0f) {
                            tooltips.add(class_2561.method_43469((String)"gtceu.gui.content.tier_boost", (Object[])new Object[]{String.format("%.1f", Float.valueOf(content.tierChanceBoost * 100.0f)) + "%"}));
                        }
                    }
                    if (index >= recipe.getOutputContents(FluidRecipeCapability.CAP).size()) {
                        tooltips.add(class_2561.method_43471((String)"gtceu.gui.content.per_tick"));
                    }
                });
            }
        });
        Size size = group.getSize();
        group.setSelfPosition(new Position((176 - size.width) / 2, 0));
        this.addWidget((Widget)group);
        int yOffset = 5 + size.height;
        this.addWidget((Widget)new LabelWidget(3, yOffset, LocalizationUtils.format((String)"gtceu.recipe.duration", (Object[])new Object[]{Float.valueOf((float)recipe.duration / 20.0f)})));
        long EUt = RecipeHelper.getInputEUt(recipe);
        boolean isOutput = false;
        if (EUt == 0L) {
            EUt = RecipeHelper.getOutputEUt(recipe);
            isOutput = true;
        }
        if (EUt > 0L) {
            this.addWidget((Widget)new LabelWidget(3, yOffset += 10, LocalizationUtils.format((String)"gtceu.recipe.total", (Object[])new Object[]{EUt * (long)recipe.duration})));
            this.addWidget((Widget)new LabelWidget(3, yOffset += 10, LocalizationUtils.format((String)(!isOutput ? "gtceu.recipe.eu" : "gtceu.recipe.eu_inverted"), (Object[])new Object[]{EUt, GTValues.VN[GTUtil.getTierByVoltage(EUt)]})));
        }
        for (RecipeCondition recipeCondition : recipe.conditions) {
            if (recipeCondition.getTooltips() == null) continue;
            this.addWidget((Widget)new LabelWidget(3, yOffset += 10, recipeCondition.getTooltips().getString()));
        }
        for (Function function : recipe.recipeType.getDataInfos()) {
            this.addWidget((Widget)new LabelWidget(3, yOffset += 10, (String)function.apply(recipe.data)));
        }
        recipe.recipeType.appendJEIUI(recipe, this);
        this.addWidget(new PredicatedButtonWidget(this.getSize().width + 3, 3, 15, 15, (IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{GuiTextures.BUTTON, new TextTexture("ID")}), cd -> class_310.method_1551().field_1774.method_1455(recipe.id.toString())).setPredicate(() -> CompassManager.INSTANCE.devMode).setHoverTooltips(new String[]{"click to copy: " + recipe.id}));
    }
}

