/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.data.recipe.generated;

import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.DustProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialStack;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.data.recipe.misc.RecyclingRecipes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_2444;

public class RecyclingRecipeHandler {
    private static final List<Object> CRUSHING_PREFIXES = Arrays.asList(TagPrefix.ingot, TagPrefix.gem, TagPrefix.rod, TagPrefix.plate, TagPrefix.ring, TagPrefix.rodLong, TagPrefix.foil, TagPrefix.bolt, TagPrefix.screw, TagPrefix.nugget, TagPrefix.gearSmall, TagPrefix.gear, TagPrefix.frameGt, TagPrefix.plateDense, TagPrefix.spring, TagPrefix.springSmall, TagPrefix.block, TagPrefix.wireFine, TagPrefix.rotor, TagPrefix.lens, TagPrefix.turbineBlade, TagPrefix.round, TagPrefix.plateDouble, TagPrefix.dust, orePrefix -> orePrefix.name().startsWith("toolHead"), orePrefix -> orePrefix.name().startsWith("gem"), orePrefix -> orePrefix.name().startsWith("cableGt"), orePrefix -> orePrefix.name().startsWith("wireGt"), orePrefix -> orePrefix.name().startsWith("pipe"));
    private static final List<TagPrefix> IGNORE_ARC_SMELTING = Arrays.asList(TagPrefix.ingot, TagPrefix.gem, TagPrefix.nugget);

    public static void init(Consumer<class_2444> provider) {
        for (TagPrefix orePrefix : TagPrefix.values()) {
            if (!CRUSHING_PREFIXES.stream().anyMatch(object -> {
                if (object instanceof TagPrefix) {
                    return object == orePrefix;
                }
                if (object instanceof Predicate) {
                    return ((Predicate)object).test(orePrefix);
                }
                return false;
            })) continue;
            orePrefix.executeHandler(PropertyKey.DUST, (tagPrefix, material, property) -> RecyclingRecipeHandler.processCrushing(tagPrefix, material, property, provider));
        }
    }

    public static void processCrushing(TagPrefix thingPrefix, Material material, DustProperty property, Consumer<class_2444> provider) {
        ArrayList<MaterialStack> materialStacks = new ArrayList<MaterialStack>();
        materialStacks.add(new MaterialStack(material, thingPrefix.getMaterialAmount(material)));
        materialStacks.addAll(thingPrefix.secondaryMaterials());
        boolean ignoreArcSmelting = IGNORE_ARC_SMELTING.contains(thingPrefix) && (!material.hasProperty(PropertyKey.INGOT) || material.getProperty(PropertyKey.INGOT).getArcSmeltingInto() == material);
        RecyclingRecipes.registerRecyclingRecipes(provider, ChemicalHelper.get(thingPrefix, material), materialStacks, ignoreArcSmelting, thingPrefix);
    }
}

