/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.pipelike.laser;

import com.gregtechceu.gtceu.api.capability.ILaserContainer;
import com.gregtechceu.gtceu.common.blockentity.LaserPipeBlockEntity;
import com.gregtechceu.gtceu.common.pipelike.laser.LaserPipeNet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;

public class LaserNetHandler
implements ILaserContainer {
    private LaserPipeNet net;
    private final LaserPipeBlockEntity pipe;
    private final class_2350 facing;
    private final class_1937 world;

    public LaserNetHandler(LaserPipeNet net, @Nonnull LaserPipeBlockEntity pipe, @Nullable class_2350 facing) {
        this.net = net;
        this.pipe = pipe;
        this.facing = facing;
        this.world = pipe.method_10997();
    }

    public void updateNetwork(LaserPipeNet net) {
        this.net = net;
    }

    private void setPipesActive() {
        for (class_2338 pos : this.net.getAllNodes().keySet()) {
            class_2586 class_25862 = this.world.method_8321(pos);
            if (!(class_25862 instanceof LaserPipeBlockEntity)) continue;
            LaserPipeBlockEntity laserPipe = (LaserPipeBlockEntity)class_25862;
            laserPipe.setActive(true, 100);
        }
    }

    @Nullable
    private ILaserContainer getInnerContainer() {
        if (this.net == null || this.pipe == null || this.pipe.isInValid() || this.facing == null || this.pipe.isBlocked(this.facing)) {
            return null;
        }
        LaserPipeNet.LaserData data = this.net.getNetData(this.pipe.getPipePos(), this.facing);
        if (data == null) {
            return null;
        }
        return data.getHandler(this.world);
    }

    @Override
    public long acceptEnergyFromNetwork(class_2350 side, long voltage, long amperage) {
        ILaserContainer handler = this.getInnerContainer();
        if (handler == null) {
            return 0L;
        }
        this.setPipesActive();
        return handler.acceptEnergyFromNetwork(side, voltage, amperage);
    }

    @Override
    public boolean inputsEnergy(class_2350 side) {
        ILaserContainer handler = this.getInnerContainer();
        if (handler == null) {
            return false;
        }
        return handler.inputsEnergy(side);
    }

    @Override
    public boolean outputsEnergy(class_2350 side) {
        ILaserContainer handler = this.getInnerContainer();
        if (handler == null) {
            return false;
        }
        return handler.outputsEnergy(side);
    }

    @Override
    public long changeEnergy(long amount) {
        ILaserContainer handler = this.getInnerContainer();
        if (handler == null) {
            return 0L;
        }
        this.setPipesActive();
        return handler.changeEnergy(amount);
    }

    @Override
    public long getEnergyStored() {
        ILaserContainer handler = this.getInnerContainer();
        if (handler == null) {
            return 0L;
        }
        return handler.getEnergyStored();
    }

    @Override
    public long getEnergyCapacity() {
        ILaserContainer handler = this.getInnerContainer();
        if (handler == null) {
            return 0L;
        }
        return handler.getEnergyCapacity();
    }

    @Override
    public long getInputAmperage() {
        return 0L;
    }

    @Override
    public long getInputVoltage() {
        return 0L;
    }

    public LaserPipeNet getNet() {
        return this.net;
    }

    @Override
    public boolean isOneProbeHidden() {
        return true;
    }
}

