/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.trait;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.data.worldgen.bedrockfluid.BedrockFluidDefinition;
import com.gregtechceu.gtceu.api.data.worldgen.bedrockfluid.BedrockFluidVeinSavedData;
import com.gregtechceu.gtceu.api.data.worldgen.bedrockfluid.FluidVeinWorldEntry;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.content.ContentModifier;
import com.gregtechceu.gtceu.common.machine.multiblock.electric.FluidDrillMachine;
import com.gregtechceu.gtceu.data.recipe.builder.GTRecipeBuilder;
import com.lowdragmc.lowdraglib.side.fluid.FluidHelper;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import javax.annotation.Nullable;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3611;
import net.minecraft.class_4076;

public class FluidDrillLogic
extends RecipeLogic {
    public static final int MAX_PROGRESS = 20;
    @Nullable
    private class_3611 veinFluid;

    public FluidDrillLogic(FluidDrillMachine machine) {
        super(machine);
    }

    @Override
    public FluidDrillMachine getMachine() {
        return (FluidDrillMachine)super.getMachine();
    }

    @Override
    public void findAndHandleRecipe() {
        class_1937 class_19372 = this.getMachine().getLevel();
        if (class_19372 instanceof class_3218) {
            GTRecipe match;
            class_3218 serverLevel = (class_3218)class_19372;
            this.lastRecipe = null;
            BedrockFluidVeinSavedData data = BedrockFluidVeinSavedData.getOrCreate(serverLevel);
            if (this.veinFluid == null) {
                this.veinFluid = data.getFluidInChunk(this.getChunkX(), this.getChunkZ());
                if (this.veinFluid == null) {
                    if (this.subscription != null) {
                        this.subscription.unsubscribe();
                        this.subscription = null;
                    }
                    return;
                }
            }
            if ((match = this.getFluidDrillRecipe()) != null) {
                GTRecipe copied = match.copy(new ContentModifier(match.duration, 0.0));
                if (match.matchRecipe(this.machine).isSuccess() && copied.matchTickRecipe(this.machine).isSuccess()) {
                    this.setupRecipe(match);
                }
            }
        }
    }

    @Nullable
    private GTRecipe getFluidDrillRecipe() {
        class_1937 class_19372 = this.getMachine().getLevel();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            if (this.veinFluid != null) {
                BedrockFluidVeinSavedData data = BedrockFluidVeinSavedData.getOrCreate(serverLevel);
                GTRecipe recipe = GTRecipeBuilder.ofRaw().duration(20).EUt(GTValues.VA[this.getMachine().getEnergyTier()]).outputFluids(FluidStack.create((class_3611)this.veinFluid, (long)this.getFluidToProduce(data.getFluidVeinWorldEntry(this.getChunkX(), this.getChunkZ())))).buildRawRecipe();
                if (recipe.matchRecipe(this.getMachine()).isSuccess() && recipe.matchTickRecipe(this.getMachine()).isSuccess()) {
                    return recipe;
                }
            }
        }
        return null;
    }

    private long getFluidToProduce(FluidVeinWorldEntry entry) {
        BedrockFluidDefinition definition = entry.getDefinition();
        if (definition != null) {
            int depletedYield = definition.getDepletedYield();
            int regularYield = entry.getFluidYield();
            int remainingOperations = entry.getOperationsRemaining();
            int produced = Math.max(depletedYield, regularYield * remainingOperations / 100000);
            produced *= FluidDrillMachine.getRigMultiplier(this.getMachine().getTier());
            if (this.isOverclocked()) {
                produced = produced * 3 / 2;
            }
            return (long)produced * FluidHelper.getBucket() / 1000L;
        }
        return 0L;
    }

    @Override
    public void onRecipeFinish() {
        this.machine.afterWorking();
        if (this.lastRecipe != null) {
            this.lastRecipe.postWorking(this.machine);
            this.lastRecipe.handleRecipeIO(IO.OUT, this.machine);
        }
        this.depleteVein();
        GTRecipe match = this.getFluidDrillRecipe();
        if (match != null) {
            GTRecipe copied = match.copy(new ContentModifier(match.duration, 0.0));
            if (match.matchRecipe(this.machine).isSuccess() && copied.matchTickRecipe(this.machine).isSuccess()) {
                this.setupRecipe(match);
                return;
            }
        }
        this.setStatus(RecipeLogic.Status.IDLE);
        this.progress = 0;
        this.duration = 0;
    }

    protected void depleteVein() {
        class_1937 class_19372 = this.getMachine().getLevel();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            int chance = FluidDrillMachine.getDepletionChance(this.getMachine().getTier());
            BedrockFluidVeinSavedData data = BedrockFluidVeinSavedData.getOrCreate(serverLevel);
            if (chance == 1 || GTValues.RNG.method_43048(chance) == 0) {
                data.depleteVein(this.getChunkX(), this.getChunkZ(), 0, false);
            }
        }
    }

    protected boolean isOverclocked() {
        return this.getMachine().getEnergyTier() > this.getMachine().getTier();
    }

    private int getChunkX() {
        return class_4076.method_18675((int)this.getMachine().getPos().method_10263());
    }

    private int getChunkZ() {
        return class_4076.method_18675((int)this.getMachine().getPos().method_10260());
    }

    @Nullable
    public class_3611 getVeinFluid() {
        return this.veinFluid;
    }
}

