/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.storage;

import com.gregtechceu.gtceu.api.capability.IControllable;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.widget.ToggleButtonWidget;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.TieredMachine;
import com.gregtechceu.gtceu.api.machine.feature.IAutoOutputItem;
import com.gregtechceu.gtceu.api.machine.feature.IDropSaveMachine;
import com.gregtechceu.gtceu.api.machine.feature.IFancyUIMachine;
import com.gregtechceu.gtceu.api.machine.feature.IInteractedMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.gregtechceu.gtceu.api.syncdata.RequireRerender;
import com.lowdragmc.lowdraglib.gui.editor.Icons;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceBorderTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.PhantomSlotWidget;
import com.lowdragmc.lowdraglib.gui.widget.SlotWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.misc.ItemStackTransfer;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.lowdragmc.lowdraglib.side.item.ItemTransferHelper;
import com.lowdragmc.lowdraglib.syncdata.ISubscription;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.DropSaved;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3738;
import net.minecraft.class_3965;
import net.minecraft.class_6179;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@class_6179
public class QuantumChestMachine
extends TieredMachine
implements IAutoOutputItem,
IInteractedMachine,
IControllable,
IDropSaveMachine,
IFancyUIMachine {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(QuantumChestMachine.class, MetaMachine.MANAGED_FIELD_HOLDER);
    @Persisted
    @DescSynced
    @RequireRerender
    protected class_2350 outputFacingItems;
    @Persisted
    @DescSynced
    @RequireRerender
    protected boolean autoOutputItems;
    @Persisted
    protected boolean allowInputFromOutputSideItems;
    private final int maxStoredItems;
    @Persisted
    @DescSynced
    @DropSaved
    protected int itemsStoredInside = 0;
    @Persisted
    @DescSynced
    @DropSaved
    private int storedAmount = 0;
    @Persisted
    @DescSynced
    @DropSaved
    @Nonnull
    private class_1799 stored = class_1799.field_8037;
    @Persisted
    @DropSaved
    protected final NotifiableItemStackHandler cache;
    @Nullable
    protected TickableSubscription autoOutputSubs;
    @Nullable
    protected ISubscription exportItemSubs;
    @Persisted
    private boolean isVoiding;
    @Persisted
    @DescSynced
    private final ItemStackTransfer lockedItem;

    public QuantumChestMachine(IMachineBlockEntity holder, int tier, int maxStoredItems, Object ... args) {
        super(holder, tier);
        this.outputFacingItems = this.getFrontFacing().method_10153();
        this.maxStoredItems = maxStoredItems;
        this.cache = this.createCacheItemHandler(args);
        this.lockedItem = new ItemStackTransfer();
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    protected NotifiableItemStackHandler createCacheItemHandler(Object ... args) {
        return new NotifiableItemStackHandler(this, 1, IO.BOTH, IO.BOTH){

            @Override
            @NotNull
            public class_1799 getStackInSlot(int slot) {
                class_1799 item = super.getStackInSlot(slot).method_7972();
                if (!item.method_7960()) {
                    item.method_7939(Math.min(QuantumChestMachine.this.itemsStoredInside + item.method_7947(), Integer.MAX_VALUE));
                }
                return item;
            }

            @Override
            public int getSlotLimit(int slot) {
                return slot == 0 ? QuantumChestMachine.this.maxStoredItems : 0;
            }

            @Override
            @NotNull
            public class_1799 insertItem(int slot, @NotNull class_1799 stack, boolean simulate, boolean notifyChanges) {
                class_1799 remained = super.insertItem(slot, stack, simulate, notifyChanges).method_7972();
                if (!remained.method_7960() && ItemTransferHelper.canItemStacksStack((class_1799)this.getStackInSlot(0), (class_1799)remained)) {
                    int added = Math.min(QuantumChestMachine.this.maxStoredItems - QuantumChestMachine.this.itemsStoredInside, remained.method_7947());
                    if (!simulate && notifyChanges) {
                        QuantumChestMachine.this.itemsStoredInside += added;
                        this.onContentsChanged();
                    }
                    remained.method_7934(added);
                    if (QuantumChestMachine.this.isVoiding) {
                        remained.method_7939(0);
                    }
                }
                return remained;
            }

            @Override
            @NotNull
            public class_1799 extractItem(int slot, int amount, boolean simulate, boolean notifyChanges) {
                class_1799 extracted = super.extractItem(slot, amount, simulate, notifyChanges).method_7972();
                if (!extracted.method_7960()) {
                    int additional = Math.min(amount - extracted.method_7947(), QuantumChestMachine.this.itemsStoredInside);
                    extracted.method_7933(additional);
                    if (!simulate && notifyChanges) {
                        QuantumChestMachine.this.itemsStoredInside -= additional;
                        if (this.getStackInSlot(0).method_7960() && QuantumChestMachine.this.itemsStoredInside > 0) {
                            class_1799 copied = extracted.method_7972();
                            copied.method_7939(Math.min(QuantumChestMachine.this.itemsStoredInside, Math.min(64, copied.method_7909().method_7882())));
                            QuantumChestMachine.this.itemsStoredInside -= copied.method_7947();
                            this.setStackInSlot(0, copied);
                        }
                        this.onContentsChanged();
                    }
                }
                return extracted;
            }

            @Override
            public void onContentsChanged() {
                super.onContentsChanged();
                if (!QuantumChestMachine.this.isRemote()) {
                    QuantumChestMachine.this.stored = this.getStackInSlot(0).method_7972();
                    QuantumChestMachine.this.storedAmount = QuantumChestMachine.this.stored.method_7947();
                    QuantumChestMachine.this.stored.method_7939(1);
                }
            }
        }.setFilter(itemStack -> !this.isLocked() || ItemTransferHelper.canItemStacksStack((class_1799)this.lockedItem.getStackInSlot(0), (class_1799)itemStack));
    }

    @Override
    public void onLoad() {
        super.onLoad();
        class_1937 class_19372 = this.getLevel();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            serverLevel.method_8503().method_18858((Runnable)new class_3738(0, this::updateAutoOutputSubscription));
        }
        this.exportItemSubs = this.cache.addChangedListener(this::updateAutoOutputSubscription);
    }

    @Override
    public void onUnload() {
        super.onUnload();
        if (this.exportItemSubs != null) {
            this.exportItemSubs.unsubscribe();
            this.exportItemSubs = null;
        }
    }

    @Override
    public boolean savePickClone() {
        return false;
    }

    @Override
    public void setAutoOutputItems(boolean allow) {
        this.autoOutputItems = allow;
        this.updateAutoOutputSubscription();
    }

    @Override
    public void setOutputFacingItems(@Nullable class_2350 outputFacing) {
        this.outputFacingItems = outputFacing;
        this.updateAutoOutputSubscription();
    }

    @Override
    public void onNeighborChanged(class_2248 block, class_2338 fromPos, boolean isMoving) {
        super.onNeighborChanged(block, fromPos, isMoving);
        this.updateAutoOutputSubscription();
    }

    @Override
    public boolean isWorkingEnabled() {
        return this.isAutoOutputItems();
    }

    @Override
    public void setWorkingEnabled(boolean isWorkingAllowed) {
        this.setAutoOutputItems(isWorkingAllowed);
    }

    protected void updateAutoOutputSubscription() {
        class_2350 outputFacing = this.getOutputFacingItems();
        if (this.isAutoOutputItems() && !this.cache.isEmpty() && outputFacing != null && ItemTransferHelper.getItemTransfer((class_1937)this.getLevel(), (class_2338)this.getPos().method_10093(outputFacing), (class_2350)outputFacing.method_10153()) != null) {
            this.autoOutputSubs = this.subscribeServerTick(this.autoOutputSubs, this::checkAutoOutput);
        } else if (this.autoOutputSubs != null) {
            this.autoOutputSubs.unsubscribe();
            this.autoOutputSubs = null;
        }
    }

    protected void checkAutoOutput() {
        if (this.getOffsetTimer() % 5L == 0L) {
            if (this.isAutoOutputItems() && this.getOutputFacingItems() != null) {
                this.cache.exportToNearby(this.getOutputFacingItems());
            }
            this.updateAutoOutputSubscription();
        }
    }

    @Override
    public boolean isFacingValid(class_2350 facing) {
        if (facing == this.outputFacingItems) {
            return false;
        }
        return super.isFacingValid(facing);
    }

    @Override
    public class_1269 onUse(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_1799 held;
        if (hit.method_17780() == this.getFrontFacing() && !(held = player.method_6047()).method_7960() && (ItemTransferHelper.canItemStacksStack((class_1799)held, (class_1799)this.stored) || this.stored.method_7960())) {
            if (!this.isRemote()) {
                class_1799 remaining = this.cache.insertItem(0, held, false);
                player.method_6122(class_1268.field_5808, remaining);
            }
            return class_1269.field_5812;
        }
        return IInteractedMachine.super.onUse(state, world, pos, player, hand, hit);
    }

    @Override
    public boolean onLeftClick(class_1657 player, class_1937 world, class_1268 hand, class_2338 pos, class_2350 direction) {
        class_1799 drained;
        if (direction == this.getFrontFacing() && !this.isRemote() && !this.stored.method_7960() && !(drained = this.cache.extractItem(0, player.method_18276() ? this.stored.method_7909().method_7882() : 1, false)).method_7960() && player.method_7270(drained)) {
            class_2248.method_9577((class_1937)world, (class_2338)this.getPos().method_10093(this.getFrontFacing()), (class_1799)drained);
        }
        return IInteractedMachine.super.onLeftClick(player, world, hand, pos, direction);
    }

    @Override
    protected class_1269 onWrenchClick(class_1657 playerIn, class_1268 hand, class_2350 gridSide, class_3965 hitResult) {
        if (!playerIn.method_18276() && !this.isRemote()) {
            class_1799 tool = playerIn.method_5998(hand);
            if (tool.method_7919() >= tool.method_7936()) {
                return class_1269.field_5811;
            }
            if (this.hasFrontFacing() && gridSide == this.getFrontFacing()) {
                return class_1269.field_5811;
            }
            if (gridSide != this.getOutputFacingItems()) {
                this.setOutputFacingItems(gridSide);
            } else {
                this.setOutputFacingItems(null);
            }
            return class_1269.field_21466;
        }
        return super.onWrenchClick(playerIn, hand, gridSide, hitResult);
    }

    @Override
    protected class_1269 onScrewdriverClick(class_1657 playerIn, class_1268 hand, class_2350 gridSide, class_3965 hitResult) {
        if (!this.isRemote()) {
            if (gridSide == this.getOutputFacingItems()) {
                if (this.isAllowInputFromOutputSideItems()) {
                    this.setAllowInputFromOutputSideItems(false);
                    playerIn.method_43496((class_2561)class_2561.method_43471((String)"gtceu.machine.basic.input_from_output_side.disallow").method_10852((class_2561)class_2561.method_43471((String)"gtceu.creative.chest.item")));
                } else {
                    this.setAllowInputFromOutputSideItems(true);
                    playerIn.method_43496((class_2561)class_2561.method_43471((String)"gtceu.machine.basic.input_from_output_side.allow").method_10852((class_2561)class_2561.method_43471((String)"gtceu.creative.chest.item")));
                }
            }
            return class_1269.field_5812;
        }
        return super.onScrewdriverClick(playerIn, hand, gridSide, hitResult);
    }

    public boolean isLocked() {
        return !this.lockedItem.getStackInSlot(0).method_7960();
    }

    protected void setLocked(boolean locked) {
        if (!this.stored.method_7960() && locked) {
            class_1799 copied = this.stored.method_7972();
            copied.method_7939(1);
            this.lockedItem.setStackInSlot(0, copied);
        } else if (!locked) {
            this.lockedItem.setStackInSlot(0, class_1799.field_8037);
        }
        this.lockedItem.onContentsChanged(0);
    }

    @Override
    public Widget createUIWidget() {
        WidgetGroup group = new WidgetGroup(0, 0, 109, 63);
        ItemStackTransfer importItems = new ItemStackTransfer();
        importItems.setFilter(itemStack -> {
            class_1799 item = this.cache.getStackInSlot(0);
            return this.maxStoredItems - this.storedAmount > itemStack.method_7947() && (item.method_7960() && (!this.isLocked() || ItemTransferHelper.canItemStacksStack((class_1799)itemStack, (class_1799)this.getLockedItem().getStackInSlot(0))) || ItemTransferHelper.canItemStacksStack((class_1799)itemStack, (class_1799)item));
        });
        importItems.setOnContentsChanged(() -> {
            class_1799 item = importItems.getStackInSlot(0).method_7972();
            if (!item.method_7960()) {
                importItems.setStackInSlot(0, class_1799.field_8037);
                importItems.onContentsChanged(0);
                this.cache.insertItem(0, item.method_7972(), false);
            }
        });
        class_1799 current = this.cache.getStackInSlot(0).method_7972();
        if (!current.method_7960()) {
            current.method_7939(Math.min(current.method_7947(), current.method_7909().method_7882()));
        }
        group.addWidget((Widget)new ImageWidget(4, 4, 81, 55, (IGuiTexture)GuiTextures.DISPLAY)).addWidget((Widget)new LabelWidget(8, 8, "gtceu.machine.quantum_chest.items_stored")).addWidget((Widget)new LabelWidget(8, 18, () -> "" + this.storedAmount).setTextColor(-1).setDropShadow(true)).addWidget((Widget)new SlotWidget((IItemTransfer)importItems, 0, 87, 5, false, true).setBackgroundTexture((IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{GuiTextures.SLOT, GuiTextures.IN_SLOT_OVERLAY}))).addWidget((Widget)new SlotWidget((IItemTransfer)this.cache, 0, 87, 23, false, false).setItemHook(itemStack -> {
            class_1799 copied = itemStack.method_7972();
            if (!copied.method_7960()) {
                copied.method_7939(1);
            }
            return copied;
        }).setBackgroundTexture((IGuiTexture)GuiTextures.SLOT)).addWidget((Widget)new ButtonWidget(87, 42, 18, 18, (IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{ResourceBorderTexture.BUTTON_COMMON, Icons.DOWN.scale(0.7f)}), cd -> {
            class_1799 extracted;
            class_1799 stored;
            if (!(cd.isRemote || (stored = this.cache.getStackInSlot(0)).method_7960() || group.getGui().entityPlayer.method_7270(extracted = this.cache.extractItem(0, Math.min(stored.method_7947(), stored.method_7909().method_7882()), false)))) {
                class_2248.method_9577((class_1937)group.getGui().entityPlayer.method_37908(), (class_2338)group.getGui().entityPlayer.method_23312(), (class_1799)extracted);
            }
        })).addWidget((Widget)new PhantomSlotWidget((IItemTransfer)this.lockedItem, 0, 58, 41)).addWidget((Widget)new ToggleButtonWidget(4, 41, 18, 18, (IGuiTexture)GuiTextures.BUTTON_ITEM_OUTPUT, this::isAutoOutputItems, this::setAutoOutputItems).setShouldUseBaseBackground().setTooltipText("gtceu.gui.item_auto_output.tooltip")).addWidget((Widget)new ToggleButtonWidget(22, 41, 18, 18, (IGuiTexture)GuiTextures.BUTTON_LOCK, this::isLocked, this::setLocked).setShouldUseBaseBackground().setTooltipText("gtceu.gui.item_lock.tooltip")).addWidget((Widget)new ToggleButtonWidget(40, 41, 18, 18, (IGuiTexture)GuiTextures.BUTTON_VOID, this::isVoiding, this::setVoiding).setShouldUseBaseBackground().setTooltipText("gtceu.gui.item_voiding_partial.tooltip"));
        group.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE});
        return group;
    }

    @Override
    public ResourceTexture sideTips(class_1657 player, Set<GTToolType> toolTypes, class_2350 side) {
        if (toolTypes.contains(GTToolType.WRENCH)) {
            if (!(player.method_18276() || this.hasFrontFacing() && side == this.getFrontFacing())) {
                return GuiTextures.TOOL_IO_FACING_ROTATION;
            }
        } else if (toolTypes.contains(GTToolType.SCREWDRIVER) && side == this.getOutputFacingItems()) {
            return GuiTextures.TOOL_ALLOW_INPUT;
        }
        return super.sideTips(player, toolTypes, side);
    }

    @Override
    public class_2350 getOutputFacingItems() {
        return this.outputFacingItems;
    }

    @Override
    public boolean isAutoOutputItems() {
        return this.autoOutputItems;
    }

    @Override
    public boolean isAllowInputFromOutputSideItems() {
        return this.allowInputFromOutputSideItems;
    }

    @Override
    public void setAllowInputFromOutputSideItems(boolean allowInputFromOutputSideItems) {
        this.allowInputFromOutputSideItems = allowInputFromOutputSideItems;
    }

    public int getMaxStoredItems() {
        return this.maxStoredItems;
    }

    public int getStoredAmount() {
        return this.storedAmount;
    }

    @Nonnull
    public class_1799 getStored() {
        return this.stored;
    }

    public boolean isVoiding() {
        return this.isVoiding;
    }

    public void setVoiding(boolean isVoiding) {
        this.isVoiding = isVoiding;
    }

    public ItemStackTransfer getLockedItem() {
        return this.lockedItem;
    }
}

