/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.multiblock.steam;

import com.gregtechceu.gtceu.api.capability.recipe.EURecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeHandler;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.UITemplate;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IDisplayUIMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.WorkableMultiblockMachine;
import com.gregtechceu.gtceu.api.machine.steam.SteamEnergyRecipeHandler;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableFluidTank;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.RecipeHelper;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.data.GTRecipeModifiers;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.lowdragmc.lowdraglib.gui.modular.IUIHolder;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.ComponentPanelWidget;
import com.lowdragmc.lowdraglib.gui.widget.DraggableScrollableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.side.fluid.FluidHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_6328;

@ParametersAreNonnullByDefault
@class_6328
public class SteamParallelMultiblockMachine
extends WorkableMultiblockMachine
implements IDisplayUIMachine {
    public static final int MAX_PARALLELS = 8;
    private static final double CONVERSION_RATE = (double)(FluidHelper.getBucket() * 2L) / 1000.0;

    public SteamParallelMultiblockMachine(IMachineBlockEntity holder, Object ... args) {
        super(holder, args);
    }

    @Override
    public void onStructureFormed() {
        super.onStructureFormed();
        List handlers = (List)this.capabilitiesProxy.get((Object)IO.IN, (Object)FluidRecipeCapability.CAP);
        if (handlers == null) {
            return;
        }
        Iterator itr = handlers.iterator();
        while (itr.hasNext()) {
            NotifiableFluidTank tank;
            IRecipeHandler handler = (IRecipeHandler)itr.next();
            if (!(handler instanceof NotifiableFluidTank) || !(tank = (NotifiableFluidTank)handler).isFluidValid(0, GTMaterials.Steam.getFluid(1L))) continue;
            itr.remove();
            if (!this.capabilitiesProxy.contains((Object)IO.IN, (Object)EURecipeCapability.CAP)) {
                this.capabilitiesProxy.put((Object)IO.IN, (Object)EURecipeCapability.CAP, new ArrayList());
            }
            ((List)this.capabilitiesProxy.get((Object)IO.IN, (Object)EURecipeCapability.CAP)).add(new SteamEnergyRecipeHandler(tank, CONVERSION_RATE));
            return;
        }
    }

    public static GTRecipe recipeModifier(MetaMachine machine, @Nonnull GTRecipe recipe) {
        int duration = recipe.duration;
        long eut = RecipeHelper.getInputEUt(recipe);
        GTRecipe result = (GTRecipe)GTRecipeModifiers.accurateParallel(machine, recipe, 8, false).method_15442();
        recipe = result == recipe ? result.copy() : result;
        recipe.duration = (int)((double)duration * 1.5);
        eut = (long)Math.min(32.0, Math.ceil((double)eut * 1.33));
        recipe.tickInputs.put(EURecipeCapability.CAP, List.of(new Content(eut, 1.0f, 0.0f, null, null)));
        return recipe;
    }

    @Override
    public void addDisplayText(List<class_2561> textList) {
        IDisplayUIMachine.super.addDisplayText(textList);
        if (this.isFormed()) {
            SteamEnergyRecipeHandler steamHandler;
            Object e;
            List handlers = (List)this.capabilitiesProxy.get((Object)IO.IN, (Object)EURecipeCapability.CAP);
            if (handlers != null && handlers.size() > 0 && (e = handlers.get(0)) instanceof SteamEnergyRecipeHandler && (steamHandler = (SteamEnergyRecipeHandler)e).getCapacity() > 0L) {
                long steamStored = steamHandler.getStored();
                textList.add((class_2561)class_2561.method_43469((String)"gtceu.multiblock.steam.steam_stored", (Object[])new Object[]{steamStored, steamHandler.getCapacity()}));
            }
            if (!this.isWorkingEnabled()) {
                textList.add((class_2561)class_2561.method_43471((String)"gtceu.multiblock.work_paused"));
            } else if (this.isActive()) {
                textList.add((class_2561)class_2561.method_43471((String)"gtceu.multiblock.running"));
                int currentProgress = (int)(this.recipeLogic.getProgressPercent() * 100.0);
                textList.add((class_2561)class_2561.method_43469((String)"gtceu.multiblock.parallel", (Object[])new Object[]{8}));
                textList.add((class_2561)class_2561.method_43469((String)"gtceu.multiblock.progress", (Object[])new Object[]{currentProgress}));
            } else {
                textList.add((class_2561)class_2561.method_43471((String)"gtceu.multiblock.idling"));
            }
            if (this.recipeLogic.isWaiting()) {
                textList.add((class_2561)class_2561.method_43471((String)"gtceu.multiblock.steam.low_steam").method_10862(class_2583.field_24360.method_10977(class_124.field_1061)));
            }
        }
    }

    @Override
    public IGuiTexture getScreenTexture() {
        return GuiTextures.DISPLAY_STEAM.get(ConfigHolder.INSTANCE.machines.steelSteamMultiblocks);
    }

    @Override
    public ModularUI createUI(class_1657 entityPlayer) {
        DraggableScrollableWidgetGroup screen = new DraggableScrollableWidgetGroup(7, 4, 162, 121).setBackground(this.getScreenTexture());
        screen.addWidget((Widget)new LabelWidget(4, 5, this.self().getBlockState().method_26204().method_9539()));
        screen.addWidget((Widget)new ComponentPanelWidget(4, 17, this::addDisplayText).setMaxWidthLimit(150).clickHandler(this::handleDisplayClick));
        return new ModularUI(176, 216, (IUIHolder)this, entityPlayer).background(new IGuiTexture[]{GuiTextures.BACKGROUND_STEAM.get(ConfigHolder.INSTANCE.machines.steelSteamMultiblocks)}).widget((Widget)screen).widget((Widget)UITemplate.bindPlayerInventory(entityPlayer.method_31548(), (IGuiTexture)GuiTextures.SLOT_STEAM.get(ConfigHolder.INSTANCE.machines.steelSteamMultiblocks), 7, 134, true));
    }
}

