/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.multiblock.primitive;

import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.multiblock.MultiblockControllerMachine;
import com.gregtechceu.gtceu.api.machine.trait.IRecipeHandlerTrait;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableFluidTank;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.lowdragmc.lowdraglib.side.fluid.FluidHelper;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1959;
import net.minecraft.class_6328;
import net.minecraft.class_6880;

@ParametersAreNonnullByDefault
@class_6328
public class PrimitivePumpMachine
extends MultiblockControllerMachine {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(PrimitivePumpMachine.class, MultiblockControllerMachine.MANAGED_FIELD_HOLDER);
    private long biomeModifier = 0L;
    private int hatchModifier = 0;
    private NotifiableFluidTank fluidTank;
    private TickableSubscription produceWaterSubscription;

    public PrimitivePumpMachine(IMachineBlockEntity holder) {
        super(holder);
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Override
    public void onStructureFormed() {
        super.onStructureFormed();
        this.initializeTank();
        this.produceWaterSubscription = this.subscribeServerTick(this::produceWater);
        this.produceWater();
    }

    private void initializeTank() {
        for (IMultiPart part : this.getParts()) {
            for (IRecipeHandlerTrait handler : part.getRecipeHandlers()) {
                if (handler.getHandlerIO() != IO.OUT || handler.getCapability() != FluidRecipeCapability.CAP) continue;
                this.fluidTank = (NotifiableFluidTank)handler;
                long tankCapacity = this.fluidTank.getTankCapacity(0);
                this.hatchModifier = tankCapacity == FluidHelper.getBucket() ? 1 : (tankCapacity == FluidHelper.getBucket() * 8L ? 2 : 4);
                return;
            }
        }
    }

    @Override
    public void onStructureInvalid() {
        super.onStructureInvalid();
        this.resetState();
    }

    @Override
    public void onPartUnload() {
        super.onPartUnload();
        this.resetState();
    }

    @Override
    public void onUnload() {
        super.onUnload();
        this.resetState();
    }

    private void resetState() {
        this.unsubscribe(this.produceWaterSubscription);
        this.hatchModifier = 0;
        this.fluidTank = null;
    }

    private void produceWater() {
        if (this.getOffsetTimer() % 20L == 0L && this.isFormed() && !this.getMultiblockState().hasError()) {
            if (this.biomeModifier == 0L) {
                this.biomeModifier = GTUtil.getPumpBiomeModifier((class_6880<class_1959>)this.getLevel().method_23753(this.getPos()));
            } else if (this.biomeModifier > 0L) {
                if (this.fluidTank == null) {
                    this.initializeTank();
                }
                if (this.fluidTank != null) {
                    this.fluidTank.handleRecipe(IO.OUT, null, List.of(FluidIngredient.of(GTMaterials.Water.getFluid(this.getFluidProduction()))), null, false);
                }
            }
        }
    }

    private boolean isRainingInBiome() {
        if (!this.getLevel().method_8419()) {
            return false;
        }
        return this.getBiomePrecipitation() != class_1959.class_1963.field_9384;
    }

    private class_1959.class_1963 getBiomePrecipitation() {
        return ((class_1959)this.getLevel().method_23753(this.getPos()).comp_349()).method_48162(this.getPos());
    }

    public long getFluidProduction() {
        long value = this.biomeModifier * (long)this.hatchModifier;
        if (this.isRainingInBiome()) {
            value = value * 3L / 2L;
        }
        return value;
    }
}

