/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.multiblock.part;

import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.multiblock.part.TieredIOPartMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableFluidTank;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.TankWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.side.fluid.FluidHelper;
import com.lowdragmc.lowdraglib.side.fluid.FluidTransferHelper;
import com.lowdragmc.lowdraglib.side.fluid.IFluidStorage;
import com.lowdragmc.lowdraglib.syncdata.ISubscription;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_3218;
import net.minecraft.class_3738;
import net.minecraft.class_6328;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@class_6328
public class FluidHatchPartMachine
extends TieredIOPartMachine {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(FluidHatchPartMachine.class, TieredIOPartMachine.MANAGED_FIELD_HOLDER);
    public static final long INITIAL_TANK_CAPACITY_1X = 8L * FluidHelper.getBucket();
    public static final long INITIAL_TANK_CAPACITY_4X = 2L * FluidHelper.getBucket();
    public static final long INITIAL_TANK_CAPACITY_9X = FluidHelper.getBucket();
    @Persisted
    public final NotifiableFluidTank tank;
    private final int slots;
    @Nullable
    protected TickableSubscription autoIOSubs;
    @Nullable
    protected ISubscription tankSubs;

    public FluidHatchPartMachine(IMachineBlockEntity holder, int tier, IO io, long initialCapacity, int slots, Object ... args) {
        super(holder, tier, io);
        this.slots = slots;
        this.tank = this.createTank(initialCapacity, slots, args);
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    protected NotifiableFluidTank createTank(long initialCapacity, int slots, Object ... args) {
        return new NotifiableFluidTank((MetaMachine)this, slots, FluidHatchPartMachine.getTankCapacity(initialCapacity, this.getTier()), this.io);
    }

    public static long getTankCapacity(long initialCapacity, int tier) {
        return initialCapacity * (1L << Math.min(9, tier));
    }

    @Override
    public void onLoad() {
        super.onLoad();
        class_1937 class_19372 = this.getLevel();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            serverLevel.method_8503().method_18858((Runnable)new class_3738(0, this::updateTankSubscription));
        }
        this.tankSubs = this.tank.addChangedListener(this::updateTankSubscription);
    }

    @Override
    public void onUnload() {
        super.onUnload();
        if (this.tankSubs != null) {
            this.tankSubs.unsubscribe();
            this.tankSubs = null;
        }
    }

    @Override
    public void onNeighborChanged(class_2248 block, class_2338 fromPos, boolean isMoving) {
        super.onNeighborChanged(block, fromPos, isMoving);
        this.updateTankSubscription();
    }

    @Override
    public void onRotated(class_2350 oldFacing, class_2350 newFacing) {
        super.onRotated(oldFacing, newFacing);
        this.updateTankSubscription();
    }

    protected void updateTankSubscription() {
        if (this.isWorkingEnabled() && (this.io == IO.OUT && !this.tank.isEmpty() || this.io == IO.IN) && FluidTransferHelper.getFluidTransfer((class_1937)this.getLevel(), (class_2338)this.getPos().method_10093(this.getFrontFacing()), (class_2350)this.getFrontFacing().method_10153()) != null) {
            this.autoIOSubs = this.subscribeServerTick(this.autoIOSubs, this::autoIO);
        } else if (this.autoIOSubs != null) {
            this.autoIOSubs.unsubscribe();
            this.autoIOSubs = null;
        }
    }

    protected void autoIO() {
        if (this.getOffsetTimer() % 5L == 0L) {
            if (this.isWorkingEnabled()) {
                if (this.io == IO.OUT) {
                    this.tank.exportToNearby(this.getFrontFacing());
                } else if (this.io == IO.IN) {
                    this.tank.importFromNearby(this.getFrontFacing());
                }
            }
            this.updateTankSubscription();
        }
    }

    @Override
    public void setWorkingEnabled(boolean workingEnabled) {
        super.setWorkingEnabled(workingEnabled);
        this.updateTankSubscription();
    }

    @Override
    public Widget createUIWidget() {
        if (this.slots == 1) {
            return this.createSingleSlotGUI();
        }
        return this.createMultiSlotGUI();
    }

    protected Widget createSingleSlotGUI() {
        WidgetGroup group = new WidgetGroup(0, 0, 89, 63);
        group.addWidget((Widget)new ImageWidget(4, 4, 81, 55, (IGuiTexture)GuiTextures.DISPLAY)).addWidget((Widget)new LabelWidget(8, 8, "gtceu.gui.fluid_amount")).addWidget((Widget)new LabelWidget(8, 18, () -> String.valueOf(this.tank.getFluidInTank(0).getAmount())).setTextColor(-1).setDropShadow(true)).addWidget((Widget)new TankWidget((IFluidStorage)this.tank.storages[0], 67, 22, true, this.io.support(IO.IN)).setBackground((IGuiTexture)GuiTextures.FLUID_SLOT));
        group.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE});
        return group;
    }

    protected Widget createMultiSlotGUI() {
        int rowSize;
        int colSize = rowSize = (int)Math.sqrt(this.slots);
        if (this.slots == 8) {
            rowSize = 4;
            colSize = 2;
        }
        WidgetGroup group = new WidgetGroup(0, 0, 18 * rowSize + 16, 18 * colSize + 16);
        WidgetGroup container = new WidgetGroup(4, 4, 18 * rowSize + 8, 18 * colSize + 8);
        int index = 0;
        for (int y = 0; y < colSize; ++y) {
            for (int x = 0; x < rowSize; ++x) {
                container.addWidget((Widget)new TankWidget((IFluidStorage)this.tank.storages[index++], 4 + x * 18, 4 + y * 18, true, this.io.support(IO.IN)).setBackground((IGuiTexture)GuiTextures.FLUID_SLOT));
            }
        }
        container.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE});
        group.addWidget((Widget)container);
        return group;
    }
}

