/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.multiblock.electric;

import com.gregtechceu.gtceu.api.capability.IControllable;
import com.gregtechceu.gtceu.api.capability.IEnergyContainer;
import com.gregtechceu.gtceu.api.capability.recipe.EURecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.machine.ConditionalSubscriptionHandler;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.multiblock.PartAbility;
import com.gregtechceu.gtceu.api.machine.multiblock.WorkableElectricMultiblockMachine;
import com.gregtechceu.gtceu.api.machine.trait.IRecipeHandlerTrait;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.misc.EnergyContainerList;
import com.gregtechceu.gtceu.api.pattern.Predicates;
import com.gregtechceu.gtceu.api.pattern.TraceabilityPredicate;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import java.util.ArrayList;
import java.util.Map;

public class ActiveTransformerMachine
extends WorkableElectricMultiblockMachine
implements IControllable {
    private IEnergyContainer powerOutput = new EnergyContainerList(new ArrayList());
    private IEnergyContainer powerInput = new EnergyContainerList(new ArrayList());
    protected ConditionalSubscriptionHandler converterSubscription = new ConditionalSubscriptionHandler(this, this::convertEnergyTick, this::isSubscriptionActive);

    public ActiveTransformerMachine(IMachineBlockEntity holder) {
        super(holder, new Object[0]);
    }

    public void convertEnergyTick() {
        this.getRecipeLogic().setStatus(RecipeLogic.Status.WORKING);
        if (this.isWorkingEnabled()) {
            long canDrain = this.powerInput.getEnergyStored();
            long totalDrained = this.powerOutput.changeEnergy(canDrain);
            this.powerInput.removeEnergy(totalDrained);
        }
        this.converterSubscription.updateSubscription();
    }

    protected boolean isSubscriptionActive() {
        if (this.powerInput != null && this.powerInput.getEnergyStored() > 0L) {
            return true;
        }
        if (this.powerOutput == null) {
            return false;
        }
        if (this.powerOutput.getEnergyStored() <= 0L) {
            return false;
        }
        return this.powerOutput.getEnergyStored() < this.powerOutput.getEnergyCapacity();
    }

    @Override
    public void onStructureFormed() {
        super.onStructureFormed();
        ArrayList<IEnergyContainer> powerInput = new ArrayList<IEnergyContainer>();
        ArrayList<IEnergyContainer> powerOutput = new ArrayList<IEnergyContainer>();
        Map ioMap = (Map)this.getMultiblockState().getMatchContext().getOrCreate("ioMap", Long2ObjectMaps::emptyMap);
        for (IMultiPart part : this.getParts()) {
            IO io = ioMap.getOrDefault(part.self().getPos().method_10063(), IO.BOTH);
            if (io == IO.NONE) continue;
            for (IRecipeHandlerTrait handler : part.getRecipeHandlers()) {
                IO handlerIO = handler.getHandlerIO();
                if (io != IO.BOTH && handlerIO != IO.BOTH && io != handlerIO || handler.getCapability() != EURecipeCapability.CAP || !(handler instanceof IEnergyContainer)) continue;
                IEnergyContainer container = (IEnergyContainer)((Object)handler);
                if (handlerIO == IO.IN) {
                    powerInput.add(container);
                } else if (handlerIO == IO.OUT) {
                    powerOutput.add(container);
                }
                this.traitSubscriptions.add(handler.addChangedListener(this.converterSubscription::updateSubscription));
            }
        }
        if (powerInput.isEmpty() || powerOutput.isEmpty()) {
            this.onStructureInvalid();
        }
        this.powerOutput = new EnergyContainerList(powerOutput);
        this.powerInput = new EnergyContainerList(powerInput);
    }

    @Override
    public void onStructureInvalid() {
        super.onStructureInvalid();
        this.powerOutput = new EnergyContainerList(new ArrayList());
        this.powerInput = new EnergyContainerList(new ArrayList());
        this.getRecipeLogic().setStatus(RecipeLogic.Status.IDLE);
    }

    public static TraceabilityPredicate getHatchPredicates() {
        return Predicates.abilities(PartAbility.INPUT_ENERGY).setPreviewCount(1).or(Predicates.abilities(PartAbility.OUTPUT_ENERGY).setPreviewCount(2)).or(Predicates.abilities(PartAbility.INPUT_LASER).setPreviewCount(1)).or(Predicates.abilities(PartAbility.OUTPUT_LASER).setPreviewCount(1));
    }
}

