/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.electric;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.UITemplate;
import com.gregtechceu.gtceu.api.gui.widget.ToggleButtonWidget;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.TieredEnergyMachine;
import com.gregtechceu.gtceu.api.machine.feature.IAutoOutputFluid;
import com.gregtechceu.gtceu.api.machine.feature.IMachineLife;
import com.gregtechceu.gtceu.api.machine.feature.IUIMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableFluidTank;
import com.gregtechceu.gtceu.api.syncdata.RequireRerender;
import com.gregtechceu.gtceu.common.data.GTBlocks;
import com.lowdragmc.lowdraglib.gui.modular.IUIHolder;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.TankWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.misc.FluidBlockTransfer;
import com.lowdragmc.lowdraglib.side.fluid.FluidHelper;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.lowdraglib.side.fluid.IFluidStorage;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.DropSaved;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2404;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_6328;

@ParametersAreNonnullByDefault
@class_6328
public class PumpMachine
extends TieredEnergyMachine
implements IAutoOutputFluid,
IUIMachine,
IMachineLife {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(PumpMachine.class, TieredEnergyMachine.MANAGED_FIELD_HOLDER);
    public static final int BASE_PUMP_RANGE = 32;
    public static final int EXTRA_PUMP_RANGE = 8;
    public static final int PUMP_SPEED_BASE = 80;
    private final Deque<class_2338> fluidSourceBlocks = new ArrayDeque<class_2338>();
    private final Deque<class_2338> blocksToCheck = new ArrayDeque<class_2338>();
    private boolean initializedQueue = false;
    @Persisted
    private int pumpHeadY;
    @Persisted
    @DescSynced
    @RequireRerender
    protected boolean autoOutputFluids;
    @Persisted
    @DropSaved
    protected final NotifiableFluidTank cache;

    public PumpMachine(IMachineBlockEntity holder, int tier, Object ... args) {
        super(holder, tier, new Object[0]);
        this.cache = this.createCacheFluidHandler(args);
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    protected NotifiableFluidTank createCacheFluidHandler(Object ... args) {
        return new NotifiableFluidTank(this, 1, 16L * FluidHelper.getBucket() * (long)Math.max(1, this.getTier()), IO.NONE, IO.OUT);
    }

    @Override
    public boolean isAllowInputFromOutputSideFluids() {
        return false;
    }

    @Override
    public void setAllowInputFromOutputSideFluids(boolean allow) {
    }

    @Override
    public class_2350 getOutputFacingFluids() {
        return this.getFrontFacing();
    }

    @Override
    public void setOutputFacingFluids(class_2350 outputFacing) {
        this.setFrontFacing(outputFacing);
    }

    @Override
    public void onLoad() {
        super.onLoad();
        this.subscribeServerTick(this::update);
    }

    @Override
    public boolean shouldWeatherOrTerrainExplosion() {
        return false;
    }

    private int getMaxPumpRange() {
        return 32 + 8 * this.getTier();
    }

    private boolean isStraightInPumpRange(class_2338 checkPos) {
        class_2338 pos = this.getPos();
        return checkPos.method_10263() == pos.method_10263() && checkPos.method_10260() == pos.method_10260() && pos.method_10264() < checkPos.method_10264() && pos.method_10264() + this.pumpHeadY >= checkPos.method_10264();
    }

    private void updateQueueState(int blocksToCheckAmount) {
        class_2338 selfPos = this.getPos().method_10087(this.pumpHeadY);
        for (int i = 0; i < blocksToCheckAmount; ++i) {
            class_2338 checkPos = null;
            int amountIterated = 0;
            do {
                if (checkPos == null) continue;
                this.blocksToCheck.push(checkPos);
                ++amountIterated;
            } while ((checkPos = this.blocksToCheck.poll()) != null && !this.getLevel().method_8477(checkPos) && amountIterated < this.blocksToCheck.size());
            if (checkPos == null) break;
            this.checkFluidBlockAt(selfPos, checkPos);
        }
        if (this.fluidSourceBlocks.isEmpty()) {
            if (this.getOffsetTimer() % 20L == 0L) {
                class_2680 downBlock;
                class_2338 downPos = selfPos.method_10087(1);
                if (downPos.method_10264() >= this.getLevel().method_31607() && (downBlock = this.getLevel().method_8320(downPos)).method_26204() instanceof class_2404) {
                    class_3218 serverLevel;
                    ++this.pumpHeadY;
                    class_1937 class_19372 = this.getLevel();
                    if (class_19372 instanceof class_3218 && (serverLevel = (class_3218)class_19372).method_8320(selfPos).method_26215()) {
                        serverLevel.method_8501(selfPos, GTBlocks.MINER_PIPE.getDefaultState());
                    }
                }
                this.initializedQueue = false;
            }
            if (!this.initializedQueue || this.getOffsetTimer() % 6000L == 0L) {
                this.initializedQueue = true;
                this.blocksToCheck.add(selfPos);
            }
        }
    }

    @Override
    public void onMachineRemoved() {
        class_1937 class_19372 = this.getLevel();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            class_2338 pos = this.getPos().method_10093(class_2350.field_11033);
            while (serverLevel.method_8320(pos).method_27852((class_2248)GTBlocks.MINER_PIPE.get())) {
                serverLevel.method_8650(pos, false);
                pos = pos.method_10093(class_2350.field_11033);
            }
        }
    }

    private void checkFluidBlockAt(class_2338 pumpHeadPos, class_2338 checkPos) {
        class_2404 liquidBlock;
        class_2680 blockHere = this.getLevel().method_8320(checkPos);
        boolean shouldCheckNeighbours = this.isStraightInPumpRange(checkPos);
        class_2350[] class_2350Array = blockHere.method_26204();
        if (class_2350Array instanceof class_2404 && (liquidBlock = (class_2404)class_2350Array).method_9545(blockHere).method_15771()) {
            FluidBlockTransfer fluidHandler = new FluidBlockTransfer(liquidBlock, this.getLevel(), checkPos);
            FluidStack drainStack = fluidHandler.drain(Integer.MAX_VALUE, true);
            if (!drainStack.isEmpty()) {
                this.fluidSourceBlocks.add(checkPos);
            }
            shouldCheckNeighbours = true;
        }
        if (shouldCheckNeighbours) {
            int maxPumpRange = this.getMaxPumpRange();
            for (class_2350 facing : class_2350.values()) {
                class_2338 offsetPos = checkPos.method_10093(facing);
                if (offsetPos.method_10262((class_2382)pumpHeadPos) > (double)(maxPumpRange * maxPumpRange) || this.fluidSourceBlocks.contains(offsetPos) || this.blocksToCheck.contains(offsetPos)) continue;
                this.blocksToCheck.add(offsetPos);
            }
        }
    }

    private void tryPumpFirstBlock() {
        FluidBlockTransfer fluidHandler;
        FluidStack drainStack;
        class_2404 liquidBlock;
        class_2338 fluidBlockPos = this.fluidSourceBlocks.poll();
        if (fluidBlockPos == null) {
            return;
        }
        class_2680 blockHere = this.getLevel().method_8320(fluidBlockPos);
        class_2248 class_22482 = blockHere.method_26204();
        if (class_22482 instanceof class_2404 && (liquidBlock = (class_2404)class_22482).method_9545(blockHere).method_15771() && !(drainStack = (fluidHandler = new FluidBlockTransfer(liquidBlock, this.getLevel(), fluidBlockPos)).drain(Integer.MAX_VALUE, true)).isEmpty() && this.cache.fillInternal(drainStack, true) == drainStack.getAmount()) {
            this.cache.fillInternal(drainStack, false);
            fluidHandler.drain(drainStack, false);
            this.getLevel().method_8501(fluidBlockPos, class_2246.field_10124.method_9564());
            this.fluidSourceBlocks.remove(fluidBlockPos);
            this.energyContainer.changeEnergy(-GTValues.V[this.getTier()] * 2L);
        }
    }

    public void update() {
        if (this.getOutputFacingFluids() != null) {
            this.cache.exportToNearby(this.getOutputFacingFluids());
        }
        if (this.energyContainer.getEnergyStored() < GTValues.V[this.getTier()] * 2L) {
            return;
        }
        this.updateQueueState(this.getTier());
        if (this.getOffsetTimer() % (long)this.getPumpingCycleLength() == 0L && !this.fluidSourceBlocks.isEmpty()) {
            this.tryPumpFirstBlock();
        }
    }

    private int getPumpingCycleLength() {
        return 80 / (1 << this.getTier() - 1);
    }

    public ModularUI createUI(class_1657 entityPlayer) {
        return new ModularUI(176, 166, (IUIHolder)this, entityPlayer).background(new IGuiTexture[]{GuiTextures.BACKGROUND}).widget((Widget)new ImageWidget(7, 16, 81, 55, (IGuiTexture)GuiTextures.DISPLAY)).widget((Widget)new LabelWidget(11, 20, "gtceu.gui.fluid_amount")).widget((Widget)new LabelWidget(11, 30, () -> "" + this.cache.getFluidInTank(0).getAmount()).setTextColor(-1).setDropShadow(true)).widget((Widget)new LabelWidget(6, 6, this.getBlockState().method_26204().method_9539())).widget((Widget)new TankWidget((IFluidStorage)this.cache.storages[0], 90, 35, true, true).setBackground((IGuiTexture)GuiTextures.FLUID_SLOT)).widget((Widget)new ToggleButtonWidget(7, 53, 18, 18, (IGuiTexture)GuiTextures.BUTTON_FLUID_OUTPUT, this::isAutoOutputFluids, this::setAutoOutputFluids).setShouldUseBaseBackground().setTooltipText("gtceu.gui.fluid_auto_output.tooltip")).widget((Widget)UITemplate.bindPlayerInventory(entityPlayer.method_31548(), (IGuiTexture)GuiTextures.SLOT, 7, 84, true));
    }

    @Override
    public ResourceTexture sideTips(class_1657 player, Set<GTToolType> toolTypes, class_2350 side) {
        if (toolTypes.contains(GTToolType.WRENCH) && player.method_18276() && this.hasFrontFacing() && side != this.getFrontFacing() && this.isFacingValid(side)) {
            return GuiTextures.TOOL_IO_FACING_ROTATION;
        }
        return super.sideTips(player, toolTypes, side);
    }

    public int getPumpHeadY() {
        return this.pumpHeadY;
    }

    @Override
    public boolean isAutoOutputFluids() {
        return this.autoOutputFluids;
    }

    @Override
    public void setAutoOutputFluids(boolean autoOutputFluids) {
        this.autoOutputFluids = autoOutputFluids;
    }
}

