/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.electric;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.WidgetUtils;
import com.gregtechceu.gtceu.api.gui.editor.EditableMachineUI;
import com.gregtechceu.gtceu.api.gui.editor.EditableUI;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.TieredEnergyMachine;
import com.gregtechceu.gtceu.api.machine.feature.IAutoOutputItem;
import com.gregtechceu.gtceu.api.machine.feature.IFancyUIMachine;
import com.gregtechceu.gtceu.api.machine.feature.IMachineModifyDrops;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.gregtechceu.gtceu.api.syncdata.RequireRerender;
import com.gregtechceu.gtceu.data.lang.LangHandler;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.gui.widget.ProgressWidget;
import com.lowdragmc.lowdraglib.gui.widget.SlotWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.misc.ItemStackTransfer;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.lowdragmc.lowdraglib.side.item.ItemTransferHelper;
import com.lowdragmc.lowdraglib.syncdata.ISubscription;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import javax.annotation.ParametersAreNonnullByDefault;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3738;
import net.minecraft.class_3965;
import net.minecraft.class_5250;
import net.minecraft.class_6328;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@class_6328
public class BlockBreakerMachine
extends TieredEnergyMachine
implements IAutoOutputItem,
IFancyUIMachine,
IMachineModifyDrops {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(BlockBreakerMachine.class, TieredEnergyMachine.MANAGED_FIELD_HOLDER);
    @Persisted
    @DescSynced
    @RequireRerender
    protected class_2350 outputFacingItems;
    @Persisted
    @DescSynced
    @RequireRerender
    protected boolean autoOutputItems;
    @Persisted
    protected final NotifiableItemStackHandler cache;
    @Persisted
    protected final ItemStackTransfer chargerInventory;
    @Nullable
    protected TickableSubscription autoOutputSubs;
    @Nullable
    protected TickableSubscription batterySubs;
    @Nullable
    protected TickableSubscription breakerSubs;
    @Nullable
    protected ISubscription exportItemSubs;
    @Nullable
    protected ISubscription energySubs;
    private final int inventorySize;
    @DescSynced
    private int blockBreakProgress = 0;
    private float currentHardness;
    private final long energyPerTick;
    public final float efficiencyMultiplier;
    public static BiFunction<class_2960, Integer, EditableMachineUI> EDITABLE_UI_CREATOR = class_156.method_34865((path, inventorySize) -> new EditableMachineUI("misc", (class_2960)path, () -> {
        WidgetGroup template = BlockBreakerMachine.createTemplate(inventorySize).createDefault();
        ProgressWidget energyBar = BlockBreakerMachine.createEnergyBar().createDefault();
        SlotWidget batterySlot = BlockBreakerMachine.createBatterySlot().createDefault();
        WidgetGroup energyGroup = new WidgetGroup(0, 0, energyBar.getSize().width, energyBar.getSize().height + 20);
        batterySlot.setSelfPosition(new Position((energyBar.getSize().width - 18) / 2, energyBar.getSize().height + 1));
        energyGroup.addWidget((Widget)energyBar);
        energyGroup.addWidget((Widget)batterySlot);
        WidgetGroup group = new WidgetGroup(0, 0, Math.max(energyGroup.getSize().width + template.getSize().width + 4 + 8, 172), Math.max(template.getSize().height + 8, energyGroup.getSize().height + 8));
        Size size = group.getSize();
        energyGroup.setSelfPosition(new Position(3, (size.height - energyGroup.getSize().height) / 2));
        template.setSelfPosition(new Position((size.width - energyGroup.getSize().width - 4 - template.getSize().width) / 2 + 2 + energyGroup.getSize().width + 2, (size.height - template.getSize().height) / 2));
        group.addWidget((Widget)energyGroup);
        group.addWidget((Widget)template);
        return group;
    }, (template, machine) -> {
        if (machine instanceof BlockBreakerMachine) {
            BlockBreakerMachine blockBreakerMachine = (BlockBreakerMachine)machine;
            BlockBreakerMachine.createTemplate(inventorySize).setupUI((WidgetGroup)template, blockBreakerMachine);
            BlockBreakerMachine.createEnergyBar().setupUI((WidgetGroup)template, blockBreakerMachine);
            BlockBreakerMachine.createBatterySlot().setupUI((WidgetGroup)template, blockBreakerMachine);
        }
    }));

    public BlockBreakerMachine(IMachineBlockEntity holder, int tier, Object ... args) {
        super(holder, tier, new Object[0]);
        this.inventorySize = (tier + 1) * (tier + 1);
        this.cache = this.createCacheItemHandler(args);
        this.chargerInventory = this.createChargerItemHandler(new Object[0]);
        this.energyPerTick = GTValues.V[tier - 1];
        this.setOutputFacingItems(this.getFrontFacing().method_10153());
        this.efficiencyMultiplier = 1.0f - BlockBreakerMachine.getEfficiencyMultiplier(tier);
    }

    public static float getEfficiencyMultiplier(int tier) {
        float efficiencyMultiplier = 1.0f - 0.2f * ((float)tier - 1.0f);
        if (efficiencyMultiplier > 1.0f) {
            efficiencyMultiplier = 1.0f;
        } else if (efficiencyMultiplier < 0.1f) {
            efficiencyMultiplier = 0.1f;
        }
        efficiencyMultiplier = 1.0f - efficiencyMultiplier;
        return efficiencyMultiplier;
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    protected ItemStackTransfer createChargerItemHandler(Object ... args) {
        ItemStackTransfer transfer = new ItemStackTransfer();
        transfer.setFilter(item -> GTCapabilityHelper.getElectricItem(item) != null);
        return transfer;
    }

    protected NotifiableItemStackHandler createCacheItemHandler(Object ... args) {
        return new NotifiableItemStackHandler(this, this.inventorySize, IO.BOTH, IO.OUT);
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (!this.isRemote()) {
            class_1937 class_19372 = this.getLevel();
            if (class_19372 instanceof class_3218) {
                class_3218 serverLevel = (class_3218)class_19372;
                serverLevel.method_8503().method_18858((Runnable)new class_3738(0, this::updateAutoOutputSubscription));
                serverLevel.method_8503().method_18858((Runnable)new class_3738(0, this::updateBreakerUpdateSubscription));
            }
            this.exportItemSubs = this.cache.addChangedListener(this::updateAutoOutputSubscription);
            this.energySubs = this.energyContainer.addChangedListener(() -> {
                this.updateBatterySubscription();
                this.updateBreakerUpdateSubscription();
            });
            this.chargerInventory.setOnContentsChanged(this::updateBatterySubscription);
        }
    }

    @Override
    public void onUnload() {
        super.onUnload();
        if (this.energySubs != null) {
            this.energySubs.unsubscribe();
            this.energySubs = null;
        }
        if (this.exportItemSubs != null) {
            this.exportItemSubs.unsubscribe();
            this.exportItemSubs = null;
        }
    }

    @Override
    public void onDrops(List<class_1799> drops, class_1657 entity) {
        BlockBreakerMachine.clearInventory(drops, (IItemTransfer)this.chargerInventory);
        BlockBreakerMachine.clearInventory(drops, (IItemTransfer)this.cache.storage);
    }

    @Override
    public void onNeighborChanged(class_2248 block, class_2338 fromPos, boolean isMoving) {
        super.onNeighborChanged(block, fromPos, isMoving);
        this.updateBreakerUpdateSubscription();
        this.updateAutoOutputSubscription();
    }

    public void updateBreakerUpdateSubscription() {
        if (this.drainEnergy(true) && !this.getLevel().method_8320(this.getPos().method_10093(this.getFrontFacing())).method_26215() && this.getLevel().method_49803(this.getPos())) {
            this.breakerSubs = this.subscribeServerTick(this.breakerSubs, this::breakerUpdate);
        } else if (this.breakerSubs != null) {
            this.blockBreakProgress = 0;
            this.breakerSubs.unsubscribe();
            this.breakerSubs = null;
        }
    }

    public void breakerUpdate() {
        float hardness;
        class_2680 blockState;
        class_2338 pos;
        if (this.blockBreakProgress > 0) {
            --this.blockBreakProgress;
            this.drainEnergy(false);
            if (this.blockBreakProgress == 0) {
                pos = this.getPos().method_10093(this.getFrontFacing());
                blockState = this.getLevel().method_8320(pos);
                hardness = blockState.method_26204().method_36555();
                if (hardness >= 0.0f && Math.abs(hardness - this.currentHardness) < 0.5f) {
                    List<class_1799> drops = this.tryDestroyBlockAndGetDrops(pos);
                    for (class_1799 drop : drops) {
                        class_1799 remainder = this.tryFillCache(drop);
                        if (remainder.method_7960()) continue;
                        if (this.getOutputFacingItems() == null) {
                            class_2248.method_9577((class_1937)this.getLevel(), (class_2338)this.getPos(), (class_1799)remainder);
                            continue;
                        }
                        class_2248.method_9577((class_1937)this.getLevel(), (class_2338)this.getPos().method_10093(this.getOutputFacingItems()), (class_1799)remainder);
                    }
                }
                this.currentHardness = 0.0f;
            }
        }
        if (this.blockBreakProgress == 0) {
            pos = this.getPos().method_10093(this.getFrontFacing());
            blockState = this.getLevel().method_8320(pos);
            hardness = blockState.method_26204().method_36555();
            boolean skipBlock = blockState.method_26215();
            if (hardness >= 0.0f && !skipBlock) {
                int ticksPerOneDurability = 5;
                int totalTicksPerBlock = (int)Math.ceil((float)ticksPerOneDurability * hardness);
                this.blockBreakProgress = (int)Math.ceil((float)totalTicksPerBlock * this.efficiencyMultiplier);
                this.currentHardness = hardness;
            }
        }
        this.updateBreakerUpdateSubscription();
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void clientTick() {
        super.clientTick();
        if (this.blockBreakProgress > 0) {
            class_2338 pos = this.getPos().method_10093(this.getFrontFacing());
            class_2680 blockState = this.getLevel().method_8320(pos);
            this.getLevel().method_31595(pos, blockState);
        }
    }

    private List<class_1799> tryDestroyBlockAndGetDrops(class_2338 pos) {
        List drops = class_2248.method_9609((class_2680)this.getLevel().method_8320(pos), (class_3218)((class_3218)this.getLevel()), (class_2338)pos, null, null, (class_1799)class_1799.field_8037);
        this.getLevel().method_22352(pos, false);
        return drops;
    }

    private class_1799 tryFillCache(class_1799 stack) {
        for (int i = 0; i < this.cache.getSlots(); ++i) {
            if (this.cache.insertItemInternal(i, stack, true).method_7947() == stack.method_7947()) continue;
            return this.tryFillCache(this.cache.insertItemInternal(i, stack, false));
        }
        return stack;
    }

    public boolean drainEnergy(boolean simulate) {
        long resultEnergy = this.energyContainer.getEnergyStored() - this.energyPerTick;
        if (resultEnergy >= 0L && resultEnergy <= this.energyContainer.getEnergyCapacity()) {
            if (!simulate) {
                this.energyContainer.removeEnergy(this.energyPerTick);
            }
            return true;
        }
        return false;
    }

    @Override
    public void setAutoOutputItems(boolean allow) {
        this.autoOutputItems = allow;
        this.updateAutoOutputSubscription();
    }

    @Override
    public boolean isAllowInputFromOutputSideItems() {
        return false;
    }

    @Override
    public void setAllowInputFromOutputSideItems(boolean allow) {
    }

    @Override
    public void setOutputFacingItems(@Nullable class_2350 outputFacing) {
        this.outputFacingItems = outputFacing;
        this.updateAutoOutputSubscription();
    }

    protected void updateAutoOutputSubscription() {
        class_2350 outputFacing = this.getOutputFacingItems();
        if (this.isAutoOutputItems() && !this.cache.isEmpty() && outputFacing != null && ItemTransferHelper.getItemTransfer((class_1937)this.getLevel(), (class_2338)this.getPos().method_10093(outputFacing), (class_2350)outputFacing.method_10153()) != null) {
            this.autoOutputSubs = this.subscribeServerTick(this.autoOutputSubs, this::checkAutoOutput);
        } else if (this.autoOutputSubs != null) {
            this.autoOutputSubs.unsubscribe();
            this.autoOutputSubs = null;
        }
    }

    protected void checkAutoOutput() {
        if (this.getOffsetTimer() % 5L == 0L) {
            if (this.isAutoOutputItems() && this.getOutputFacingItems() != null) {
                this.cache.exportToNearby(this.getOutputFacingItems());
            }
            this.updateAutoOutputSubscription();
        }
    }

    protected void updateBatterySubscription() {
        if (this.energyContainer.dischargeOrRechargeEnergyContainers((IItemTransfer)this.chargerInventory, 0, true)) {
            this.batterySubs = this.subscribeServerTick(this.batterySubs, this::chargeBattery);
        } else if (this.batterySubs != null) {
            this.batterySubs.unsubscribe();
            this.batterySubs = null;
        }
    }

    protected void chargeBattery() {
        if (!this.energyContainer.dischargeOrRechargeEnergyContainers((IItemTransfer)this.chargerInventory, 0, false)) {
            this.updateBatterySubscription();
        }
    }

    @Override
    public boolean shouldWeatherOrTerrainExplosion() {
        return false;
    }

    @Override
    public boolean isFacingValid(class_2350 facing) {
        if (facing == this.getOutputFacingItems()) {
            return false;
        }
        return super.isFacingValid(facing);
    }

    protected static EditableUI<SlotWidget, BlockBreakerMachine> createBatterySlot() {
        return new EditableUI<SlotWidget, BlockBreakerMachine>("battery_slot", SlotWidget.class, () -> {
            SlotWidget slotWidget = new SlotWidget();
            slotWidget.setBackground(new IGuiTexture[]{GuiTextures.SLOT, GuiTextures.CHARGER_OVERLAY});
            return slotWidget;
        }, (slotWidget, machine) -> {
            slotWidget.setHandlerSlot((IItemTransfer)machine.chargerInventory, 0);
            slotWidget.setCanPutItems(true);
            slotWidget.setCanTakeItems(true);
            slotWidget.setHoverTooltips((class_2561[])LangHandler.getMultiLang("gtceu.gui.charger_slot.tooltip", GTValues.VNF[machine.getTier()], GTValues.VNF[machine.getTier()]).toArray(new class_5250[0]));
        });
    }

    protected static EditableUI<WidgetGroup, BlockBreakerMachine> createTemplate(int inventorySize) {
        return new EditableUI<WidgetGroup, BlockBreakerMachine>("functional_container", WidgetGroup.class, () -> {
            int rowSize = (int)Math.sqrt(inventorySize);
            WidgetGroup main = new WidgetGroup(0, 0, rowSize * 18 + 8, rowSize * 18 + 8);
            for (int y = 0; y < rowSize; ++y) {
                for (int x = 0; x < rowSize; ++x) {
                    int index = y * rowSize + x;
                    SlotWidget slotWidget = new SlotWidget();
                    slotWidget.initTemplate();
                    slotWidget.setSelfPosition(new Position(4 + x * 18, 4 + y * 18));
                    slotWidget.setBackground(new IGuiTexture[]{GuiTextures.SLOT});
                    slotWidget.setId("slot_" + index);
                    main.addWidget((Widget)slotWidget);
                }
            }
            main.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE});
            return main;
        }, (group, machine) -> WidgetUtils.widgetByIdForEach(group, "^slot_[0-9]+$", SlotWidget.class, slot -> {
            int index = WidgetUtils.widgetIdIndex((Widget)slot);
            if (index >= 0 && index < machine.cache.getSlots()) {
                slot.setHandlerSlot((IItemTransfer)machine.cache, index);
                slot.setCanTakeItems(true);
                slot.setCanPutItems(false);
            }
        }));
    }

    @Override
    public ResourceTexture sideTips(class_1657 player, Set<GTToolType> toolTypes, class_2350 side) {
        if (!(!toolTypes.contains(GTToolType.WRENCH) || player.method_18276() || this.hasFrontFacing() && side == this.getFrontFacing())) {
            return GuiTextures.TOOL_IO_FACING_ROTATION;
        }
        return super.sideTips(player, toolTypes, side);
    }

    @Override
    protected class_1269 onWrenchClick(class_1657 playerIn, class_1268 hand, class_2350 gridSide, class_3965 hitResult) {
        if (!playerIn.method_18276() && !this.isRemote()) {
            class_1799 tool = playerIn.method_5998(hand);
            if (tool.method_7919() >= tool.method_7936()) {
                return class_1269.field_5811;
            }
            if (this.hasFrontFacing() && gridSide == this.getFrontFacing()) {
                return class_1269.field_5811;
            }
            class_2350 itemFacing = this.outputFacingItems;
            if (gridSide != itemFacing) {
                this.setOutputFacingItems(gridSide);
            } else {
                this.setOutputFacingItems(null);
            }
            return class_1269.field_21466;
        }
        return super.onWrenchClick(playerIn, hand, gridSide, hitResult);
    }

    @Override
    public class_2350 getOutputFacingItems() {
        return this.outputFacingItems;
    }

    @Override
    public boolean isAutoOutputItems() {
        return this.autoOutputItems;
    }

    public ItemStackTransfer getChargerInventory() {
        return this.chargerInventory;
    }
}

