/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.electric;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.IControllable;
import com.gregtechceu.gtceu.api.capability.IElectricItem;
import com.gregtechceu.gtceu.api.capability.IEnergyContainer;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.editor.EditableUI;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.TieredEnergyMachine;
import com.gregtechceu.gtceu.api.machine.feature.IFancyUIMachine;
import com.gregtechceu.gtceu.api.machine.feature.IMachineModifyDrops;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableEnergyContainer;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.ProgressWidget;
import com.lowdragmc.lowdraglib.gui.widget.SlotWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.misc.ItemStackTransfer;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_6328;

@ParametersAreNonnullByDefault
@class_6328
public class BatteryBufferMachine
extends TieredEnergyMachine
implements IControllable,
IFancyUIMachine,
IMachineModifyDrops {
    public static final long AMPS_PER_BATTERY = 2L;
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(BatteryBufferMachine.class, TieredEnergyMachine.MANAGED_FIELD_HOLDER);
    @Persisted
    private boolean isWorkingEnabled = true;
    private final int inventorySize;
    @Persisted
    protected final ItemStackTransfer batteryInventory;

    public BatteryBufferMachine(IMachineBlockEntity holder, int tier, int inventorySize, Object ... args) {
        super(holder, tier, inventorySize);
        this.inventorySize = inventorySize;
        this.batteryInventory = this.createBatteryInventory(args);
        this.batteryInventory.setOnContentsChanged(this.energyContainer::checkOutputSubscription);
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Override
    protected NotifiableEnergyContainer createEnergyContainer(Object ... args) {
        return new EnergyBatteryTrait((Integer)args[0]);
    }

    protected ItemStackTransfer createBatteryInventory(Object ... args) {
        ItemStackTransfer itemTransfer = new ItemStackTransfer(this.inventorySize);
        itemTransfer.setFilter(item -> GTCapabilityHelper.getElectricItem(item) != null);
        return itemTransfer;
    }

    @Override
    public int tintColor(int index) {
        if (index == 2) {
            return GTValues.VC[this.getTier()];
        }
        return super.tintColor(index);
    }

    @Override
    public Widget createUIWidget() {
        int rowSize;
        int colSize = rowSize = (int)Math.sqrt(this.inventorySize);
        if (this.inventorySize == 8) {
            rowSize = 4;
            colSize = 2;
        }
        WidgetGroup template = new WidgetGroup(0, 0, 18 * rowSize + 8, 18 * colSize + 8);
        template.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE});
        int index = 0;
        for (int y = 0; y < colSize; ++y) {
            for (int x = 0; x < rowSize; ++x) {
                template.addWidget((Widget)new SlotWidget((IItemTransfer)this.batteryInventory, index++, 4 + x * 18, 4 + y * 18, true, true).setBackgroundTexture((IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{GuiTextures.SLOT, GuiTextures.BATTERY_OVERLAY})));
            }
        }
        EditableUI<ProgressWidget, TieredEnergyMachine> editableUI = BatteryBufferMachine.createEnergyBar();
        ProgressWidget energyBar = editableUI.createDefault();
        WidgetGroup group = new WidgetGroup(0, 0, Math.max(energyBar.getSize().width + template.getSize().width + 4 + 8, 172), Math.max(template.getSize().height + 8, energyBar.getSize().height + 8));
        Size size = group.getSize();
        energyBar.setSelfPosition(new Position(3, (size.height - energyBar.getSize().height) / 2));
        template.setSelfPosition(new Position((size.width - energyBar.getSize().width - 4 - template.getSize().width) / 2 + 2 + energyBar.getSize().width + 2, (size.height - template.getSize().height) / 2));
        group.addWidget((Widget)energyBar);
        group.addWidget((Widget)template);
        editableUI.setupUI(group, this);
        return group;
    }

    private List<IElectricItem> getNonFullBatteries() {
        ArrayList<IElectricItem> batteries = new ArrayList<IElectricItem>();
        for (int i = 0; i < this.batteryInventory.getSlots(); ++i) {
            class_1799 batteryStack = this.batteryInventory.getStackInSlot(i);
            IElectricItem electricItem = GTCapabilityHelper.getElectricItem(batteryStack);
            if (electricItem == null || electricItem.getCharge() >= electricItem.getMaxCharge()) continue;
            batteries.add(electricItem);
        }
        return batteries;
    }

    private List<IElectricItem> getNonEmptyBatteries() {
        ArrayList<IElectricItem> batteries = new ArrayList<IElectricItem>();
        for (int i = 0; i < this.batteryInventory.getSlots(); ++i) {
            class_1799 batteryStack = this.batteryInventory.getStackInSlot(i);
            IElectricItem electricItem = GTCapabilityHelper.getElectricItem(batteryStack);
            if (electricItem == null || !electricItem.canProvideChargeExternally() || electricItem.getCharge() <= 0L) continue;
            batteries.add(electricItem);
        }
        return batteries;
    }

    private List<IElectricItem> getAllBatteries() {
        ArrayList<IElectricItem> batteries = new ArrayList<IElectricItem>();
        for (int i = 0; i < this.batteryInventory.getSlots(); ++i) {
            class_1799 batteryStack = this.batteryInventory.getStackInSlot(i);
            IElectricItem electricItem = GTCapabilityHelper.getElectricItem(batteryStack);
            if (electricItem == null) continue;
            batteries.add(electricItem);
        }
        return batteries;
    }

    @Override
    public void onDrops(List<class_1799> drops, class_1657 entity) {
        MetaMachine.clearInventory(drops, (IItemTransfer)this.batteryInventory);
    }

    @Override
    public boolean isWorkingEnabled() {
        return this.isWorkingEnabled;
    }

    @Override
    public void setWorkingEnabled(boolean isWorkingEnabled) {
        this.isWorkingEnabled = isWorkingEnabled;
    }

    public int getInventorySize() {
        return this.inventorySize;
    }

    public ItemStackTransfer getBatteryInventory() {
        return this.batteryInventory;
    }

    protected class EnergyBatteryTrait
    extends NotifiableEnergyContainer {
        protected EnergyBatteryTrait(int inventorySize) {
            super(BatteryBufferMachine.this, GTValues.V[BatteryBufferMachine.this.tier] * (long)inventorySize * 32L, GTValues.V[BatteryBufferMachine.this.tier], (long)inventorySize * 2L, GTValues.V[BatteryBufferMachine.this.tier], inventorySize);
            this.setSideInputCondition(side -> side != BatteryBufferMachine.this.getFrontFacing() && BatteryBufferMachine.this.isWorkingEnabled());
            this.setSideOutputCondition(side -> side == BatteryBufferMachine.this.getFrontFacing() && BatteryBufferMachine.this.isWorkingEnabled());
        }

        @Override
        public void serverTick() {
            class_2350 outFacing = BatteryBufferMachine.this.getFrontFacing();
            IEnergyContainer energyContainer = GTCapabilityHelper.getEnergyContainer(BatteryBufferMachine.this.getLevel(), BatteryBufferMachine.this.getPos().method_10093(outFacing), outFacing.method_10153());
            if (energyContainer == null) {
                return;
            }
            long voltage = this.getOutputVoltage();
            List<IElectricItem> batteries = BatteryBufferMachine.this.getNonEmptyBatteries();
            if (!batteries.isEmpty()) {
                long internalAmps = Math.abs(Math.min(0L, this.getInternalStorage() / voltage));
                long genAmps = Math.max(0L, (long)batteries.size() - internalAmps);
                long outAmps = 0L;
                if (genAmps > 0L && (outAmps = energyContainer.acceptEnergyFromNetwork(outFacing.method_10153(), voltage, genAmps)) == 0L && internalAmps == 0L) {
                    return;
                }
                long energy = (outAmps + internalAmps) * voltage;
                long distributed = energy / (long)batteries.size();
                boolean changed = false;
                for (IElectricItem electricItem : batteries) {
                    long charged = electricItem.discharge(distributed, BatteryBufferMachine.this.getTier(), false, true, false);
                    if (charged > 0L) {
                        changed = true;
                    }
                    energy -= charged;
                }
                if (changed) {
                    BatteryBufferMachine.this.markDirty();
                    this.checkOutputSubscription();
                }
                this.setEnergyStored(this.getInternalStorage() + internalAmps * voltage - energy);
            }
        }

        @Override
        public long acceptEnergyFromNetwork(@Nullable class_2350 side, long voltage, long amperage) {
            long latestTS = this.getMachine().getOffsetTimer();
            if (this.lastTS < latestTS) {
                this.amps = 0L;
                this.lastTS = latestTS;
            }
            if (amperage <= 0L || voltage <= 0L) {
                return 0L;
            }
            List<IElectricItem> batteries = BatteryBufferMachine.this.getNonFullBatteries();
            long leftAmps = (long)batteries.size() * 2L - this.amps;
            long usedAmps = Math.min(leftAmps, amperage);
            if (leftAmps <= 0L) {
                return 0L;
            }
            if (side == null || this.inputsEnergy(side)) {
                if (voltage > this.getInputVoltage()) {
                    BatteryBufferMachine.this.doExplosion(GTUtil.getExplosionPower(voltage));
                    return usedAmps;
                }
                long internalAmps = Math.min(leftAmps, Math.max(0L, this.getInternalStorage() / voltage));
                usedAmps = Math.min(usedAmps, leftAmps - internalAmps);
                this.amps += usedAmps;
                long energy = (usedAmps + internalAmps) * voltage;
                long distributed = energy / (long)batteries.size();
                boolean changed = false;
                for (IElectricItem battery : batteries) {
                    long charged = battery.charge(Math.min(distributed, GTValues.V[battery.getTier()] * 2L), BatteryBufferMachine.this.getTier(), true, false);
                    if (charged > 0L) {
                        changed = true;
                    }
                    energy -= charged;
                }
                if (changed) {
                    BatteryBufferMachine.this.markDirty();
                    this.checkOutputSubscription();
                }
                this.setEnergyStored(this.getInternalStorage() - internalAmps * voltage + energy);
                return usedAmps;
            }
            return 0L;
        }

        @Override
        public long getEnergyCapacity() {
            long energyCapacity = 0L;
            for (IElectricItem battery : BatteryBufferMachine.this.getAllBatteries()) {
                energyCapacity += battery.getMaxCharge();
            }
            return energyCapacity;
        }

        @Override
        public long getEnergyStored() {
            long energyStored = 0L;
            for (IElectricItem battery : BatteryBufferMachine.this.getAllBatteries()) {
                energyStored += battery.getCharge();
            }
            return energyStored;
        }

        private long getInternalStorage() {
            return this.energyStored;
        }
    }
}

