/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.item.tool.behavior;

import com.google.common.collect.ImmutableSet;
import com.gregtechceu.gtceu.api.item.tool.ToolHelper;
import com.gregtechceu.gtceu.api.item.tool.aoe.AoESymmetrical;
import com.gregtechceu.gtceu.api.item.tool.behavior.IToolBehavior;
import com.gregtechceu.gtceu.common.item.tool.behavior.fabric.HoeGroundBehaviorImpl;
import com.mojang.datafixers.util.Pair;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1794;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HoeGroundBehavior
implements IToolBehavior {
    public static final HoeGroundBehavior INSTANCE = HoeGroundBehavior.create();

    protected HoeGroundBehavior() {
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    protected static HoeGroundBehavior create() {
        return HoeGroundBehaviorImpl.create();
    }

    @Override
    @NotNull
    public class_1269 onItemUse(class_1838 context) {
        Object blocks;
        if (context.method_8038() == class_2350.field_11033) {
            return class_1269.field_5811;
        }
        class_1937 world = context.method_8045();
        class_1657 player = context.method_8036();
        class_2338 pos = context.method_8037();
        class_1268 hand = context.method_20287();
        class_1799 stack = player.method_5998(hand);
        AoESymmetrical aoeDefinition = ToolHelper.getAoEDefinition(stack);
        class_2248 hitBlock = world.method_8320(pos).method_26204();
        if (class_1794.field_8023.containsKey(hitBlock) && ((Predicate)((Pair)class_1794.field_8023.get(hitBlock)).getFirst()).test(context)) {
            if (aoeDefinition == AoESymmetrical.none()) {
                blocks = ImmutableSet.of((Object)pos);
            } else {
                class_239 rayTraceResult = ToolHelper.getPlayerDefaultRaytrace(player);
                if (rayTraceResult == null) {
                    return class_1269.field_5811;
                }
                if (rayTraceResult.method_17783() != class_239.class_240.field_1332) {
                    return class_1269.field_5811;
                }
                if (!(rayTraceResult instanceof class_3965)) {
                    return class_1269.field_5811;
                }
                class_3965 blockHitResult = (class_3965)rayTraceResult;
                if (blockHitResult.method_17780() == null) {
                    return class_1269.field_5811;
                }
                blocks = HoeGroundBehavior.getTillableBlocks(stack, aoeDefinition, world, player, (class_239)blockHitResult);
                if (this.isBlockTillable(stack, world, player, blockHitResult.method_17777(), context)) {
                    blocks.add(blockHitResult.method_17777());
                }
            }
        } else {
            return class_1269.field_5811;
        }
        boolean tilled = false;
        Iterator iterator = blocks.iterator();
        while (iterator.hasNext()) {
            class_2338 blockPos = (class_2338)iterator.next();
            class_2680 state = world.method_8320(blockPos);
            class_2248 block = state.method_26204();
            if (!class_1794.field_8023.containsKey(block)) continue;
            tilled |= this.tillGround(new class_1838(player, hand, context.method_30344().method_29328(blockPos)), state);
            if (!player.method_7337()) {
                ToolHelper.damageItem(context.method_8041(), (class_1309)context.method_8036());
            }
            if (!stack.method_7960()) continue;
            break;
        }
        if (tilled) {
            world.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14846, class_3419.field_15248, 1.0f, 1.0f);
            player.method_6104(hand);
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public static Set<class_2338> getTillableBlocks(class_1799 stack, AoESymmetrical aoeDefinition, class_1937 world, class_1657 player, class_239 rayTraceResult) {
        return ToolHelper.iterateAoE(stack, aoeDefinition, world, player, rayTraceResult, INSTANCE::isBlockTillable);
    }

    protected boolean isBlockTillable(class_1799 stack, class_1937 world, class_1657 player, class_2338 pos, class_1838 context) {
        if (world.method_8320(pos.method_10084()).method_26215()) {
            class_2248 block = world.method_8320(pos).method_26204();
            return class_1794.field_8023.containsKey(block) && ((Predicate)((Pair)class_1794.field_8023.get(block)).getFirst()).test(context);
        }
        return false;
    }

    protected boolean tillGround(class_1838 context, class_2680 block) {
        Pair state = (Pair)class_1794.field_8023.get(block.method_26204());
        if (((Predicate)state.getFirst()).test(context)) {
            ((Consumer)state.getSecond()).accept(context);
            return true;
        }
        return false;
    }

    @Override
    public void addInformation(@NotNull class_1799 stack, @Nullable class_1937 world, @NotNull List<class_2561> tooltip, @NotNull class_1836 flag) {
        tooltip.add((class_2561)class_2561.method_43471((String)"item.gtceu.tool.behavior.ground_tilling"));
    }
}

