/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.data;

import appeng.api.networking.pathing.ChannelMode;
import appeng.core.AEConfig;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.block.ICoilType;
import com.gregtechceu.gtceu.api.block.IMachineBlock;
import com.gregtechceu.gtceu.api.block.MetaMachineBlock;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.IMiner;
import com.gregtechceu.gtceu.api.capability.PlatformEnergyCompat;
import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.data.RotationState;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.item.DrumMachineItem;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.MultiblockMachineDefinition;
import com.gregtechceu.gtceu.api.machine.SimpleGeneratorMachine;
import com.gregtechceu.gtceu.api.machine.SimpleTieredMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IRotorHolderMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.CleanroomType;
import com.gregtechceu.gtceu.api.machine.multiblock.CoilWorkableElectricMultiblockMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.IBatteryData;
import com.gregtechceu.gtceu.api.machine.multiblock.MultiblockControllerMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.PartAbility;
import com.gregtechceu.gtceu.api.machine.multiblock.WorkableElectricMultiblockMachine;
import com.gregtechceu.gtceu.api.machine.steam.SimpleSteamMachine;
import com.gregtechceu.gtceu.api.machine.steam.SteamBoilerMachine;
import com.gregtechceu.gtceu.api.pattern.FactoryBlockPattern;
import com.gregtechceu.gtceu.api.pattern.MultiblockShapeInfo;
import com.gregtechceu.gtceu.api.pattern.Predicates;
import com.gregtechceu.gtceu.api.pattern.TraceabilityPredicate;
import com.gregtechceu.gtceu.api.pattern.predicates.SimplePredicate;
import com.gregtechceu.gtceu.api.pattern.util.RelativeDirection;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.recipe.OverclockingLogic;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.api.registry.registrate.MachineBuilder;
import com.gregtechceu.gtceu.api.registry.registrate.MultiblockMachineBuilder;
import com.gregtechceu.gtceu.client.TooltipHelper;
import com.gregtechceu.gtceu.client.renderer.machine.BatteryBufferRenderer;
import com.gregtechceu.gtceu.client.renderer.machine.ChargerRenderer;
import com.gregtechceu.gtceu.client.renderer.machine.ConverterRenderer;
import com.gregtechceu.gtceu.client.renderer.machine.LargeBoilerRenderer;
import com.gregtechceu.gtceu.client.renderer.machine.LargeMinerRenderer;
import com.gregtechceu.gtceu.client.renderer.machine.MachineRenderer;
import com.gregtechceu.gtceu.client.renderer.machine.MaintenanceHatchPartRenderer;
import com.gregtechceu.gtceu.client.renderer.machine.MinerRenderer;
import com.gregtechceu.gtceu.client.renderer.machine.ProcessingArrayMachineRenderer;
import com.gregtechceu.gtceu.client.renderer.machine.PumpHatchPartRenderer;
import com.gregtechceu.gtceu.client.renderer.machine.QuantumChestRenderer;
import com.gregtechceu.gtceu.client.renderer.machine.QuantumTankRenderer;
import com.gregtechceu.gtceu.client.renderer.machine.RotorHolderMachineRenderer;
import com.gregtechceu.gtceu.client.renderer.machine.SimpleGeneratorMachineRenderer;
import com.gregtechceu.gtceu.client.renderer.machine.SteamMinerRenderer;
import com.gregtechceu.gtceu.client.renderer.machine.TieredHullMachineRenderer;
import com.gregtechceu.gtceu.client.renderer.machine.TransformerRenderer;
import com.gregtechceu.gtceu.client.renderer.machine.WorkableSteamMachineRenderer;
import com.gregtechceu.gtceu.common.block.BoilerFireboxType;
import com.gregtechceu.gtceu.common.data.GCyMMachines;
import com.gregtechceu.gtceu.common.data.GTBlocks;
import com.gregtechceu.gtceu.common.data.GTCompassNodes;
import com.gregtechceu.gtceu.common.data.GTCompassSections;
import com.gregtechceu.gtceu.common.data.GTCreateMachines;
import com.gregtechceu.gtceu.common.data.GTCreativeModeTabs;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.data.GTRecipeModifiers;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.common.machine.electric.BatteryBufferMachine;
import com.gregtechceu.gtceu.common.machine.electric.BlockBreakerMachine;
import com.gregtechceu.gtceu.common.machine.electric.ChargerMachine;
import com.gregtechceu.gtceu.common.machine.electric.ConverterMachine;
import com.gregtechceu.gtceu.common.machine.electric.FisherMachine;
import com.gregtechceu.gtceu.common.machine.electric.HullMachine;
import com.gregtechceu.gtceu.common.machine.electric.MinerMachine;
import com.gregtechceu.gtceu.common.machine.electric.PumpMachine;
import com.gregtechceu.gtceu.common.machine.electric.TransformerMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.electric.ActiveTransformerMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.electric.BedrockOreMinerMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.electric.CleanroomMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.electric.FluidDrillMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.electric.FusionReactorMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.electric.LargeMinerMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.electric.PowerSubstationMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.electric.ProcessingArrayMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.generator.LargeCombustionEngineMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.generator.LargeTurbineMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.part.AutoMaintenanceHatchPartMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.part.CleaningMaintenanceHatchPartMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.part.CokeOvenHatch;
import com.gregtechceu.gtceu.common.machine.multiblock.part.DiodePartMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.part.EnergyHatchPartMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.part.FluidHatchPartMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.part.ItemBusPartMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.part.LaserHatchPartMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.part.MaintenanceHatchPartMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.part.MufflerPartMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.part.PumpHatchPartMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.part.RotorHolderPartMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.part.SteamHatchPartMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.part.SteamItemBusPartMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.primitive.CokeOvenMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.primitive.PrimitiveBlastFurnaceMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.primitive.PrimitivePumpMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.steam.LargeBoilerMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.steam.SteamParallelMultiblockMachine;
import com.gregtechceu.gtceu.common.machine.steam.SteamLiquidBoilerMachine;
import com.gregtechceu.gtceu.common.machine.steam.SteamMinerMachine;
import com.gregtechceu.gtceu.common.machine.steam.SteamSolarBoiler;
import com.gregtechceu.gtceu.common.machine.steam.SteamSolidBoilerMachine;
import com.gregtechceu.gtceu.common.machine.storage.CrateMachine;
import com.gregtechceu.gtceu.common.machine.storage.CreativeEnergyContainerMachine;
import com.gregtechceu.gtceu.common.machine.storage.DrumMachine;
import com.gregtechceu.gtceu.common.machine.storage.QuantumChestMachine;
import com.gregtechceu.gtceu.common.machine.storage.QuantumTankMachine;
import com.gregtechceu.gtceu.common.pipelike.fluidpipe.longdistance.LDFluidEndpointMachine;
import com.gregtechceu.gtceu.common.pipelike.item.longdistance.LDItemEndpointMachine;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.data.lang.LangHandler;
import com.gregtechceu.gtceu.integration.ae2.GTAEMachines;
import com.gregtechceu.gtceu.integration.kjs.GTRegistryObjectBuilderTypes;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.lowdragmc.lowdraglib.Platform;
import com.lowdragmc.lowdraglib.side.fluid.FluidHelper;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.lowdraglib.utils.BlockInfo;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.nullness.NonNullUnaryOperator;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.ints.Int2LongFunction;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2323;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_259;
import net.minecraft.class_2680;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_4970;
import net.minecraft.class_5250;
import org.apache.commons.lang3.function.TriFunction;

public class GTMachines {
    public static final int[] ALL_TIERS = GTValues.tiersBetween(0, GTCEu.isHighTier() ? 14 : 9);
    public static final int[] ELECTRIC_TIERS = GTValues.tiersBetween(1, GTCEu.isHighTier() ? 13 : 8);
    public static final int[] LOW_TIERS = GTValues.tiersBetween(1, 4);
    public static final int[] HIGH_TIERS = GTValues.tiersBetween(5, GTCEu.isHighTier() ? 13 : 9);
    public static final int[] MULTI_HATCH_TIERS = GTValues.tiersBetween(4, GTCEu.isHighTier() ? 14 : 9);
    public static final Int2LongFunction defaultTankSizeFunction = tier -> (long)(tier <= 1 ? 8 : (tier == 2 ? 12 : (tier == 3 ? 16 : (tier == 4 ? 32 : 64)))) * FluidHelper.getBucket();
    public static final Int2LongFunction hvCappedTankSizeFunction = tier -> (long)(tier <= 1 ? 8 : (tier == 2 ? 12 : 16)) * FluidHelper.getBucket();
    public static final Int2LongFunction largeTankSizeFunction = tier -> (long)(tier <= 1 ? 32 : (tier == 2 ? 48 : 64)) * FluidHelper.getBucket();
    public static final Int2LongFunction steamGeneratorTankSizeFunction = tier -> (long)Math.min(16 * (1 << tier - 1), 64) * FluidHelper.getBucket();
    public static final Int2LongFunction genericGeneratorTankSizeFunction = tier -> (long)Math.min(4 * (1 << tier - 1), 16) * FluidHelper.getBucket();
    public static Object2IntMap<MachineDefinition> DRUM_CAPACITY = new Object2IntArrayMap();
    public static final Pair<MachineDefinition, MachineDefinition> STEAM_SOLID_BOILER;
    public static final Pair<MachineDefinition, MachineDefinition> STEAM_LIQUID_BOILER;
    public static final Pair<MachineDefinition, MachineDefinition> STEAM_SOLAR_BOILER;
    public static final Pair<MachineDefinition, MachineDefinition> STEAM_EXTRACTOR;
    public static final Pair<MachineDefinition, MachineDefinition> STEAM_MACERATOR;
    public static final Pair<MachineDefinition, MachineDefinition> STEAM_COMPRESSOR;
    public static final Pair<MachineDefinition, MachineDefinition> STEAM_HAMMER;
    public static final Pair<MachineDefinition, MachineDefinition> STEAM_FURNACE;
    public static final Pair<MachineDefinition, MachineDefinition> STEAM_ALLOY_SMELTER;
    public static final Pair<MachineDefinition, MachineDefinition> STEAM_ROCK_CRUSHER;
    public static final MachineDefinition STEAM_MINER;
    public static final MachineDefinition[] HULL;
    public static final MachineDefinition[] ELECTRIC_FURNACE;
    public static final MachineDefinition[] ALLOY_SMELTER;
    public static final MachineDefinition[] ARC_FURNACE;
    public static final MachineDefinition[] ASSEMBLER;
    public static final MachineDefinition[] AUTOCLAVE;
    public static final MachineDefinition[] BENDER;
    public static final MachineDefinition[] BREWERY;
    public static final MachineDefinition[] CANNER;
    public static final MachineDefinition[] CENTRIFUGE;
    public static final MachineDefinition[] CHEMICAL_BATH;
    public static final MachineDefinition[] CHEMICAL_REACTOR;
    public static final MachineDefinition[] COMPRESSOR;
    public static final MachineDefinition[] CUTTER;
    public static final MachineDefinition[] DISTILLERY;
    public static final MachineDefinition[] ELECTROLYZER;
    public static final MachineDefinition[] ELECTROMAGNETIC_SEPARATOR;
    public static final MachineDefinition[] EXTRACTOR;
    public static final MachineDefinition[] EXTRUDER;
    public static final MachineDefinition[] FERMENTER;
    public static final MachineDefinition[] FLUID_HEATER;
    public static final MachineDefinition[] FLUID_SOLIDIFIER;
    public static final MachineDefinition[] FORGE_HAMMER;
    public static final MachineDefinition[] FORMING_PRESS;
    public static final MachineDefinition[] LATHE;
    public static final MachineDefinition[] MIXER;
    public static final MachineDefinition[] ORE_WASHER;
    public static final MachineDefinition[] PACKER;
    public static final MachineDefinition[] POLARIZER;
    public static final MachineDefinition[] LASER_ENGRAVER;
    public static final MachineDefinition[] SIFTER;
    public static final MachineDefinition[] THERMAL_CENTRIFUGE;
    public static final MachineDefinition[] WIREMILL;
    public static final MachineDefinition[] CIRCUIT_ASSEMBLER;
    public static final MachineDefinition[] MACERATOR;
    public static final MachineDefinition[] GAS_COLLECTOR;
    public static final MachineDefinition[] ROCK_CRUSHER;
    public static final MachineDefinition[] COMBUSTION;
    public static final MachineDefinition[] STEAM_TURBINE;
    public static final MachineDefinition[] GAS_TURBINE;
    public static final MachineDefinition[] TRANSFORMER;
    public static final MachineDefinition[] HI_AMP_TRANSFORMER_2A;
    public static final MachineDefinition[] HI_AMP_TRANSFORMER_4A;
    public static final MachineDefinition[] POWER_TRANSFORMER;
    public static final MachineDefinition[] ENERGY_CONVERTER_1A;
    public static final MachineDefinition[] ENERGY_CONVERTER_4A;
    public static final MachineDefinition[] ENERGY_CONVERTER_8A;
    public static final MachineDefinition[] ENERGY_CONVERTER_16A;
    public static final MachineDefinition LONG_DIST_ITEM_ENDPOINT;
    public static final MachineDefinition LONG_DIST_FLUID_ENDPOINT;
    public static final MachineDefinition[] BATTERY_BUFFER_4;
    public static final MachineDefinition[] BATTERY_BUFFER_8;
    public static final MachineDefinition[] BATTERY_BUFFER_16;
    public static final MachineDefinition[] CHARGER_4;
    public static final MachineDefinition[] PUMP;
    public static final MachineDefinition[] FISHER;
    public static final MachineDefinition[] BLOCK_BREAKER;
    public static final MachineDefinition[] MINER;
    public static final MachineDefinition CREATIVE_ENERGY;
    public static BiConsumer<class_1799, List<class_2561>> CHEST_TOOLTIPS;
    public static final MachineDefinition[] SUPER_CHEST;
    public static final MachineDefinition[] QUANTUM_CHEST;
    public static final MachineDefinition[] SUPER_TANK;
    public static final MachineDefinition[] QUANTUM_TANK;
    public static MachineDefinition WOODEN_CRATE;
    public static MachineDefinition BRONZE_CRATE;
    public static MachineDefinition STEEL_CRATE;
    public static MachineDefinition ALUMINIUM_CRATE;
    public static MachineDefinition STAINLESS_STEEL_CRATE;
    public static MachineDefinition TITANIUM_CRATE;
    public static MachineDefinition TUNGSTENSTEEL_CRATE;
    public static MachineDefinition WOODEN_DRUM;
    public static MachineDefinition BRONZE_DRUM;
    public static MachineDefinition STEEL_DRUM;
    public static MachineDefinition ALUMINIUM_DRUM;
    public static MachineDefinition STAINLESS_STEEL_DRUM;
    public static MachineDefinition GOLD_DRUM;
    public static MachineDefinition TITANIUM_DRUM;
    public static MachineDefinition TUNGSTENSTEEL_DRUM;
    public static final MachineDefinition[] ITEM_IMPORT_BUS;
    public static final MachineDefinition[] ITEM_EXPORT_BUS;
    public static final MachineDefinition[] FLUID_IMPORT_HATCH;
    public static final MachineDefinition[] FLUID_IMPORT_HATCH_4X;
    public static final MachineDefinition[] FLUID_IMPORT_HATCH_9X;
    public static final MachineDefinition[] FLUID_EXPORT_HATCH;
    public static final MachineDefinition[] FLUID_EXPORT_HATCH_4X;
    public static final MachineDefinition[] FLUID_EXPORT_HATCH_9X;
    public static final MachineDefinition[] ENERGY_INPUT_HATCH;
    public static final MachineDefinition[] ENERGY_OUTPUT_HATCH;
    public static final MachineDefinition[] ENERGY_INPUT_HATCH_4A;
    public static final MachineDefinition[] ENERGY_OUTPUT_HATCH_4A;
    public static final MachineDefinition[] ENERGY_INPUT_HATCH_16A;
    public static final MachineDefinition[] ENERGY_OUTPUT_HATCH_16A;
    public static final MachineDefinition[] SUBSTATION_ENERGY_INPUT_HATCH;
    public static final MachineDefinition[] SUBSTATION_ENERGY_OUTPUT_HATCH;
    public static final MachineDefinition[] MUFFLER_HATCH;
    public static final MachineDefinition STEAM_IMPORT_BUS;
    public static final MachineDefinition STEAM_EXPORT_BUS;
    public static final MachineDefinition STEAM_HATCH;
    public static final MachineDefinition COKE_OVEN_HATCH;
    public static final MachineDefinition PUMP_HATCH;
    public static final MachineDefinition MAINTENANCE_HATCH;
    public static final MachineDefinition CONFIGURABLE_MAINTENANCE_HATCH;
    public static final MachineDefinition CLEANING_MAINTENANCE_HATCH;
    public static final MachineDefinition AUTO_MAINTENANCE_HATCH;
    public static final MachineDefinition[] ITEM_PASSTHROUGH_HATCH;
    public static final MachineDefinition[] FLUID_PASSTHROUGH_HATCH;
    public static final MachineDefinition[] DIODE;
    public static final MachineDefinition[] ROTOR_HOLDER;
    public static final MachineDefinition[] LASER_INPUT_HATCH_256;
    public static final MachineDefinition[] LASER_OUTPUT_HATCH_256;
    public static final MachineDefinition[] LASER_INPUT_HATCH_1024;
    public static final MachineDefinition[] LASER_OUTPUT_HATCH_1024;
    public static final MachineDefinition[] LASER_INPUT_HATCH_4096;
    public static final MachineDefinition[] LASER_OUTPUT_HATCH_4096;
    public static final MultiblockMachineDefinition LARGE_BOILER_BRONZE;
    public static final MultiblockMachineDefinition LARGE_BOILER_STEEL;
    public static final MultiblockMachineDefinition LARGE_BOILER_TITANIUM;
    public static final MultiblockMachineDefinition LARGE_BOILER_TUNGSTENSTEEL;
    public static final MultiblockMachineDefinition COKE_OVEN;
    public static final MultiblockMachineDefinition PRIMITIVE_BLAST_FURNACE;
    public static final MultiblockMachineDefinition ELECTRIC_BLAST_FURNACE;
    public static final MultiblockMachineDefinition LARGE_CHEMICAL_REACTOR;
    public static final MultiblockMachineDefinition IMPLOSION_COMPRESSOR;
    public static final MultiblockMachineDefinition PYROLYSE_OVEN;
    public static final MultiblockMachineDefinition MULTI_SMELTER;
    public static final MultiblockMachineDefinition CRACKER;
    public static final MultiblockMachineDefinition DISTILLATION_TOWER;
    public static final MultiblockMachineDefinition VACUUM_FREEZER;
    public static final MultiblockMachineDefinition ASSEMBLY_LINE;
    public static final MultiblockMachineDefinition PRIMITIVE_PUMP;
    public static final MultiblockMachineDefinition STEAM_GRINDER;
    public static final MultiblockMachineDefinition STEAM_OVEN;
    public static final MultiblockMachineDefinition[] FUSION_REACTOR;
    public static final MultiblockMachineDefinition[] FLUID_DRILLING_RIG;
    public static final MultiblockMachineDefinition[] LARGE_MINER;
    public static MultiblockMachineDefinition[] BEDROCK_ORE_MINER;
    public static final MultiblockMachineDefinition CLEANROOM;
    public static final MultiblockMachineDefinition LARGE_COMBUSTION_ENGINE;
    public static final MultiblockMachineDefinition EXTREME_COMBUSTION_ENGINE;
    public static final MultiblockMachineDefinition LARGE_STEAM_TURBINE;
    public static final MultiblockMachineDefinition LARGE_GAS_TURBINE;
    public static final MultiblockMachineDefinition LARGE_PLASMA_TURBINE;
    public static final MultiblockMachineDefinition[] PROCESSING_ARRAY;
    public static final MultiblockMachineDefinition ACTIVE_TRANSFORMER;
    public static final MultiblockMachineDefinition POWER_SUBSTATION;

    public static BiConsumer<class_1799, List<class_2561>> createTankTooltips(String nbtName) {
        return (stack, list) -> {
            if (stack.method_7985()) {
                FluidStack tank = FluidStack.loadFromTag((class_2487)stack.method_7911(nbtName));
                list.add(1, class_2561.method_43469((String)"gtceu.universal.tooltip.fluid_stored", (Object[])new Object[]{tank.getDisplayName(), tank.getAmount()}));
            }
        };
    }

    public static Pair<MachineDefinition, MachineDefinition> registerSteamMachines(String name, BiFunction<IMachineBlockEntity, Boolean, MetaMachine> factory, BiFunction<Boolean, MachineBuilder<MachineDefinition>, MachineDefinition> builder) {
        MachineDefinition lowTier = builder.apply(false, GTRegistries.REGISTRATE.machine("lp_%s".formatted(name), holder -> (MetaMachine)factory.apply((IMachineBlockEntity)holder, false)).langValue("Low Pressure " + FormattingUtil.toEnglishName(name)).compassSections(GTCompassSections.STEAM).compassNode(name).compassPreNodes(GTCompassNodes.STEAM).tier(0));
        MachineDefinition highTier = builder.apply(true, GTRegistries.REGISTRATE.machine("hp_%s".formatted(name), holder -> (MetaMachine)factory.apply((IMachineBlockEntity)holder, true)).langValue("High Pressure " + FormattingUtil.toEnglishName(name)).compassSections(GTCompassSections.STEAM).compassNode(name).compassPreNodes(GTCompassNodes.STEAM).tier(1));
        return Pair.of((Object)lowTier, (Object)highTier);
    }

    public static MachineDefinition[] registerTieredMachines(String name, BiFunction<IMachineBlockEntity, Integer, MetaMachine> factory, BiFunction<Integer, MachineBuilder<MachineDefinition>, MachineDefinition> builder, int ... tiers) {
        MachineDefinition[] definitions = new MachineDefinition[GTValues.TIER_COUNT];
        for (int tier : tiers) {
            MachineBuilder<MachineDefinition> register = GTRegistries.REGISTRATE.machine(GTValues.VN[tier].toLowerCase(Locale.ROOT) + "_" + name, holder -> (MetaMachine)factory.apply((IMachineBlockEntity)holder, tier)).tier(tier);
            definitions[tier] = builder.apply(tier, register);
        }
        return definitions;
    }

    private static MachineDefinition[] registerFluidHatches(String name, String displayname, String model, IO io, long initialCapacity, int slots, int[] tiers, PartAbility ... abilities) {
        return GTMachines.registerTieredMachines(name, (holder, tier) -> new FluidHatchPartMachine((IMachineBlockEntity)holder, (int)tier, io, initialCapacity, slots, new Object[0]), (tier, builder) -> {
            builder.langValue(GTValues.VNF[tier] + " " + displayname).rotationState(RotationState.ALL).overlayTieredHullRenderer(model).abilities(abilities).compassNode("fluid_hatch").tooltips(new class_2561[]{class_2561.method_43471((String)"gtceu.machine.fluid_hatch.import.tooltip")});
            if (slots == 1) {
                builder.tooltips(new class_2561[]{class_2561.method_43469((String)"gtceu.universal.tooltip.fluid_storage_capacity", (Object[])new Object[]{FluidHatchPartMachine.getTankCapacity(initialCapacity, tier)})});
            } else {
                builder.tooltips(new class_2561[]{class_2561.method_43469((String)"gtceu.universal.tooltip.fluid_storage_capacity_mult", (Object[])new Object[]{slots, FluidHatchPartMachine.getTankCapacity(initialCapacity, tier)})});
            }
            return builder.register();
        }, tiers);
    }

    public static MachineDefinition[] registerTransformerMachines(String langName, int baseAmp) {
        return GTMachines.registerTieredMachines("transformer_%da".formatted(baseAmp), (holder, tier) -> new TransformerMachine((IMachineBlockEntity)holder, (int)tier, baseAmp, new Object[0]), (tier, builder) -> builder.rotationState(RotationState.ALL).itemColor((itemStack, index) -> index == 2 ? GTValues.VC[tier + 1] : (index == 3 ? GTValues.VC[tier] : (index == 1 ? Long.decode(ConfigHolder.INSTANCE.client.defaultPaintingColor).intValue() : -1))).renderer(() -> new TransformerRenderer((int)tier, baseAmp)).langValue("%s %sTransformer".formatted(GTValues.VOLTAGE_NAMES[tier], langName)).tooltips(GTMachines.explosion()).tooltips(new class_2561[]{class_2561.method_43471((String)"gtceu.machine.transformer.description"), class_2561.method_43471((String)"gtceu.machine.transformer.tooltip_tool_usage"), class_2561.method_43469((String)"gtceu.machine.transformer.tooltip_transform_down", (Object[])new Object[]{baseAmp, GTValues.V[tier + 1], GTValues.VNF[tier + 1], baseAmp * 4, GTValues.V[tier], GTValues.VNF[tier]}), class_2561.method_43469((String)"gtceu.machine.transformer.tooltip_transform_up", (Object[])new Object[]{baseAmp * 4, GTValues.V[tier], GTValues.VNF[tier], baseAmp, GTValues.V[tier + 1], GTValues.VNF[tier + 1]})}).compassNode("transformer").register(), 0, 1, 2, 3, 4, 5, 6, 7, 8);
    }

    public static MachineDefinition[] registerSimpleMachines(String name, GTRecipeType recipeType, Int2LongFunction tankScalingFunction, int ... tiers) {
        return GTMachines.registerTieredMachines(name, (holder, tier) -> new SimpleTieredMachine((IMachineBlockEntity)holder, (int)tier, tankScalingFunction, new Object[0]), (tier, builder) -> builder.langValue("%s %s %s".formatted(GTValues.VLVH[tier], FormattingUtil.toEnglishName(name), GTValues.VLVT[tier])).editableUI(SimpleTieredMachine.EDITABLE_UI_CREATOR.apply(GTCEu.id(name), recipeType)).rotationState(RotationState.NON_Y_AXIS).recipeType(recipeType).recipeModifier(GTRecipeModifiers.ELECTRIC_OVERCLOCK.apply(OverclockingLogic.NON_PERFECT_OVERCLOCK)).workableTieredHullRenderer(GTCEu.id("block/machines/" + name)).tooltips(GTMachines.explosion()).tooltips(GTMachines.workableTiered(tier, GTValues.V[tier], GTValues.V[tier] * 64L, recipeType, (Long)tankScalingFunction.apply(tier), true)).compassNode(name).register(), tiers);
    }

    public static MachineDefinition[] registerSimpleMachines(String name, GTRecipeType recipeType, Int2LongFunction tankScalingFunction) {
        return GTMachines.registerSimpleMachines(name, recipeType, tankScalingFunction, ELECTRIC_TIERS);
    }

    public static MachineDefinition[] registerSimpleMachines(String name, GTRecipeType recipeType) {
        return GTMachines.registerSimpleMachines(name, recipeType, defaultTankSizeFunction);
    }

    public static MachineDefinition[] registerSimpleGenerator(String name, GTRecipeType recipeType, Int2LongFunction tankScalingFunction, int ... tiers) {
        return GTMachines.registerTieredMachines(name, (holder, tier) -> new SimpleGeneratorMachine((IMachineBlockEntity)holder, (int)tier, tankScalingFunction, new Object[0]), (tier, builder) -> builder.langValue("%s %s Generator %s".formatted(GTValues.VLVH[tier], FormattingUtil.toEnglishName(name), GTValues.VLVT[tier])).editableUI(SimpleGeneratorMachine.EDITABLE_UI_CREATOR.apply(GTCEu.id(name), recipeType)).rotationState(RotationState.ALL).recipeType(recipeType).recipeModifier(SimpleGeneratorMachine::recipeModifier, true).addOutputLimit(ItemRecipeCapability.CAP, 0).addOutputLimit(FluidRecipeCapability.CAP, 0).renderer(() -> new SimpleGeneratorMachineRenderer((int)tier, GTCEu.id("block/generators/" + name))).tooltips(GTMachines.explosion()).tooltips(GTMachines.workableTiered(tier, GTValues.V[tier], GTValues.V[tier] * 64L, recipeType, (Long)tankScalingFunction.apply(tier), false)).compassNode(name).register(), tiers);
    }

    public static Pair<MachineDefinition, MachineDefinition> registerSimpleSteamMachines(String name, GTRecipeType recipeType) {
        return GTMachines.registerSteamMachines("steam_" + name, (x$0, x$1) -> new SimpleSteamMachine((IMachineBlockEntity)x$0, (boolean)x$1, new Object[0]), (pressure, builder) -> builder.rotationState(RotationState.NON_Y_AXIS).recipeType(recipeType).recipeModifier(SimpleSteamMachine::recipeModifier).renderer(() -> new WorkableSteamMachineRenderer((boolean)pressure, GTCEu.id("block/machines/" + name))).register());
    }

    public static MachineDefinition[] registerBatteryBuffer(int batterySlotSize) {
        return GTMachines.registerTieredMachines("battery_buffer_" + batterySlotSize + "x", (holder, tier) -> new BatteryBufferMachine((IMachineBlockEntity)holder, (int)tier, batterySlotSize, new Object[0]), (tier, builder) -> builder.rotationState(RotationState.ALL).renderer(() -> new BatteryBufferRenderer((int)tier, batterySlotSize)).langValue("%s %s%s".formatted(GTValues.VOLTAGE_NAMES[tier], batterySlotSize, "x Battery Buffer")).tooltips(GTMachines.explosion()).tooltips(new class_2561[]{class_2561.method_43469((String)"gtceu.universal.tooltip.item_storage_capacity", (Object[])new Object[]{batterySlotSize}), class_2561.method_43469((String)"gtceu.universal.tooltip.voltage_in_out", (Object[])new Object[]{GTValues.V[tier], GTValues.VNF[tier]}), class_2561.method_43469((String)"gtceu.universal.tooltip.amperage_in_till", (Object[])new Object[]{(long)batterySlotSize * 2L}), class_2561.method_43469((String)"gtceu.universal.tooltip.amperage_out_till", (Object[])new Object[]{batterySlotSize})}).compassNode("battery_buffer").register(), ALL_TIERS);
    }

    public static MachineDefinition[] registerCharger(int itemSlotSize) {
        return GTMachines.registerTieredMachines("charger_" + itemSlotSize + "x", (holder, tier) -> new ChargerMachine((IMachineBlockEntity)holder, (int)tier, itemSlotSize, new Object[0]), (tier, builder) -> builder.rotationState(RotationState.NON_Y_AXIS).renderer(() -> new ChargerRenderer((int)tier)).langValue("%s %s%s".formatted(GTValues.VOLTAGE_NAMES[tier], itemSlotSize, "x Turbo Charger")).tooltips(GTMachines.explosion()).tooltips(new class_2561[]{class_2561.method_43469((String)"gtceu.universal.tooltip.item_storage_capacity", (Object[])new Object[]{itemSlotSize}), class_2561.method_43469((String)"gtceu.universal.tooltip.voltage_in_out", (Object[])new Object[]{GTValues.V[tier], GTValues.VNF[tier]}), class_2561.method_43469((String)"gtceu.universal.tooltip.amperage_in_till", (Object[])new Object[]{(long)itemSlotSize * 4L})}).compassNode("charger").register(), ALL_TIERS);
    }

    public static MachineDefinition[] registerLaserHatch(IO io, int amperage, PartAbility ability) {
        String name = io == IO.IN ? "target" : "source";
        return GTMachines.registerTieredMachines(amperage + "a_laser_" + name + "_hatch", (holder, tier) -> new LaserHatchPartMachine((IMachineBlockEntity)holder, io, (int)tier, amperage), (tier, builder) -> builder.langValue(GTValues.VNF[tier] + " " + FormattingUtil.formatNumbers(amperage) + "A Laser " + FormattingUtil.toEnglishName(name) + " Hatch").rotationState(RotationState.ALL).tooltips(new class_2561[]{class_2561.method_43471((String)("gtceu.machine.laser_hatch." + name + ".tooltip.0")), class_2561.method_43471((String)("gtceu.machine.laser_hatch." + name + ".tooltip.1")), class_2561.method_43471((String)"gtceu.universal.disabled")}).abilities(ability).overlayTieredHullRenderer("laser_hatch." + name).register(), HIGH_TIERS);
    }

    public static MultiblockMachineDefinition[] registerTieredMultis(String name, BiFunction<IMachineBlockEntity, Integer, MultiblockControllerMachine> factory, BiFunction<Integer, MultiblockMachineBuilder, MultiblockMachineDefinition> builder, int ... tiers) {
        MultiblockMachineDefinition[] definitions = new MultiblockMachineDefinition[GTValues.TIER_COUNT];
        for (int tier : tiers) {
            MultiblockMachineBuilder register = GTRegistries.REGISTRATE.multiblock(GTValues.VN[tier].toLowerCase(Locale.ROOT) + "_" + name, holder -> (MultiblockControllerMachine)factory.apply((IMachineBlockEntity)holder, tier)).tier(tier);
            definitions[tier] = builder.apply(tier, register);
        }
        return definitions;
    }

    public static MultiblockMachineDefinition registerLargeBoiler(String name, Supplier<? extends class_2248> casing, Supplier<? extends class_2248> pipe, Supplier<? extends class_2248> fireBox, class_2960 texture, BoilerFireboxType firebox, int maxTemperature, int heatSpeed) {
        return ((MultiblockMachineBuilder)((MultiblockMachineBuilder)((MultiblockMachineBuilder)GTRegistries.REGISTRATE.multiblock("%s_large_boiler".formatted(name), holder -> new LargeBoilerMachine((IMachineBlockEntity)holder, maxTemperature, heatSpeed, new Object[0])).langValue("Large %s Boiler".formatted(FormattingUtil.toEnglishName(name))).rotationState(RotationState.NON_Y_AXIS).recipeType(GTRecipeTypes.LARGE_BOILER_RECIPES).recipeModifier(LargeBoilerMachine::recipeModifier)).appearanceBlock((Supplier)casing)).partAppearance((TriFunction<IMultiController, IMultiPart, class_2350, class_2680>)((TriFunction)(controller, part, side) -> controller.self().getPos().method_10074().method_10264() == part.self().getPos().method_10264() ? ((class_2248)fireBox.get()).method_9564() : ((class_2248)casing.get()).method_9564())).pattern(definition -> FactoryBlockPattern.start().aisle("XXX", "CCC", "CCC", "CCC").aisle("XXX", "CPC", "CPC", "CCC").aisle("XXX", "CSC", "CCC", "CCC").where('S', Predicates.controller(Predicates.blocks(definition.getBlock()))).where('P', Predicates.blocks((class_2248)pipe.get())).where('X', Predicates.states(GTBlocks.ALL_FIREBOXES.get(firebox).getDefaultState()).setMinGlobalLimited(4).or(Predicates.abilities(PartAbility.IMPORT_FLUIDS).setMinGlobalLimited(1).setPreviewCount(1)).or(Predicates.abilities(PartAbility.IMPORT_ITEMS).setMaxGlobalLimited(1).setPreviewCount(1)).or(Predicates.abilities(PartAbility.MUFFLER).setExactLimit(1)).or(Predicates.abilities(PartAbility.MAINTENANCE).setExactLimit(1))).where('C', Predicates.blocks((class_2248)casing.get()).setMinGlobalLimited(20).or(Predicates.abilities(PartAbility.EXPORT_FLUIDS).setMinGlobalLimited(1).setPreviewCount(1))).build()).recoveryItems(() -> new class_1935[]{(class_1935)((ItemEntry)GTItems.MATERIAL_ITEMS.get((Object)TagPrefix.dustTiny, (Object)GTMaterials.Ash)).get()}).renderer(() -> new LargeBoilerRenderer(texture, firebox, GTCEu.id("block/multiblock/generator/large_%s_boiler".formatted(name))))).tooltips(new class_2561[]{class_2561.method_43469((String)"gtceu.multiblock.large_boiler.max_temperature", (Object[])new Object[]{(int)((double)maxTemperature + 274.15), maxTemperature}), class_2561.method_43469((String)"gtceu.multiblock.large_boiler.heat_time_tooltip", (Object[])new Object[]{maxTemperature / heatSpeed / 20}), class_2561.method_43471((String)"gtceu.multiblock.large_boiler.explosion_tooltip").method_27692(class_124.field_1079)}).compassSections(GTCompassSections.STEAM).compassNode("large_boiler").register();
    }

    public static MultiblockMachineDefinition registerLargeCombustionEngine(String name, int tier, Supplier<? extends class_2248> casing, Supplier<? extends class_2248> gear, Supplier<? extends class_2248> intake, class_2960 casingTexture, class_2960 overlayModel) {
        return ((MultiblockMachineBuilder)((MultiblockMachineBuilder)GTRegistries.REGISTRATE.multiblock(name, holder -> new LargeCombustionEngineMachine((IMachineBlockEntity)holder, tier)).rotationState(RotationState.NON_Y_AXIS).recipeType(GTRecipeTypes.COMBUSTION_GENERATOR_FUELS).recipeModifier(LargeCombustionEngineMachine::recipeModifier, true)).appearanceBlock((Supplier)casing)).pattern(definition -> FactoryBlockPattern.start().aisle("XXX", "XDX", "XXX").aisle("XCX", "CGC", "XCX").aisle("XCX", "CGC", "XCX").aisle("AAA", "AYA", "AAA").where('X', Predicates.blocks((class_2248)casing.get())).where('G', Predicates.blocks((class_2248)gear.get())).where('C', Predicates.blocks((class_2248)casing.get()).setMinGlobalLimited(3).or(Predicates.autoAbilities(definition.getRecipeTypes(), false, false, true, true, true, true)).or(Predicates.autoAbilities(true, true, false))).where('D', Predicates.ability(PartAbility.OUTPUT_ENERGY, Stream.of(0, 1, 2, 3, 4, 5, 6, 7, 8, 9).filter(t -> t >= tier).mapToInt(Integer::intValue).toArray()).addTooltips(new class_2561[]{class_2561.method_43469((String)"gtceu.multiblock.pattern.error.limited.1", (Object[])new Object[]{GTValues.VN[tier]})})).where('A', Predicates.blocks((class_2248)intake.get()).addTooltips(new class_2561[]{class_2561.method_43471((String)"gtceu.multiblock.pattern.clear_amount_1")})).where('Y', Predicates.controller(Predicates.blocks(definition.getBlock()))).build()).recoveryItems(() -> new class_1935[]{(class_1935)((ItemEntry)GTItems.MATERIAL_ITEMS.get((Object)TagPrefix.dustTiny, (Object)GTMaterials.Ash)).get()}).workableCasingRenderer(casingTexture, overlayModel, false).tooltips(new class_2561[]{class_2561.method_43469((String)"gtceu.universal.tooltip.base_production_eut", (Object[])new Object[]{GTValues.V[tier]}), class_2561.method_43469((String)"gtceu.universal.tooltip.uses_per_hour_lubricant", (Object[])new Object[]{FluidHelper.getBucket()}), tier > 4 ? class_2561.method_43469((String)"gtceu.machine.large_combustion_engine.tooltip.boost_extreme", (Object[])new Object[]{GTValues.V[tier] * 4L}) : class_2561.method_43469((String)"gtceu.machine.large_combustion_engine.tooltip.boost_regular", (Object[])new Object[]{GTValues.V[tier] * 3L})}).compassSections(GTCompassSections.TIER[4]).compassNode("large_combustion").register();
    }

    public static MultiblockMachineDefinition registerLargeTurbine(String name, int tier, GTRecipeType recipeType, Supplier<? extends class_2248> casing, Supplier<? extends class_2248> gear, class_2960 casingTexture, class_2960 overlayModel) {
        return ((MultiblockMachineBuilder)((MultiblockMachineBuilder)GTRegistries.REGISTRATE.multiblock(name, holder -> new LargeTurbineMachine((IMachineBlockEntity)holder, tier)).rotationState(RotationState.NON_Y_AXIS).recipeType(recipeType).recipeModifier(LargeTurbineMachine::recipeModifier, true)).appearanceBlock((Supplier)casing)).pattern(definition -> FactoryBlockPattern.start().aisle("CCCC", "CHHC", "CCCC").aisle("CHHC", "RGGR", "CHHC").aisle("CCCC", "CSHC", "CCCC").where('S', Predicates.controller(Predicates.blocks(definition.getBlock()))).where('G', Predicates.blocks((class_2248)gear.get())).where('C', Predicates.blocks((class_2248)casing.get())).where('R', new TraceabilityPredicate(new SimplePredicate(state -> {
            MetaMachine patt135453$temp = MetaMachine.getMachine((class_1922)state.getWorld(), state.getPos());
            if (!(patt135453$temp instanceof IRotorHolderMachine)) return false;
            IRotorHolderMachine rotorHolder = (IRotorHolderMachine)((Object)patt135453$temp);
            if (!state.getWorld().method_8320(state.getPos().method_10093(rotorHolder.self().getFrontFacing())).method_26215()) return false;
            return true;
        }, () -> (BlockInfo[])PartAbility.ROTOR_HOLDER.getAllBlocks().stream().map(BlockInfo::fromBlock).toArray(BlockInfo[]::new))).addTooltips(new class_2561[]{class_2561.method_43471((String)"gtceu.multiblock.pattern.clear_amount_3")}).addTooltips(new class_2561[]{class_2561.method_43469((String)"gtceu.multiblock.pattern.error.limited.1", (Object[])new Object[]{GTValues.VN[tier]})}).setExactLimit(1).or(Predicates.abilities(PartAbility.OUTPUT_ENERGY)).setExactLimit(1)).where('H', Predicates.blocks((class_2248)casing.get()).or(Predicates.autoAbilities(definition.getRecipeTypes(), false, false, true, true, true, true)).or(Predicates.autoAbilities(true, true, false))).build()).recoveryItems(() -> new class_1935[]{(class_1935)((ItemEntry)GTItems.MATERIAL_ITEMS.get((Object)TagPrefix.dustTiny, (Object)GTMaterials.Ash)).get()}).workableCasingRenderer(casingTexture, overlayModel, false).tooltips(new class_2561[]{class_2561.method_43469((String)"gtceu.universal.tooltip.base_production_eut", (Object[])new Object[]{GTValues.V[tier] * 2L}), class_2561.method_43469((String)"gtceu.multiblock.turbine.efficiency_tooltip", (Object[])new Object[]{GTValues.VNF[tier]})}).compassSections(GTCompassSections.TIER[3]).compassNode("large_turbine").register();
    }

    public static MachineDefinition registerCrate(Material material, int capacity, String lang) {
        boolean wooden = material.hasProperty(PropertyKey.WOOD);
        return GTRegistries.REGISTRATE.machine(material + "_crate", holder -> new CrateMachine((IMachineBlockEntity)holder, material, capacity)).langValue(lang).rotationState(RotationState.NONE).tooltips(new class_2561[]{class_2561.method_43469((String)"gtceu.universal.tooltip.item_storage_capacity", (Object[])new Object[]{capacity})}).renderer(() -> new MachineRenderer(GTCEu.id("block/machine/crate/" + (wooden ? "wooden" : "metal") + "_crate"))).paintingColor(wooden ? 0xFFFFFF : material.getMaterialRGB()).itemColor((s, t) -> wooden ? 0xFFFFFF : material.getMaterialRGB()).compassNode("crate").register();
    }

    public static MachineDefinition registerDrum(Material material, int capacity, String lang) {
        boolean wooden = material.hasProperty(PropertyKey.WOOD);
        Object definition = GTRegistries.REGISTRATE.machine(material + "_drum", MachineDefinition::createDefinition, holder -> new DrumMachine((IMachineBlockEntity)holder, material, capacity, new Object[0]), MetaMachineBlock::new, DrumMachineItem::create, MetaMachineBlockEntity::createBlockEntity).langValue(lang).rotationState(RotationState.NONE).renderer(() -> new MachineRenderer(GTCEu.id("block/machine/" + (wooden ? "wooden" : "metal") + "_drum"))).tooltipBuilder(GTMachines.createTankTooltips("Fluid")).tooltips(new class_2561[]{class_2561.method_43471((String)"gtceu.machine.quantum_tank.tooltip"), class_2561.method_43469((String)"gtceu.universal.tooltip.fluid_storage_capacity", (Object[])new Object[]{capacity})}).paintingColor(wooden ? 0xFFFFFF : material.getMaterialRGB()).itemColor((s, i) -> wooden ? 0xFFFFFF : material.getMaterialRGB()).compassNode("drum").register();
        DRUM_CAPACITY.put(definition, capacity);
        return definition;
    }

    public static MachineDefinition[] registerConverter(int amperage) {
        return GTMachines.registerTieredMachines(amperage + "a_energy_converter", (holder, tier) -> new ConverterMachine((IMachineBlockEntity)holder, (int)tier, amperage, new Object[0]), (tier, builder) -> builder.rotationState(RotationState.ALL).langValue("%s %sA Energy Converter".formatted(GTValues.VN[tier], amperage)).renderer(() -> new ConverterRenderer((int)tier)).tooltips(new class_2561[]{class_2561.method_43471((String)"gtceu.machine.energy_converter.description"), class_2561.method_43471((String)"gtceu.machine.energy_converter.tooltip_tool_usage"), class_2561.method_43469((String)"gtceu.machine.energy_converter.tooltip_conversion_native", (Object[])new Object[]{PlatformEnergyCompat.toNativeLong(GTValues.V[tier] * (long)amperage, PlatformEnergyCompat.ratio(true)), amperage, GTValues.V[tier], GTValues.VNF[tier]}), class_2561.method_43469((String)"gtceu.machine.energy_converter.tooltip_conversion_eu", (Object[])new Object[]{amperage, GTValues.V[tier], GTValues.VNF[tier], PlatformEnergyCompat.toNativeLong(GTValues.V[tier] * (long)amperage, PlatformEnergyCompat.ratio(false))})}).compassNode("converter").register(), ALL_TIERS);
    }

    public static class_2561 explosion() {
        if (ConfigHolder.INSTANCE.machines.doTerrainExplosion) {
            return class_2561.method_43471((String)"gtceu.universal.tooltip.terrain_resist");
        }
        return null;
    }

    public static class_2561[] workableTiered(int tier, long voltage, long energyCapacity, GTRecipeType recipeType, long tankCapacity, boolean input) {
        ArrayList<class_5250> tooltipComponents = new ArrayList<class_5250>();
        tooltipComponents.add(input ? class_2561.method_43469((String)"gtceu.universal.tooltip.voltage_in", (Object[])new Object[]{voltage, GTValues.VNF[tier]}) : class_2561.method_43469((String)"gtceu.universal.tooltip.voltage_out", (Object[])new Object[]{voltage, GTValues.VNF[tier]}));
        tooltipComponents.add(class_2561.method_43469((String)"gtceu.universal.tooltip.energy_storage_capacity", (Object[])new Object[]{energyCapacity}));
        if (recipeType.getMaxInputs(FluidRecipeCapability.CAP) > 0 || recipeType.getMaxOutputs(FluidRecipeCapability.CAP) > 0) {
            tooltipComponents.add(class_2561.method_43469((String)"gtceu.universal.tooltip.fluid_storage_capacity", (Object[])new Object[]{tankCapacity}));
        }
        return (class_2561[])tooltipComponents.toArray(class_2561[]::new);
    }

    public static void init() {
        GCyMMachines.init();
        if (GTCEu.isCreateLoaded()) {
            GTCreateMachines.init();
        }
        if (GTCEu.isAE2Loaded()) {
            GTAEMachines.init();
        }
        if (ConfigHolder.INSTANCE.machines.doBedrockOres || Platform.isDevEnv()) {
            BEDROCK_ORE_MINER = GTMachines.registerTieredMultis("bedrock_ore_miner", BedrockOreMinerMachine::new, (tier, builder) -> ((MultiblockMachineBuilder)builder.rotationState(RotationState.NON_Y_AXIS).langValue("%s Bedrock Ore Miner %s".formatted(GTValues.VLVH[tier], GTValues.VLVT[tier])).recipeType(new GTRecipeType(GTCEu.id("bedrock_ore_miner"), "dummy", new class_3956[0])).tooltips(new class_2561[]{class_2561.method_43471((String)"gtceu.machine.bedrock_ore_miner.description"), class_2561.method_43469((String)"gtceu.machine.bedrock_ore_miner.depletion", (Object[])new Object[]{FormattingUtil.formatNumbers(100.0 / (double)BedrockOreMinerMachine.getDepletionChance(tier))}), class_2561.method_43469((String)"gtceu.universal.tooltip.energy_tier_range", (Object[])new Object[]{GTValues.VNF[tier], GTValues.VNF[tier + 1]}), class_2561.method_43469((String)"gtceu.machine.bedrock_ore_miner.production", (Object[])new Object[]{BedrockOreMinerMachine.getRigMultiplier(tier), FormattingUtil.formatNumbers((double)BedrockOreMinerMachine.getRigMultiplier(tier) * 1.5)})}).appearanceBlock(() -> BedrockOreMinerMachine.getCasingState(tier))).pattern(definition -> FactoryBlockPattern.start().aisle("XXX", "#F#", "#F#", "#F#", "###", "###", "###").aisle("XXX", "FCF", "FCF", "FCF", "#F#", "#F#", "#F#").aisle("XSX", "#F#", "#F#", "#F#", "###", "###", "###").where('S', Predicates.controller(Predicates.blocks(definition.get()))).where('X', Predicates.blocks(BedrockOreMinerMachine.getCasingState(tier)).setMinGlobalLimited(3).or(Predicates.abilities(PartAbility.INPUT_ENERGY).setMinGlobalLimited(1).setMaxGlobalLimited(3)).or(Predicates.abilities(PartAbility.EXPORT_ITEMS).setMaxGlobalLimited(1))).where('C', Predicates.blocks(BedrockOreMinerMachine.getCasingState(tier))).where('F', Predicates.blocks(BedrockOreMinerMachine.getFrameState(tier))).where('#', Predicates.any()).build()).workableCasingRenderer(BedrockOreMinerMachine.getBaseTexture(tier), GTCEu.id("block/multiblock/bedrock_ore_miner"), false).register(), 2, 3, 4);
        }
        if (GTCEu.isKubeJSLoaded()) {
            GTRegistryObjectBuilderTypes.registerFor(GTRegistries.MACHINES.getRegistryName());
        }
    }

    public static MachineDefinition get(String name) {
        return (MachineDefinition)GTRegistries.MACHINES.get(GTCEu.id(name));
    }

    static {
        GTRegistries.REGISTRATE.creativeModeTab(() -> GTCreativeModeTabs.MACHINE);
        STEAM_SOLID_BOILER = GTMachines.registerSteamMachines("steam_solid_boiler", (x$0, x$1) -> new SteamSolidBoilerMachine((IMachineBlockEntity)x$0, (boolean)x$1, new Object[0]), (pressure, builder) -> builder.rotationState(RotationState.NON_Y_AXIS).recipeType(GTRecipeTypes.STEAM_BOILER_RECIPES).recipeModifier(SteamBoilerMachine::recipeModifier).workableSteamHullRenderer((boolean)pressure, GTCEu.id("block/generators/boiler/coal")).tooltips(new class_2561[]{class_2561.method_43469((String)"gtceu.universal.tooltip.produces_fluid", (Object[])new Object[]{(long)(pressure != false ? 300 : 120) * FluidHelper.getBucket() / 20000L})}).register());
        STEAM_LIQUID_BOILER = GTMachines.registerSteamMachines("steam_liquid_boiler", (x$0, x$1) -> new SteamLiquidBoilerMachine((IMachineBlockEntity)x$0, (boolean)x$1, new Object[0]), (pressure, builder) -> builder.rotationState(RotationState.NON_Y_AXIS).recipeType(GTRecipeTypes.STEAM_BOILER_RECIPES).recipeModifier(SteamBoilerMachine::recipeModifier).workableSteamHullRenderer((boolean)pressure, GTCEu.id("block/generators/boiler/lava")).tooltips(new class_2561[]{class_2561.method_43469((String)"gtceu.universal.tooltip.produces_fluid", (Object[])new Object[]{(long)(pressure != false ? 600 : 240) * FluidHelper.getBucket() / 20000L})}).register());
        STEAM_SOLAR_BOILER = GTMachines.registerSteamMachines("steam_solar_boiler", (x$0, x$1) -> new SteamSolarBoiler((IMachineBlockEntity)x$0, (boolean)x$1, new Object[0]), (pressure, builder) -> builder.rotationState(RotationState.NON_Y_AXIS).recipeType(GTRecipeTypes.STEAM_BOILER_RECIPES).recipeModifier(SteamBoilerMachine::recipeModifier).workableSteamHullRenderer((boolean)pressure, GTCEu.id("block/generators/boiler/solar")).tooltips(new class_2561[]{class_2561.method_43469((String)"gtceu.universal.tooltip.produces_fluid", (Object[])new Object[]{(long)(pressure != false ? 360 : 120) * FluidHelper.getBucket() / 20000L})}).register());
        STEAM_EXTRACTOR = GTMachines.registerSimpleSteamMachines("extractor", GTRecipeTypes.EXTRACTOR_RECIPES);
        STEAM_MACERATOR = GTMachines.registerSteamMachines("steam_macerator", (x$0, x$1) -> new SimpleSteamMachine((IMachineBlockEntity)x$0, (boolean)x$1, new Object[0]), (pressure, builder) -> builder.rotationState(RotationState.NON_Y_AXIS).recipeType(GTRecipeTypes.MACERATOR_RECIPES).recipeModifier(SimpleSteamMachine::recipeModifier).addOutputLimit(ItemRecipeCapability.CAP, 1).renderer(() -> new WorkableSteamMachineRenderer((boolean)pressure, GTCEu.id("block/machines/macerator"))).register());
        STEAM_COMPRESSOR = GTMachines.registerSimpleSteamMachines("compressor", GTRecipeTypes.COMPRESSOR_RECIPES);
        STEAM_HAMMER = GTMachines.registerSimpleSteamMachines("forge_hammer", GTRecipeTypes.FORGE_HAMMER_RECIPES);
        STEAM_FURNACE = GTMachines.registerSimpleSteamMachines("furnace", GTRecipeTypes.FURNACE_RECIPES);
        STEAM_ALLOY_SMELTER = GTMachines.registerSimpleSteamMachines("alloy_smelter", GTRecipeTypes.ALLOY_SMELTER_RECIPES);
        STEAM_ROCK_CRUSHER = GTMachines.registerSimpleSteamMachines("rock_crusher", GTRecipeTypes.ROCK_BREAKER_RECIPES);
        STEAM_MINER = GTRegistries.REGISTRATE.machine("steam_miner", holder -> new SteamMinerMachine((IMachineBlockEntity)holder, 320, 4, 0)).rotationState(RotationState.NON_Y_AXIS).langValue("Steam Miner").recipeType(GTRecipeTypes.DUMMY_RECIPES).tier(0).tooltips(new class_2561[]{class_2561.method_43469((String)"gtceu.universal.tooltip.uses_per_tick_steam", (Object[])new Object[]{16}).method_27693(class_124.field_1080 + ", ").method_10852((class_2561)class_2561.method_43469((String)"gtceu.machine.miner.per_block", (Object[])new Object[]{16}))}).tooltipBuilder((item, tooltip) -> {
            int maxArea = IMiner.getWorkingArea(4);
            tooltip.add(class_2561.method_43469((String)"gtceu.universal.tooltip.working_area", (Object[])new Object[]{maxArea, maxArea}));
        }).compassNode("steam_miner").renderer(() -> new SteamMinerRenderer(false, GTCEu.id("block/machines/steam_miner"))).register();
        HULL = GTMachines.registerTieredMachines("machine_hull", HullMachine::new, (tier, builder) -> builder.rotationState(RotationState.ALL).overlayTieredHullRenderer("hull").abilities(PartAbility.PASSTHROUGH_HATCH).langValue("%s Machine Hull".formatted(GTValues.VN[tier])).tooltips(new class_2561[]{class_2561.method_43471((String)"gtceu.machine.hull.tooltip")}).compassNode("machine_hull").register(), ALL_TIERS);
        ELECTRIC_FURNACE = GTMachines.registerSimpleMachines("electric_furnace", GTRecipeTypes.FURNACE_RECIPES);
        ALLOY_SMELTER = GTMachines.registerSimpleMachines("alloy_smelter", GTRecipeTypes.ALLOY_SMELTER_RECIPES);
        ARC_FURNACE = GTMachines.registerSimpleMachines("arc_furnace", GTRecipeTypes.ARC_FURNACE_RECIPES, hvCappedTankSizeFunction);
        ASSEMBLER = GTMachines.registerSimpleMachines("assembler", GTRecipeTypes.ASSEMBLER_RECIPES, hvCappedTankSizeFunction);
        AUTOCLAVE = GTMachines.registerSimpleMachines("autoclave", GTRecipeTypes.AUTOCLAVE_RECIPES, hvCappedTankSizeFunction);
        BENDER = GTMachines.registerSimpleMachines("bender", GTRecipeTypes.BENDER_RECIPES);
        BREWERY = GTMachines.registerSimpleMachines("brewery", GTRecipeTypes.BREWING_RECIPES, hvCappedTankSizeFunction);
        CANNER = GTMachines.registerSimpleMachines("canner", GTRecipeTypes.CANNER_RECIPES);
        CENTRIFUGE = GTMachines.registerSimpleMachines("centrifuge", GTRecipeTypes.CENTRIFUGE_RECIPES, largeTankSizeFunction);
        CHEMICAL_BATH = GTMachines.registerSimpleMachines("chemical_bath", GTRecipeTypes.CHEMICAL_BATH_RECIPES, hvCappedTankSizeFunction);
        CHEMICAL_REACTOR = GTMachines.registerSimpleMachines("chemical_reactor", GTRecipeTypes.CHEMICAL_RECIPES, tier -> 16L * FluidHelper.getBucket());
        COMPRESSOR = GTMachines.registerSimpleMachines("compressor", GTRecipeTypes.COMPRESSOR_RECIPES);
        CUTTER = GTMachines.registerSimpleMachines("cutter", GTRecipeTypes.CUTTER_RECIPES);
        DISTILLERY = GTMachines.registerSimpleMachines("distillery", GTRecipeTypes.DISTILLERY_RECIPES, hvCappedTankSizeFunction);
        ELECTROLYZER = GTMachines.registerSimpleMachines("electrolyzer", GTRecipeTypes.ELECTROLYZER_RECIPES, largeTankSizeFunction);
        ELECTROMAGNETIC_SEPARATOR = GTMachines.registerSimpleMachines("electromagnetic_separator", GTRecipeTypes.ELECTROMAGNETIC_SEPARATOR_RECIPES);
        EXTRACTOR = GTMachines.registerSimpleMachines("extractor", GTRecipeTypes.EXTRACTOR_RECIPES);
        EXTRUDER = GTMachines.registerSimpleMachines("extruder", GTRecipeTypes.EXTRUDER_RECIPES);
        FERMENTER = GTMachines.registerSimpleMachines("fermenter", GTRecipeTypes.FERMENTING_RECIPES, hvCappedTankSizeFunction);
        FLUID_HEATER = GTMachines.registerSimpleMachines("fluid_heater", GTRecipeTypes.FLUID_HEATER_RECIPES, hvCappedTankSizeFunction);
        FLUID_SOLIDIFIER = GTMachines.registerSimpleMachines("fluid_solidifier", GTRecipeTypes.FLUID_SOLIDFICATION_RECIPES, hvCappedTankSizeFunction);
        FORGE_HAMMER = GTMachines.registerSimpleMachines("forge_hammer", GTRecipeTypes.FORGE_HAMMER_RECIPES);
        FORMING_PRESS = GTMachines.registerSimpleMachines("forming_press", GTRecipeTypes.FORMING_PRESS_RECIPES);
        LATHE = GTMachines.registerSimpleMachines("lathe", GTRecipeTypes.LATHE_RECIPES);
        MIXER = GTMachines.registerSimpleMachines("mixer", GTRecipeTypes.MIXER_RECIPES, hvCappedTankSizeFunction);
        ORE_WASHER = GTMachines.registerSimpleMachines("ore_washer", GTRecipeTypes.ORE_WASHER_RECIPES);
        PACKER = GTMachines.registerSimpleMachines("packer", GTRecipeTypes.PACKER_RECIPES);
        POLARIZER = GTMachines.registerSimpleMachines("polarizer", GTRecipeTypes.POLARIZER_RECIPES);
        LASER_ENGRAVER = GTMachines.registerSimpleMachines("laser_engraver", GTRecipeTypes.LASER_ENGRAVER_RECIPES);
        SIFTER = GTMachines.registerSimpleMachines("sifter", GTRecipeTypes.SIFTER_RECIPES);
        THERMAL_CENTRIFUGE = GTMachines.registerSimpleMachines("thermal_centrifuge", GTRecipeTypes.THERMAL_CENTRIFUGE_RECIPES);
        WIREMILL = GTMachines.registerSimpleMachines("wiremill", GTRecipeTypes.WIREMILL_RECIPES);
        CIRCUIT_ASSEMBLER = GTMachines.registerSimpleMachines("circuit_assembler", GTRecipeTypes.CIRCUIT_ASSEMBLER_RECIPES, hvCappedTankSizeFunction);
        MACERATOR = GTMachines.registerTieredMachines("macerator", (holder, tier) -> new SimpleTieredMachine((IMachineBlockEntity)holder, (int)tier, defaultTankSizeFunction, new Object[0]), (tier, builder) -> {
            MachineBuilder machineBuilder = builder.langValue("%s Macerator %s".formatted(GTValues.VLVH[tier], GTValues.VLVT[tier])).editableUI(SimpleTieredMachine.EDITABLE_UI_CREATOR.apply(GTCEu.id("macerator"), GTRecipeTypes.MACERATOR_RECIPES)).rotationState(RotationState.NON_Y_AXIS).recipeType(GTRecipeTypes.MACERATOR_RECIPES);
            return machineBuilder.addOutputLimit(ItemRecipeCapability.CAP, switch (tier) {
                case 1, 2 -> 1;
                case 3 -> 3;
                default -> 4;
            }).recipeModifier(GTRecipeModifiers.ELECTRIC_OVERCLOCK.apply(OverclockingLogic.NON_PERFECT_OVERCLOCK)).workableTieredHullRenderer(GTCEu.id("block/machines/macerator")).tooltips(GTMachines.explosion()).tooltips(GTMachines.workableTiered(tier, GTValues.V[tier], GTValues.V[tier] * 64L, GTRecipeTypes.MACERATOR_RECIPES, (Long)defaultTankSizeFunction.apply(tier), true)).compassNode("macerator").register();
        }, ELECTRIC_TIERS);
        GAS_COLLECTOR = GTMachines.registerSimpleMachines("gas_collector", GTRecipeTypes.GAS_COLLECTOR_RECIPES, largeTankSizeFunction);
        ROCK_CRUSHER = GTMachines.registerSimpleMachines("rock_crusher", GTRecipeTypes.ROCK_BREAKER_RECIPES);
        COMBUSTION = GTMachines.registerSimpleGenerator("combustion", GTRecipeTypes.COMBUSTION_GENERATOR_FUELS, genericGeneratorTankSizeFunction, 1, 2, 3);
        STEAM_TURBINE = GTMachines.registerSimpleGenerator("steam_turbine", GTRecipeTypes.STEAM_TURBINE_FUELS, steamGeneratorTankSizeFunction, 1, 2, 3);
        GAS_TURBINE = GTMachines.registerSimpleGenerator("gas_turbine", GTRecipeTypes.GAS_TURBINE_FUELS, genericGeneratorTankSizeFunction, 1, 2, 3);
        TRANSFORMER = GTMachines.registerTransformerMachines("", 1);
        HI_AMP_TRANSFORMER_2A = GTMachines.registerTransformerMachines("Hi-Amp (2x) ", 2);
        HI_AMP_TRANSFORMER_4A = GTMachines.registerTransformerMachines("Hi-Amp (4x) ", 4);
        POWER_TRANSFORMER = GTMachines.registerTransformerMachines("Power ", 16);
        ENERGY_CONVERTER_1A = GTMachines.registerConverter(1);
        ENERGY_CONVERTER_4A = GTMachines.registerConverter(4);
        ENERGY_CONVERTER_8A = GTMachines.registerConverter(8);
        ENERGY_CONVERTER_16A = GTMachines.registerConverter(16);
        LONG_DIST_ITEM_ENDPOINT = GTRegistries.REGISTRATE.machine("long_distance_item_pipeline_endpoint", LDItemEndpointMachine::new).langValue("Long Distance Item Pipeline Endpoint").rotationState(RotationState.ALL).tier(1).renderer(() -> new TieredHullMachineRenderer(1, GTCEu.id("block/machine/ld_item_endpoint_machine"))).tooltips((class_2561[])LangHandler.getMultiLang("gtceu.machine.endpoint.tooltip").toArray(class_2561[]::new)).tooltipBuilder((stack, tooltip) -> {
            if (ConfigHolder.INSTANCE.machines.ldItemPipeMinDistance > 0) {
                tooltip.add(class_2561.method_43469((String)"gtceu.machine.endpoint.tooltip.min_length", (Object[])new Object[]{ConfigHolder.INSTANCE.machines.ldItemPipeMinDistance}));
            }
        }).compassNode("ld_item_pipeline").register();
        LONG_DIST_FLUID_ENDPOINT = GTRegistries.REGISTRATE.machine("long_distance_fluid_pipeline_endpoint", LDFluidEndpointMachine::new).langValue("Long Distance Fluid Pipeline Endpoint").rotationState(RotationState.ALL).tier(1).renderer(() -> new TieredHullMachineRenderer(1, GTCEu.id("block/machine/ld_fluid_endpoint_machine"))).tooltips(new class_2561[]{class_2561.method_43471((String)"gtceu.machine.endpoint.tooltip.0"), class_2561.method_43471((String)"gtceu.machine.endpoint.tooltip.1"), class_2561.method_43471((String)"gtceu.machine.endpoint.tooltip.2")}).tooltipBuilder((stack, tooltip) -> {
            if (ConfigHolder.INSTANCE.machines.ldFluidPipeMinDistance > 0) {
                tooltip.add(class_2561.method_43469((String)"gtceu.machine.endpoint.tooltip.min_length", (Object[])new Object[]{ConfigHolder.INSTANCE.machines.ldItemPipeMinDistance}));
            }
        }).compassNode("ld_fluid_pipeline").register();
        BATTERY_BUFFER_4 = GTMachines.registerBatteryBuffer(4);
        BATTERY_BUFFER_8 = GTMachines.registerBatteryBuffer(8);
        BATTERY_BUFFER_16 = GTMachines.registerBatteryBuffer(16);
        CHARGER_4 = GTMachines.registerCharger(4);
        PUMP = GTMachines.registerTieredMachines("pump", (x$0, x$1) -> new PumpMachine((IMachineBlockEntity)x$0, (int)x$1, new Object[0]), (tier, builder) -> builder.rotationState(RotationState.NON_Y_AXIS).renderer(() -> new TieredHullMachineRenderer((int)tier, GTCEu.id("block/machine/pump_machine"))).langValue("%s Pump %s".formatted(GTValues.VLVH[tier], GTValues.VLVT[tier])).tooltips(new class_2561[]{class_2561.method_43471((String)"gtceu.machine.pump.tooltip"), class_2561.method_43469((String)"gtceu.universal.tooltip.voltage_in", (Object[])new Object[]{GTValues.V[tier], GTValues.VNF[tier]}), class_2561.method_43469((String)"gtceu.universal.tooltip.energy_storage_capacity", (Object[])new Object[]{GTValues.V[tier] * 64L}), class_2561.method_43469((String)"gtceu.universal.tooltip.fluid_storage_capacity", (Object[])new Object[]{16L * FluidHelper.getBucket() * (long)Math.max(1, tier)}), class_2561.method_43469((String)"gtceu.universal.tooltip.working_area", (Object[])new Object[]{32 + 8 * tier, 32 + 8 * tier})}).compassNode("pump").register(), 1, 2, 3, 4);
        FISHER = GTMachines.registerTieredMachines("fisher", (x$0, x$1) -> new FisherMachine((IMachineBlockEntity)x$0, (int)x$1, new Object[0]), (tier, builder) -> builder.rotationState(RotationState.NON_Y_AXIS).editableUI(FisherMachine.EDITABLE_UI_CREATOR.apply(GTCEu.id("fisher"), (tier + 1) * (tier + 1))).renderer(() -> new TieredHullMachineRenderer((int)tier, GTCEu.id("block/machine/fisher_machine"))).langValue("%s Fisher %s".formatted(GTValues.VLVH[tier], GTValues.VLVT[tier])).tooltips(new class_2561[]{class_2561.method_43471((String)"gtceu.machine.fisher.tooltip"), class_2561.method_43469((String)"gtceu.machine.fisher.speed", (Object[])new Object[]{1000L - (long)tier.intValue() * 200L}), class_2561.method_43469((String)"gtceu.machine.fisher.requirement", (Object[])new Object[]{5, 5}), class_2561.method_43469((String)"gtceu.universal.tooltip.voltage_in", (Object[])new Object[]{GTValues.V[tier], GTValues.VNF[tier]}), class_2561.method_43469((String)"gtceu.universal.tooltip.energy_storage_capacity", (Object[])new Object[]{GTValues.V[tier] * 64L})}).compassNode("fisher").register(), 1, 2, 3, 4);
        BLOCK_BREAKER = GTMachines.registerTieredMachines("block_breaker", (x$0, x$1) -> new BlockBreakerMachine((IMachineBlockEntity)x$0, (int)x$1, new Object[0]), (tier, builder) -> builder.rotationState(RotationState.NON_Y_AXIS).editableUI(BlockBreakerMachine.EDITABLE_UI_CREATOR.apply(GTCEu.id("block_breaker"), (tier + 1) * (tier + 1))).renderer(() -> new TieredHullMachineRenderer((int)tier, GTCEu.id("block/machine/block_breaker_machine"))).langValue("%s Block Breaker %s".formatted(GTValues.VLVH[tier], GTValues.VLVT[tier])).tooltips(new class_2561[]{class_2561.method_43471((String)"gtceu.machine.block_breaker.tooltip"), class_2561.method_43469((String)"gtceu.machine.block_breaker.speed_bonus", (Object[])new Object[]{(int)(BlockBreakerMachine.getEfficiencyMultiplier(tier) * 100.0f)}), class_2561.method_43469((String)"gtceu.universal.tooltip.voltage_in", (Object[])new Object[]{GTValues.V[tier], GTValues.VNF[tier]}), class_2561.method_43469((String)"gtceu.universal.tooltip.energy_storage_capacity", (Object[])new Object[]{GTValues.V[tier] * 64L})}).compassNode("block_breaker").register(), 1, 2, 3, 4);
        MINER = GTMachines.registerTieredMachines("miner", (holder, tier) -> new MinerMachine((IMachineBlockEntity)holder, (int)tier, 320 / (tier * 2), tier * 8, (int)tier, new Object[0]), (tier, builder) -> builder.rotationState(RotationState.NON_Y_AXIS).langValue("%s Miner %s".formatted(GTValues.VLVH[tier], GTValues.VLVT[tier])).recipeType(GTRecipeTypes.DUMMY_RECIPES).editableUI(MinerMachine.EDITABLE_UI_CREATOR.apply(GTCEu.id("miner"), (tier + 1) * (tier + 1))).renderer(() -> new MinerRenderer((int)tier, GTCEu.id("block/machines/miner"))).tooltipBuilder((stack, tooltip) -> {
            int maxArea = IMiner.getWorkingArea(tier * 8);
            long energyPerTick = GTValues.V[tier - 1];
            int tickSpeed = 320 / (tier * 2);
            tooltip.add(class_2561.method_43469((String)"gtceu.machine.miner.tooltip", (Object[])new Object[]{maxArea, maxArea}));
            tooltip.add(class_2561.method_43469((String)"gtceu.universal.tooltip.uses_per_tick", (Object[])new Object[]{energyPerTick}).method_10852((class_2561)class_2561.method_43470((String)", ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43469((String)"gtceu.machine.miner.per_block", (Object[])new Object[]{tickSpeed / 20})));
            tooltip.add(class_2561.method_43469((String)"gtceu.universal.tooltip.voltage_in", (Object[])new Object[]{GTValues.V[tier], GTValues.VNF[tier]}));
            tooltip.add(class_2561.method_43469((String)"gtceu.universal.tooltip.energy_storage_capacity", (Object[])new Object[]{GTValues.V[tier] * 64L}));
            tooltip.add(class_2561.method_43469((String)"gtceu.universal.tooltip.working_area_max", (Object[])new Object[]{maxArea, maxArea}));
        }).compassNode("miner").register(), 1, 2, 3);
        CREATIVE_ENERGY = GTRegistries.REGISTRATE.machine("infinite_energy", CreativeEnergyContainerMachine::new).rotationState(RotationState.NONE).tooltips(new class_2561[]{class_2561.method_43471((String)"gtceu.creative_tooltip.1"), class_2561.method_43471((String)"gtceu.creative_tooltip.2"), class_2561.method_43471((String)"gtceu.creative_tooltip.3")}).compassNodeSelf().register();
        CHEST_TOOLTIPS = (stack, list) -> {
            if (stack.method_7985()) {
                class_1799 itemStack = class_1799.method_7915((class_2487)stack.method_7911("stored"));
                int storedAmount = stack.method_7948().method_10550("storedAmount");
                list.add(1, class_2561.method_43469((String)"gtceu.universal.tooltip.item_stored", (Object[])new Object[]{itemStack.method_7922(), storedAmount}));
            }
        };
        SUPER_CHEST = GTMachines.registerTieredMachines("super_chest", (holder, tier) -> new QuantumChestMachine((IMachineBlockEntity)holder, (int)tier, 4000000 * (int)Math.pow(2.0, tier.intValue()), new Object[0]), (tier, builder) -> builder.langValue("Super Chest " + GTValues.LVT[tier + 1 - LOW_TIERS[0]]).blockProp((NonNullUnaryOperator<class_4970.class_2251>)((NonNullUnaryOperator)class_4970.class_2251::method_9624)).rotationState(RotationState.ALL).renderer(() -> new QuantumChestRenderer((int)tier)).hasTESR(true).tooltipBuilder(CHEST_TOOLTIPS).tooltips(new class_2561[]{class_2561.method_43471((String)"gtceu.machine.quantum_chest.tooltip"), class_2561.method_43469((String)"gtceu.universal.tooltip.item_storage_total", (Object[])new Object[]{4000000 * (int)Math.pow(2.0, tier.intValue())})}).compassNode("super_chest").register(), LOW_TIERS);
        QUANTUM_CHEST = GTMachines.registerTieredMachines("quantum_chest", (holder, tier) -> new QuantumChestMachine((IMachineBlockEntity)holder, (int)tier, tier == 9 ? Integer.MAX_VALUE : 4000000 * (int)Math.pow(2.0, tier.intValue()), new Object[0]), (tier, builder) -> builder.langValue("Quantum Chest " + GTValues.LVT[tier + 1 - LOW_TIERS[0]]).blockProp((NonNullUnaryOperator<class_4970.class_2251>)((NonNullUnaryOperator)class_4970.class_2251::method_9624)).rotationState(RotationState.ALL).renderer(() -> new QuantumChestRenderer((int)tier)).hasTESR(true).tooltipBuilder(CHEST_TOOLTIPS).tooltips(new class_2561[]{class_2561.method_43471((String)"gtceu.machine.quantum_chest.tooltip"), class_2561.method_43469((String)"gtceu.universal.tooltip.item_storage_total", (Object[])new Object[]{4000000 * (int)Math.pow(2.0, tier.intValue())})}).compassNode("super_chest").register(), HIGH_TIERS);
        SUPER_TANK = GTMachines.registerTieredMachines("super_tank", (holder, tier) -> new QuantumTankMachine((IMachineBlockEntity)holder, (int)tier, 4000L * FluidHelper.getBucket() * (long)((int)Math.pow(2.0, tier.intValue())), new Object[0]), (tier, builder) -> builder.langValue("Super Tank " + GTValues.LVT[tier + 1 - LOW_TIERS[0]]).blockProp((NonNullUnaryOperator<class_4970.class_2251>)((NonNullUnaryOperator)class_4970.class_2251::method_9624)).rotationState(RotationState.ALL).renderer(() -> new QuantumTankRenderer((int)tier)).hasTESR(true).tooltipBuilder(GTMachines.createTankTooltips("stored")).tooltips(new class_2561[]{class_2561.method_43471((String)"gtceu.machine.quantum_tank.tooltip"), class_2561.method_43469((String)"gtceu.universal.tooltip.fluid_storage_capacity", (Object[])new Object[]{4000000 * (int)Math.pow(2.0, tier.intValue())})}).compassNode("super_tank").register(), LOW_TIERS);
        QUANTUM_TANK = GTMachines.registerTieredMachines("quantum_tank", (holder, tier) -> new QuantumTankMachine((IMachineBlockEntity)holder, (int)tier, tier == 9 ? Integer.MAX_VALUE : 4000L * FluidHelper.getBucket() * (long)((int)Math.pow(2.0, tier.intValue())), new Object[0]), (tier, builder) -> builder.langValue("Quantum Tank " + GTValues.LVT[tier + 1 - LOW_TIERS[0]]).blockProp((NonNullUnaryOperator<class_4970.class_2251>)((NonNullUnaryOperator)class_4970.class_2251::method_9624)).rotationState(RotationState.ALL).renderer(() -> new QuantumTankRenderer((int)tier)).hasTESR(true).tooltipBuilder(GTMachines.createTankTooltips("stored")).tooltips(new class_2561[]{class_2561.method_43471((String)"gtceu.machine.quantum_tank.tooltip"), class_2561.method_43469((String)"gtceu.universal.tooltip.fluid_storage_capacity", (Object[])new Object[]{4000000 * (int)Math.pow(2.0, tier.intValue())})}).compassNode("super_tank").register(), HIGH_TIERS);
        WOODEN_CRATE = GTMachines.registerCrate(GTMaterials.Wood, 27, "Wooden Crate");
        BRONZE_CRATE = GTMachines.registerCrate(GTMaterials.Bronze, 54, "Bronze Crate");
        STEEL_CRATE = GTMachines.registerCrate(GTMaterials.Steel, 72, "Steel Crate");
        ALUMINIUM_CRATE = GTMachines.registerCrate(GTMaterials.Aluminium, 90, "Aluminium Crate");
        STAINLESS_STEEL_CRATE = GTMachines.registerCrate(GTMaterials.StainlessSteel, 108, "Stainless Steel Crate");
        TITANIUM_CRATE = GTMachines.registerCrate(GTMaterials.Titanium, 126, "Titanium Crate");
        TUNGSTENSTEEL_CRATE = GTMachines.registerCrate(GTMaterials.TungstenSteel, 144, "Tungstensteel Crate");
        WOODEN_DRUM = GTMachines.registerDrum(GTMaterials.Wood, (int)(16L * FluidHelper.getBucket()), "Wooden Barrel");
        BRONZE_DRUM = GTMachines.registerDrum(GTMaterials.Bronze, (int)(32L * FluidHelper.getBucket()), "Bronze Drum");
        STEEL_DRUM = GTMachines.registerDrum(GTMaterials.Steel, (int)(64L * FluidHelper.getBucket()), "Steel Drum");
        ALUMINIUM_DRUM = GTMachines.registerDrum(GTMaterials.Aluminium, (int)(128L * FluidHelper.getBucket()), "Aluminium Drum");
        STAINLESS_STEEL_DRUM = GTMachines.registerDrum(GTMaterials.StainlessSteel, (int)(256L * FluidHelper.getBucket()), "Stainless Steel Drum");
        GOLD_DRUM = GTMachines.registerDrum(GTMaterials.Gold, (int)(32L * FluidHelper.getBucket()), "Gold Drum");
        TITANIUM_DRUM = GTMachines.registerDrum(GTMaterials.Titanium, (int)(512L * FluidHelper.getBucket()), "Titanium Drum");
        TUNGSTENSTEEL_DRUM = GTMachines.registerDrum(GTMaterials.TungstenSteel, (int)(1024L * FluidHelper.getBucket()), "Tungstensteel Drum");
        ITEM_IMPORT_BUS = GTMachines.registerTieredMachines("input_bus", (holder, tier) -> new ItemBusPartMachine((IMachineBlockEntity)holder, (int)tier, IO.IN, new Object[0]), (tier, builder) -> {
            PartAbility[] partAbilityArray;
            MachineBuilder machineBuilder = builder.langValue(GTValues.VNF[tier] + " Input Bus").rotationState(RotationState.ALL);
            if (tier == 0) {
                PartAbility[] partAbilityArray2 = new PartAbility[2];
                partAbilityArray2[0] = PartAbility.IMPORT_ITEMS;
                partAbilityArray = partAbilityArray2;
                partAbilityArray2[1] = PartAbility.STEAM_IMPORT_ITEMS;
            } else {
                PartAbility[] partAbilityArray3 = new PartAbility[1];
                partAbilityArray = partAbilityArray3;
                partAbilityArray3[0] = PartAbility.IMPORT_ITEMS;
            }
            return machineBuilder.abilities(partAbilityArray).overlayTieredHullRenderer("item_bus.import").tooltips(new class_2561[]{class_2561.method_43471((String)"gtceu.machine.item_bus.import.tooltip"), class_2561.method_43469((String)"gtceu.universal.tooltip.item_storage_capacity", (Object[])new Object[]{(1 + Math.min(9, tier)) * (1 + Math.min(9, tier))})}).compassNode("item_bus").register();
        }, ALL_TIERS);
        ITEM_EXPORT_BUS = GTMachines.registerTieredMachines("output_bus", (holder, tier) -> new ItemBusPartMachine((IMachineBlockEntity)holder, (int)tier, IO.OUT, new Object[0]), (tier, builder) -> {
            PartAbility[] partAbilityArray;
            MachineBuilder machineBuilder = builder.langValue(GTValues.VNF[tier] + " Output Bus").rotationState(RotationState.ALL);
            if (tier == 0) {
                PartAbility[] partAbilityArray2 = new PartAbility[2];
                partAbilityArray2[0] = PartAbility.EXPORT_ITEMS;
                partAbilityArray = partAbilityArray2;
                partAbilityArray2[1] = PartAbility.STEAM_EXPORT_ITEMS;
            } else {
                PartAbility[] partAbilityArray3 = new PartAbility[1];
                partAbilityArray = partAbilityArray3;
                partAbilityArray3[0] = PartAbility.EXPORT_ITEMS;
            }
            return machineBuilder.abilities(partAbilityArray).overlayTieredHullRenderer("item_bus.export").tooltips(new class_2561[]{class_2561.method_43471((String)"gtceu.machine.item_bus.export.tooltip"), class_2561.method_43469((String)"gtceu.universal.tooltip.item_storage_capacity", (Object[])new Object[]{(1 + Math.min(9, tier)) * (1 + Math.min(9, tier))})}).compassNode("item_bus").register();
        }, ALL_TIERS);
        FLUID_IMPORT_HATCH = GTMachines.registerFluidHatches("input_hatch", "Input Hatch", "fluid_hatch.import", IO.IN, FluidHatchPartMachine.INITIAL_TANK_CAPACITY_1X, 1, ALL_TIERS, PartAbility.IMPORT_FLUIDS, PartAbility.IMPORT_FLUIDS_1X);
        FLUID_IMPORT_HATCH_4X = GTMachines.registerFluidHatches("input_hatch_4x", "Quadruple Input Hatch", "fluid_hatch.import_4x", IO.IN, FluidHatchPartMachine.INITIAL_TANK_CAPACITY_4X, 4, MULTI_HATCH_TIERS, PartAbility.IMPORT_FLUIDS, PartAbility.IMPORT_FLUIDS_4X);
        FLUID_IMPORT_HATCH_9X = GTMachines.registerFluidHatches("input_hatch_9x", "Nonuple Input Hatch", "fluid_hatch.import_9x", IO.IN, FluidHatchPartMachine.INITIAL_TANK_CAPACITY_9X, 9, MULTI_HATCH_TIERS, PartAbility.IMPORT_FLUIDS, PartAbility.IMPORT_FLUIDS_9X);
        FLUID_EXPORT_HATCH = GTMachines.registerFluidHatches("output_hatch", "Output Hatch", "fluid_hatch.export", IO.OUT, FluidHatchPartMachine.INITIAL_TANK_CAPACITY_1X, 1, ALL_TIERS, PartAbility.EXPORT_FLUIDS, PartAbility.EXPORT_FLUIDS_1X);
        FLUID_EXPORT_HATCH_4X = GTMachines.registerFluidHatches("output_hatch_4x", "Quadruple Output Hatch", "fluid_hatch.export_4x", IO.OUT, FluidHatchPartMachine.INITIAL_TANK_CAPACITY_4X, 4, MULTI_HATCH_TIERS, PartAbility.EXPORT_FLUIDS, PartAbility.EXPORT_FLUIDS_4X);
        FLUID_EXPORT_HATCH_9X = GTMachines.registerFluidHatches("output_hatch_9x", "Nonuple Output Hatch", "fluid_hatch.export_9x", IO.OUT, FluidHatchPartMachine.INITIAL_TANK_CAPACITY_9X, 9, MULTI_HATCH_TIERS, PartAbility.EXPORT_FLUIDS, PartAbility.EXPORT_FLUIDS_9X);
        ENERGY_INPUT_HATCH = GTMachines.registerTieredMachines("energy_input_hatch", (holder, tier) -> new EnergyHatchPartMachine((IMachineBlockEntity)holder, (int)tier, IO.IN, 2, new Object[0]), (tier, builder) -> builder.langValue(GTValues.VNF[tier] + " Energy Hatch").rotationState(RotationState.ALL).abilities(PartAbility.INPUT_ENERGY).tooltips(new class_2561[]{class_2561.method_43471((String)"gtceu.machine.energy_hatch.input.tooltip")}).overlayTieredHullRenderer("energy_hatch.input").compassNode("energy_hatch").register(), ALL_TIERS);
        ENERGY_OUTPUT_HATCH = GTMachines.registerTieredMachines("energy_output_hatch", (holder, tier) -> new EnergyHatchPartMachine((IMachineBlockEntity)holder, (int)tier, IO.OUT, 2, new Object[0]), (tier, builder) -> builder.langValue(GTValues.VNF[tier] + " Dynamo Hatch").rotationState(RotationState.ALL).abilities(PartAbility.OUTPUT_ENERGY).tooltips(new class_2561[]{class_2561.method_43471((String)"gtceu.machine.energy_hatch.output.tooltip")}).overlayTieredHullRenderer("energy_hatch.output").compassNode("energy_hatch").register(), ALL_TIERS);
        ENERGY_INPUT_HATCH_4A = GTMachines.registerTieredMachines("energy_input_hatch_4a", (holder, tier) -> new EnergyHatchPartMachine((IMachineBlockEntity)holder, (int)tier, IO.IN, 4, new Object[0]), (tier, builder) -> builder.langValue(GTValues.VNF[tier] + " 4A Energy Hatch").rotationState(RotationState.ALL).abilities(PartAbility.INPUT_ENERGY).tooltips(new class_2561[]{class_2561.method_43471((String)"gtceu.machine.energy_hatch.input_hi_amp.tooltip")}).overlayTieredHullRenderer("energy_hatch.input_4a").compassNode("energy_hatch").register(), 4, 5, 6, 7, 8, 9);
        ENERGY_OUTPUT_HATCH_4A = GTMachines.registerTieredMachines("energy_output_hatch_4a", (holder, tier) -> new EnergyHatchPartMachine((IMachineBlockEntity)holder, (int)tier, IO.OUT, 4, new Object[0]), (tier, builder) -> builder.langValue(GTValues.VNF[tier] + " 4A Dynamo Hatch").rotationState(RotationState.ALL).abilities(PartAbility.OUTPUT_ENERGY).tooltips(new class_2561[]{class_2561.method_43471((String)"gtceu.machine.energy_hatch.output_hi_amp.tooltip")}).overlayTieredHullRenderer("energy_hatch.output_4a").compassNode("energy_hatch").register(), 4, 5, 6, 7, 8, 9);
        ENERGY_INPUT_HATCH_16A = GTMachines.registerTieredMachines("energy_input_hatch_16a", (holder, tier) -> new EnergyHatchPartMachine((IMachineBlockEntity)holder, (int)tier, IO.IN, 16, new Object[0]), (tier, builder) -> builder.langValue(GTValues.VNF[tier] + " 16A Energy Hatch").rotationState(RotationState.ALL).abilities(PartAbility.INPUT_ENERGY).tooltips(new class_2561[]{class_2561.method_43471((String)"gtceu.machine.energy_hatch.input_hi_amp.tooltip")}).overlayTieredHullRenderer("energy_hatch.input_16a").compassNode("energy_hatch").register(), 4, 5, 6, 7, 8, 9);
        ENERGY_OUTPUT_HATCH_16A = GTMachines.registerTieredMachines("energy_output_hatch_16a", (holder, tier) -> new EnergyHatchPartMachine((IMachineBlockEntity)holder, (int)tier, IO.OUT, 16, new Object[0]), (tier, builder) -> builder.langValue(GTValues.VNF[tier] + " 16A Dynamo Hatch").rotationState(RotationState.ALL).abilities(PartAbility.OUTPUT_ENERGY).tooltips(new class_2561[]{class_2561.method_43471((String)"gtceu.machine.energy_hatch.output_hi_amp.tooltip")}).overlayTieredHullRenderer("energy_hatch.output_16a").compassNode("energy_hatch").register(), 4, 5, 6, 7, 8, 9);
        SUBSTATION_ENERGY_INPUT_HATCH = GTMachines.registerTieredMachines("substation_input_hatch_64a", (holder, tier) -> new EnergyHatchPartMachine((IMachineBlockEntity)holder, (int)tier, IO.IN, 64, new Object[0]), (tier, builder) -> builder.langValue(GTValues.VNF[tier] + " 64A Substation Energy Hatch").rotationState(RotationState.ALL).abilities(PartAbility.SUBSTATION_INPUT_ENERGY).tooltips(new class_2561[]{class_2561.method_43471((String)"gtceu.machine.substation_hatch.input.tooltip")}).overlayTieredHullRenderer("energy_hatch.input_16a").compassNode("energy_hatch").register(), 4, 5, 6, 7, 8, 9);
        SUBSTATION_ENERGY_OUTPUT_HATCH = GTMachines.registerTieredMachines("substation_output_hatch_64a", (holder, tier) -> new EnergyHatchPartMachine((IMachineBlockEntity)holder, (int)tier, IO.OUT, 64, new Object[0]), (tier, builder) -> builder.langValue(GTValues.VNF[tier] + " 64A Substation Dynamo Hatch").rotationState(RotationState.ALL).abilities(PartAbility.SUBSTATION_OUTPUT_ENERGY).tooltips(new class_2561[]{class_2561.method_43471((String)"gtceu.machine.substation_hatch.output.tooltip")}).overlayTieredHullRenderer("energy_hatch.output_16a").compassNode("energy_hatch").register(), 4, 5, 6, 7, 8, 9);
        MUFFLER_HATCH = GTMachines.registerTieredMachines("muffler_hatch", MufflerPartMachine::new, (tier, builder) -> builder.langValue("Muffler Hatch " + GTValues.VNF[tier]).rotationState(RotationState.ALL).abilities(PartAbility.MUFFLER).overlayTieredHullRenderer("muffler_hatch").tooltips(new class_2561[]{LangHandler.getFromMultiLang("gtceu.machine.muffler_hatch.tooltip", 0), class_2561.method_43469((String)"gtceu.muffler.recovery_tooltip", (Object[])new Object[]{Math.max(1, tier * 10)}), class_2561.method_43471((String)"gtceu.universal.enabled"), LangHandler.getFromMultiLang("gtceu.machine.muffler_hatch.tooltip", 1).method_27692(class_124.field_1079)}).compassNode("muffler_hatch").register(), ELECTRIC_TIERS);
        STEAM_IMPORT_BUS = GTRegistries.REGISTRATE.machine("steam_input_bus", holder -> new SteamItemBusPartMachine((IMachineBlockEntity)holder, IO.IN, new Object[0])).rotationState(RotationState.ALL).abilities(PartAbility.STEAM_IMPORT_ITEMS).overlaySteamHullRenderer("item_bus.import").langValue("Input Bus (Steam)").compassSections(GTCompassSections.STEAM).compassNode("item_bus").register();
        STEAM_EXPORT_BUS = GTRegistries.REGISTRATE.machine("steam_output_bus", holder -> new SteamItemBusPartMachine((IMachineBlockEntity)holder, IO.OUT, new Object[0])).rotationState(RotationState.ALL).abilities(PartAbility.STEAM_EXPORT_ITEMS).overlaySteamHullRenderer("item_bus.export").langValue("Output Bus (Steam)").compassSections(GTCompassSections.STEAM).compassNode("item_bus").register();
        STEAM_HATCH = GTRegistries.REGISTRATE.machine("steam_input_hatch", x$0 -> new SteamHatchPartMachine((IMachineBlockEntity)x$0, new Object[0])).rotationState(RotationState.ALL).abilities(PartAbility.STEAM).overlaySteamHullRenderer("steam_hatch").tooltips(new class_2561[]{class_2561.method_43469((String)"gtceu.universal.tooltip.fluid_storage_capacity", (Object[])new Object[]{SteamHatchPartMachine.INITIAL_TANK_CAPACITY}), class_2561.method_43471((String)"gtceu.machine.steam.steam_hatch.tooltip")}).compassSections(GTCompassSections.STEAM).compassNode("steam_hatch").register();
        COKE_OVEN_HATCH = GTRegistries.REGISTRATE.machine("coke_oven_hatch", x$0 -> new CokeOvenHatch((IMachineBlockEntity)x$0, new Object[0])).rotationState(RotationState.ALL).modelRenderer(() -> GTCEu.id("block/machine/part/coke_oven_hatch")).compassSections(GTCompassSections.STEAM).compassNode("coke_oven_hatch").register();
        PUMP_HATCH = GTRegistries.REGISTRATE.machine("pump_hatch", x$0 -> new PumpHatchPartMachine((IMachineBlockEntity)x$0, new Object[0])).rotationState(RotationState.ALL).abilities(PartAbility.PUMP_FLUID_HATCH).renderer(PumpHatchPartRenderer::new).compassSections(GTCompassSections.STEAM).compassNode("pump_hatch").register();
        MAINTENANCE_HATCH = GTRegistries.REGISTRATE.machine("maintenance_hatch", blockEntity -> new MaintenanceHatchPartMachine((IMachineBlockEntity)blockEntity, false)).rotationState(RotationState.ALL).abilities(PartAbility.MAINTENANCE).tooltips(new class_2561[]{class_2561.method_43471((String)"gtceu.universal.disabled")}).renderer(() -> new MaintenanceHatchPartRenderer(1, GTCEu.id("block/machine/part/maintenance"))).compassNodeSelf().register();
        CONFIGURABLE_MAINTENANCE_HATCH = GTRegistries.REGISTRATE.machine("configurable_maintenance_hatch", blockEntity -> new MaintenanceHatchPartMachine((IMachineBlockEntity)blockEntity, true)).rotationState(RotationState.ALL).abilities(PartAbility.MAINTENANCE).tooltips(new class_2561[]{class_2561.method_43471((String)"gtceu.universal.disabled")}).renderer(() -> new MaintenanceHatchPartRenderer(3, GTCEu.id("block/machine/part/maintenance.configurable"))).compassNodeSelf().register();
        CLEANING_MAINTENANCE_HATCH = GTRegistries.REGISTRATE.machine("cleaning_maintenance_hatch", CleaningMaintenanceHatchPartMachine::new).rotationState(RotationState.ALL).abilities(PartAbility.MAINTENANCE).tooltips(new class_2561[]{class_2561.method_43471((String)"gtceu.universal.disabled"), class_2561.method_43471((String)"gtceu.machine.maintenance_hatch_cleanroom_auto.tooltip.0"), class_2561.method_43471((String)"gtceu.machine.maintenance_hatch_cleanroom_auto.tooltip.1")}).tooltipBuilder((stack, tooltips) -> {
            for (CleanroomType type : CleaningMaintenanceHatchPartMachine.getCleanroomTypes()) {
                tooltips.add(class_2561.method_43470((String)String.format("  %s%s", class_124.field_1060, class_2561.method_43471((String)type.getTranslationKey()).getString())));
            }
        }).renderer(() -> new MaintenanceHatchPartRenderer(3, GTCEu.id("block/machine/part/maintenance.cleaning"))).compassNodeSelf().register();
        AUTO_MAINTENANCE_HATCH = GTRegistries.REGISTRATE.machine("auto_maintenance_hatch", AutoMaintenanceHatchPartMachine::new).rotationState(RotationState.ALL).abilities(PartAbility.MAINTENANCE).tooltips(new class_2561[]{class_2561.method_43471((String)"gtceu.universal.disabled")}).renderer(() -> new MaintenanceHatchPartRenderer(3, GTCEu.id("block/machine/part/maintenance.full_auto"))).compassNodeSelf().register();
        ITEM_PASSTHROUGH_HATCH = GTMachines.registerTieredMachines("item_passthrough_hatch", (holder, tier) -> new ItemBusPartMachine((IMachineBlockEntity)holder, (int)tier, IO.BOTH, new Object[0]), (tier, builder) -> builder.langValue("%s Item Passthrough Hatch".formatted(GTValues.VNF[tier])).rotationState(RotationState.ALL).abilities(PartAbility.PASSTHROUGH_HATCH).overlayTieredHullRenderer("item_passthrough_hatch").tooltips(new class_2561[]{class_2561.method_43469((String)"gtceu.universal.tooltip.item_storage_capacity", (Object[])new Object[]{(1 + Math.min(9, tier)) * (1 + Math.min(9, tier))}), class_2561.method_43471((String)"gtceu.universal.enabled")}).compassNode("item_passthrough_hatch").register(), ELECTRIC_TIERS);
        FLUID_PASSTHROUGH_HATCH = GTMachines.registerTieredMachines("fluid_passthrough_hatch", (holder, tier) -> new FluidHatchPartMachine((IMachineBlockEntity)holder, (int)tier, IO.BOTH, FluidHatchPartMachine.INITIAL_TANK_CAPACITY_1X, 1, new Object[0]), (tier, builder) -> builder.langValue("%s Fluid Passthrough Hatch".formatted(GTValues.VNF[tier])).rotationState(RotationState.ALL).abilities(PartAbility.PASSTHROUGH_HATCH).overlayTieredHullRenderer("fluid_passthrough_hatch").tooltips(new class_2561[]{class_2561.method_43469((String)"gtceu.universal.tooltip.fluid_storage_capacity_mult", (Object[])new Object[]{tier + 1, 16L * FluidHelper.getBucket()}), class_2561.method_43471((String)"gtceu.universal.enabled")}).compassNode("fluid_passthrough_hatch").register(), ELECTRIC_TIERS);
        DIODE = GTMachines.registerTieredMachines("diode", DiodePartMachine::new, (tier, builder) -> builder.langValue("%s Diode".formatted(GTValues.VNF[tier])).rotationState(RotationState.ALL).abilities(PartAbility.PASSTHROUGH_HATCH).overlayTieredHullRenderer("diode").tooltips(new class_2561[]{class_2561.method_43471((String)"gtceu.machine.diode.tooltip_general"), class_2561.method_43471((String)"gtceu.machine.diode.tooltip_starts_at"), class_2561.method_43469((String)"gtceu.universal.tooltip.voltage_in_out", (Object[])new Object[]{GTValues.V[tier], GTValues.VNF[tier]}), class_2561.method_43469((String)"gtceu.universal.tooltip.amperage_in_out_till", (Object[])new Object[]{DiodePartMachine.MAX_AMPS})}).compassNode("diode").register(), ELECTRIC_TIERS);
        ROTOR_HOLDER = GTMachines.registerTieredMachines("rotor_holder", RotorHolderPartMachine::new, (tier, builder) -> builder.langValue("%s Rotor Holder".formatted(GTValues.VNF[tier])).rotationState(RotationState.ALL).abilities(PartAbility.ROTOR_HOLDER).renderer(() -> new RotorHolderMachineRenderer((int)tier)).tooltips(new class_2561[]{LangHandler.getFromMultiLang("gtceu.machine.muffler_hatch.tooltip", 0), LangHandler.getFromMultiLang("gtceu.machine.muffler_hatch.tooltip", 1), class_2561.method_43471((String)"gtceu.universal.disabled")}).compassNode("rotor_holder").register(), 3, 4, 5, 6, 7, 8);
        LASER_INPUT_HATCH_256 = GTMachines.registerLaserHatch(IO.IN, 256, PartAbility.INPUT_LASER);
        LASER_OUTPUT_HATCH_256 = GTMachines.registerLaserHatch(IO.OUT, 256, PartAbility.OUTPUT_LASER);
        LASER_INPUT_HATCH_1024 = GTMachines.registerLaserHatch(IO.IN, 1024, PartAbility.INPUT_LASER);
        LASER_OUTPUT_HATCH_1024 = GTMachines.registerLaserHatch(IO.OUT, 1024, PartAbility.OUTPUT_LASER);
        LASER_INPUT_HATCH_4096 = GTMachines.registerLaserHatch(IO.IN, 4096, PartAbility.INPUT_LASER);
        LASER_OUTPUT_HATCH_4096 = GTMachines.registerLaserHatch(IO.OUT, 4096, PartAbility.OUTPUT_LASER);
        LARGE_BOILER_BRONZE = GTMachines.registerLargeBoiler("bronze", GTBlocks.CASING_BRONZE_BRICKS, GTBlocks.CASING_BRONZE_PIPE, GTBlocks.FIREBOX_BRONZE, GTCEu.id("block/casings/solid/machine_casing_bronze_plated_bricks"), BoilerFireboxType.BRONZE_FIREBOX, 800, 1);
        LARGE_BOILER_STEEL = GTMachines.registerLargeBoiler("steel", GTBlocks.CASING_STEEL_SOLID, GTBlocks.CASING_STEEL_PIPE, GTBlocks.FIREBOX_STEEL, GTCEu.id("block/casings/solid/machine_casing_solid_steel"), BoilerFireboxType.STEEL_FIREBOX, 1800, 1);
        LARGE_BOILER_TITANIUM = GTMachines.registerLargeBoiler("titanium", GTBlocks.CASING_TITANIUM_STABLE, GTBlocks.CASING_TITANIUM_PIPE, GTBlocks.FIREBOX_TITANIUM, GTCEu.id("block/casings/solid/machine_casing_stable_titanium"), BoilerFireboxType.TITANIUM_FIREBOX, 3200, 1);
        LARGE_BOILER_TUNGSTENSTEEL = GTMachines.registerLargeBoiler("tungstensteel", GTBlocks.CASING_TUNGSTENSTEEL_ROBUST, GTBlocks.CASING_TUNGSTENSTEEL_PIPE, GTBlocks.FIREBOX_TUNGSTENSTEEL, GTCEu.id("block/casings/solid/machine_casing_robust_tungstensteel"), BoilerFireboxType.TUNGSTENSTEEL_FIREBOX, 6400, 2);
        COKE_OVEN = ((MultiblockMachineBuilder)GTRegistries.REGISTRATE.multiblock("coke_oven", x$0 -> new CokeOvenMachine((IMachineBlockEntity)x$0, new Object[0])).rotationState(RotationState.NON_Y_AXIS).recipeType(GTRecipeTypes.COKE_OVEN_RECIPES).appearanceBlock((Supplier)GTBlocks.CASING_COKE_BRICKS)).pattern(definition -> FactoryBlockPattern.start().aisle("XXX", "XXX", "XXX").aisle("XXX", "X#X", "XXX").aisle("XXX", "XYX", "XXX").where('X', Predicates.blocks((class_2248)GTBlocks.CASING_COKE_BRICKS.get()).or(Predicates.blocks(COKE_OVEN_HATCH.get()).setMaxGlobalLimited(5))).where('#', Predicates.air()).where('Y', Predicates.controller(Predicates.blocks(definition.getBlock()))).build()).workableCasingRenderer(GTCEu.id("block/casings/solid/machine_coke_bricks"), GTCEu.id("block/multiblock/coke_oven"), false).compassSections(GTCompassSections.STEAM).compassNodeSelf().register();
        PRIMITIVE_BLAST_FURNACE = ((MultiblockMachineBuilder)GTRegistries.REGISTRATE.multiblock("primitive_blast_furnace", x$0 -> new PrimitiveBlastFurnaceMachine((IMachineBlockEntity)x$0, new Object[0])).rotationState(RotationState.NON_Y_AXIS).recipeType(GTRecipeTypes.PRIMITIVE_BLAST_FURNACE_RECIPES).appearanceBlock((Supplier)GTBlocks.CASING_PRIMITIVE_BRICKS)).pattern(definition -> FactoryBlockPattern.start().aisle("XXX", "XXX", "XXX", "XXX").aisle("XXX", "X#X", "X#X", "X#X").aisle("XXX", "XYX", "XXX", "XXX").where('X', Predicates.blocks((class_2248)GTBlocks.CASING_PRIMITIVE_BRICKS.get())).where('#', Predicates.air()).where('Y', Predicates.controller(Predicates.blocks(definition.getBlock()))).build()).workableCasingRenderer(GTCEu.id("block/casings/solid/machine_primitive_bricks"), GTCEu.id("block/multiblock/primitive_blast_furnace"), false).compassSections(GTCompassSections.STEAM).compassNodeSelf().register();
        ELECTRIC_BLAST_FURNACE = ((MultiblockMachineBuilder)((MultiblockMachineBuilder)GTRegistries.REGISTRATE.multiblock("electric_blast_furnace", CoilWorkableElectricMultiblockMachine::new).rotationState(RotationState.NON_Y_AXIS).recipeType(GTRecipeTypes.BLAST_RECIPES).recipeModifier(GTRecipeModifiers::ebfOverclock)).appearanceBlock((Supplier)GTBlocks.CASING_INVAR_HEATPROOF)).pattern(definition -> FactoryBlockPattern.start().aisle("XXX", "CCC", "CCC", "XXX").aisle("XXX", "C#C", "C#C", "XMX").aisle("XSX", "CCC", "CCC", "XXX").where('S', Predicates.controller(Predicates.blocks(definition.getBlock()))).where('X', Predicates.blocks((class_2248)GTBlocks.CASING_INVAR_HEATPROOF.get()).setMinGlobalLimited(9).or(Predicates.autoAbilities(definition.getRecipeTypes())).or(Predicates.autoAbilities(true, false, false))).where('M', Predicates.abilities(PartAbility.MUFFLER)).where('C', Predicates.heatingCoils()).where('#', Predicates.air()).build()).shapeInfos(definition -> {
            ArrayList shapeInfo = new ArrayList();
            MultiblockShapeInfo.ShapeInfoBuilder builder = ((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)MultiblockShapeInfo.builder().aisle(new String[]{"ISO", "CCC", "CCC", "XMX"})).aisle(new String[]{"FXD", "C#C", "C#C", "XHX"})).aisle(new String[]{"EEX", "CCC", "CCC", "XXX"})).where('X', GTBlocks.CASING_INVAR_HEATPROOF.getDefaultState()).where('S', (Supplier<? extends IMachineBlock>)definition, class_2350.field_11043).where('#', class_2246.field_10124.method_9564()).where('E', ENERGY_INPUT_HATCH[1], class_2350.field_11035).where('I', ITEM_IMPORT_BUS[1], class_2350.field_11043).where('O', ITEM_EXPORT_BUS[1], class_2350.field_11043).where('F', FLUID_IMPORT_HATCH[1], class_2350.field_11039).where('D', FLUID_EXPORT_HATCH[1], class_2350.field_11034).where('H', MUFFLER_HATCH[1], class_2350.field_11036).where('M', MAINTENANCE_HATCH, class_2350.field_11043);
            GTBlocks.ALL_COILS.entrySet().stream().sorted(Comparator.comparingInt(entry -> ((ICoilType)entry.getKey()).getTier())).forEach(coil -> shapeInfo.add(((MultiblockShapeInfo.ShapeInfoBuilder)builder.shallowCopy()).where('C', (class_2248)((Supplier)coil.getValue()).get()).build()));
            return shapeInfo;
        }).recoveryItems(() -> new class_1935[]{(class_1935)((ItemEntry)GTItems.MATERIAL_ITEMS.get((Object)TagPrefix.dustTiny, (Object)GTMaterials.Ash)).get()}).workableCasingRenderer(GTCEu.id("block/casings/solid/machine_casing_heatproof"), GTCEu.id("block/multiblock/electric_blast_furnace"), false).tooltips(new class_2561[]{class_2561.method_43469((String)"gtceu.machine.electric_blast_furnace.tooltip.1", (Object[])new Object[]{class_2561.method_43471((String)"gtceu.machine.electric_blast_furnace.tooltip.2"), class_2561.method_43471((String)"gtceu.machine.electric_blast_furnace.tooltip.3")})}).additionalDisplay((controller, components) -> {
            if (controller instanceof CoilWorkableElectricMultiblockMachine) {
                CoilWorkableElectricMultiblockMachine coilMachine = (CoilWorkableElectricMultiblockMachine)controller;
                if (controller.isFormed()) {
                    components.add(class_2561.method_43469((String)"gtceu.multiblock.blast_furnace.max_temperature", (Object[])new Object[]{class_2561.method_43471((String)(FormattingUtil.formatNumbers((long)coilMachine.getCoilType().getCoilTemperature() + 100L * (long)Math.max(0, coilMachine.getTier() - 2)) + "K")).method_10862(class_2583.field_24360.method_10977(class_124.field_1061))}));
                }
            }
        }).compassSections(GTCompassSections.TIER[2]).compassNodeSelf().register();
        LARGE_CHEMICAL_REACTOR = ((MultiblockMachineBuilder)((MultiblockMachineBuilder)GTRegistries.REGISTRATE.multiblock("large_chemical_reactor", x$0 -> new WorkableElectricMultiblockMachine((IMachineBlockEntity)x$0, new Object[0])).rotationState(RotationState.NON_Y_AXIS).recipeType(GTRecipeTypes.LARGE_CHEMICAL_RECIPES).recipeModifier((BiFunction)GTRecipeModifiers.ELECTRIC_OVERCLOCK.apply(OverclockingLogic.PERFECT_OVERCLOCK))).appearanceBlock((Supplier)GTBlocks.CASING_PTFE_INERT)).pattern(definition -> {
            TraceabilityPredicate casing = Predicates.blocks((class_2248)GTBlocks.CASING_PTFE_INERT.get()).setMinGlobalLimited(10);
            TraceabilityPredicate abilities = Predicates.autoAbilities(definition.getRecipeTypes()).or(Predicates.autoAbilities(true, false, false));
            return FactoryBlockPattern.start().aisle("XXX", "XCX", "XXX").aisle("XCX", "CPC", "XCX").aisle("XXX", "XSX", "XXX").where('S', Predicates.controller(Predicates.blocks(definition.getBlock()))).where('X', casing.or(abilities)).where('P', Predicates.blocks((class_2248)GTBlocks.CASING_POLYTETRAFLUOROETHYLENE_PIPE.get())).where('C', Predicates.blocks((class_2248)GTBlocks.COIL_CUPRONICKEL.get()).setExactLimit(1).or(abilities).or(casing)).build();
        }).shapeInfos(definition -> {
            ArrayList<MultiblockShapeInfo> shapeInfo = new ArrayList<MultiblockShapeInfo>();
            MultiblockShapeInfo.ShapeInfoBuilder baseBuilder = MultiblockShapeInfo.builder().where('S', (Supplier<? extends IMachineBlock>)definition, class_2350.field_11043).where('X', GTBlocks.CASING_PTFE_INERT.getDefaultState()).where('P', GTBlocks.CASING_POLYTETRAFLUOROETHYLENE_PIPE.getDefaultState()).where('C', GTBlocks.COIL_CUPRONICKEL.getDefaultState()).where('I', ITEM_IMPORT_BUS[3], class_2350.field_11043).where('E', ENERGY_INPUT_HATCH[3], class_2350.field_11043).where('O', ITEM_EXPORT_BUS[3], class_2350.field_11043).where('F', FLUID_IMPORT_HATCH[3], class_2350.field_11043).where('M', MAINTENANCE_HATCH, class_2350.field_11043).where('H', FLUID_EXPORT_HATCH[3], class_2350.field_11043);
            shapeInfo.add(((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)baseBuilder.shallowCopy()).aisle(new String[]{"IXO", "FSH", "XMX"})).aisle(new String[]{"XXX", "XPX", "XXX"})).aisle(new String[]{"XEX", "XCX", "XXX"})).build());
            shapeInfo.add(((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)baseBuilder.shallowCopy()).aisle(new String[]{"IXO", "FSH", "XMX"})).aisle(new String[]{"XXX", "XPX", "XCX"})).aisle(new String[]{"XEX", "XXX", "XXX"})).build());
            shapeInfo.add(((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)baseBuilder.shallowCopy()).aisle(new String[]{"IXO", "FSH", "XMX"})).aisle(new String[]{"XCX", "XPX", "XXX"})).aisle(new String[]{"XEX", "XXX", "XXX"})).build());
            shapeInfo.add(((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)baseBuilder.shallowCopy()).aisle(new String[]{"IXO", "FSH", "XMX"})).aisle(new String[]{"XXX", "CPX", "XXX"})).aisle(new String[]{"XEX", "XXX", "XXX"})).build());
            shapeInfo.add(((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)baseBuilder.shallowCopy()).aisle(new String[]{"IXO", "FSH", "XMX"})).aisle(new String[]{"XXX", "XPC", "XXX"})).aisle(new String[]{"XEX", "XXX", "XXX"})).build());
            return shapeInfo;
        }).workableCasingRenderer(GTCEu.id("block/casings/solid/machine_casing_inert_ptfe"), GTCEu.id("block/multiblock/large_chemical_reactor"), false).compassSections(GTCompassSections.TIER[3]).compassNodeSelf().register();
        IMPLOSION_COMPRESSOR = ((MultiblockMachineBuilder)((MultiblockMachineBuilder)GTRegistries.REGISTRATE.multiblock("implosion_compressor", x$0 -> new WorkableElectricMultiblockMachine((IMachineBlockEntity)x$0, new Object[0])).rotationState(RotationState.NON_Y_AXIS).recipeType(GTRecipeTypes.IMPLOSION_RECIPES).recipeModifier((BiFunction)GTRecipeModifiers.ELECTRIC_OVERCLOCK.apply(OverclockingLogic.NON_PERFECT_OVERCLOCK))).appearanceBlock((Supplier)GTBlocks.CASING_STEEL_SOLID)).pattern(definition -> FactoryBlockPattern.start().aisle("XXX", "XXX", "XXX").aisle("XXX", "X#X", "XXX").aisle("XXX", "XSX", "XXX").where('S', Predicates.controller(Predicates.blocks(definition.get()))).where('X', Predicates.blocks((class_2248)GTBlocks.CASING_STEEL_SOLID.get()).setMinGlobalLimited(14).or(Predicates.autoAbilities(definition.getRecipeTypes())).or(Predicates.autoAbilities(true, true, false))).where('#', Predicates.air()).build()).workableCasingRenderer(GTCEu.id("block/casings/solid/machine_casing_solid_steel"), GTCEu.id("block/multiblock/implosion_compressor"), false).compassSections(GTCompassSections.TIER[3]).compassNodeSelf().register();
        PYROLYSE_OVEN = ((MultiblockMachineBuilder)((MultiblockMachineBuilder)GTRegistries.REGISTRATE.multiblock("pyrolyse_oven", CoilWorkableElectricMultiblockMachine::new).rotationState(RotationState.NON_Y_AXIS).recipeType(GTRecipeTypes.PYROLYSE_RECIPES).recipeModifier(GTRecipeModifiers::pyrolyseOvenOverclock)).appearanceBlock((Supplier)GTBlocks.MACHINE_CASING_ULV)).pattern(definition -> FactoryBlockPattern.start().aisle("XXX", "XXX", "XXX").aisle("CCC", "C#C", "CCC").aisle("CCC", "C#C", "CCC").aisle("XXX", "XSX", "XXX").where('S', Predicates.controller(Predicates.blocks(definition.get()))).where('X', Predicates.blocks((class_2248)GTBlocks.MACHINE_CASING_ULV.get()).setMinGlobalLimited(6).or(Predicates.autoAbilities(definition.getRecipeTypes())).or(Predicates.autoAbilities(true, true, false))).where('C', Predicates.heatingCoils()).where('#', Predicates.air()).build()).shapeInfos(definition -> {
            ArrayList shapeInfo = new ArrayList();
            MultiblockShapeInfo.ShapeInfoBuilder builder = ((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)MultiblockShapeInfo.builder().aisle(new String[]{"IXO", "XSX", "FMD"})).aisle(new String[]{"CCC", "C#C", "CCC"})).aisle(new String[]{"CCC", "C#C", "CCC"})).aisle(new String[]{"EEX", "XHX", "XXX"})).where('S', (Supplier<? extends IMachineBlock>)definition, class_2350.field_11043).where('X', GTBlocks.MACHINE_CASING_ULV.getDefaultState()).where('E', ENERGY_INPUT_HATCH[1], class_2350.field_11035).where('I', ITEM_IMPORT_BUS[1], class_2350.field_11043).where('O', ITEM_EXPORT_BUS[1], class_2350.field_11043).where('F', FLUID_IMPORT_HATCH[1], class_2350.field_11043).where('D', FLUID_EXPORT_HATCH[1], class_2350.field_11043).where('H', MUFFLER_HATCH[1], class_2350.field_11035).where('M', MAINTENANCE_HATCH, class_2350.field_11043).where('#', class_2246.field_10124.method_9564());
            GTBlocks.ALL_COILS.entrySet().stream().sorted(Comparator.comparingInt(entry -> ((ICoilType)entry.getKey()).getTier())).forEach(coil -> shapeInfo.add(((MultiblockShapeInfo.ShapeInfoBuilder)builder.shallowCopy()).where('C', (class_2248)((Supplier)coil.getValue()).get()).build()));
            return shapeInfo;
        }).workableCasingRenderer(GTCEu.id("block/casings/voltage/ulv/side"), GTCEu.id("block/multiblock/pyrolyse_oven"), false).tooltips(new class_2561[]{class_2561.method_43471((String)"gtceu.machine.pyrolyse_oven.tooltip.1")}).additionalDisplay((controller, components) -> {
            if (controller instanceof CoilWorkableElectricMultiblockMachine) {
                CoilWorkableElectricMultiblockMachine coilMachine = (CoilWorkableElectricMultiblockMachine)controller;
                if (controller.isFormed()) {
                    components.add(class_2561.method_43469((String)"gtceu.multiblock.pyrolyse_oven.speed", (Object[])new Object[]{coilMachine.getCoilTier() == 0 ? 75 : 50 * (coilMachine.getCoilTier() + 1)}));
                }
            }
        }).compassSections(GTCompassSections.TIER[2]).compassNodeSelf().register();
        MULTI_SMELTER = ((MultiblockMachineBuilder)((MultiblockMachineBuilder)GTRegistries.REGISTRATE.multiblock("multi_smelter", CoilWorkableElectricMultiblockMachine::new).rotationState(RotationState.NON_Y_AXIS).recipeTypes(GTRecipeTypes.FURNACE_RECIPES, GTRecipeTypes.ALLOY_SMELTER_RECIPES).recipeModifier(GTRecipeModifiers::multiSmelterOverclock)).appearanceBlock((Supplier)GTBlocks.CASING_INVAR_HEATPROOF)).pattern(definition -> FactoryBlockPattern.start().aisle("XXX", "CCC", "XXX").aisle("XXX", "C#C", "XMX").aisle("XSX", "CCC", "XXX").where('S', Predicates.controller(Predicates.blocks(definition.get()))).where('X', Predicates.blocks((class_2248)GTBlocks.CASING_INVAR_HEATPROOF.get()).setMinGlobalLimited(9).or(Predicates.autoAbilities(definition.getRecipeTypes())).or(Predicates.autoAbilities(true, false, false))).where('M', Predicates.abilities(PartAbility.MUFFLER)).where('C', Predicates.heatingCoils()).where('#', Predicates.air()).build()).shapeInfos(definition -> {
            ArrayList shapeInfo = new ArrayList();
            MultiblockShapeInfo.ShapeInfoBuilder builder = ((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)MultiblockShapeInfo.builder().aisle(new String[]{"ISO", "CCC", "XMX"})).aisle(new String[]{"XXX", "C#C", "XHX"})).aisle(new String[]{"EEX", "CCC", "XXX"})).where('S', (Supplier<? extends IMachineBlock>)definition, class_2350.field_11043).where('X', GTBlocks.CASING_INVAR_HEATPROOF.getDefaultState()).where('E', ENERGY_INPUT_HATCH[1], class_2350.field_11035).where('I', ITEM_IMPORT_BUS[1], class_2350.field_11043).where('O', ITEM_EXPORT_BUS[1], class_2350.field_11043).where('H', MUFFLER_HATCH[1], class_2350.field_11035).where('M', MAINTENANCE_HATCH, class_2350.field_11043).where('#', class_2246.field_10124.method_9564());
            GTBlocks.ALL_COILS.entrySet().stream().sorted(Comparator.comparingInt(entry -> ((ICoilType)entry.getKey()).getTier())).forEach(coil -> shapeInfo.add(((MultiblockShapeInfo.ShapeInfoBuilder)builder.shallowCopy()).where('C', (class_2248)((Supplier)coil.getValue()).get()).build()));
            return shapeInfo;
        }).recoveryItems(() -> new class_1935[]{(class_1935)((ItemEntry)GTItems.MATERIAL_ITEMS.get((Object)TagPrefix.dustTiny, (Object)GTMaterials.Ash)).get()}).workableCasingRenderer(GTCEu.id("block/casings/solid/machine_casing_heatproof"), GTCEu.id("block/multiblock/multi_furnace"), false).additionalDisplay((controller, components) -> {
            if (controller instanceof CoilWorkableElectricMultiblockMachine) {
                CoilWorkableElectricMultiblockMachine coilMachine = (CoilWorkableElectricMultiblockMachine)controller;
                if (controller.isFormed()) {
                    components.add(class_2561.method_43469((String)"gtceu.multiblock.multi_furnace.heating_coil_level", (Object[])new Object[]{coilMachine.getCoilType().getLevel()}));
                    components.add(class_2561.method_43469((String)"gtceu.multiblock.multi_furnace.heating_coil_discount", (Object[])new Object[]{coilMachine.getCoilType().getEnergyDiscount()}));
                }
            }
        }).compassSections(GTCompassSections.TIER[2]).compassNodeSelf().register();
        CRACKER = ((MultiblockMachineBuilder)((MultiblockMachineBuilder)GTRegistries.REGISTRATE.multiblock("cracker", CoilWorkableElectricMultiblockMachine::new).rotationState(RotationState.NON_Y_AXIS).recipeType(GTRecipeTypes.CRACKING_RECIPES).recipeModifier(GTRecipeModifiers::crackerOverclock)).appearanceBlock((Supplier)GTBlocks.CASING_STAINLESS_CLEAN)).pattern(definition -> FactoryBlockPattern.start().aisle("HCHCH", "HCHCH", "HCHCH").aisle("HCHCH", "H###H", "HCHCH").aisle("HCHCH", "HCOCH", "HCHCH").where('O', Predicates.controller(Predicates.blocks(definition.get()))).where('H', Predicates.blocks((class_2248)GTBlocks.CASING_STAINLESS_CLEAN.get()).setMinGlobalLimited(12).or(Predicates.autoAbilities(definition.getRecipeTypes())).or(Predicates.autoAbilities(true, true, false))).where('#', Predicates.air()).where('C', Predicates.heatingCoils()).build()).shapeInfos(definition -> {
            ArrayList shapeInfo = new ArrayList();
            MultiblockShapeInfo.ShapeInfoBuilder builder = ((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)MultiblockShapeInfo.builder().aisle(new String[]{"FCICD", "HCSCH", "HCMCH"})).aisle(new String[]{"ECHCH", "H###H", "HCHCH"})).aisle(new String[]{"ECHCH", "HCHCH", "HCHCH"})).where('S', (Supplier<? extends IMachineBlock>)definition, class_2350.field_11043).where('H', GTBlocks.CASING_STAINLESS_CLEAN.getDefaultState()).where('E', ENERGY_INPUT_HATCH[1], class_2350.field_11039).where('I', ITEM_IMPORT_BUS[1], class_2350.field_11043).where('F', FLUID_IMPORT_HATCH[1], class_2350.field_11043).where('D', FLUID_EXPORT_HATCH[1], class_2350.field_11043).where('M', MAINTENANCE_HATCH, class_2350.field_11043).where('#', class_2246.field_10124.method_9564());
            GTBlocks.ALL_COILS.entrySet().stream().sorted(Comparator.comparingInt(entry -> ((ICoilType)entry.getKey()).getTier())).forEach(coil -> shapeInfo.add(((MultiblockShapeInfo.ShapeInfoBuilder)builder.shallowCopy()).where('C', (class_2248)((Supplier)coil.getValue()).get()).build()));
            return shapeInfo;
        }).workableCasingRenderer(GTCEu.id("block/casings/solid/machine_casing_clean_stainless_steel"), GTCEu.id("block/multiblock/cracking_unit"), false).tooltips(new class_2561[]{class_2561.method_43471((String)"gtceu.machine.cracker.tooltip.1")}).additionalDisplay((controller, components) -> {
            if (controller instanceof CoilWorkableElectricMultiblockMachine) {
                CoilWorkableElectricMultiblockMachine coilMachine = (CoilWorkableElectricMultiblockMachine)controller;
                if (controller.isFormed()) {
                    components.add(class_2561.method_43469((String)"gtceu.multiblock.cracking_unit.energy", (Object[])new Object[]{100 - 10 * coilMachine.getCoilTier()}));
                }
            }
        }).compassSections(GTCompassSections.TIER[4]).compassNodeSelf().register();
        DISTILLATION_TOWER = ((MultiblockMachineBuilder)((MultiblockMachineBuilder)GTRegistries.REGISTRATE.multiblock("distillation_tower", x$0 -> new WorkableElectricMultiblockMachine((IMachineBlockEntity)x$0, new Object[0])).rotationState(RotationState.NON_Y_AXIS).recipeType(GTRecipeTypes.DISTILLATION_RECIPES).recipeModifier((BiFunction)GTRecipeModifiers.ELECTRIC_OVERCLOCK.apply(OverclockingLogic.NON_PERFECT_OVERCLOCK))).appearanceBlock((Supplier)GTBlocks.CASING_STAINLESS_CLEAN)).pattern(definition -> FactoryBlockPattern.start(RelativeDirection.RIGHT, RelativeDirection.BACK, RelativeDirection.UP).aisle("YSY", "YYY", "YYY").aisle("XXX", "X#X", "XXX").setRepeatable(1, 11).aisle("XXX", "XXX", "XXX").where('S', Predicates.controller(Predicates.blocks(definition.getBlock()))).where('Y', Predicates.blocks((class_2248)GTBlocks.CASING_STAINLESS_CLEAN.get()).or(Predicates.abilities(PartAbility.EXPORT_ITEMS).setMaxGlobalLimited(1)).or(Predicates.abilities(PartAbility.INPUT_ENERGY).setMinGlobalLimited(1).setMaxGlobalLimited(3)).or(Predicates.abilities(PartAbility.IMPORT_FLUIDS).setExactLimit(1))).where('X', Predicates.blocks((class_2248)GTBlocks.CASING_STAINLESS_CLEAN.get()).or(Predicates.abilities(PartAbility.EXPORT_FLUIDS_1X).setMinLayerLimited(1).setMaxLayerLimited(1))).where('#', Predicates.air()).build()).partSorter(Comparator.comparingInt(a -> a.self().getPos().method_10264())).workableCasingRenderer(GTCEu.id("block/casings/solid/machine_casing_clean_stainless_steel"), GTCEu.id("block/multiblock/distillation_tower"), false).compassSections(GTCompassSections.TIER[4]).compassNodeSelf().register();
        VACUUM_FREEZER = ((MultiblockMachineBuilder)((MultiblockMachineBuilder)GTRegistries.REGISTRATE.multiblock("vacuum_freezer", x$0 -> new WorkableElectricMultiblockMachine((IMachineBlockEntity)x$0, new Object[0])).rotationState(RotationState.NON_Y_AXIS).recipeType(GTRecipeTypes.VACUUM_RECIPES).recipeModifier((BiFunction)GTRecipeModifiers.ELECTRIC_OVERCLOCK.apply(OverclockingLogic.NON_PERFECT_OVERCLOCK))).appearanceBlock((Supplier)GTBlocks.CASING_ALUMINIUM_FROSTPROOF)).pattern(definition -> FactoryBlockPattern.start().aisle("XXX", "XXX", "XXX").aisle("XXX", "X#X", "XXX").aisle("XXX", "XSX", "XXX").where('S', Predicates.controller(Predicates.blocks(definition.getBlock()))).where('X', Predicates.blocks((class_2248)GTBlocks.CASING_ALUMINIUM_FROSTPROOF.get()).setMinGlobalLimited(14).or(Predicates.autoAbilities(definition.getRecipeTypes())).or(Predicates.autoAbilities(true, true, false))).where('#', Predicates.air()).build()).workableCasingRenderer(GTCEu.id("block/casings/solid/machine_casing_frost_proof"), GTCEu.id("block/multiblock/vacuum_freezer"), false).compassSections(GTCompassSections.TIER[3]).compassNodeSelf().register();
        ASSEMBLY_LINE = ((MultiblockMachineBuilder)((MultiblockMachineBuilder)GTRegistries.REGISTRATE.multiblock("assembly_line", x$0 -> new WorkableElectricMultiblockMachine((IMachineBlockEntity)x$0, new Object[0])).rotationState(RotationState.NON_Y_AXIS).recipeType(GTRecipeTypes.ASSEMBLY_LINE_RECIPES).recipeModifier((BiFunction)GTRecipeModifiers.ELECTRIC_OVERCLOCK.apply(OverclockingLogic.NON_PERFECT_OVERCLOCK))).appearanceBlock((Supplier)GTBlocks.CASING_STEEL_SOLID)).pattern(definition -> FactoryBlockPattern.start(RelativeDirection.BACK, RelativeDirection.UP, RelativeDirection.RIGHT).aisle("FIF", "RTR", "SAG", "#Y#").aisle("FIF", "RTR", "GAG", "#Y#").setRepeatable(3, 15).aisle("FOF", "RTR", "GAG", "#Y#").where('S', Predicates.controller(Predicates.blocks(definition.getBlock()))).where('F', Predicates.blocks((class_2248)GTBlocks.CASING_STEEL_SOLID.get()).or(Predicates.abilities(PartAbility.IMPORT_FLUIDS).setMaxGlobalLimited(4))).where('O', Predicates.abilities(PartAbility.EXPORT_ITEMS).addTooltips(new class_2561[]{class_2561.method_43471((String)"gtceu.multiblock.pattern.location_end")})).where('Y', Predicates.blocks((class_2248)GTBlocks.CASING_STEEL_SOLID.get()).or(Predicates.abilities(PartAbility.INPUT_ENERGY).setMinGlobalLimited(1).setMaxGlobalLimited(3))).where('I', Predicates.blocks(ITEM_IMPORT_BUS[0].getBlock())).where('G', Predicates.blocks((class_2248)GTBlocks.CASING_GRATE.get())).where('A', Predicates.blocks((class_2248)GTBlocks.CASING_ASSEMBLY_CONTROL.get())).where('R', Predicates.blocks((class_2248)GTBlocks.CASING_LAMINATED_GLASS.get())).where('T', Predicates.blocks((class_2248)GTBlocks.CASING_ASSEMBLY_LINE.get())).where('#', Predicates.any()).build()).workableCasingRenderer(GTCEu.id("block/casings/solid/machine_casing_solid_steel"), GTCEu.id("block/multiblock/assembly_line"), false).compassSections(GTCompassSections.TIER[5]).compassNodeSelf().register();
        PRIMITIVE_PUMP = ((MultiblockMachineBuilder)GTRegistries.REGISTRATE.multiblock("primitive_pump", PrimitivePumpMachine::new).rotationState(RotationState.NON_Y_AXIS).appearanceBlock((Supplier)GTBlocks.CASING_PUMP_DECK)).pattern(definition -> FactoryBlockPattern.start().aisle("XXXX", "##F#", "##F#").aisle("XXHX", "F##F", "FFFF").aisle("SXXX", "##F#", "##F#").where('S', Predicates.controller(Predicates.blocks(definition.getBlock()))).where('X', Predicates.blocks((class_2248)GTBlocks.CASING_PUMP_DECK.get())).where('F', Predicates.blocks((class_2248)((BlockEntry)GTBlocks.MATERIAL_BLOCKS.get((Object)TagPrefix.frameGt, (Object)GTMaterials.TreatedWood)).get())).where('H', Predicates.abilities(PartAbility.PUMP_FLUID_HATCH).or(Predicates.blocks(FLUID_EXPORT_HATCH[1].get(), FLUID_EXPORT_HATCH[2].get()))).where('#', Predicates.any()).build()).sidedWorkableCasingRenderer("block/casings/pump_deck", GTCEu.id("block/multiblock/primitive_pump"), false).compassSections(GTCompassSections.STEAM).compassNodeSelf().register();
        STEAM_GRINDER = ((MultiblockMachineBuilder)((MultiblockMachineBuilder)((MultiblockMachineBuilder)GTRegistries.REGISTRATE.multiblock("steam_grinder", x$0 -> new SteamParallelMultiblockMachine((IMachineBlockEntity)x$0, new Object[0])).rotationState(RotationState.NON_Y_AXIS).appearanceBlock((Supplier)GTBlocks.CASING_BRONZE_BRICKS)).recipeType(GTRecipeTypes.MACERATOR_RECIPES).recipeModifier(SteamParallelMultiblockMachine::recipeModifier, true)).addOutputLimit((RecipeCapability)ItemRecipeCapability.CAP, 1)).pattern(definition -> FactoryBlockPattern.start().aisle("XXX", "XXX", "XXX").aisle("XXX", "X#X", "XXX").aisle("XXX", "XSX", "XXX").where('S', Predicates.controller(Predicates.blocks(definition.getBlock()))).where('#', Predicates.air()).where('X', Predicates.blocks((class_2248)GTBlocks.CASING_BRONZE_BRICKS.get()).setMinGlobalLimited(14).or(Predicates.abilities(PartAbility.STEAM_IMPORT_ITEMS).setPreviewCount(1)).or(Predicates.abilities(PartAbility.STEAM_EXPORT_ITEMS).setPreviewCount(1)).or(Predicates.abilities(PartAbility.STEAM).setExactLimit(1))).build()).workableCasingRenderer(GTCEu.id("block/casings/solid/machine_casing_bronze_plated_bricks"), GTCEu.id("block/multiblock/steam_grinder"), false).compassSections(GTCompassSections.STEAM).compassNodeSelf().register();
        STEAM_OVEN = ((MultiblockMachineBuilder)((MultiblockMachineBuilder)((MultiblockMachineBuilder)((MultiblockMachineBuilder)GTRegistries.REGISTRATE.multiblock("steam_oven", x$0 -> new SteamParallelMultiblockMachine((IMachineBlockEntity)x$0, new Object[0])).rotationState(RotationState.NON_Y_AXIS).appearanceBlock((Supplier)GTBlocks.CASING_BRONZE_BRICKS)).recipeType(GTRecipeTypes.FURNACE_RECIPES).recipeModifier(SteamParallelMultiblockMachine::recipeModifier, true)).addOutputLimit((RecipeCapability)ItemRecipeCapability.CAP, 1)).pattern(definition -> FactoryBlockPattern.start().aisle("FFF", "XXX", " X ").aisle("FFF", "X#X", " X ").aisle("FFF", "XSX", " X ").where('S', Predicates.controller(Predicates.blocks(definition.getBlock()))).where('#', Predicates.air()).where(' ', Predicates.any()).where('X', Predicates.blocks((class_2248)GTBlocks.CASING_BRONZE_BRICKS.get()).setMinGlobalLimited(6).or(Predicates.abilities(PartAbility.STEAM_IMPORT_ITEMS).setPreviewCount(1)).or(Predicates.abilities(PartAbility.STEAM_EXPORT_ITEMS).setPreviewCount(1))).where('F', Predicates.blocks((class_2248)GTBlocks.FIREBOX_BRONZE.get()).or(Predicates.abilities(PartAbility.STEAM).setExactLimit(1))).build()).renderer(() -> new LargeBoilerRenderer(GTCEu.id("block/casings/solid/machine_casing_bronze_plated_bricks"), BoilerFireboxType.BRONZE_FIREBOX, GTCEu.id("block/multiblock/steam_oven")))).compassSections(GTCompassSections.STEAM).compassNodeSelf().register();
        FUSION_REACTOR = GTMachines.registerTieredMultis("fusion_reactor", FusionReactorMachine::new, (tier, builder) -> ((MultiblockMachineBuilder)((MultiblockMachineBuilder)builder.rotationState(RotationState.NON_Y_AXIS).langValue("Fusion Reactor Computer MK %s".formatted(FormattingUtil.toRomanNumeral(tier - 5))).recipeType(GTRecipeTypes.FUSION_RECIPES).recipeModifier(FusionReactorMachine::recipeModifier)).tooltips(new class_2561[]{class_2561.method_43469((String)"gtceu.machine.fusion_reactor.capacity", (Object[])new Object[]{FusionReactorMachine.calculateEnergyStorageFactor(tier, 16) / 1000000L}), class_2561.method_43471((String)"gtceu.machine.fusion_reactor.overclocking"), class_2561.method_43471((String)"gtceu.multiblock.fusion_reactor.%s.description".formatted(GTValues.VN[tier].toLowerCase(Locale.ROOT)))}).appearanceBlock(() -> FusionReactorMachine.getCasingState(tier))).pattern(definition -> {
            TraceabilityPredicate casing = Predicates.blocks(FusionReactorMachine.getCasingState(tier));
            return FactoryBlockPattern.start().aisle("###############", "######OGO######", "###############").aisle("######ICI######", "####GGAAAGG####", "######ICI######").aisle("####CC###CC####", "###EAAOGOAAE###", "####CC###CC####").aisle("###C#######C###", "##EKEG###GEKE##", "###C#######C###").aisle("##C#########C##", "#GAE#######EAG#", "##C#########C##").aisle("##C#########C##", "#GAG#######GAG#", "##C#########C##").aisle("#I###########I#", "OAO#########OAO", "#I###########I#").aisle("#C###########C#", "GAG#########GAG", "#C###########C#").aisle("#I###########I#", "OAO#########OAO", "#I###########I#").aisle("##C#########C##", "#GAG#######GAG#", "##C#########C##").aisle("##C#########C##", "#GAE#######EAG#", "##C#########C##").aisle("###C#######C###", "##EKEG###GEKE##", "###C#######C###").aisle("####CC###CC####", "###EAAOGOAAE###", "####CC###CC####").aisle("######ICI######", "####GGAAAGG####", "######ICI######").aisle("###############", "######OSO######", "###############").where('S', Predicates.controller(Predicates.blocks(definition.get()))).where('G', Predicates.blocks((class_2248)GTBlocks.FUSION_GLASS.get()).or(casing)).where('E', casing.or(Predicates.blocks((class_2248[])PartAbility.INPUT_ENERGY.getBlockRange((int)tier, 8).toArray(class_2248[]::new)).setMinGlobalLimited(1).setPreviewCount(16))).where('C', casing).where('K', Predicates.blocks(FusionReactorMachine.getCoilState(tier))).where('O', casing.or(Predicates.abilities(PartAbility.EXPORT_FLUIDS))).where('A', Predicates.air()).where('I', casing.or(Predicates.abilities(PartAbility.IMPORT_FLUIDS).setMinGlobalLimited(2))).where('#', Predicates.any()).build();
        }).shapeInfos(controller -> {
            ArrayList<MultiblockShapeInfo> shapeInfos = new ArrayList<MultiblockShapeInfo>();
            MultiblockShapeInfo.ShapeInfoBuilder baseBuilder = ((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)MultiblockShapeInfo.builder().aisle(new String[]{"###############", "######WGW######", "###############"})).aisle(new String[]{"######DCD######", "####GG###GG####", "######UCU######"})).aisle(new String[]{"####CC###CC####", "###w##EGE##s###", "####CC###CC####"})).aisle(new String[]{"###C#######C###", "##nKeG###GeKn##", "###C#######C###"})).aisle(new String[]{"##C#########C##", "#G#s#######w#G#", "##C#########C##"})).aisle(new String[]{"##C#########C##", "#G#G#######G#G#", "##C#########C##"})).aisle(new String[]{"#D###########D#", "N#S#########N#S", "#U###########U#"})).aisle(new String[]{"#C###########C#", "G#G#########G#G", "#C###########C#"})).aisle(new String[]{"#D###########D#", "N#S#########N#S", "#U###########U#"})).aisle(new String[]{"##C#########C##", "#G#G#######G#G#", "##C#########C##"})).aisle(new String[]{"##C#########C##", "#G#s#######w#G#", "##C#########C##"})).aisle(new String[]{"###C#######C###", "##eKnG###GnKe##", "###C#######C###"})).aisle(new String[]{"####CC###CC####", "###w##WGW##s###", "####CC###CC####"})).aisle(new String[]{"######DCD######", "####GG###GG####", "######UCU######"})).aisle(new String[]{"###############", "######EME######", "###############"})).where('M', (Supplier<? extends IMachineBlock>)controller, class_2350.field_11035).where('C', FusionReactorMachine.getCasingState(tier)).where('G', (class_2248)GTBlocks.FUSION_GLASS.get()).where('K', FusionReactorMachine.getCoilState(tier)).where('W', FLUID_EXPORT_HATCH[tier], class_2350.field_11043).where('E', FLUID_EXPORT_HATCH[tier], class_2350.field_11035).where('S', FLUID_EXPORT_HATCH[tier], class_2350.field_11034).where('N', FLUID_EXPORT_HATCH[tier], class_2350.field_11039).where('w', ENERGY_INPUT_HATCH[tier], class_2350.field_11039).where('e', ENERGY_INPUT_HATCH[tier], class_2350.field_11035).where('s', ENERGY_INPUT_HATCH[tier], class_2350.field_11034).where('n', ENERGY_INPUT_HATCH[tier], class_2350.field_11043).where('U', FLUID_IMPORT_HATCH[tier], class_2350.field_11036).where('D', FLUID_IMPORT_HATCH[tier], class_2350.field_11033).where('#', class_2246.field_10124.method_9564());
            shapeInfos.add(((MultiblockShapeInfo.ShapeInfoBuilder)baseBuilder.shallowCopy()).where('G', FusionReactorMachine.getCasingState(tier)).build());
            shapeInfos.add(baseBuilder.build());
            return shapeInfos;
        }).workableCasingRenderer(FusionReactorMachine.getCasingType(tier).getTexture(), GTCEu.id("block/multiblock/fusion_reactor"), false).compassSections(GTCompassSections.TIER[6]).compassNodeSelf().register(), 6, 7, 8);
        FLUID_DRILLING_RIG = GTMachines.registerTieredMultis("fluid_drilling_rig", FluidDrillMachine::new, (tier, builder) -> ((MultiblockMachineBuilder)builder.rotationState(RotationState.NON_Y_AXIS).langValue("%s Fluid Drilling Rig %s".formatted(GTValues.VLVH[tier], GTValues.VLVT[tier])).recipeType(GTRecipeTypes.DUMMY_RECIPES).tooltips(new class_2561[]{class_2561.method_43471((String)"gtceu.machine.fluid_drilling_rig.description"), class_2561.method_43469((String)"gtceu.machine.fluid_drilling_rig.depletion", (Object[])new Object[]{FormattingUtil.formatNumbers(100.0 / (double)FluidDrillMachine.getDepletionChance(tier))}), class_2561.method_43469((String)"gtceu.universal.tooltip.energy_tier_range", (Object[])new Object[]{GTValues.VNF[tier], GTValues.VNF[tier + 1]}), class_2561.method_43469((String)"gtceu.machine.fluid_drilling_rig.production", (Object[])new Object[]{FluidDrillMachine.getRigMultiplier(tier), FormattingUtil.formatNumbers((double)FluidDrillMachine.getRigMultiplier(tier) * 1.5)})}).appearanceBlock(() -> FluidDrillMachine.getCasingState(tier))).pattern(definition -> FactoryBlockPattern.start().aisle("XXX", "#F#", "#F#", "#F#", "###", "###", "###").aisle("XXX", "FCF", "FCF", "FCF", "#F#", "#F#", "#F#").aisle("XSX", "#F#", "#F#", "#F#", "###", "###", "###").where('S', Predicates.controller(Predicates.blocks(definition.get()))).where('X', Predicates.blocks(FluidDrillMachine.getCasingState(tier)).setMinGlobalLimited(3).or(Predicates.abilities(PartAbility.INPUT_ENERGY).setMinGlobalLimited(1).setMaxGlobalLimited(3)).or(Predicates.abilities(PartAbility.EXPORT_FLUIDS).setMaxGlobalLimited(1))).where('C', Predicates.blocks(FluidDrillMachine.getCasingState(tier))).where('F', Predicates.blocks(FluidDrillMachine.getFrameState(tier))).where('#', Predicates.any()).build()).workableCasingRenderer(FluidDrillMachine.getBaseTexture(tier), GTCEu.id("block/multiblock/fluid_drilling_rig"), false).compassSections(GTCompassSections.TIER[2]).compassNode("fluid_drilling_rig").register(), 2, 3, 4);
        LARGE_MINER = GTMachines.registerTieredMultis("large_miner", (holder, tier) -> new LargeMinerMachine((IMachineBlockEntity)holder, (int)tier, 64 / tier, 2 * tier - 5, (int)tier, 8 - (tier - 5)), (tier, builder) -> ((MultiblockMachineBuilder)((MultiblockMachineBuilder)((MultiblockMachineBuilder)builder.rotationState(RotationState.NON_Y_AXIS).langValue("%s Large Miner %s".formatted(GTValues.VLVH[tier], GTValues.VLVT[tier])).recipeType(GTRecipeTypes.MACERATOR_RECIPES).appearanceBlock(() -> LargeMinerMachine.getCasingState(tier))).pattern(definition -> FactoryBlockPattern.start().aisle("XXX", "#F#", "#F#", "#F#", "###", "###", "###").aisle("XXX", "FCF", "FCF", "FCF", "#F#", "#F#", "#F#").aisle("XSX", "#F#", "#F#", "#F#", "###", "###", "###").where('S', Predicates.controller(Predicates.blocks(definition.getBlock()))).where('X', Predicates.blocks(LargeMinerMachine.getCasingState(tier)).or(Predicates.abilities(PartAbility.EXPORT_ITEMS).setMaxGlobalLimited(1).setPreviewCount(1)).or(Predicates.abilities(PartAbility.IMPORT_FLUIDS).setExactLimit(1).setPreviewCount(1)).or(Predicates.abilities(PartAbility.INPUT_ENERGY).setMinGlobalLimited(1).setMaxGlobalLimited(3).setPreviewCount(1))).where('C', Predicates.blocks(LargeMinerMachine.getCasingState(tier))).where('F', Predicates.frames(LargeMinerMachine.getMaterial(tier))).where('#', Predicates.any()).build()).renderer(() -> new LargeMinerRenderer((class_2960)MinerRenderer.MATERIALS_TO_CASING_MODELS.get((Object)LargeMinerMachine.getMaterial(tier)), GTCEu.id("block/multiblock/large_miner")))).tooltips(new class_2561[]{class_2561.method_43471((String)"gtceu.machine.large_miner.%s.tooltip".formatted(GTValues.VN[tier].toLowerCase(Locale.ROOT))), class_2561.method_43471((String)"gtceu.machine.miner.multi.description")}).tooltipBuilder((stack, tooltip) -> {
            int workingAreaChunks = (2 * tier - 5) * 2 / 16;
            tooltip.add(class_2561.method_43471((String)"gtceu.machine.miner.multi.modes"));
            tooltip.add(class_2561.method_43471((String)"gtceu.machine.miner.multi.production"));
            tooltip.add(class_2561.method_43469((String)"gtceu.machine.miner.fluid_usage", (Object[])new Object[]{8 - (tier - 5), GTMaterials.DrillingFluid.getLocalizedName()}));
            tooltip.add(class_2561.method_43469((String)"gtceu.universal.tooltip.working_area_chunks", (Object[])new Object[]{workingAreaChunks, workingAreaChunks}));
            tooltip.add(class_2561.method_43469((String)"gtceu.universal.tooltip.energy_tier_range", (Object[])new Object[]{GTValues.VNF[tier], GTValues.VNF[tier + 1]}));
        })).compassSections(GTCompassSections.TIER[4]).compassNode("large_miner").register(), 4, 5, 6);
        CLEANROOM = ((MultiblockMachineBuilder)((MultiblockMachineBuilder)GTRegistries.REGISTRATE.multiblock("cleanroom", CleanroomMachine::new).rotationState(RotationState.NONE).recipeType(GTRecipeTypes.DUMMY_RECIPES).appearanceBlock((Supplier)GTBlocks.PLASTCRETE)).tooltips(new class_2561[]{class_2561.method_43471((String)"gtceu.machine.cleanroom.tooltip.0"), class_2561.method_43471((String)"gtceu.machine.cleanroom.tooltip.1"), class_2561.method_43471((String)"gtceu.machine.cleanroom.tooltip.2"), class_2561.method_43471((String)"gtceu.machine.cleanroom.tooltip.3")}).tooltipBuilder((stack, tooltip) -> {
            if (GTUtil.isCtrlDown()) {
                tooltip.add(class_2561.method_43473());
                tooltip.add(class_2561.method_43471((String)"gtceu.machine.cleanroom.tooltip.4"));
                tooltip.add(class_2561.method_43471((String)"gtceu.machine.cleanroom.tooltip.5"));
                tooltip.add(class_2561.method_43471((String)"gtceu.machine.cleanroom.tooltip.6"));
                tooltip.add(class_2561.method_43471((String)"gtceu.machine.cleanroom.tooltip.7"));
                if (GTCEu.isAE2Loaded()) {
                    tooltip.add(class_2561.method_43471((String)(AEConfig.instance().getChannelMode() == ChannelMode.INFINITE ? "gtceu.machine.cleanroom.tooltip.ae2.no_channels" : "gtceu.machine.cleanroom.tooltip.ae2.channels")));
                }
                tooltip.add(class_2561.method_43473());
            } else {
                tooltip.add(class_2561.method_43471((String)"gtceu.machine.cleanroom.tooltip.hold_ctrl"));
            }
        })).pattern(definition -> FactoryBlockPattern.start().aisle("XXXXX", "XXXXX", "XXXXX", "XXXXX", "XXXXX").aisle("XXXXX", "X   X", "X   X", "X   X", "XFFFX").aisle("XXXXX", "X   X", "X   X", "X   X", "XFSFX").aisle("XXXXX", "X   X", "X   X", "X   X", "XFFFX").aisle("XXXXX", "XXXXX", "XXXXX", "XXXXX", "XXXXX").where('X', Predicates.blocks((class_2248)GTBlocks.PLASTCRETE.get()).or(Predicates.blocks((class_2248)GTBlocks.CLEANROOM_GLASS.get())).or(Predicates.abilities(PartAbility.PASSTHROUGH_HATCH).setMaxGlobalLimited(30, 3)).or(Predicates.abilities(PartAbility.INPUT_ENERGY).setMinGlobalLimited(1).setMaxGlobalLimited(3, 2)).or(Predicates.blocks(ConfigHolder.INSTANCE.machines.enableMaintenance ? MAINTENANCE_HATCH.getBlock() : (class_2248)GTBlocks.PLASTCRETE.get()).setExactLimit(1)).or(Predicates.blocks(class_2246.field_9973).setMaxGlobalLimited(8))).where('S', Predicates.controller(Predicates.blocks(definition.getBlock()))).where(' ', Predicates.any()).where('E', Predicates.abilities(PartAbility.INPUT_ENERGY)).where('F', Predicates.cleanroomFilters()).where('I', Predicates.abilities(PartAbility.PASSTHROUGH_HATCH)).build()).shapeInfos(controller -> {
            ArrayList shapeInfo = new ArrayList();
            MultiblockShapeInfo.ShapeInfoBuilder builder = ((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)MultiblockShapeInfo.builder().aisle(new String[]{"XXXXX", "XIHLX", "XXDXX", "XXXXX", "XXXXX"})).aisle(new String[]{"XXXXX", "X   X", "G   G", "X   X", "XFFFX"})).aisle(new String[]{"XXXXX", "X   X", "G   G", "X   X", "XFSFX"})).aisle(new String[]{"XXXXX", "X   X", "G   G", "X   X", "XFFFX"})).aisle(new String[]{"XMXEX", "XXOXX", "XXRXX", "XXXXX", "XXXXX"})).where('X', (Supplier<? extends class_2248>)GTBlocks.PLASTCRETE).where('G', (Supplier<? extends class_2248>)GTBlocks.CLEANROOM_GLASS).where('S', CLEANROOM.getBlock()).where(' ', class_2246.field_10124).where('E', ENERGY_INPUT_HATCH[1], class_2350.field_11035).where('I', ITEM_PASSTHROUGH_HATCH[1], class_2350.field_11043).where('L', FLUID_PASSTHROUGH_HATCH[1], class_2350.field_11043).where('H', HULL[3], class_2350.field_11043).where('D', DIODE[3], class_2350.field_11043).where('O', (class_2680)((class_2680)class_2246.field_9973.method_9564().method_11657((class_2769)class_2323.field_10938, (Comparable)class_2350.field_11043)).method_11657((class_2769)class_2323.field_10946, (Comparable)class_2756.field_12607)).where('R', (class_2680)((class_2680)class_2246.field_9973.method_9564().method_11657((class_2769)class_2323.field_10938, (Comparable)class_2350.field_11043)).method_11657((class_2769)class_2323.field_10946, (Comparable)class_2756.field_12609));
            if (ConfigHolder.INSTANCE.machines.enableMaintenance) {
                builder.where('M', MAINTENANCE_HATCH, class_2350.field_11035);
            } else {
                builder.where('M', (class_2248)GTBlocks.PLASTCRETE.get());
            }
            GTBlocks.ALL_FILTERS.values().forEach(block -> shapeInfo.add(builder.where('F', (class_2248)block.get()).build()));
            return shapeInfo;
        }).workableCasingRenderer(GTCEu.id("block/casings/cleanroom/plascrete"), GTCEu.id("block/multiblock/cleanroom"), false).compassSections(GTCompassSections.TIER[3]).compassNodeSelf().register();
        LARGE_COMBUSTION_ENGINE = GTMachines.registerLargeCombustionEngine("large_combustion_engine", 4, GTBlocks.CASING_TITANIUM_STABLE, GTBlocks.CASING_TITANIUM_GEARBOX, GTBlocks.CASING_ENGINE_INTAKE, GTCEu.id("block/casings/solid/machine_casing_stable_titanium"), GTCEu.id("block/multiblock/generator/large_combustion_engine"));
        EXTREME_COMBUSTION_ENGINE = GTMachines.registerLargeCombustionEngine("extreme_combustion_engine", 5, GTBlocks.CASING_TUNGSTENSTEEL_ROBUST, GTBlocks.CASING_TUNGSTENSTEEL_GEARBOX, GTBlocks.CASING_EXTREME_ENGINE_INTAKE, GTCEu.id("block/casings/solid/machine_casing_robust_tungstensteel"), GTCEu.id("block/multiblock/generator/extreme_combustion_engine"));
        LARGE_STEAM_TURBINE = GTMachines.registerLargeTurbine("steam_large_turbine", 3, GTRecipeTypes.STEAM_TURBINE_FUELS, GTBlocks.CASING_STEEL_TURBINE, GTBlocks.CASING_STEEL_GEARBOX, GTCEu.id("block/casings/solid/machine_casing_solid_steel"), GTCEu.id("block/multiblock/generator/large_steam_turbine"));
        LARGE_GAS_TURBINE = GTMachines.registerLargeTurbine("gas_large_turbine", 4, GTRecipeTypes.GAS_TURBINE_FUELS, GTBlocks.CASING_STAINLESS_CLEAN, GTBlocks.CASING_STAINLESS_STEEL_GEARBOX, GTCEu.id("block/casings/solid/machine_casing_clean_stainless_steel"), GTCEu.id("block/multiblock/generator/large_gas_turbine"));
        LARGE_PLASMA_TURBINE = GTMachines.registerLargeTurbine("plasma_large_turbine", 5, GTRecipeTypes.PLASMA_GENERATOR_FUELS, GTBlocks.CASING_TUNGSTENSTEEL_TURBINE, GTBlocks.CASING_TUNGSTENSTEEL_GEARBOX, GTCEu.id("block/casings/solid/machine_casing_robust_tungstensteel"), GTCEu.id("block/multiblock/generator/large_plasma_turbine"));
        PROCESSING_ARRAY = ConfigHolder.INSTANCE.machines.doProcessingArray ? GTMachines.registerTieredMultis("processing_array", (x$0, x$1) -> new ProcessingArrayMachine((IMachineBlockEntity)x$0, (int)x$1, new Object[0]), (tier, builder) -> ((MultiblockMachineBuilder)((MultiblockMachineBuilder)((MultiblockMachineBuilder)((MultiblockMachineBuilder)builder.langValue(GTValues.VNF[tier] + " Processing Array").rotationState(RotationState.NON_Y_AXIS).blockProp(p -> p.method_22488().method_26245((state, level, pos) -> false))).shape(class_259.method_1081((double)0.001, (double)0.001, (double)0.001, (double)0.999, (double)0.999, (double)0.999)).appearanceBlock(() -> ProcessingArrayMachine.getCasingState(tier))).recipeType(GTRecipeTypes.DUMMY_RECIPES).recipeModifier(ProcessingArrayMachine::recipeModifier, true)).pattern(definition -> FactoryBlockPattern.start().aisle("XXX", "CCC", "XXX").aisle("XXX", "C#C", "XXX").aisle("XSX", "CCC", "XXX").where('S', Predicates.controller(Predicates.blocks(definition.getBlock()))).where('X', Predicates.blocks(ProcessingArrayMachine.getCasingState(tier)).setMinGlobalLimited(4).or(Predicates.abilities(PartAbility.IMPORT_ITEMS)).or(Predicates.abilities(PartAbility.EXPORT_ITEMS)).or(Predicates.abilities(PartAbility.IMPORT_FLUIDS)).or(Predicates.abilities(PartAbility.EXPORT_FLUIDS)).or(Predicates.abilities(PartAbility.INPUT_ENERGY)).or(Predicates.abilities(PartAbility.OUTPUT_ENERGY)).or(Predicates.autoAbilities(true, false, false))).where('C', Predicates.blocks((class_2248)GTBlocks.CLEANROOM_GLASS.get())).where('#', Predicates.air()).build()).tooltips(new class_2561[]{class_2561.method_43469((String)"gtceu.universal.tooltip.parallel", (Object[])new Object[]{ProcessingArrayMachine.getMachineLimit(tier)})}).renderer(() -> new ProcessingArrayMachineRenderer(tier == 5 ? GTCEu.id("block/casings/solid/machine_casing_robust_tungstensteel") : GTCEu.id("block/casings/solid/machine_casing_sturdy_hsse"), GTCEu.id("block/multiblock/processing_array")))).compassSections(GTCompassSections.TIER[5]).compassNode("processing_array").register(), 5, 6) : null;
        ACTIVE_TRANSFORMER = ((MultiblockMachineBuilder)GTRegistries.REGISTRATE.multiblock("active_transformer", ActiveTransformerMachine::new).rotationState(RotationState.NON_Y_AXIS).recipeType(GTRecipeTypes.DUMMY_RECIPES).appearanceBlock((Supplier)GTBlocks.HIGH_POWER_CASING)).tooltips(new class_2561[]{class_2561.method_43471((String)"gtceu.machine.active_transformer.tooltip.0"), class_2561.method_43471((String)"gtceu.machine.active_transformer.tooltip.1"), class_2561.method_43471((String)"gtceu.machine.active_transformer.tooltip.2").method_10852((class_2561)class_2561.method_43471((String)"gtceu.machine.active_transformer.tooltip.3").method_27692(TooltipHelper.RAINBOW_SLOW.getCurrent()))}).pattern(definition -> FactoryBlockPattern.start().aisle("XXX", "XXX", "XXX").aisle("XXX", "XCX", "XXX").aisle("XXX", "XSX", "XXX").where('S', Predicates.controller(Predicates.blocks(definition.getBlock()))).where('X', Predicates.blocks((class_2248)GTBlocks.HIGH_POWER_CASING.get()).setMinGlobalLimited(12).or(ActiveTransformerMachine.getHatchPredicates())).where('C', Predicates.blocks((class_2248)GTBlocks.SUPERCONDUCTING_COIL.get())).build()).workableCasingRenderer(GTCEu.id("block/casings/hpca/high_power_casing"), GTCEu.id("block/multiblock/data_bank"), false).register();
        POWER_SUBSTATION = ((MultiblockMachineBuilder)GTRegistries.REGISTRATE.multiblock("power_substation", PowerSubstationMachine::new).rotationState(RotationState.NON_Y_AXIS).recipeType(GTRecipeTypes.DUMMY_RECIPES).tooltips(new class_2561[]{class_2561.method_43471((String)"gtceu.machine.power_substation.tooltip.0"), class_2561.method_43471((String)"gtceu.machine.power_substation.tooltip.1"), class_2561.method_43469((String)"gtceu.machine.power_substation.tooltip.2", (Object[])new Object[]{18}), class_2561.method_43471((String)"gtceu.machine.power_substation.tooltip.3"), class_2561.method_43469((String)"gtceu.machine.power_substation.tooltip.4", (Object[])new Object[]{100L}), class_2561.method_43471((String)"gtceu.machine.power_substation.tooltip.5").method_10852((class_2561)class_2561.method_43471((String)"gtceu.machine.power_substation.tooltip.6").method_27692(TooltipHelper.RAINBOW_SLOW.getCurrent()))}).appearanceBlock((Supplier)GTBlocks.CASING_PALLADIUM_SUBSTATION)).pattern(definition -> FactoryBlockPattern.start(RelativeDirection.RIGHT, RelativeDirection.BACK, RelativeDirection.UP).aisle("XXSXX", "XXXXX", "XXXXX", "XXXXX", "XXXXX").aisle("XXXXX", "XCCCX", "XCCCX", "XCCCX", "XXXXX").aisle("GGGGG", "GBBBG", "GBBBG", "GBBBG", "GGGGG").setRepeatable(1, 18).aisle("GGGGG", "GGGGG", "GGGGG", "GGGGG", "GGGGG").where('S', Predicates.controller(Predicates.blocks(definition.getBlock()))).where('C', Predicates.blocks((class_2248)GTBlocks.CASING_PALLADIUM_SUBSTATION.get())).where('X', Predicates.blocks((class_2248)GTBlocks.CASING_PALLADIUM_SUBSTATION.get()).setMinGlobalLimited(14).or(Predicates.autoAbilities(true, false, false)).or(Predicates.abilities(PartAbility.INPUT_ENERGY, PartAbility.SUBSTATION_INPUT_ENERGY, PartAbility.INPUT_LASER).setMinGlobalLimited(1)).or(Predicates.abilities(PartAbility.OUTPUT_ENERGY, PartAbility.SUBSTATION_OUTPUT_ENERGY, PartAbility.OUTPUT_LASER).setMinGlobalLimited(1))).where('G', Predicates.blocks((class_2248)GTBlocks.CASING_LAMINATED_GLASS.get())).where('B', Predicates.powerSubstationBatteries()).build()).shapeInfos(definition -> {
            ArrayList shapeInfo = new ArrayList();
            MultiblockShapeInfo.ShapeInfoBuilder builder = ((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)MultiblockShapeInfo.builder().aisle(new String[]{"CCCCC", "CCCCC", "GGGGG", "GGGGG", "GGGGG"})).aisle(new String[]{"CCCCC", "CCCCC", "GBBBG", "GBBBG", "GGGGG"})).aisle(new String[]{"CCCCC", "CCCCC", "GBBBG", "GBBBG", "GGGGG"})).aisle(new String[]{"CCCCC", "CCCCC", "GBBBG", "GBBBG", "GGGGG"})).aisle(new String[]{"ICSCO", "NCMCT", "GGGGG", "GGGGG", "GGGGG"})).where('S', (Supplier<? extends IMachineBlock>)definition, class_2350.field_11035).where('C', (Supplier<? extends class_2248>)GTBlocks.CASING_PALLADIUM_SUBSTATION).where('G', (Supplier<? extends class_2248>)GTBlocks.CASING_LAMINATED_GLASS).where('I', ENERGY_INPUT_HATCH[3], class_2350.field_11035).where('N', SUBSTATION_ENERGY_INPUT_HATCH[4], class_2350.field_11035).where('O', ENERGY_OUTPUT_HATCH[3], class_2350.field_11035).where('T', SUBSTATION_ENERGY_OUTPUT_HATCH[4], class_2350.field_11035).where('M', ConfigHolder.INSTANCE.machines.enableMaintenance ? (class_2680)MAINTENANCE_HATCH.getBlock().method_9564().method_11657((class_2769)GTMachines.MAINTENANCE_HATCH.get().getRotationState().property, (Comparable)class_2350.field_11035) : ((class_2248)GTBlocks.CASING_PALLADIUM_SUBSTATION.get()).method_9564());
            GTBlocks.PSS_BATTERIES.entrySet().stream().filter(entry -> ((IBatteryData)entry.getKey()).getCapacity() > 0L).sorted(Comparator.comparingInt(entry -> ((IBatteryData)entry.getKey()).getTier())).forEach(entry -> shapeInfo.add(builder.where('B', (class_2248)((Supplier)entry.getValue()).get()).build()));
            return shapeInfo;
        }).workableCasingRenderer(GTCEu.id("block/casings/solid/machine_casing_palladium_substation"), GTCEu.id("block/multiblock/power_substation"), false).register();
    }
}

