/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.data;

import com.google.common.collect.ArrayTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.cover.filter.SimpleFluidFilter;
import com.gregtechceu.gtceu.api.cover.filter.SimpleItemFilter;
import com.gregtechceu.gtceu.api.cover.filter.TagFluidFilter;
import com.gregtechceu.gtceu.api.cover.filter.TagItemFilter;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.MarkerMaterial;
import com.gregtechceu.gtceu.api.data.chemical.material.MarkerMaterials;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.ToolProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.ItemMaterialInfo;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialStack;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.UnificationEntry;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.data.tag.TagUtil;
import com.gregtechceu.gtceu.api.gui.misc.ProspectorMode;
import com.gregtechceu.gtceu.api.item.ComponentItem;
import com.gregtechceu.gtceu.api.item.IGTTool;
import com.gregtechceu.gtceu.api.item.TagPrefixItem;
import com.gregtechceu.gtceu.api.item.component.ElectricStats;
import com.gregtechceu.gtceu.api.item.component.ICustomDescriptionId;
import com.gregtechceu.gtceu.api.item.component.IItemComponent;
import com.gregtechceu.gtceu.api.item.component.IMaterialPartItem;
import com.gregtechceu.gtceu.api.item.component.ThermalFluidStats;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.item.tool.MaterialToolTier;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.api.registry.registrate.CompassNode;
import com.gregtechceu.gtceu.api.registry.registrate.CompassSection;
import com.gregtechceu.gtceu.common.data.GTCompassNodes;
import com.gregtechceu.gtceu.common.data.GTCompassSections;
import com.gregtechceu.gtceu.common.data.GTCovers;
import com.gregtechceu.gtceu.common.data.GTCreativeModeTabs;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.data.GTModels;
import com.gregtechceu.gtceu.common.data.fabric.GTItemsImpl;
import com.gregtechceu.gtceu.common.data.materials.GTFoods;
import com.gregtechceu.gtceu.common.item.ColorSprayBehaviour;
import com.gregtechceu.gtceu.common.item.CoverPlaceBehavior;
import com.gregtechceu.gtceu.common.item.FacadeItemBehaviour;
import com.gregtechceu.gtceu.common.item.FertilizerBehavior;
import com.gregtechceu.gtceu.common.item.FluidFilterBehaviour;
import com.gregtechceu.gtceu.common.item.IntCircuitBehaviour;
import com.gregtechceu.gtceu.common.item.ItemFilterBehaviour;
import com.gregtechceu.gtceu.common.item.ItemFluidContainer;
import com.gregtechceu.gtceu.common.item.ProspectorScannerBehavior;
import com.gregtechceu.gtceu.common.item.TerminalBehavior;
import com.gregtechceu.gtceu.common.item.TooltipBehavior;
import com.gregtechceu.gtceu.common.item.TurbineRotorBehaviour;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.data.lang.LangHandler;
import com.gregtechceu.gtceu.data.recipe.CustomTags;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.lowdragmc.lowdraglib.gui.texture.ItemStackTexture;
import com.lowdragmc.lowdraglib.side.fluid.FluidHelper;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.lowdraglib.side.fluid.FluidTransferHelper;
import com.lowdragmc.lowdraglib.utils.LocalizationUtils;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.providers.RegistrateLangProvider;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.entry.ItemProviderEntry;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import com.tterrag.registrate.util.nullness.NonNullConsumer;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1269;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1814;
import net.minecraft.class_1832;
import net.minecraft.class_1834;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_326;
import net.minecraft.class_3468;
import net.minecraft.class_3545;
import net.minecraft.class_3612;
import net.minecraft.class_5556;
import net.minecraft.class_5620;
import net.minecraft.class_6862;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class GTItems {
    public static final Map<UnificationEntry, class_1935> toUnify;
    public static final Map<TagPrefix, TagPrefix> purifyMap;
    public static Table<TagPrefix, Material, ItemEntry<TagPrefixItem>> MATERIAL_ITEMS;
    public static final Table<Material, GTToolType, ItemProviderEntry<IGTTool>> TOOL_ITEMS;
    public static ItemEntry<class_1792> CREDIT_COPPER;
    public static ItemEntry<class_1792> CREDIT_CUPRONICKEL;
    public static ItemEntry<class_1792> CREDIT_SILVER;
    public static ItemEntry<class_1792> CREDIT_GOLD;
    public static ItemEntry<class_1792> CREDIT_PLATINUM;
    public static ItemEntry<class_1792> CREDIT_OSMIUM;
    public static ItemEntry<class_1792> CREDIT_NAQUADAH;
    public static ItemEntry<class_1792> CREDIT_NEUTRONIUM;
    public static ItemEntry<class_1792> COIN_GOLD_ANCIENT;
    public static ItemEntry<class_1792> COIN_DOGE;
    public static ItemEntry<class_1792> COIN_CHOCOLATE;
    public static ItemEntry<class_1792> COMPRESSED_CLAY;
    public static ItemEntry<class_1792> COMPRESSED_COKE_CLAY;
    public static ItemEntry<class_1792> COMPRESSED_FIRECLAY;
    public static ItemEntry<class_1792> FIRECLAY_BRICK;
    public static ItemEntry<class_1792> COKE_OVEN_BRICK;
    public static ItemEntry<class_1792> WOODEN_FORM_EMPTY;
    public static ItemEntry<ComponentItem> WOODEN_FORM_BRICK;
    public static ItemEntry<class_1792> SHAPE_EMPTY;
    public static final ItemEntry<class_1792>[] SHAPE_MOLDS;
    public static final ItemEntry<class_1792> SHAPE_MOLD_PLATE;
    public static final ItemEntry<class_1792> SHAPE_MOLD_GEAR;
    public static final ItemEntry<class_1792> SHAPE_MOLD_CREDIT;
    public static final ItemEntry<class_1792> SHAPE_MOLD_BOTTLE;
    public static final ItemEntry<class_1792> SHAPE_MOLD_INGOT;
    public static final ItemEntry<class_1792> SHAPE_MOLD_BALL;
    public static final ItemEntry<class_1792> SHAPE_MOLD_BLOCK;
    public static final ItemEntry<class_1792> SHAPE_MOLD_NUGGET;
    public static final ItemEntry<class_1792> SHAPE_MOLD_CYLINDER;
    public static final ItemEntry<class_1792> SHAPE_MOLD_ANVIL;
    public static final ItemEntry<class_1792> SHAPE_MOLD_NAME;
    public static final ItemEntry<class_1792> SHAPE_MOLD_GEAR_SMALL;
    public static final ItemEntry<class_1792> SHAPE_MOLD_ROTOR;
    public static final ItemEntry<class_1792>[] SHAPE_EXTRUDERS;
    public static ItemEntry<class_1792> SHAPE_EXTRUDER_PLATE;
    public static ItemEntry<class_1792> SHAPE_EXTRUDER_ROD;
    public static ItemEntry<class_1792> SHAPE_EXTRUDER_BOLT;
    public static ItemEntry<class_1792> SHAPE_EXTRUDER_RING;
    public static ItemEntry<class_1792> SHAPE_EXTRUDER_CELL;
    public static ItemEntry<class_1792> SHAPE_EXTRUDER_INGOT;
    public static ItemEntry<class_1792> SHAPE_EXTRUDER_WIRE;
    public static ItemEntry<class_1792> SHAPE_EXTRUDER_PIPE_TINY;
    public static ItemEntry<class_1792> SHAPE_EXTRUDER_PIPE_SMALL;
    public static ItemEntry<class_1792> SHAPE_EXTRUDER_PIPE_NORMAL;
    public static ItemEntry<class_1792> SHAPE_EXTRUDER_PIPE_LARGE;
    public static ItemEntry<class_1792> SHAPE_EXTRUDER_PIPE_HUGE;
    public static ItemEntry<class_1792> SHAPE_EXTRUDER_BLOCK;
    public static ItemEntry<class_1792> SHAPE_EXTRUDER_GEAR;
    public static ItemEntry<class_1792> SHAPE_EXTRUDER_BOTTLE;
    public static ItemEntry<class_1792> SHAPE_EXTRUDER_FOIL;
    public static ItemEntry<class_1792> SHAPE_EXTRUDER_GEAR_SMALL;
    public static ItemEntry<class_1792> SHAPE_EXTRUDER_ROD_LONG;
    public static ItemEntry<class_1792> SHAPE_EXTRUDER_ROTOR;
    public static ItemEntry<class_1792> SPRAY_EMPTY;
    public static ItemEntry<ComponentItem> SPRAY_SOLVENT;
    public static ItemEntry<ComponentItem> FLUID_CELL;
    public static ItemEntry<ComponentItem> FLUID_CELL_UNIVERSAL;
    public static ItemEntry<ComponentItem> FLUID_CELL_LARGE_STEEL;
    public static ItemEntry<ComponentItem> FLUID_CELL_LARGE_ALUMINIUM;
    public static ItemEntry<ComponentItem> FLUID_CELL_LARGE_STAINLESS_STEEL;
    public static ItemEntry<ComponentItem> FLUID_CELL_LARGE_TITANIUM;
    public static ItemEntry<ComponentItem> FLUID_CELL_LARGE_TUNGSTEN_STEEL;
    public static ItemEntry<ComponentItem> FLUID_CELL_GLASS_VIAL;
    public static ItemEntry<class_1792> TOOL_MATCHES;
    public static ItemEntry<class_1792> TOOL_MATCHBOX;
    public static ItemEntry<class_1792> TOOL_LIGHTER_INVAR;
    public static ItemEntry<class_1792> TOOL_LIGHTER_PLATINUM;
    public static ItemEntry<class_1792> CARBON_FIBERS;
    public static ItemEntry<class_1792> CARBON_MESH;
    public static ItemEntry<class_1792> CARBON_FIBER_PLATE;
    public static ItemEntry<class_1792> DUCT_TAPE;
    public static ItemEntry<class_1792> NEUTRON_REFLECTOR;
    public static ItemEntry<class_1792> BATTERY_HULL_LV;
    public static ItemEntry<class_1792> BATTERY_HULL_MV;
    public static ItemEntry<class_1792> BATTERY_HULL_HV;
    public static ItemEntry<class_1792> BATTERY_HULL_SMALL_VANADIUM;
    public static ItemEntry<class_1792> BATTERY_HULL_MEDIUM_VANADIUM;
    public static ItemEntry<class_1792> BATTERY_HULL_LARGE_VANADIUM;
    public static ItemEntry<class_1792> BATTERY_HULL_MEDIUM_NAQUADRIA;
    public static ItemEntry<class_1792> BATTERY_HULL_LARGE_NAQUADRIA;
    public static ItemEntry<ComponentItem> BATTERY_ULV_TANTALUM;
    public static ItemEntry<ComponentItem> BATTERY_LV_SODIUM;
    public static ItemEntry<ComponentItem> BATTERY_MV_SODIUM;
    public static ItemEntry<ComponentItem> BATTERY_HV_SODIUM;
    public static ItemEntry<ComponentItem> BATTERY_LV_LITHIUM;
    public static ItemEntry<ComponentItem> BATTERY_MV_LITHIUM;
    public static ItemEntry<ComponentItem> BATTERY_HV_LITHIUM;
    public static ItemEntry<ComponentItem> BATTERY_LV_CADMIUM;
    public static ItemEntry<ComponentItem> BATTERY_MV_CADMIUM;
    public static ItemEntry<ComponentItem> BATTERY_HV_CADMIUM;
    public static ItemEntry<ComponentItem> ENERGIUM_CRYSTAL;
    public static ItemEntry<ComponentItem> LAPOTRON_CRYSTAL;
    public static ItemEntry<ComponentItem> BATTERY_EV_VANADIUM;
    public static ItemEntry<ComponentItem> BATTERY_IV_VANADIUM;
    public static ItemEntry<ComponentItem> BATTERY_LUV_VANADIUM;
    public static ItemEntry<ComponentItem> BATTERY_ZPM_NAQUADRIA;
    public static ItemEntry<ComponentItem> BATTERY_UV_NAQUADRIA;
    public static ItemEntry<ComponentItem> ENERGY_LAPOTRONIC_ORB;
    public static ItemEntry<ComponentItem> ENERGY_LAPOTRONIC_ORB_CLUSTER;
    public static ItemEntry<ComponentItem> ENERGY_MODULE;
    public static ItemEntry<ComponentItem> ENERGY_CLUSTER;
    public static ItemEntry<ComponentItem> ZERO_POINT_MODULE;
    public static ItemEntry<ComponentItem> ULTIMATE_BATTERY;
    public static ItemEntry<class_1792> ELECTRIC_MOTOR_LV;
    public static ItemEntry<class_1792> ELECTRIC_MOTOR_MV;
    public static ItemEntry<class_1792> ELECTRIC_MOTOR_HV;
    public static ItemEntry<class_1792> ELECTRIC_MOTOR_EV;
    public static ItemEntry<class_1792> ELECTRIC_MOTOR_IV;
    public static ItemEntry<class_1792> ELECTRIC_MOTOR_LuV;
    public static ItemEntry<class_1792> ELECTRIC_MOTOR_ZPM;
    public static ItemEntry<class_1792> ELECTRIC_MOTOR_UV;
    public static ItemEntry<class_1792> ELECTRIC_MOTOR_UHV;
    public static ItemEntry<class_1792> ELECTRIC_MOTOR_UEV;
    public static ItemEntry<class_1792> ELECTRIC_MOTOR_UIV;
    public static ItemEntry<class_1792> ELECTRIC_MOTOR_UXV;
    public static ItemEntry<class_1792> ELECTRIC_MOTOR_OpV;
    public static ItemEntry<ComponentItem> ELECTRIC_PUMP_LV;
    public static ItemEntry<ComponentItem> ELECTRIC_PUMP_MV;
    public static ItemEntry<ComponentItem> ELECTRIC_PUMP_HV;
    public static ItemEntry<ComponentItem> ELECTRIC_PUMP_EV;
    public static ItemEntry<ComponentItem> ELECTRIC_PUMP_IV;
    public static ItemEntry<ComponentItem> ELECTRIC_PUMP_LuV;
    public static ItemEntry<ComponentItem> ELECTRIC_PUMP_ZPM;
    public static ItemEntry<ComponentItem> ELECTRIC_PUMP_UV;
    public static ItemEntry<ComponentItem> ELECTRIC_PUMP_UHV;
    public static ItemEntry<ComponentItem> ELECTRIC_PUMP_UEV;
    public static ItemEntry<ComponentItem> ELECTRIC_PUMP_UIV;
    public static ItemEntry<ComponentItem> ELECTRIC_PUMP_UXV;
    public static ItemEntry<ComponentItem> ELECTRIC_PUMP_OpV;
    public static ItemEntry<ComponentItem> FLUID_REGULATOR_LV;
    public static ItemEntry<ComponentItem> FLUID_REGULATOR_MV;
    public static ItemEntry<ComponentItem> FLUID_REGULATOR_HV;
    public static ItemEntry<ComponentItem> FLUID_REGULATOR_EV;
    public static ItemEntry<ComponentItem> FLUID_REGULATOR_IV;
    public static ItemEntry<ComponentItem> FLUID_REGULATOR_LUV;
    public static ItemEntry<ComponentItem> FLUID_REGULATOR_ZPM;
    public static ItemEntry<ComponentItem> FLUID_REGULATOR_UV;
    public static ItemEntry<ComponentItem> FLUID_REGULATOR_UHV;
    public static ItemEntry<ComponentItem> FLUID_REGULATOR_UEV;
    public static ItemEntry<ComponentItem> FLUID_REGULATOR_UIV;
    public static ItemEntry<ComponentItem> FLUID_REGULATOR_UXV;
    public static ItemEntry<ComponentItem> FLUID_REGULATOR_OpV;
    public static ItemEntry<ComponentItem> DYNAMITE;
    public static ItemEntry<ComponentItem> CONVEYOR_MODULE_LV;
    public static ItemEntry<ComponentItem> CONVEYOR_MODULE_MV;
    public static ItemEntry<ComponentItem> CONVEYOR_MODULE_HV;
    public static ItemEntry<ComponentItem> CONVEYOR_MODULE_EV;
    public static ItemEntry<ComponentItem> CONVEYOR_MODULE_IV;
    public static ItemEntry<ComponentItem> CONVEYOR_MODULE_LuV;
    public static ItemEntry<ComponentItem> CONVEYOR_MODULE_ZPM;
    public static ItemEntry<ComponentItem> CONVEYOR_MODULE_UV;
    public static ItemEntry<ComponentItem> CONVEYOR_MODULE_UHV;
    public static ItemEntry<ComponentItem> CONVEYOR_MODULE_UEV;
    public static ItemEntry<ComponentItem> CONVEYOR_MODULE_UIV;
    public static ItemEntry<ComponentItem> CONVEYOR_MODULE_UXV;
    public static ItemEntry<ComponentItem> CONVEYOR_MODULE_OpV;
    public static ItemEntry<class_1792> ELECTRIC_PISTON_LV;
    public static ItemEntry<class_1792> ELECTRIC_PISTON_MV;
    public static ItemEntry<class_1792> ELECTRIC_PISTON_HV;
    public static ItemEntry<class_1792> ELECTRIC_PISTON_EV;
    public static ItemEntry<class_1792> ELECTRIC_PISTON_IV;
    public static ItemEntry<class_1792> ELECTRIC_PISTON_LUV;
    public static ItemEntry<class_1792> ELECTRIC_PISTON_ZPM;
    public static ItemEntry<class_1792> ELECTRIC_PISTON_UV;
    public static ItemEntry<class_1792> ELECTRIC_PISTON_UHV;
    public static ItemEntry<class_1792> ELECTRIC_PISTON_UEV;
    public static ItemEntry<class_1792> ELECTRIC_PISTON_UIV;
    public static ItemEntry<class_1792> ELECTRIC_PISTON_UXV;
    public static ItemEntry<class_1792> ELECTRIC_PISTON_OpV;
    public static ItemEntry<ComponentItem> ROBOT_ARM_LV;
    public static ItemEntry<ComponentItem> ROBOT_ARM_MV;
    public static ItemEntry<ComponentItem> ROBOT_ARM_HV;
    public static ItemEntry<ComponentItem> ROBOT_ARM_EV;
    public static ItemEntry<ComponentItem> ROBOT_ARM_IV;
    public static ItemEntry<ComponentItem> ROBOT_ARM_LuV;
    public static ItemEntry<ComponentItem> ROBOT_ARM_ZPM;
    public static ItemEntry<ComponentItem> ROBOT_ARM_UV;
    public static ItemEntry<ComponentItem> ROBOT_ARM_UHV;
    public static ItemEntry<ComponentItem> ROBOT_ARM_UEV;
    public static ItemEntry<ComponentItem> ROBOT_ARM_UIV;
    public static ItemEntry<ComponentItem> ROBOT_ARM_UXV;
    public static ItemEntry<ComponentItem> ROBOT_ARM_OpV;
    public static ItemEntry<class_1792> FIELD_GENERATOR_LV;
    public static ItemEntry<class_1792> FIELD_GENERATOR_MV;
    public static ItemEntry<class_1792> FIELD_GENERATOR_HV;
    public static ItemEntry<class_1792> FIELD_GENERATOR_EV;
    public static ItemEntry<class_1792> FIELD_GENERATOR_IV;
    public static ItemEntry<class_1792> FIELD_GENERATOR_LuV;
    public static ItemEntry<class_1792> FIELD_GENERATOR_ZPM;
    public static ItemEntry<class_1792> FIELD_GENERATOR_UV;
    public static ItemEntry<class_1792> FIELD_GENERATOR_UHV;
    public static ItemEntry<class_1792> FIELD_GENERATOR_UEV;
    public static ItemEntry<class_1792> FIELD_GENERATOR_UIV;
    public static ItemEntry<class_1792> FIELD_GENERATOR_UXV;
    public static ItemEntry<class_1792> FIELD_GENERATOR_OpV;
    public static ItemEntry<class_1792> EMITTER_LV;
    public static ItemEntry<class_1792> EMITTER_MV;
    public static ItemEntry<class_1792> EMITTER_HV;
    public static ItemEntry<class_1792> EMITTER_EV;
    public static ItemEntry<class_1792> EMITTER_IV;
    public static ItemEntry<class_1792> EMITTER_LuV;
    public static ItemEntry<class_1792> EMITTER_ZPM;
    public static ItemEntry<class_1792> EMITTER_UV;
    public static ItemEntry<class_1792> SENSOR_LV;
    public static ItemEntry<class_1792> SENSOR_MV;
    public static ItemEntry<class_1792> SENSOR_HV;
    public static ItemEntry<class_1792> SENSOR_EV;
    public static ItemEntry<class_1792> SENSOR_IV;
    public static ItemEntry<class_1792> SENSOR_LuV;
    public static ItemEntry<class_1792> SENSOR_ZPM;
    public static ItemEntry<class_1792> SENSOR_UV;
    public static ItemEntry<class_1792> SENSOR_UHV;
    public static ItemEntry<class_1792> SENSOR_UEV;
    public static ItemEntry<class_1792> SENSOR_UIV;
    public static ItemEntry<class_1792> SENSOR_UXV;
    public static ItemEntry<class_1792> SENSOR_OpV;
    public static ItemEntry<class_1792> TOOL_DATA_STICK;
    public static ItemEntry<class_1792> TOOL_DATA_ORB;
    public static final Map<MarkerMaterial, ItemEntry<class_1792>> GLASS_LENSES;
    public static ItemEntry<class_1792> SILICON_BOULE;
    public static ItemEntry<class_1792> PHOSPHORUS_BOULE;
    public static ItemEntry<class_1792> NAQUADAH_BOULE;
    public static ItemEntry<class_1792> NEUTRONIUM_BOULE;
    public static ItemEntry<class_1792> SILICON_WAFER;
    public static ItemEntry<class_1792> PHOSPHORUS_WAFER;
    public static ItemEntry<class_1792> NAQUADAH_WAFER;
    public static ItemEntry<class_1792> NEUTRONIUM_WAFER;
    public static ItemEntry<class_1792> CENTRAL_PROCESSING_UNIT_WAFER;
    public static ItemEntry<class_1792> RANDOM_ACCESS_MEMORY_WAFER;
    public static ItemEntry<class_1792> INTEGRATED_LOGIC_CIRCUIT_WAFER;
    public static ItemEntry<class_1792> NANO_CENTRAL_PROCESSING_UNIT_WAFER;
    public static ItemEntry<class_1792> QUBIT_CENTRAL_PROCESSING_UNIT_WAFER;
    public static ItemEntry<class_1792> SIMPLE_SYSTEM_ON_CHIP_WAFER;
    public static ItemEntry<class_1792> SYSTEM_ON_CHIP_WAFER;
    public static ItemEntry<class_1792> ADVANCED_SYSTEM_ON_CHIP_WAFER;
    public static ItemEntry<class_1792> HIGHLY_ADVANCED_SOC_WAFER;
    public static ItemEntry<class_1792> NAND_MEMORY_CHIP_WAFER;
    public static ItemEntry<class_1792> NOR_MEMORY_CHIP_WAFER;
    public static ItemEntry<class_1792> ULTRA_LOW_POWER_INTEGRATED_CIRCUIT_WAFER;
    public static ItemEntry<class_1792> LOW_POWER_INTEGRATED_CIRCUIT_WAFER;
    public static ItemEntry<class_1792> POWER_INTEGRATED_CIRCUIT_WAFER;
    public static ItemEntry<class_1792> HIGH_POWER_INTEGRATED_CIRCUIT_WAFER;
    public static ItemEntry<class_1792> ULTRA_HIGH_POWER_INTEGRATED_CIRCUIT_WAFER;
    public static ItemEntry<class_1792> ENGRAVED_CRYSTAL_CHIP;
    public static ItemEntry<class_1792> ENGRAVED_LAPOTRON_CHIP;
    public static ItemEntry<class_1792> CENTRAL_PROCESSING_UNIT;
    public static ItemEntry<class_1792> RANDOM_ACCESS_MEMORY;
    public static ItemEntry<class_1792> INTEGRATED_LOGIC_CIRCUIT;
    public static ItemEntry<class_1792> NANO_CENTRAL_PROCESSING_UNIT;
    public static ItemEntry<class_1792> QUBIT_CENTRAL_PROCESSING_UNIT;
    public static ItemEntry<class_1792> SIMPLE_SYSTEM_ON_CHIP;
    public static ItemEntry<class_1792> SYSTEM_ON_CHIP;
    public static ItemEntry<class_1792> ADVANCED_SYSTEM_ON_CHIP;
    public static ItemEntry<class_1792> HIGHLY_ADVANCED_SOC;
    public static ItemEntry<class_1792> NAND_MEMORY_CHIP;
    public static ItemEntry<class_1792> NOR_MEMORY_CHIP;
    public static ItemEntry<class_1792> ULTRA_LOW_POWER_INTEGRATED_CIRCUIT;
    public static ItemEntry<class_1792> LOW_POWER_INTEGRATED_CIRCUIT;
    public static ItemEntry<class_1792> POWER_INTEGRATED_CIRCUIT;
    public static ItemEntry<class_1792> HIGH_POWER_INTEGRATED_CIRCUIT;
    public static ItemEntry<class_1792> ULTRA_HIGH_POWER_INTEGRATED_CIRCUIT;
    public static ItemEntry<class_1792> RAW_CRYSTAL_CHIP;
    public static ItemEntry<class_1792> RAW_CRYSTAL_CHIP_PART;
    public static ItemEntry<class_1792> CRYSTAL_CENTRAL_PROCESSING_UNIT;
    public static ItemEntry<class_1792> CRYSTAL_SYSTEM_ON_CHIP;
    public static ItemEntry<class_1792> COATED_BOARD;
    public static ItemEntry<class_1792> PHENOLIC_BOARD;
    public static ItemEntry<class_1792> PLASTIC_BOARD;
    public static ItemEntry<class_1792> EPOXY_BOARD;
    public static ItemEntry<class_1792> FIBER_BOARD;
    public static ItemEntry<class_1792> MULTILAYER_FIBER_BOARD;
    public static ItemEntry<class_1792> WETWARE_BOARD;
    public static ItemEntry<class_1792> BASIC_CIRCUIT_BOARD;
    public static ItemEntry<class_1792> GOOD_CIRCUIT_BOARD;
    public static ItemEntry<class_1792> PLASTIC_CIRCUIT_BOARD;
    public static ItemEntry<class_1792> ADVANCED_CIRCUIT_BOARD;
    public static ItemEntry<class_1792> EXTREME_CIRCUIT_BOARD;
    public static ItemEntry<class_1792> ELITE_CIRCUIT_BOARD;
    public static ItemEntry<class_1792> WETWARE_CIRCUIT_BOARD;
    public static ItemEntry<class_1792> VACUUM_TUBE;
    public static ItemEntry<class_1792> GLASS_TUBE;
    public static ItemEntry<class_1792> TRANSISTOR;
    public static ItemEntry<class_1792> RESISTOR;
    public static ItemEntry<class_1792> CAPACITOR;
    public static ItemEntry<class_1792> DIODE;
    public static ItemEntry<class_1792> INDUCTOR;
    public static ItemEntry<class_1792> SMD_TRANSISTOR;
    public static ItemEntry<class_1792> SMD_RESISTOR;
    public static ItemEntry<class_1792> SMD_CAPACITOR;
    public static ItemEntry<class_1792> SMD_DIODE;
    public static ItemEntry<class_1792> SMD_INDUCTOR;
    public static ItemEntry<class_1792> ADVANCED_SMD_TRANSISTOR;
    public static ItemEntry<class_1792> ADVANCED_SMD_RESISTOR;
    public static ItemEntry<class_1792> ADVANCED_SMD_CAPACITOR;
    public static ItemEntry<class_1792> ADVANCED_SMD_DIODE;
    public static ItemEntry<class_1792> ADVANCED_SMD_INDUCTOR;
    public static ItemEntry<class_1792> ELECTRONIC_CIRCUIT_LV;
    public static ItemEntry<class_1792> ELECTRONIC_CIRCUIT_MV;
    public static ItemEntry<class_1792> INTEGRATED_CIRCUIT_LV;
    public static ItemEntry<class_1792> INTEGRATED_CIRCUIT_MV;
    public static ItemEntry<class_1792> INTEGRATED_CIRCUIT_HV;
    public static ItemEntry<class_1792> NAND_CHIP_ULV;
    public static ItemEntry<class_1792> MICROPROCESSOR_LV;
    public static ItemEntry<class_1792> PROCESSOR_MV;
    public static ItemEntry<class_1792> PROCESSOR_ASSEMBLY_HV;
    public static ItemEntry<class_1792> WORKSTATION_EV;
    public static ItemEntry<class_1792> MAINFRAME_IV;
    public static ItemEntry<class_1792> NANO_PROCESSOR_HV;
    public static ItemEntry<class_1792> NANO_PROCESSOR_ASSEMBLY_EV;
    public static ItemEntry<class_1792> NANO_COMPUTER_IV;
    public static ItemEntry<class_1792> NANO_MAINFRAME_LUV;
    public static ItemEntry<class_1792> QUANTUM_PROCESSOR_EV;
    public static ItemEntry<class_1792> QUANTUM_ASSEMBLY_IV;
    public static ItemEntry<class_1792> QUANTUM_COMPUTER_LUV;
    public static ItemEntry<class_1792> QUANTUM_MAINFRAME_ZPM;
    public static ItemEntry<class_1792> CRYSTAL_PROCESSOR_IV;
    public static ItemEntry<class_1792> CRYSTAL_ASSEMBLY_LUV;
    public static ItemEntry<class_1792> CRYSTAL_COMPUTER_ZPM;
    public static ItemEntry<class_1792> CRYSTAL_MAINFRAME_UV;
    public static ItemEntry<class_1792> WETWARE_PROCESSOR_LUV;
    public static ItemEntry<class_1792> WETWARE_PROCESSOR_ASSEMBLY_ZPM;
    public static ItemEntry<class_1792> WETWARE_SUPER_COMPUTER_UV;
    public static ItemEntry<class_1792> WETWARE_MAINFRAME_UHV;
    public static ItemEntry<class_1792> COMPONENT_GRINDER_DIAMOND;
    public static ItemEntry<class_1792> COMPONENT_GRINDER_TUNGSTEN;
    public static ItemEntry<class_1792> QUANTUM_EYE;
    public static ItemEntry<class_1792> QUANTUM_STAR;
    public static ItemEntry<class_1792> GRAVI_STAR;
    public static ItemEntry<ComponentItem> ITEM_FILTER;
    public static ItemEntry<ComponentItem> ORE_DICTIONARY_FILTER;
    public static ItemEntry<ComponentItem> FLUID_FILTER;
    public static ItemEntry<ComponentItem> TAG_FLUID_FILTER;
    public static ItemEntry<ComponentItem> COVER_MACHINE_CONTROLLER;
    public static ItemEntry<ComponentItem> COVER_ACTIVITY_DETECTOR;
    public static ItemEntry<ComponentItem> COVER_ACTIVITY_DETECTOR_ADVANCED;
    public static ItemEntry<ComponentItem> COVER_FLUID_DETECTOR;
    public static ItemEntry<ComponentItem> COVER_FLUID_DETECTOR_ADVANCED;
    public static ItemEntry<ComponentItem> COVER_ITEM_DETECTOR;
    public static ItemEntry<ComponentItem> COVER_ITEM_DETECTOR_ADVANCED;
    public static ItemEntry<ComponentItem> COVER_ENERGY_DETECTOR;
    public static ItemEntry<ComponentItem> COVER_ENERGY_DETECTOR_ADVANCED;
    public static ItemEntry<ComponentItem> COVER_MAINTENANCE_DETECTOR;
    public static ItemEntry<ComponentItem> COVER_SCREEN;
    public static ItemEntry<ComponentItem> COVER_CRAFTING;
    public static ItemEntry<ComponentItem> COVER_SHUTTER;
    public static ItemEntry<ComponentItem> COVER_INFINITE_WATER;
    public static ItemEntry<ComponentItem> COVER_ENDER_FLUID_LINK;
    public static ItemEntry<ComponentItem> COVER_DIGITAL_INTERFACE;
    public static ItemEntry<ComponentItem> COVER_DIGITAL_INTERFACE_WIRELESS;
    public static ItemEntry<ComponentItem> COVER_FLUID_VOIDING;
    public static ItemEntry<ComponentItem> COVER_FLUID_VOIDING_ADVANCED;
    public static ItemEntry<ComponentItem> COVER_ITEM_VOIDING;
    public static ItemEntry<ComponentItem> COVER_ITEM_VOIDING_ADVANCED;
    public static ItemEntry<ComponentItem> COVER_FACADE;
    public static ItemEntry<ComponentItem> COVER_SOLAR_PANEL;
    public static ItemEntry<ComponentItem> COVER_SOLAR_PANEL_ULV;
    public static ItemEntry<ComponentItem> COVER_SOLAR_PANEL_LV;
    public static ItemEntry<ComponentItem> COVER_SOLAR_PANEL_MV;
    public static ItemEntry<ComponentItem> COVER_SOLAR_PANEL_HV;
    public static ItemEntry<ComponentItem> COVER_SOLAR_PANEL_EV;
    public static ItemEntry<ComponentItem> COVER_SOLAR_PANEL_IV;
    public static ItemEntry<ComponentItem> COVER_SOLAR_PANEL_LUV;
    public static ItemEntry<ComponentItem> COVER_SOLAR_PANEL_ZPM;
    public static ItemEntry<ComponentItem> COVER_SOLAR_PANEL_UV;
    public static ItemEntry<class_1792> PLUGIN_TEXT;
    public static ItemEntry<class_1792> PLUGIN_ONLINE_PIC;
    public static ItemEntry<class_1792> PLUGIN_FAKE_GUI;
    public static ItemEntry<class_1792> PLUGIN_ADVANCED_MONITOR;
    public static ItemEntry<ComponentItem> INTEGRATED_CIRCUIT;
    public static ItemEntry<class_1792> GELLED_TOLUENE;
    public static ItemEntry<class_1792> BOTTLE_PURPLE_DRINK;
    public static ItemEntry<ComponentItem> PLANT_BALL;
    public static ItemEntry<ComponentItem> STICKY_RESIN;
    public static ItemEntry<ComponentItem> BIO_CHAFF;
    public static ItemEntry<class_1792> ENERGIUM_DUST;
    public static ItemEntry<class_1792> POWER_UNIT_LV;
    public static ItemEntry<class_1792> POWER_UNIT_MV;
    public static ItemEntry<class_1792> POWER_UNIT_HV;
    public static ItemEntry<class_1792> POWER_UNIT_EV;
    public static ItemEntry<class_1792> POWER_UNIT_IV;
    public static ItemEntry<class_1792> NANO_SABER;
    public static ItemEntry<ComponentItem> PROSPECTOR_LV;
    public static ItemEntry<ComponentItem> PROSPECTOR_HV;
    public static ItemEntry<ComponentItem> PROSPECTOR_LUV;
    public static ItemEntry<class_1792> TRICORDER_SCANNER;
    public static ItemEntry<class_1792> DEBUG_SCANNER;
    public static ItemEntry<class_1792> ITEM_MAGNET_LV;
    public static ItemEntry<class_1792> ITEM_MAGNET_HV;
    public static ItemEntry<class_1792> WIRELESS;
    public static ItemEntry<class_1792> CAMERA;
    public static ItemEntry<ComponentItem> TERMINAL;
    public static final ItemEntry<class_1792>[] DYE_ONLY_ITEMS;
    public static final ItemEntry<ComponentItem>[] SPRAY_CAN_DYES;
    public static ItemEntry<ComponentItem> TURBINE_ROTOR;
    public static ItemEntry<class_1792> NEURO_PROCESSOR;
    public static ItemEntry<class_1792> STEM_CELLS;
    public static ItemEntry<class_1792> PETRI_DISH;
    public static ItemEntry<ComponentItem> VOLTAGE_COIL_ULV;
    public static ItemEntry<ComponentItem> VOLTAGE_COIL_LV;
    public static ItemEntry<ComponentItem> VOLTAGE_COIL_MV;
    public static ItemEntry<ComponentItem> VOLTAGE_COIL_HV;
    public static ItemEntry<ComponentItem> VOLTAGE_COIL_EV;
    public static ItemEntry<ComponentItem> VOLTAGE_COIL_IV;
    public static ItemEntry<ComponentItem> VOLTAGE_COIL_LuV;
    public static ItemEntry<ComponentItem> VOLTAGE_COIL_ZPM;
    public static ItemEntry<ComponentItem> VOLTAGE_COIL_UV;
    public static ItemEntry<class_1792> CLIPBOARD;
    public static ItemEntry<class_1792> POWER_THRUSTER;
    public static ItemEntry<class_1792> POWER_THRUSTER_ADVANCED;
    public static ItemEntry<class_1792> GRAVITATION_ENGINE;
    public static ItemEntry<class_1792> SUS_RECORD;
    public static ItemEntry<class_1792> NAN_CERTIFICATE;
    public static ItemEntry<ComponentItem> FERTILIZER;
    public static ItemEntry<class_1792> BLACKLIGHT;

    public static void generateMaterialItems() {
        GTRegistries.REGISTRATE.creativeModeTab(() -> GTCreativeModeTabs.MATERIAL_ITEM);
        ImmutableTable.Builder builder = ImmutableTable.builder();
        for (TagPrefix tagPrefix : TagPrefix.values()) {
            if (!tagPrefix.doGenerateItem()) continue;
            for (Material material : GTRegistries.MATERIALS) {
                if (!tagPrefix.doGenerateItem(material)) continue;
                String first = tagPrefix.invertedName ? FormattingUtil.toLowerCaseUnder(tagPrefix.name) : material.getName();
                String last = tagPrefix.invertedName ? material.getName() : FormattingUtil.toLowerCaseUnder(tagPrefix.name);
                builder.put((Object)tagPrefix, (Object)material, (Object)((ItemBuilder)((ItemBuilder)((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item(first + "_" + last, properties -> TagPrefixItem.create(properties, tagPrefix, material)).onRegister(TagPrefixItem::onRegister)).setData(ProviderType.LANG, NonNullBiConsumer.noop())).transform(GTItems.unificationItem(tagPrefix, material))).properties(p -> p.method_7889(tagPrefix.maxStackSize())).model(NonNullBiConsumer.noop()).color(() -> TagPrefixItem::tintColor).onRegister(GTItems::cauldronInteraction)).onRegister(item -> {
                    switch (tagPrefix.name) {
                        case "buzzSawBlade": 
                        case "screwDriverTip": 
                        case "drillHead": 
                        case "chainSawHead": 
                        case "wrenchTip": 
                        case "turbineBlade": {
                            CompassNode.getOrCreate(GTCompassSections.MATERIALS, "tool_heads").addItem(() -> item);
                            break;
                        }
                        default: {
                            CompassNode.getOrCreate(GTCompassSections.MATERIALS, FormattingUtil.toLowerCaseUnderscore(tagPrefix.name)).iconIfNull(() -> new ItemStackTexture(new class_1792[]{item})).addTag(tagPrefix.getItemParentTags());
                        }
                    }
                })).register());
            }
        }
        MATERIAL_ITEMS = builder.build();
    }

    public static void generateTools() {
        GTRegistries.REGISTRATE.creativeModeTab(() -> GTCreativeModeTabs.TOOL);
        HashMultimap tiers = HashMultimap.create();
        for (Object tier : class_1834.values()) {
            tiers.put((Object)tier.method_8024(), (Object)new class_3545((Object)GTItems.getTierName((class_1832)tier), tier));
        }
        for (Material material : GTRegistries.MATERIALS) {
            if (!material.hasProperty(PropertyKey.TOOL)) continue;
            MaterialToolTier tier = material.getToolTier();
            tiers.put((Object)tier.method_8024(), (Object)new class_3545((Object)GTCEu.id(material.getName()), (Object)tier));
        }
        for (Material material : GTRegistries.MATERIALS.values()) {
            Object tier;
            if (!material.hasProperty(PropertyKey.TOOL)) continue;
            ToolProperty property = material.getProperty(PropertyKey.TOOL);
            tier = material.getToolTier();
            List<class_2960> lower = tiers.values().stream().filter(arg_0 -> GTItems.lambda$generateTools$9((MaterialToolTier)tier, arg_0)).map(class_3545::method_15442).toList();
            List<class_2960> higher = tiers.values().stream().filter(arg_0 -> GTItems.lambda$generateTools$10((MaterialToolTier)tier, arg_0)).map(class_3545::method_15442).toList();
            GTItems.registerToolTier((MaterialToolTier)tier, GTCEu.id(material.getName()), lower, higher);
            for (GTToolType toolType : GTToolType.getTypes().values()) {
                if (!property.hasType(toolType)) continue;
                TOOL_ITEMS.put((Object)material, (Object)toolType, (Object)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("%s_%s".formatted(tier.material.getName().toLowerCase(Locale.ROOT), toolType.name), arg_0 -> GTItems.lambda$generateTools$11(toolType, (MaterialToolTier)tier, material, arg_0)).properties(p -> p.method_7896(class_1802.field_8162)).setData(ProviderType.LANG, NonNullBiConsumer.noop())).model(NonNullBiConsumer.noop()).color(() -> IGTTool::tintColor).onRegister(item -> CompassNode.getOrCreate(GTCompassSections.TOOLS, FormattingUtil.toLowerCaseUnderscore(toolType.name)).iconIfNull(() -> new ItemStackTexture(new class_1792[]{item})).addTag(toolType.itemTags.get(0)))).register());
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class_326 cellColor() {
        return (itemStack, index) -> {
            FluidStack held;
            if (index == 1 && (held = FluidTransferHelper.getFluidContained((class_1799)itemStack)) != null) {
                if (held.getFluid() == class_3612.field_15908) {
                    return -36864;
                }
                return FluidHelper.getColor((FluidStack)held);
            }
            return -1;
        };
    }

    public static ICustomDescriptionId cellName() {
        return itemStack -> {
            FluidStack held = FluidTransferHelper.getFluidContained((class_1799)itemStack);
            String prefix = LocalizationUtils.format((String)"Empty", (Object[])new Object[0]);
            if (held != null && !held.isEmpty()) {
                prefix = FluidHelper.getDisplayName((FluidStack)held).getString();
            }
            return "%s %s".formatted(prefix, LocalizationUtils.format((String)itemStack.method_7909().method_7876(), (Object[])new Object[0]));
        };
    }

    public static void init() {
        GTItems.generateMaterialItems();
        GTItems.generateTools();
    }

    public static <T extends class_1935> NonNullConsumer<T> compassNode(CompassSection section, CompassNode ... preNodes) {
        return item -> CompassNode.getOrCreate(section, () -> ((class_1935)item).method_8389()).addPreNode(preNodes);
    }

    public static <T extends class_1935> NonNullConsumer<T> compassNodeExist(CompassSection section, String node, CompassNode ... preNodes) {
        return item -> CompassNode.getOrCreate(section, node).addPreNode(preNodes).addItem(() -> ((class_1935)item).method_8389());
    }

    public static <T extends class_1935> NonNullConsumer<T> materialInfo(ItemMaterialInfo materialInfo) {
        return item -> ChemicalHelper.registerMaterialInfo(item, materialInfo);
    }

    public static <P, T extends class_1792, S2 extends ItemBuilder<T, P>> NonNullFunction<S2, S2> unificationItem(@Nonnull TagPrefix tagPrefix, @Nonnull Material mat) {
        return builder -> {
            builder.onRegister(item -> {
                UnificationEntry entry = new UnificationEntry(tagPrefix, mat);
                toUnify.put(entry, (class_1935)item);
                ChemicalHelper.registerUnificationItems(entry, new class_1935[]{item});
            });
            return builder;
        };
    }

    public static <T extends class_1792> void cauldronInteraction(T item) {
        if (item instanceof TagPrefixItem) {
            TagPrefixItem tagPrefixItem = (TagPrefixItem)item;
            if (purifyMap.containsKey(tagPrefixItem.tagPrefix)) {
                class_5620.field_27776.put(item, (state, world, pos, player, hand, stack) -> {
                    class_1792 stackItem;
                    if (!world.field_9236 && (stackItem = stack.method_7909()) instanceof TagPrefixItem) {
                        TagPrefixItem prefixItem = (TagPrefixItem)stackItem;
                        if (!purifyMap.containsKey(prefixItem.tagPrefix)) {
                            return class_1269.field_5811;
                        }
                        if (!state.method_28498((class_2769)class_5556.field_27206)) {
                            return class_1269.field_5811;
                        }
                        int level = (Integer)state.method_11654((class_2769)class_5556.field_27206);
                        if (level == 0) {
                            return class_1269.field_5811;
                        }
                        player.method_6122(hand, ChemicalHelper.get(purifyMap.get(prefixItem.tagPrefix), prefixItem.material, stack.method_7947()));
                        player.method_7281(class_3468.field_15373);
                        player.method_7259(class_3468.field_15372.method_14956((Object)stackItem));
                        class_5556.method_31650((class_2680)state, (class_1937)world, (class_2338)pos);
                    }
                    return class_1269.method_29236((boolean)world.field_9236);
                });
            }
        }
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T extends ComponentItem> NonNullConsumer<T> burnTime(int burnTime) {
        return GTItemsImpl.burnTime(burnTime);
    }

    public static <T extends ComponentItem> NonNullConsumer<T> attach(IItemComponent ... components) {
        return item -> item.attachComponents(components);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T extends class_1792> NonNullConsumer<T> modelPredicate(class_2960 predicate, Function<class_1799, Float> property) {
        void var1_1;
        return GTItemsImpl.modelPredicate(predicate, (Function<class_1799, Float>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerToolTier(MaterialToolTier tier, class_2960 id, Collection<class_2960> before, Collection<class_2960> after) {
        void var3_3;
        void var2_2;
        void var1_1;
        GTItemsImpl.registerToolTier(tier, (class_2960)var1_1, (Collection<class_2960>)var2_2, (Collection<class_2960>)var3_3);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static class_2960 getTierName(class_1832 tier) {
        return GTItemsImpl.getTierName(tier);
    }

    @NotNull
    private static <T extends class_1792> NonNullBiConsumer<DataGenContext<class_1792, T>, RegistrateLangProvider> reverseLangValue() {
        return (ctx, prov) -> {
            List names = Arrays.stream(ctx.getName().split("/.")).collect(Collectors.toList());
            Collections.reverse(names);
            prov.add((class_1792)ctx.get(), names.stream().map(StringUtils::capitalize).collect(Collectors.joining(" ")));
        };
    }

    private static /* synthetic */ class_1792 lambda$generateTools$11(GTToolType toolType, MaterialToolTier tier, Material material, class_1792.class_1793 p) {
        return toolType.constructor.apply(toolType, tier, material, toolType.toolDefinition, p).method_8389();
    }

    private static /* synthetic */ boolean lambda$generateTools$10(MaterialToolTier tier, class_3545 high) {
        return ((class_1832)high.method_15441()).method_8024() == tier.method_8024() + 1;
    }

    private static /* synthetic */ boolean lambda$generateTools$9(MaterialToolTier tier, class_3545 low) {
        return ((class_1832)low.method_15441()).method_8024() == tier.method_8024() - 1;
    }

    static {
        class_1767 dyeColor;
        int i;
        toUnify = new HashMap<UnificationEntry, class_1935>();
        purifyMap = new HashMap<TagPrefix, TagPrefix>();
        purifyMap.put(TagPrefix.crushed, TagPrefix.crushedPurified);
        purifyMap.put(TagPrefix.dustImpure, TagPrefix.dust);
        purifyMap.put(TagPrefix.dustPure, TagPrefix.dust);
        TOOL_ITEMS = ArrayTable.create(GTRegistries.MATERIALS.values().stream().filter(mat -> mat.hasProperty(PropertyKey.TOOL)).toList(), GTToolType.getTypes().values().stream().toList());
        GTRegistries.REGISTRATE.creativeModeTab(() -> GTCreativeModeTabs.ITEM);
        CREDIT_COPPER = ((ItemBuilder)GTRegistries.REGISTRATE.item("copper_credit", class_1792::new).lang("Copper Credit").onRegister(GTItems.compassNodeExist(GTCompassSections.MISC, "credit", new CompassNode[0]))).register();
        CREDIT_CUPRONICKEL = ((ItemBuilder)GTRegistries.REGISTRATE.item("cupronickel_credit", class_1792::new).lang("Cupronickel Credit").defaultModel().onRegister(GTItems.compassNodeExist(GTCompassSections.MISC, "credit", new CompassNode[0]))).register();
        CREDIT_SILVER = ((ItemBuilder)GTRegistries.REGISTRATE.item("silver_credit", class_1792::new).lang("Silver Credit").properties(p -> p.method_7894(class_1814.field_8907)).onRegister(GTItems.compassNodeExist(GTCompassSections.MISC, "credit", new CompassNode[0]))).register();
        CREDIT_GOLD = ((ItemBuilder)GTRegistries.REGISTRATE.item("gold_credit", class_1792::new).lang("Gold Credit").properties(p -> p.method_7894(class_1814.field_8907)).onRegister(GTItems.compassNodeExist(GTCompassSections.MISC, "credit", new CompassNode[0]))).register();
        CREDIT_PLATINUM = ((ItemBuilder)GTRegistries.REGISTRATE.item("platinum_credit", class_1792::new).lang("Platinum Credit").properties(p -> p.method_7894(class_1814.field_8903)).onRegister(GTItems.compassNodeExist(GTCompassSections.MISC, "credit", new CompassNode[0]))).register();
        CREDIT_OSMIUM = ((ItemBuilder)GTRegistries.REGISTRATE.item("osmium_credit", class_1792::new).lang("Osmium Credit").properties(p -> p.method_7894(class_1814.field_8903)).onRegister(GTItems.compassNodeExist(GTCompassSections.MISC, "credit", new CompassNode[0]))).register();
        CREDIT_NAQUADAH = ((ItemBuilder)GTRegistries.REGISTRATE.item("naquadah_credit", class_1792::new).lang("Naquadah Credit").properties(p -> p.method_7894(class_1814.field_8904)).onRegister(GTItems.compassNodeExist(GTCompassSections.MISC, "credit", new CompassNode[0]))).register();
        CREDIT_NEUTRONIUM = ((ItemBuilder)GTRegistries.REGISTRATE.item("neutronium_credit", class_1792::new).lang("Neutronium Credit").properties(p -> p.method_7894(class_1814.field_8904)).onRegister(GTItems.compassNodeExist(GTCompassSections.MISC, "credit", new CompassNode[0]))).register();
        COIN_GOLD_ANCIENT = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("ancient_gold_coin", class_1792::new).lang("Ancient Gold Coin").properties(p -> p.method_7894(class_1814.field_8903)).onRegister(GTItems.compassNode(GTCompassSections.MISC, new CompassNode[0]))).onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Gold, 907200L))))).register();
        COIN_DOGE = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("doge_coin", class_1792::new).lang("Doge Coin").properties(p -> p.method_7894(class_1814.field_8904)).onRegister(GTItems.compassNode(GTCompassSections.MISC, new CompassNode[0]))).onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Brass, 907200L))))).register();
        COIN_CHOCOLATE = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("chocolate_coin", class_1792::new).lang("Chocolate Coin").properties(p -> p.method_7894(class_1814.field_8904).method_19265(GTFoods.CHOCOLATE)).onRegister(GTItems.compassNode(GTCompassSections.MISC, new CompassNode[0]))).onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Gold, 907200L))))).register();
        COMPRESSED_CLAY = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("compressed_clay", class_1792::new).lang("Compressed Clay").onRegister(GTItems.compassNode(GTCompassSections.MISC, new CompassNode[0]))).onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Clay, 3628800L))))).register();
        COMPRESSED_COKE_CLAY = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("compressed_coke_clay", class_1792::new).lang("Compressed Coke Clay").onRegister(GTItems.compassNode(GTCompassSections.MISC, new CompassNode[0]))).onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Clay, 3628800L))))).register();
        COMPRESSED_FIRECLAY = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("compressed_fireclay", class_1792::new).lang("Compressed Fireclay").onRegister(GTItems.compassNode(GTCompassSections.MISC, new CompassNode[0]))).onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Fireclay, 3628800L))))).register();
        FIRECLAY_BRICK = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("firebrick", class_1792::new).lang("Firebrick").onRegister(GTItems.compassNode(GTCompassSections.MISC, new CompassNode[0]))).onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Fireclay, 3628800L))))).register();
        COKE_OVEN_BRICK = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("coke_oven_brick", class_1792::new).lang("Coke Oven Brick").onRegister(GTItems.compassNode(GTCompassSections.MISC, new CompassNode[0]))).onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Clay, 3628800L))))).register();
        WOODEN_FORM_EMPTY = ((ItemBuilder)GTRegistries.REGISTRATE.item("empty_wooden_form", class_1792::new).lang("Empty Wooden Form").onRegister(GTItems.compassNode(GTCompassSections.MISC, new CompassNode[0]))).register();
        WOODEN_FORM_BRICK = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("brick_wooden_form", ComponentItem::create).lang("Brick Wooden Form").properties(p -> p.method_7896(class_1802.field_8162).method_7889(1)).onRegister(GTItems.compassNode(GTCompassSections.MISC, new CompassNode[0]))).onRegister(GTItems.attach(stack -> stack))).register();
        SHAPE_EMPTY = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("empty_mold", class_1792::new).lang("Empty Mold").onRegister(GTItems.compassNode(GTCompassSections.MISC, new CompassNode[0]))).onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Steel, 14515200L))))).register();
        SHAPE_MOLDS = new ItemEntry[13];
        GTItems.SHAPE_MOLDS[0] = SHAPE_MOLD_PLATE = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("plate_casting_mold", class_1792::new).lang("Casting Mold (Plate)").onRegister(GTItems.compassNodeExist(GTCompassSections.MISC, "mold", new CompassNode[0]))).onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Steel, 14515200L))))).register();
        GTItems.SHAPE_MOLDS[1] = SHAPE_MOLD_GEAR = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("gear_casting_mold", class_1792::new).lang("Casting Mold (Gear)").onRegister(GTItems.compassNodeExist(GTCompassSections.MISC, "mold", new CompassNode[0]))).onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Steel, 14515200L))))).register();
        GTItems.SHAPE_MOLDS[2] = SHAPE_MOLD_CREDIT = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("credit_casting_mold", class_1792::new).lang("Casting Mold (Coinage)").onRegister(GTItems.compassNodeExist(GTCompassSections.MISC, "mold", new CompassNode[0]))).onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Steel, 14515200L))))).register();
        GTItems.SHAPE_MOLDS[3] = SHAPE_MOLD_BOTTLE = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("bottle_casting_mold", class_1792::new).lang("Casting Mold (Bottle)").onRegister(GTItems.compassNodeExist(GTCompassSections.MISC, "mold", new CompassNode[0]))).onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Steel, 14515200L))))).register();
        GTItems.SHAPE_MOLDS[4] = SHAPE_MOLD_INGOT = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("ingot_casting_mold", class_1792::new).lang("Casting Mold (Ingot)").onRegister(GTItems.compassNodeExist(GTCompassSections.MISC, "mold", new CompassNode[0]))).onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Steel, 14515200L))))).register();
        GTItems.SHAPE_MOLDS[5] = SHAPE_MOLD_BALL = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("ball_casting_mold", class_1792::new).lang("Casting Mold (Ball)").onRegister(GTItems.compassNodeExist(GTCompassSections.MISC, "mold", new CompassNode[0]))).onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Steel, 14515200L))))).register();
        GTItems.SHAPE_MOLDS[6] = SHAPE_MOLD_BLOCK = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("block_casting_mold", class_1792::new).lang("Casting Mold (Block)").onRegister(GTItems.compassNodeExist(GTCompassSections.MISC, "mold", new CompassNode[0]))).onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Steel, 14515200L))))).register();
        GTItems.SHAPE_MOLDS[7] = SHAPE_MOLD_NUGGET = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("nugget_casting_mold", class_1792::new).lang("Casting Mold (Nugget)").onRegister(GTItems.compassNodeExist(GTCompassSections.MISC, "mold", new CompassNode[0]))).onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Steel, 14515200L))))).register();
        GTItems.SHAPE_MOLDS[8] = SHAPE_MOLD_CYLINDER = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("cylinder_casting_mold", class_1792::new).lang("Casting Mold (Cylinder)").onRegister(GTItems.compassNodeExist(GTCompassSections.MISC, "mold", new CompassNode[0]))).onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Steel, 14515200L))))).register();
        GTItems.SHAPE_MOLDS[9] = SHAPE_MOLD_ANVIL = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("anvil_casting_mold", class_1792::new).lang("Casting Mold (Anvil)").onRegister(GTItems.compassNodeExist(GTCompassSections.MISC, "mold", new CompassNode[0]))).onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Steel, 14515200L))))).register();
        GTItems.SHAPE_MOLDS[10] = SHAPE_MOLD_NAME = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("name_casting_mold", class_1792::new).lang("Casting Mold (Name)").onRegister(GTItems.compassNodeExist(GTCompassSections.MISC, "mold", new CompassNode[0]))).onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Steel, 14515200L))))).register();
        GTItems.SHAPE_MOLDS[11] = SHAPE_MOLD_GEAR_SMALL = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("small_gear_casting_mold", class_1792::new).lang("Casting Mold (Small Gear)").onRegister(GTItems.compassNodeExist(GTCompassSections.MISC, "mold", new CompassNode[0]))).onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Steel, 14515200L))))).register();
        GTItems.SHAPE_MOLDS[12] = SHAPE_MOLD_ROTOR = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("rotor_casting_mold", class_1792::new).lang("Casting Mold (Rotor)").onRegister(GTItems.compassNodeExist(GTCompassSections.MISC, "mold", new CompassNode[0]))).onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Steel, 14515200L))))).register();
        SHAPE_EXTRUDERS = new ItemEntry[27];
        GTItems.SHAPE_EXTRUDERS[0] = SHAPE_EXTRUDER_PLATE = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("plate_extruder_mold", class_1792::new).lang("Extruder Mold (Plate)").onRegister(GTItems.compassNodeExist(GTCompassSections.MISC, "extruder_shape", new CompassNode[0]))).onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Steel, 14515200L))))).register();
        GTItems.SHAPE_EXTRUDERS[1] = SHAPE_EXTRUDER_ROD = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("rod_extruder_mold", class_1792::new).lang("Extruder Mold (Rod)").onRegister(GTItems.compassNodeExist(GTCompassSections.MISC, "extruder_shape", new CompassNode[0]))).onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Steel, 14515200L))))).register();
        GTItems.SHAPE_EXTRUDERS[2] = SHAPE_EXTRUDER_BOLT = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("bolt_extruder_mold", class_1792::new).lang("Extruder Mold (Bolt)").onRegister(GTItems.compassNodeExist(GTCompassSections.MISC, "extruder_shape", new CompassNode[0]))).onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Steel, 14515200L))))).register();
        GTItems.SHAPE_EXTRUDERS[3] = SHAPE_EXTRUDER_RING = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("ring_extruder_mold", class_1792::new).lang("Extruder Mold (Ring)").onRegister(GTItems.compassNodeExist(GTCompassSections.MISC, "extruder_shape", new CompassNode[0]))).onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Steel, 14515200L))))).register();
        GTItems.SHAPE_EXTRUDERS[4] = SHAPE_EXTRUDER_CELL = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("cell_extruder_mold", class_1792::new).lang("Extruder Mold (Cell)").onRegister(GTItems.compassNodeExist(GTCompassSections.MISC, "extruder_shape", new CompassNode[0]))).onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Steel, 14515200L))))).register();
        GTItems.SHAPE_EXTRUDERS[5] = SHAPE_EXTRUDER_INGOT = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("ingot_extruder_mold", class_1792::new).lang("Extruder Mold (Ingot)").onRegister(GTItems.compassNodeExist(GTCompassSections.MISC, "extruder_shape", new CompassNode[0]))).onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Steel, 14515200L))))).register();
        GTItems.SHAPE_EXTRUDERS[6] = SHAPE_EXTRUDER_WIRE = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("wire_extruder_mold", class_1792::new).lang("Extruder Mold (Wire)").onRegister(GTItems.compassNodeExist(GTCompassSections.MISC, "extruder_shape", new CompassNode[0]))).onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Steel, 14515200L))))).register();
        GTItems.SHAPE_EXTRUDERS[7] = SHAPE_EXTRUDER_PIPE_TINY = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("tiny_pipe_extruder_mold", class_1792::new).lang("Extruder Mold (Tiny Pipe)").onRegister(GTItems.compassNodeExist(GTCompassSections.MISC, "extruder_shape", new CompassNode[0]))).onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Steel, 14515200L))))).register();
        GTItems.SHAPE_EXTRUDERS[8] = SHAPE_EXTRUDER_PIPE_SMALL = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("small_pipe_extruder_mold", class_1792::new).lang("Extruder Mold (Small Pipe)").onRegister(GTItems.compassNodeExist(GTCompassSections.MISC, "extruder_shape", new CompassNode[0]))).onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Steel, 14515200L))))).register();
        GTItems.SHAPE_EXTRUDERS[9] = SHAPE_EXTRUDER_PIPE_NORMAL = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("normal_pipe_extruder_mold", class_1792::new).lang("Extruder Mold (Normal Pipe)").onRegister(GTItems.compassNodeExist(GTCompassSections.MISC, "extruder_shape", new CompassNode[0]))).onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Steel, 14515200L))))).register();
        GTItems.SHAPE_EXTRUDERS[10] = SHAPE_EXTRUDER_PIPE_LARGE = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("large_pipe_extruder_mold", class_1792::new).lang("Extruder Mold (Large Pipe)").onRegister(GTItems.compassNodeExist(GTCompassSections.MISC, "extruder_shape", new CompassNode[0]))).onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Steel, 14515200L))))).register();
        GTItems.SHAPE_EXTRUDERS[11] = SHAPE_EXTRUDER_PIPE_HUGE = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("huge_pipe_extruder_mold", class_1792::new).lang("Extruder Mold (Huge Pipe)").onRegister(GTItems.compassNodeExist(GTCompassSections.MISC, "extruder_shape", new CompassNode[0]))).onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Steel, 14515200L))))).register();
        GTItems.SHAPE_EXTRUDERS[12] = SHAPE_EXTRUDER_BLOCK = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("block_extruder_mold", class_1792::new).lang("Extruder Mold (Block)").onRegister(GTItems.compassNodeExist(GTCompassSections.MISC, "extruder_shape", new CompassNode[0]))).onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Steel, 14515200L))))).register();
        GTItems.SHAPE_EXTRUDERS[21] = SHAPE_EXTRUDER_GEAR = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("gear_extruder_mold", class_1792::new).lang("Extruder Mold (Gear)").onRegister(GTItems.compassNodeExist(GTCompassSections.MISC, "extruder_shape", new CompassNode[0]))).onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Steel, 14515200L))))).register();
        GTItems.SHAPE_EXTRUDERS[22] = SHAPE_EXTRUDER_BOTTLE = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("bottle_extruder_mold", class_1792::new).lang("Extruder Mold (Bottle)").onRegister(GTItems.compassNodeExist(GTCompassSections.MISC, "extruder_shape", new CompassNode[0]))).onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Steel, 14515200L))))).register();
        GTItems.SHAPE_EXTRUDERS[23] = SHAPE_EXTRUDER_FOIL = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("foil_extruder_mold", class_1792::new).lang("Extruder Mold (Foil)").onRegister(GTItems.compassNodeExist(GTCompassSections.MISC, "extruder_shape", new CompassNode[0]))).onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Steel, 14515200L))))).register();
        GTItems.SHAPE_EXTRUDERS[24] = SHAPE_EXTRUDER_GEAR_SMALL = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("small_gear_extruder_mold", class_1792::new).lang("Extruder Mold (Small Gear)").onRegister(GTItems.compassNodeExist(GTCompassSections.MISC, "extruder_shape", new CompassNode[0]))).onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Steel, 14515200L))))).register();
        GTItems.SHAPE_EXTRUDERS[25] = SHAPE_EXTRUDER_ROD_LONG = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("long_rod_extruder_mold", class_1792::new).lang("Extruder Mold (Long Rod)").onRegister(GTItems.compassNodeExist(GTCompassSections.MISC, "extruder_shape", new CompassNode[0]))).onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Steel, 14515200L))))).register();
        GTItems.SHAPE_EXTRUDERS[26] = SHAPE_EXTRUDER_ROTOR = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("rotor_extruder_mold", class_1792::new).lang("Extruder Mold (Rotor)").onRegister(GTItems.compassNodeExist(GTCompassSections.MISC, "extruder_shape", new CompassNode[0]))).onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Steel, 14515200L))))).register();
        SPRAY_EMPTY = ((ItemBuilder)GTRegistries.REGISTRATE.item("empty_spray_can", class_1792::new).onRegister(GTItems.compassNode(GTCompassSections.ITEMS, new CompassNode[0]))).lang("Spray Can (Empty)").register();
        SPRAY_SOLVENT = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("solvent_spray_can", ComponentItem::create).lang("Spray Can (Solvent)").properties(p -> p.method_7889(1)).onRegister(GTItems.compassNode(GTCompassSections.ITEMS, new CompassNode[0]))).onRegister(GTItems.attach(new ColorSprayBehaviour(() -> SPRAY_EMPTY.asStack(), 1024, -1)))).register();
        FLUID_CELL = ((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("fluid_cell", ComponentItem::create).model(GTModels::cellModel).color(() -> GTItems::cellColor).onRegister(GTItems.compassNodeExist(GTCompassSections.ITEMS, "empty_cell", new CompassNode[0]))).onRegister(GTItems.modelPredicate(GTCEu.id("fluid_cell"), itemStack -> Float.valueOf(FluidTransferHelper.getFluidContained((class_1799)itemStack) == null ? 0.0f : 1.0f)))).onRegister(GTItems.attach(ThermalFluidStats.create((int)FluidHelper.getBucket(), 1800, true, false, false, false, false), new ItemFluidContainer(), GTItems.cellName()))).register();
        FLUID_CELL_UNIVERSAL = ((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("universal_fluid_cell", ComponentItem::create).lang("Universal Cell").model(GTModels::cellModel).color(() -> GTItems::cellColor).onRegister(GTItems.compassNodeExist(GTCompassSections.ITEMS, "empty_cell", new CompassNode[0]))).onRegister(GTItems.modelPredicate(GTCEu.id("fluid_cell"), itemStack -> Float.valueOf(FluidTransferHelper.getFluidContained((class_1799)itemStack) == null ? 0.0f : 1.0f)))).onRegister(GTItems.attach(GTItems.cellName(), ThermalFluidStats.create((int)FluidHelper.getBucket(), 1800, true, false, false, false, true), new ItemFluidContainer()))).register();
        FLUID_CELL_LARGE_STEEL = ((ItemBuilder)((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("steel_fluid_cell", ComponentItem::create).lang("Steel Cell").model(GTModels::cellModel).color(() -> GTItems::cellColor).onRegister(GTItems.compassNodeExist(GTCompassSections.ITEMS, "empty_cell", new CompassNode[0]))).onRegister(GTItems.modelPredicate(GTCEu.id("fluid_cell"), itemStack -> Float.valueOf(FluidTransferHelper.getFluidContained((class_1799)itemStack) == null ? 0.0f : 1.0f)))).onRegister(GTItems.attach(GTItems.cellName(), ThermalFluidStats.create((int)FluidHelper.getBucket() * 8, GTMaterials.Steel.getProperty(PropertyKey.FLUID_PIPE).getMaxFluidTemperature(), true, false, false, false, true), new ItemFluidContainer()))).onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Steel, 14515200L))))).register();
        FLUID_CELL_LARGE_ALUMINIUM = ((ItemBuilder)((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("aluminium_fluid_cell", ComponentItem::create).lang("Aluminium Cell").model(GTModels::cellModel).color(() -> GTItems::cellColor).onRegister(GTItems.compassNodeExist(GTCompassSections.ITEMS, "empty_cell", new CompassNode[0]))).onRegister(GTItems.modelPredicate(GTCEu.id("fluid_cell"), itemStack -> Float.valueOf(FluidTransferHelper.getFluidContained((class_1799)itemStack) == null ? 0.0f : 1.0f)))).onRegister(GTItems.attach(GTItems.cellName(), ThermalFluidStats.create((int)FluidHelper.getBucket() * 32, GTMaterials.Aluminium.getProperty(PropertyKey.FLUID_PIPE).getMaxFluidTemperature(), true, false, false, false, true), new ItemFluidContainer()))).onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Aluminium, 14515200L))))).register();
        FLUID_CELL_LARGE_STAINLESS_STEEL = ((ItemBuilder)((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("stainless_steel_fluid_cell", ComponentItem::create).lang("Stainless Steel Cell").model(GTModels::cellModel).color(() -> GTItems::cellColor).onRegister(GTItems.compassNodeExist(GTCompassSections.ITEMS, "empty_cell", new CompassNode[0]))).onRegister(GTItems.modelPredicate(GTCEu.id("fluid_cell"), itemStack -> Float.valueOf(FluidTransferHelper.getFluidContained((class_1799)itemStack) == null ? 0.0f : 1.0f)))).onRegister(GTItems.attach(GTItems.cellName(), ThermalFluidStats.create((int)FluidHelper.getBucket() * 64, GTMaterials.StainlessSteel.getProperty(PropertyKey.FLUID_PIPE).getMaxFluidTemperature(), true, false, false, false, true), new ItemFluidContainer()))).onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.StainlessSteel, 21772800L))))).register();
        FLUID_CELL_LARGE_TITANIUM = ((ItemBuilder)((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("titanium_fluid_cell", ComponentItem::create).lang("Titanium Cell").model(GTModels::cellModel).color(() -> GTItems::cellColor).onRegister(GTItems.compassNodeExist(GTCompassSections.ITEMS, "empty_cell", new CompassNode[0]))).onRegister(GTItems.modelPredicate(GTCEu.id("fluid_cell"), itemStack -> Float.valueOf(FluidTransferHelper.getFluidContained((class_1799)itemStack) == null ? 0.0f : 1.0f)))).onRegister(GTItems.attach(GTItems.cellName(), ThermalFluidStats.create((int)FluidHelper.getBucket() * 128, GTMaterials.TungstenSteel.getProperty(PropertyKey.FLUID_PIPE).getMaxFluidTemperature(), true, false, false, false, true), new ItemFluidContainer()))).onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.TungstenSteel, 21772800L))))).register();
        FLUID_CELL_LARGE_TUNGSTEN_STEEL = ((ItemBuilder)((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("tungstensteel_fluid_cell", ComponentItem::create).lang("Tungstensteel Cell").model(GTModels::cellModel).color(() -> GTItems::cellColor).properties(p -> p.method_7889(32)).onRegister(GTItems.compassNodeExist(GTCompassSections.ITEMS, "empty_cell", new CompassNode[0]))).onRegister(GTItems.modelPredicate(GTCEu.id("fluid_cell"), itemStack -> Float.valueOf(FluidTransferHelper.getFluidContained((class_1799)itemStack) == null ? 0.0f : 1.0f)))).onRegister(GTItems.attach(GTItems.cellName(), ThermalFluidStats.create((int)FluidHelper.getBucket() * 512, GTMaterials.TungstenSteel.getProperty(PropertyKey.FLUID_PIPE).getMaxFluidTemperature(), true, false, false, false, true), new ItemFluidContainer()))).onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.TungstenSteel, 29030400L))))).register();
        FLUID_CELL_GLASS_VIAL = ((ItemBuilder)((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("glass_vial", ComponentItem::create).model(GTModels::cellModel).color(() -> GTItems::cellColor).onRegister(GTItems.compassNode(GTCompassSections.ITEMS, new CompassNode[0]))).onRegister(GTItems.modelPredicate(GTCEu.id("fluid_cell"), itemStack -> Float.valueOf(FluidTransferHelper.getFluidContained((class_1799)itemStack) == null ? 0.0f : 1.0f)))).onRegister(GTItems.attach(GTItems.cellName(), ThermalFluidStats.create((int)FluidHelper.getBucket(), 1200, false, true, false, false, true), new ItemFluidContainer()))).onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Glass, 907200L))))).register();
        CARBON_FIBERS = ((ItemBuilder)GTRegistries.REGISTRATE.item("carbon_fibers", class_1792::new).onRegister(GTItems.compassNodeExist(GTCompassSections.MISC, "raw_carbon_fibers", new CompassNode[0]))).lang("Raw Carbon Fibers").register();
        CARBON_MESH = ((ItemBuilder)GTRegistries.REGISTRATE.item("carbon_fiber_mesh", class_1792::new).onRegister(GTItems.compassNodeExist(GTCompassSections.MISC, "carbon_fiber_mesh", new CompassNode[0]))).lang("Carbon Fiber Mesh").register();
        CARBON_FIBER_PLATE = ((ItemBuilder)GTRegistries.REGISTRATE.item("carbon_fiber_plate", class_1792::new).onRegister(GTItems.compassNodeExist(GTCompassSections.MISC, "carbon_fiber_plate", new CompassNode[0]))).lang("Carbon Fiber Plate").register();
        DUCT_TAPE = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("duct_tape", class_1792::new).onRegister(GTItems.compassNode(GTCompassSections.MISC, new CompassNode[0]))).lang("BrainTech Aerospace Advanced Reinforced Duct Tape FAL-84").onRegister(GTItems.compassNode(GTCompassSections.ITEMS, new CompassNode[0]))).register();
        NEUTRON_REFLECTOR = ((ItemBuilder)GTRegistries.REGISTRATE.item("neutron_reflector", class_1792::new).onRegister(GTItems.compassNodeExist(GTCompassSections.ITEMS, "iridium_neutron_reflector", new CompassNode[0]))).lang("Iridium Neutron Reflector").register();
        BATTERY_HULL_LV = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("lv_battery_hull", class_1792::new).lang("Small Battery Hull").onRegister(GTItems.compassNodeExist(GTCompassSections.MISC, "battery_hull", new CompassNode[0]))).onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.BatteryAlloy, 3628800L))))).register();
        BATTERY_HULL_MV = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("mv_battery_hull", class_1792::new).lang("Medium Battery Hull").onRegister(GTItems.compassNodeExist(GTCompassSections.MISC, "battery_hull", new CompassNode[0]))).onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.BatteryAlloy, 10886400L))))).register();
        BATTERY_HULL_HV = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("hv_battery_hull", class_1792::new).lang("Large Battery Hull").onRegister(GTItems.compassNodeExist(GTCompassSections.MISC, "battery_hull", new CompassNode[0]))).onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.BatteryAlloy, 32659200L))))).register();
        BATTERY_HULL_SMALL_VANADIUM = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("ev_battery_hull", class_1792::new).lang("Small Vanadium Battery Hull").onRegister(GTItems.compassNodeExist(GTCompassSections.MISC, "battery_hull", new CompassNode[0]))).onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.BlueSteel, 7257600L))))).register();
        BATTERY_HULL_MEDIUM_VANADIUM = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("iv_battery_hull", class_1792::new).lang("Medium Vanadium Battery Hull").onRegister(GTItems.compassNodeExist(GTCompassSections.MISC, "battery_hull", new CompassNode[0]))).onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.RoseGold, 21772800L))))).register();
        BATTERY_HULL_LARGE_VANADIUM = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("luv_battery_hull", class_1792::new).lang("Large Vanadium Battery Hull").onRegister(GTItems.compassNodeExist(GTCompassSections.MISC, "battery_hull", new CompassNode[0]))).onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.RedSteel, 65318400L))))).register();
        BATTERY_HULL_MEDIUM_NAQUADRIA = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("zpm_battery_hull", class_1792::new).lang("Medium Naquadria Battery Hull").onRegister(GTItems.compassNodeExist(GTCompassSections.MISC, "battery_hull", new CompassNode[0]))).onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Europium, 21772800L))))).register();
        BATTERY_HULL_LARGE_NAQUADRIA = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("uv_battery_hull", class_1792::new).lang("Large Naquadria Battery Hull").onRegister(GTItems.compassNodeExist(GTCompassSections.MISC, "battery_hull", new CompassNode[0]))).onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Americium, 65318400L))))).register();
        BATTERY_ULV_TANTALUM = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("tantalum_capacitor", ComponentItem::create).lang("Tantalum Capacitor").onRegister(GTItems.compassNodeExist(GTCompassSections.BATTERIES, "tantalum_capacitor", new CompassNode[0]))).onRegister(GTItems.attach(ElectricStats.createRechargeableBattery(1000L, 0)))).tag(new class_6862[]{CustomTags.ULV_BATTERIES}).register();
        BATTERY_LV_SODIUM = ((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("lv_sodium_battery", ComponentItem::create).lang("Small Sodium Battery").model(GTModels.overrideModel(GTCEu.id("battery"), 8)).onRegister(GTItems.compassNodeExist(GTCompassSections.BATTERIES, "small_sodium_battery", new CompassNode[0]))).onRegister(GTItems.modelPredicate(GTCEu.id("battery"), ElectricStats::getStoredPredicate))).onRegister(GTItems.attach(ElectricStats.createRechargeableBattery(80000L, 1)))).tag(new class_6862[]{CustomTags.LV_BATTERIES}).register();
        BATTERY_MV_SODIUM = ((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("mv_sodium_battery", ComponentItem::create).lang("Medium Sodium Battery").model(GTModels.overrideModel(GTCEu.id("battery"), 8)).onRegister(GTItems.compassNodeExist(GTCompassSections.BATTERIES, "medium_sodium_battery", new CompassNode[0]))).onRegister(GTItems.modelPredicate(GTCEu.id("battery"), ElectricStats::getStoredPredicate))).onRegister(GTItems.attach(ElectricStats.createRechargeableBattery(360000L, 2)))).tag(new class_6862[]{CustomTags.MV_BATTERIES}).register();
        BATTERY_HV_SODIUM = ((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("hv_sodium_battery", ComponentItem::create).lang("Large Sodium Battery").model(GTModels.overrideModel(GTCEu.id("battery"), 8)).onRegister(GTItems.compassNodeExist(GTCompassSections.BATTERIES, "large_sodium_battery", new CompassNode[0]))).onRegister(GTItems.modelPredicate(GTCEu.id("battery"), ElectricStats::getStoredPredicate))).onRegister(GTItems.attach(ElectricStats.createRechargeableBattery(1200000L, 3)))).tag(new class_6862[]{CustomTags.HV_BATTERIES}).register();
        BATTERY_LV_LITHIUM = ((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("lv_lithium_battery", ComponentItem::create).lang("Small Lithium Battery").model(GTModels.overrideModel(GTCEu.id("battery"), 8)).onRegister(GTItems.compassNodeExist(GTCompassSections.BATTERIES, "small_lithium_battery", new CompassNode[0]))).onRegister(GTItems.modelPredicate(GTCEu.id("battery"), ElectricStats::getStoredPredicate))).onRegister(GTItems.attach(ElectricStats.createRechargeableBattery(120000L, 1)))).tag(new class_6862[]{CustomTags.LV_BATTERIES}).register();
        BATTERY_MV_LITHIUM = ((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("mv_lithium_battery", ComponentItem::create).lang("Medium Lithium Battery").model(GTModels.overrideModel(GTCEu.id("battery"), 8)).onRegister(GTItems.compassNodeExist(GTCompassSections.BATTERIES, "medium_lithium_battery", new CompassNode[0]))).onRegister(GTItems.modelPredicate(GTCEu.id("battery"), ElectricStats::getStoredPredicate))).onRegister(GTItems.attach(ElectricStats.createRechargeableBattery(420000L, 2)))).tag(new class_6862[]{CustomTags.MV_BATTERIES}).register();
        BATTERY_HV_LITHIUM = ((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("hv_lithium_battery", ComponentItem::create).lang("Large Lithium Battery").model(GTModels.overrideModel(GTCEu.id("battery"), 8)).onRegister(GTItems.compassNodeExist(GTCompassSections.BATTERIES, "large_lithium_battery", new CompassNode[0]))).onRegister(GTItems.modelPredicate(GTCEu.id("battery"), ElectricStats::getStoredPredicate))).onRegister(GTItems.attach(ElectricStats.createRechargeableBattery(1800000L, 3)))).tag(new class_6862[]{CustomTags.HV_BATTERIES}).register();
        BATTERY_LV_CADMIUM = ((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("lv_cadmium_battery", ComponentItem::create).lang("Small Cadmium Battery").model(GTModels.overrideModel(GTCEu.id("battery"), 8)).onRegister(GTItems.compassNodeExist(GTCompassSections.BATTERIES, "small_cadmium_battery", new CompassNode[0]))).onRegister(GTItems.modelPredicate(GTCEu.id("battery"), ElectricStats::getStoredPredicate))).onRegister(GTItems.attach(ElectricStats.createRechargeableBattery(100000L, 1)))).tag(new class_6862[]{CustomTags.LV_BATTERIES}).register();
        BATTERY_MV_CADMIUM = ((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("mv_cadmium_battery", ComponentItem::create).lang("Medium Cadmium Battery").model(GTModels.overrideModel(GTCEu.id("battery"), 8)).onRegister(GTItems.compassNodeExist(GTCompassSections.BATTERIES, "medium_cadmium_battery", new CompassNode[0]))).onRegister(GTItems.modelPredicate(GTCEu.id("battery"), ElectricStats::getStoredPredicate))).onRegister(GTItems.attach(ElectricStats.createRechargeableBattery(400000L, 2)))).tag(new class_6862[]{CustomTags.MV_BATTERIES}).register();
        BATTERY_HV_CADMIUM = ((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("hv_cadmium_battery", ComponentItem::create).lang("Large Cadmium Battery").model(GTModels.overrideModel(GTCEu.id("battery"), 8)).onRegister(GTItems.compassNodeExist(GTCompassSections.BATTERIES, "large_cadmium_battery", new CompassNode[0]))).onRegister(GTItems.modelPredicate(GTCEu.id("battery"), ElectricStats::getStoredPredicate))).onRegister(GTItems.attach(ElectricStats.createRechargeableBattery(1600000L, 3)))).tag(new class_6862[]{CustomTags.HV_BATTERIES}).register();
        ENERGIUM_CRYSTAL = ((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("energy_crystal", ComponentItem::create).lang("Energium Crystal").model(GTModels.overrideModel(GTCEu.id("battery"), 8)).onRegister(GTItems.compassNodeExist(GTCompassSections.BATTERIES, "energy_crystal", new CompassNode[0]))).onRegister(GTItems.modelPredicate(GTCEu.id("battery"), ElectricStats::getStoredPredicate))).onRegister(GTItems.attach(ElectricStats.createRechargeableBattery(6400000L, 3)))).tag(new class_6862[]{CustomTags.HV_BATTERIES}).register();
        LAPOTRON_CRYSTAL = ((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("lapotron_crystal", ComponentItem::create).model(GTModels.overrideModel(GTCEu.id("battery"), 8)).onRegister(GTItems.compassNodeExist(GTCompassSections.BATTERIES, "lapotron_crystal", new CompassNode[0]))).onRegister(GTItems.modelPredicate(GTCEu.id("battery"), ElectricStats::getStoredPredicate))).onRegister(GTItems.attach(ElectricStats.createRechargeableBattery(25000000L, 4)))).tag(new class_6862[]{CustomTags.EV_BATTERIES}).register();
        BATTERY_EV_VANADIUM = ((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("ev_vanadium_battery", ComponentItem::create).lang("Small Vanadium Battery").model(GTModels.overrideModel(GTCEu.id("battery"), 8)).onRegister(GTItems.compassNodeExist(GTCompassSections.BATTERIES, "small_vanadium_battery", new CompassNode[0]))).onRegister(GTItems.modelPredicate(GTCEu.id("battery"), ElectricStats::getStoredPredicate))).onRegister(GTItems.attach(ElectricStats.createRechargeableBattery(10240000L, 4)))).tag(new class_6862[]{CustomTags.EV_BATTERIES}).register();
        BATTERY_IV_VANADIUM = ((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("iv_vanadium_battery", ComponentItem::create).lang("Medium Vanadium Battery").model(GTModels.overrideModel(GTCEu.id("battery"), 8)).onRegister(GTItems.compassNodeExist(GTCompassSections.BATTERIES, "medium_vanadium_battery", new CompassNode[0]))).onRegister(GTItems.modelPredicate(GTCEu.id("battery"), ElectricStats::getStoredPredicate))).onRegister(GTItems.attach(ElectricStats.createRechargeableBattery(40960000L, 5)))).tag(new class_6862[]{CustomTags.IV_BATTERIES}).register();
        BATTERY_LUV_VANADIUM = ((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("luv_vanadium_battery", ComponentItem::create).lang("Large Vanadium Battery").model(GTModels.overrideModel(GTCEu.id("battery"), 8)).onRegister(GTItems.compassNodeExist(GTCompassSections.BATTERIES, "large_vanadium_battery", new CompassNode[0]))).onRegister(GTItems.modelPredicate(GTCEu.id("battery"), ElectricStats::getStoredPredicate))).onRegister(GTItems.attach(ElectricStats.createRechargeableBattery(163840000L, 6)))).tag(new class_6862[]{CustomTags.LuV_BATTERIES}).register();
        BATTERY_ZPM_NAQUADRIA = ((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("zpm_naquadria_battery", ComponentItem::create).lang("Medium Naquadria Battery").model(GTModels.overrideModel(GTCEu.id("battery"), 8)).onRegister(GTItems.compassNodeExist(GTCompassSections.BATTERIES, "medium_naquadria_battery", new CompassNode[0]))).onRegister(GTItems.modelPredicate(GTCEu.id("battery"), ElectricStats::getStoredPredicate))).onRegister(GTItems.attach(ElectricStats.createRechargeableBattery(655360000L, 7)))).tag(new class_6862[]{CustomTags.ZPM_BATTERIES}).register();
        BATTERY_UV_NAQUADRIA = ((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("uv_naquadria_battery", ComponentItem::create).lang("Large Naquadria Battery").model(GTModels.overrideModel(GTCEu.id("battery"), 8)).onRegister(GTItems.compassNodeExist(GTCompassSections.BATTERIES, "large_naquadria_battery", new CompassNode[0]))).onRegister(GTItems.modelPredicate(GTCEu.id("battery"), ElectricStats::getStoredPredicate))).onRegister(GTItems.attach(ElectricStats.createRechargeableBattery(2621440000L, 8)))).tag(new class_6862[]{CustomTags.UV_BATTERIES}).register();
        ENERGY_LAPOTRONIC_ORB = ((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("lapotronic_energy_orb", ComponentItem::create).lang("Lapotronic Energy Orb").model(GTModels.overrideModel(GTCEu.id("battery"), 8)).onRegister(GTItems.compassNodeExist(GTCompassSections.BATTERIES, "lapotronic_energy_orb", new CompassNode[0]))).onRegister(GTItems.modelPredicate(GTCEu.id("battery"), ElectricStats::getStoredPredicate))).onRegister(GTItems.attach(ElectricStats.createRechargeableBattery(250000000L, 5)))).tag(new class_6862[]{CustomTags.IV_BATTERIES}).register();
        ENERGY_LAPOTRONIC_ORB_CLUSTER = ((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("lapotronic_energy_orb_cluster", ComponentItem::create).lang("Lapotronic Energy Orb Cluster").model(GTModels.overrideModel(GTCEu.id("battery"), 8)).onRegister(GTItems.compassNodeExist(GTCompassSections.BATTERIES, "lapotronic_energy_orb_cluster", new CompassNode[0]))).onRegister(GTItems.modelPredicate(GTCEu.id("battery"), ElectricStats::getStoredPredicate))).onRegister(GTItems.attach(ElectricStats.createRechargeableBattery(1000000000L, 6)))).tag(new class_6862[]{CustomTags.LuV_BATTERIES}).register();
        ENERGY_MODULE = ((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("energy_module", ComponentItem::create).lang("Energy Module").model(GTModels.overrideModel(GTCEu.id("battery"), 8)).onRegister(GTItems.compassNodeExist(GTCompassSections.BATTERIES, "energy_module", new CompassNode[0]))).onRegister(GTItems.modelPredicate(GTCEu.id("battery"), ElectricStats::getStoredPredicate))).onRegister(GTItems.attach(ElectricStats.createRechargeableBattery(4000000000L, 7)))).tag(new class_6862[]{CustomTags.ZPM_BATTERIES}).register();
        ENERGY_CLUSTER = ((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("energy_cluster", ComponentItem::create).lang("Energy Cluster").model(GTModels.overrideModel(GTCEu.id("battery"), 8)).onRegister(GTItems.compassNodeExist(GTCompassSections.BATTERIES, "energy_cluster", new CompassNode[0]))).onRegister(GTItems.modelPredicate(GTCEu.id("battery"), ElectricStats::getStoredPredicate))).onRegister(GTItems.attach(ElectricStats.createRechargeableBattery(20000000000L, 8)))).tag(new class_6862[]{CustomTags.UV_BATTERIES}).register();
        ZERO_POINT_MODULE = ((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("zero_point_module", ComponentItem::create).lang("Zero Point Module").model(GTModels.overrideModel(GTCEu.id("battery"), 8)).onRegister(GTItems.compassNodeExist(GTCompassSections.BATTERIES, "zero_point_module", new CompassNode[0]))).onRegister(GTItems.modelPredicate(GTCEu.id("battery"), ElectricStats::getStoredPredicate))).onRegister(GTItems.attach(ElectricStats.createBattery(2000000000000L, 7, true)))).register();
        ULTIMATE_BATTERY = ((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("max_battery", ComponentItem::create).lang("Ultimate Battery").model(GTModels.overrideModel(GTCEu.id("battery"), 8)).onRegister(GTItems.compassNodeExist(GTCompassSections.BATTERIES, "ultimate_battery", new CompassNode[0]))).onRegister(GTItems.modelPredicate(GTCEu.id("battery"), ElectricStats::getStoredPredicate))).onRegister(GTItems.attach(ElectricStats.createRechargeableBattery(Long.MAX_VALUE, 9)))).tag(new class_6862[]{CustomTags.UHV_BATTERIES}).register();
        ELECTRIC_MOTOR_LV = ((ItemBuilder)GTRegistries.REGISTRATE.item("lv_electric_motor", class_1792::new).lang("LV Electric Motor").onRegister(GTItems.compassNodeExist(GTCompassSections.COMPONENTS, "electric_motor", new CompassNode[0]))).register();
        ELECTRIC_MOTOR_MV = ((ItemBuilder)GTRegistries.REGISTRATE.item("mv_electric_motor", class_1792::new).lang("MV Electric Motor").onRegister(GTItems.compassNodeExist(GTCompassSections.MISC, "electric_motor", new CompassNode[0]))).register();
        ELECTRIC_MOTOR_HV = ((ItemBuilder)GTRegistries.REGISTRATE.item("hv_electric_motor", class_1792::new).lang("HV Electric Motor").onRegister(GTItems.compassNodeExist(GTCompassSections.COMPONENTS, "electric_motor", new CompassNode[0]))).register();
        ELECTRIC_MOTOR_EV = ((ItemBuilder)GTRegistries.REGISTRATE.item("ev_electric_motor", class_1792::new).lang("EV Electric Motor").onRegister(GTItems.compassNodeExist(GTCompassSections.COMPONENTS, "electric_motor", new CompassNode[0]))).register();
        ELECTRIC_MOTOR_IV = ((ItemBuilder)GTRegistries.REGISTRATE.item("iv_electric_motor", class_1792::new).lang("IV Electric Motor").onRegister(GTItems.compassNodeExist(GTCompassSections.COMPONENTS, "electric_motor", new CompassNode[0]))).register();
        ELECTRIC_MOTOR_LuV = ((ItemBuilder)GTRegistries.REGISTRATE.item("luv_electric_motor", class_1792::new).lang("LuV Electric Motor").onRegister(GTItems.compassNodeExist(GTCompassSections.COMPONENTS, "electric_motor", new CompassNode[0]))).register();
        ELECTRIC_MOTOR_ZPM = ((ItemBuilder)GTRegistries.REGISTRATE.item("zpm_electric_motor", class_1792::new).lang("ZPM Electric Motor").onRegister(GTItems.compassNodeExist(GTCompassSections.COMPONENTS, "electric_motor", new CompassNode[0]))).register();
        ELECTRIC_MOTOR_UV = ((ItemBuilder)GTRegistries.REGISTRATE.item("uv_electric_motor", class_1792::new).lang("UV Electric Motor").onRegister(GTItems.compassNodeExist(GTCompassSections.COMPONENTS, "electric_motor", new CompassNode[0]))).register();
        ELECTRIC_MOTOR_UHV = GTCEu.isHighTier() ? ((ItemBuilder)GTRegistries.REGISTRATE.item("uhv_electric_motor", class_1792::new).lang("UHV Electric Motor").onRegister(GTItems.compassNodeExist(GTCompassSections.COMPONENTS, "electric_motor", new CompassNode[0]))).register() : null;
        ELECTRIC_MOTOR_UEV = GTCEu.isHighTier() ? ((ItemBuilder)GTRegistries.REGISTRATE.item("uev_electric_motor", class_1792::new).lang("UEV Electric Motor").onRegister(GTItems.compassNodeExist(GTCompassSections.COMPONENTS, "electric_motor", new CompassNode[0]))).register() : null;
        ELECTRIC_MOTOR_UIV = GTCEu.isHighTier() ? ((ItemBuilder)GTRegistries.REGISTRATE.item("uiv_electric_motor", class_1792::new).lang("UIV Electric Motor").onRegister(GTItems.compassNodeExist(GTCompassSections.COMPONENTS, "electric_motor", new CompassNode[0]))).register() : null;
        ELECTRIC_MOTOR_UXV = GTCEu.isHighTier() ? ((ItemBuilder)GTRegistries.REGISTRATE.item("uxv_electric_motor", class_1792::new).lang("UXV Electric Motor").onRegister(GTItems.compassNodeExist(GTCompassSections.COMPONENTS, "electric_motor", new CompassNode[0]))).register() : null;
        ELECTRIC_MOTOR_OpV = GTCEu.isHighTier() ? ((ItemBuilder)GTRegistries.REGISTRATE.item("opv_electric_motor", class_1792::new).lang("OpV Electric Motor").onRegister(GTItems.compassNodeExist(GTCompassSections.COMPONENTS, "electric_motor", new CompassNode[0]))).register() : null;
        ELECTRIC_PUMP_LV = ((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("lv_electric_pump", ComponentItem::create).lang("LV Electric Pump").onRegister(GTItems.attach(new CoverPlaceBehavior(GTCovers.PUMPS[0])))).onRegister(GTItems.attach(new TooltipBehavior(lines -> {
            lines.add(class_2561.method_43471((String)"item.gtceu.electric.pump.tooltip"));
            lines.add(class_2561.method_43469((String)"gtceu.universal.tooltip.fluid_transfer_rate", (Object[])new Object[]{64}));
        })))).onRegister(GTItems.compassNodeExist(GTCompassSections.COVERS, "pump", GTCompassNodes.COVER))).register();
        ELECTRIC_PUMP_MV = ((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("mv_electric_pump", ComponentItem::create).lang("MV Electric Pump").onRegister(GTItems.attach(new CoverPlaceBehavior(GTCovers.PUMPS[1])))).onRegister(GTItems.attach(new TooltipBehavior(lines -> {
            lines.add(class_2561.method_43471((String)"item.gtceu.electric.pump.tooltip"));
            lines.add(class_2561.method_43469((String)"gtceu.universal.tooltip.fluid_transfer_rate", (Object[])new Object[]{256}));
        })))).onRegister(GTItems.compassNodeExist(GTCompassSections.COVERS, "pump", GTCompassNodes.COVER))).register();
        ELECTRIC_PUMP_HV = ((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("hv_electric_pump", ComponentItem::create).lang("HV Electric Pump").onRegister(GTItems.attach(new CoverPlaceBehavior(GTCovers.PUMPS[2])))).onRegister(GTItems.attach(new TooltipBehavior(lines -> {
            lines.add(class_2561.method_43471((String)"item.gtceu.electric.pump.tooltip"));
            lines.add(class_2561.method_43469((String)"gtceu.universal.tooltip.fluid_transfer_rate", (Object[])new Object[]{1024}));
        })))).onRegister(GTItems.compassNodeExist(GTCompassSections.COVERS, "pump", GTCompassNodes.COVER))).register();
        ELECTRIC_PUMP_EV = ((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("ev_electric_pump", ComponentItem::create).lang("EV Electric Pump").onRegister(GTItems.attach(new CoverPlaceBehavior(GTCovers.PUMPS[3])))).onRegister(GTItems.attach(new TooltipBehavior(lines -> {
            lines.add(class_2561.method_43471((String)"item.gtceu.electric.pump.tooltip"));
            lines.add(class_2561.method_43469((String)"gtceu.universal.tooltip.fluid_transfer_rate", (Object[])new Object[]{4096}));
        })))).onRegister(GTItems.compassNodeExist(GTCompassSections.COVERS, "pump", GTCompassNodes.COVER))).register();
        ELECTRIC_PUMP_IV = ((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("iv_electric_pump", ComponentItem::create).lang("IV Electric Pump").onRegister(GTItems.attach(new CoverPlaceBehavior(GTCovers.PUMPS[4])))).onRegister(GTItems.attach(new TooltipBehavior(lines -> {
            lines.add(class_2561.method_43471((String)"item.gtceu.electric.pump.tooltip"));
            lines.add(class_2561.method_43469((String)"gtceu.universal.tooltip.fluid_transfer_rate", (Object[])new Object[]{16384}));
        })))).onRegister(GTItems.compassNodeExist(GTCompassSections.COVERS, "pump", GTCompassNodes.COVER))).register();
        ELECTRIC_PUMP_LuV = ((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("luv_electric_pump", ComponentItem::create).lang("LuV Electric Pump").onRegister(GTItems.attach(new CoverPlaceBehavior(GTCovers.PUMPS[5])))).onRegister(GTItems.attach(new TooltipBehavior(lines -> {
            lines.add(class_2561.method_43471((String)"item.gtceu.electric.pump.tooltip"));
            lines.add(class_2561.method_43469((String)"gtceu.universal.tooltip.fluid_transfer_rate", (Object[])new Object[]{65536}));
        })))).onRegister(GTItems.compassNodeExist(GTCompassSections.COVERS, "pump", GTCompassNodes.COVER))).register();
        ELECTRIC_PUMP_ZPM = ((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("zpm_electric_pump", ComponentItem::create).lang("ZPM Electric Pump").onRegister(GTItems.attach(new CoverPlaceBehavior(GTCovers.PUMPS[6])))).onRegister(GTItems.attach(new TooltipBehavior(lines -> {
            lines.add(class_2561.method_43471((String)"item.gtceu.electric.pump.tooltip"));
            lines.add(class_2561.method_43469((String)"gtceu.universal.tooltip.fluid_transfer_rate", (Object[])new Object[]{262144}));
        })))).onRegister(GTItems.compassNodeExist(GTCompassSections.COVERS, "pump", GTCompassNodes.COVER))).register();
        ELECTRIC_PUMP_UV = ((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("uv_electric_pump", ComponentItem::create).lang("UV Electric Pump").onRegister(GTItems.attach(new CoverPlaceBehavior(GTCovers.PUMPS[7])))).onRegister(GTItems.attach(new TooltipBehavior(lines -> {
            lines.add(class_2561.method_43471((String)"item.gtceu.electric.pump.tooltip"));
            lines.add(class_2561.method_43469((String)"gtceu.universal.tooltip.fluid_transfer_rate", (Object[])new Object[]{0x100000}));
        })))).onRegister(GTItems.compassNodeExist(GTCompassSections.COVERS, "pump", GTCompassNodes.COVER))).register();
        ELECTRIC_PUMP_UHV = GTCEu.isHighTier() ? ((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("uhv_electric_pump", ComponentItem::create).lang("UHV Electric Pump").onRegister(GTItems.attach(new CoverPlaceBehavior(GTCovers.PUMPS[8])))).onRegister(GTItems.attach(new TooltipBehavior(lines -> {
            lines.add(class_2561.method_43471((String)"item.gtceu.electric.pump.tooltip"));
            lines.add(class_2561.method_43469((String)"gtceu.universal.tooltip.fluid_transfer_rate", (Object[])new Object[]{0x100000}));
        })))).onRegister(GTItems.compassNodeExist(GTCompassSections.COVERS, "pump", GTCompassNodes.COVER))).register() : null;
        ELECTRIC_PUMP_UEV = GTCEu.isHighTier() ? ((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("uev_electric_pump", ComponentItem::create).lang("UEV Electric Pump").onRegister(GTItems.attach(new CoverPlaceBehavior(GTCovers.PUMPS[9])))).onRegister(GTItems.attach(new TooltipBehavior(lines -> {
            lines.add(class_2561.method_43471((String)"item.gtceu.electric.pump.tooltip"));
            lines.add(class_2561.method_43469((String)"gtceu.universal.tooltip.fluid_transfer_rate", (Object[])new Object[]{0x100000}));
        })))).onRegister(GTItems.compassNodeExist(GTCompassSections.COVERS, "pump", GTCompassNodes.COVER))).register() : null;
        ELECTRIC_PUMP_UIV = GTCEu.isHighTier() ? ((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("uiv_electric_pump", ComponentItem::create).lang("UIV Electric Pump").onRegister(GTItems.attach(new CoverPlaceBehavior(GTCovers.PUMPS[10])))).onRegister(GTItems.attach(new TooltipBehavior(lines -> {
            lines.add(class_2561.method_43471((String)"item.gtceu.electric.pump.tooltip"));
            lines.add(class_2561.method_43469((String)"gtceu.universal.tooltip.fluid_transfer_rate", (Object[])new Object[]{0x100000}));
        })))).onRegister(GTItems.compassNodeExist(GTCompassSections.COVERS, "pump", GTCompassNodes.COVER))).register() : null;
        ELECTRIC_PUMP_UXV = GTCEu.isHighTier() ? ((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("uxv_electric_pump", ComponentItem::create).lang("UHV Electric Pump").onRegister(GTItems.attach(new CoverPlaceBehavior(GTCovers.PUMPS[11])))).onRegister(GTItems.attach(new TooltipBehavior(lines -> {
            lines.add(class_2561.method_43471((String)"item.gtceu.electric.pump.tooltip"));
            lines.add(class_2561.method_43469((String)"gtceu.universal.tooltip.fluid_transfer_rate", (Object[])new Object[]{0x100000}));
        })))).onRegister(GTItems.compassNodeExist(GTCompassSections.COVERS, "pump", GTCompassNodes.COVER))).register() : null;
        ELECTRIC_PUMP_OpV = GTCEu.isHighTier() ? ((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("opv_electric_pump", ComponentItem::create).lang("OpV Electric Pump").onRegister(GTItems.attach(new CoverPlaceBehavior(GTCovers.PUMPS[12])))).onRegister(GTItems.attach(new TooltipBehavior(lines -> {
            lines.add(class_2561.method_43471((String)"item.gtceu.electric.pump.tooltip"));
            lines.add(class_2561.method_43469((String)"gtceu.universal.tooltip.fluid_transfer_rate", (Object[])new Object[]{0x100000}));
        })))).onRegister(GTItems.compassNodeExist(GTCompassSections.COVERS, "pump", GTCompassNodes.COVER))).register() : null;
        FLUID_REGULATOR_LV = ((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("lv_fluid_regulator", ComponentItem::create).lang("LV Fluid Regulator").onRegister(GTItems.attach(new CoverPlaceBehavior(GTCovers.FLUID_REGULATORS[0])))).onRegister(GTItems.attach(new TooltipBehavior(lines -> {
            lines.add(class_2561.method_43471((String)"item.gtceu.fluid.regulator.tooltip"));
            lines.add(class_2561.method_43469((String)"gtceu.universal.tooltip.fluid_transfer_rate", (Object[])new Object[]{64}));
        })))).onRegister(GTItems.compassNodeExist(GTCompassSections.COMPONENTS, "fluid_regulator", new CompassNode[0]))).register();
        FLUID_REGULATOR_MV = ((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("mv_fluid_regulator", ComponentItem::create).lang("MV Fluid Regulator").onRegister(GTItems.attach(new CoverPlaceBehavior(GTCovers.FLUID_REGULATORS[1])))).onRegister(GTItems.attach(new TooltipBehavior(lines -> {
            lines.add(class_2561.method_43471((String)"item.gtceu.fluid.regulator.tooltip"));
            lines.add(class_2561.method_43469((String)"gtceu.universal.tooltip.fluid_transfer_rate", (Object[])new Object[]{256}));
        })))).onRegister(GTItems.compassNodeExist(GTCompassSections.COMPONENTS, "fluid_regulator", new CompassNode[0]))).register();
        FLUID_REGULATOR_HV = ((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("hv_fluid_regulator", ComponentItem::create).lang("HV Fluid Regulator").onRegister(GTItems.attach(new CoverPlaceBehavior(GTCovers.FLUID_REGULATORS[2])))).onRegister(GTItems.attach(new TooltipBehavior(lines -> {
            lines.add(class_2561.method_43471((String)"item.gtceu.fluid.regulator.tooltip"));
            lines.add(class_2561.method_43469((String)"gtceu.universal.tooltip.fluid_transfer_rate", (Object[])new Object[]{1024}));
        })))).onRegister(GTItems.compassNodeExist(GTCompassSections.COMPONENTS, "fluid_regulator", new CompassNode[0]))).register();
        FLUID_REGULATOR_EV = ((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("ev_fluid_regulator", ComponentItem::create).lang("EV Fluid Regulator").onRegister(GTItems.attach(new CoverPlaceBehavior(GTCovers.FLUID_REGULATORS[3])))).onRegister(GTItems.attach(new TooltipBehavior(lines -> {
            lines.add(class_2561.method_43471((String)"item.gtceu.fluid.regulator.tooltip"));
            lines.add(class_2561.method_43469((String)"gtceu.universal.tooltip.fluid_transfer_rate", (Object[])new Object[]{4096}));
        })))).onRegister(GTItems.compassNodeExist(GTCompassSections.COMPONENTS, "fluid_regulator", new CompassNode[0]))).register();
        FLUID_REGULATOR_IV = ((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("iv_fluid_regulator", ComponentItem::create).lang("IV Fluid Regulator").onRegister(GTItems.attach(new CoverPlaceBehavior(GTCovers.FLUID_REGULATORS[4])))).onRegister(GTItems.attach(new TooltipBehavior(lines -> {
            lines.add(class_2561.method_43471((String)"item.gtceu.fluid.regulator.tooltip"));
            lines.add(class_2561.method_43469((String)"gtceu.universal.tooltip.fluid_transfer_rate", (Object[])new Object[]{16384}));
        })))).onRegister(GTItems.compassNodeExist(GTCompassSections.COMPONENTS, "fluid_regulator", new CompassNode[0]))).register();
        FLUID_REGULATOR_LUV = ((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("luv_fluid_regulator", ComponentItem::create).lang("LuV Fluid Regulator").onRegister(GTItems.attach(new CoverPlaceBehavior(GTCovers.FLUID_REGULATORS[5])))).onRegister(GTItems.attach(new TooltipBehavior(lines -> {
            lines.add(class_2561.method_43471((String)"item.gtceu.fluid.regulator.tooltip"));
            lines.add(class_2561.method_43469((String)"gtceu.universal.tooltip.fluid_transfer_rate", (Object[])new Object[]{65536}));
        })))).onRegister(GTItems.compassNodeExist(GTCompassSections.COMPONENTS, "fluid_regulator", new CompassNode[0]))).register();
        FLUID_REGULATOR_ZPM = ((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("zpm_fluid_regulator", ComponentItem::create).lang("ZPM Fluid Regulator").onRegister(GTItems.attach(new CoverPlaceBehavior(GTCovers.FLUID_REGULATORS[6])))).onRegister(GTItems.attach(new TooltipBehavior(lines -> {
            lines.add(class_2561.method_43471((String)"item.gtceu.fluid.regulator.tooltip"));
            lines.add(class_2561.method_43469((String)"gtceu.universal.tooltip.fluid_transfer_rate", (Object[])new Object[]{262144}));
        })))).onRegister(GTItems.compassNodeExist(GTCompassSections.COMPONENTS, "fluid_regulator", new CompassNode[0]))).register();
        FLUID_REGULATOR_UV = ((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("uv_fluid_regulator", ComponentItem::create).lang("UV Fluid Regulator").onRegister(GTItems.attach(new CoverPlaceBehavior(GTCovers.FLUID_REGULATORS[7])))).onRegister(GTItems.attach(new TooltipBehavior(lines -> {
            lines.add(class_2561.method_43471((String)"item.gtceu.fluid.regulator.tooltip"));
            lines.add(class_2561.method_43469((String)"gtceu.universal.tooltip.fluid_transfer_rate", (Object[])new Object[]{0x100000}));
        })))).onRegister(GTItems.compassNodeExist(GTCompassSections.COMPONENTS, "fluid_regulator", new CompassNode[0]))).register();
        FLUID_REGULATOR_UHV = GTCEu.isHighTier() ? ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("uhv_fluid_regulator", ComponentItem::create).lang("UHV Fluid Regulator").onRegister(GTItems.attach(new CoverPlaceBehavior(GTCovers.FLUID_REGULATORS[8])))).onRegister(GTItems.attach(new TooltipBehavior(lines -> {
            lines.add(class_2561.method_43471((String)"item.gtceu.fluid.regulator.tooltip"));
            lines.add(class_2561.method_43469((String)"gtceu.universal.tooltip.fluid_transfer_rate", (Object[])new Object[]{0x100000}));
        })))).register() : null;
        FLUID_REGULATOR_UEV = GTCEu.isHighTier() ? ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("uev_fluid_regulator", ComponentItem::create).lang("UEV Fluid Regulator").onRegister(GTItems.attach(new CoverPlaceBehavior(GTCovers.FLUID_REGULATORS[9])))).onRegister(GTItems.attach(new TooltipBehavior(lines -> {
            lines.add(class_2561.method_43471((String)"item.gtceu.fluid.regulator.tooltip"));
            lines.add(class_2561.method_43469((String)"gtceu.universal.tooltip.fluid_transfer_rate", (Object[])new Object[]{0x100000}));
        })))).register() : null;
        FLUID_REGULATOR_UIV = GTCEu.isHighTier() ? ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("uiv_fluid_regulator", ComponentItem::create).lang("UIV Fluid Regulator").onRegister(GTItems.attach(new CoverPlaceBehavior(GTCovers.FLUID_REGULATORS[10])))).onRegister(GTItems.attach(new TooltipBehavior(lines -> {
            lines.add(class_2561.method_43471((String)"item.gtceu.fluid.regulator.tooltip"));
            lines.add(class_2561.method_43469((String)"gtceu.universal.tooltip.fluid_transfer_rate", (Object[])new Object[]{0x100000}));
        })))).register() : null;
        FLUID_REGULATOR_UXV = GTCEu.isHighTier() ? ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("uxv_fluid_regulator", ComponentItem::create).lang("UXV Fluid Regulator").onRegister(GTItems.attach(new CoverPlaceBehavior(GTCovers.FLUID_REGULATORS[11])))).onRegister(GTItems.attach(new TooltipBehavior(lines -> {
            lines.add(class_2561.method_43471((String)"item.gtceu.fluid.regulator.tooltip"));
            lines.add(class_2561.method_43469((String)"gtceu.universal.tooltip.fluid_transfer_rate", (Object[])new Object[]{0x100000}));
        })))).register() : null;
        FLUID_REGULATOR_OpV = GTCEu.isHighTier() ? ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("opv_fluid_regulator", ComponentItem::create).lang("OpV Fluid Regulator").onRegister(GTItems.attach(new CoverPlaceBehavior(GTCovers.FLUID_REGULATORS[12])))).onRegister(GTItems.attach(new TooltipBehavior(lines -> {
            lines.add(class_2561.method_43471((String)"item.gtceu.fluid.regulator.tooltip"));
            lines.add(class_2561.method_43469((String)"gtceu.universal.tooltip.fluid_transfer_rate", (Object[])new Object[]{0x100000}));
        })))).register() : null;
        CONVEYOR_MODULE_LV = ((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("lv_conveyor_module", ComponentItem::create).lang("LV Conveyor Module").onRegister(GTItems.attach(new CoverPlaceBehavior(GTCovers.CONVEYORS[0])))).onRegister(GTItems.attach(new TooltipBehavior(lines -> {
            lines.add(class_2561.method_43471((String)"item.gtceu.conveyor.module.tooltip"));
            lines.add(class_2561.method_43469((String)"gtceu.universal.tooltip.item_transfer_rate", (Object[])new Object[]{8}));
        })))).onRegister(GTItems.compassNodeExist(GTCompassSections.COVERS, "conveyor", GTCompassNodes.COVER))).register();
        CONVEYOR_MODULE_MV = ((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("mv_conveyor_module", ComponentItem::create).lang("MV Conveyor Module").onRegister(GTItems.attach(new CoverPlaceBehavior(GTCovers.CONVEYORS[1])))).onRegister(GTItems.attach(new TooltipBehavior(lines -> {
            lines.add(class_2561.method_43471((String)"item.gtceu.conveyor.module.tooltip"));
            lines.add(class_2561.method_43469((String)"gtceu.universal.tooltip.item_transfer_rate", (Object[])new Object[]{32}));
        })))).onRegister(GTItems.compassNodeExist(GTCompassSections.COVERS, "conveyor", GTCompassNodes.COVER))).register();
        CONVEYOR_MODULE_HV = ((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("hv_conveyor_module", ComponentItem::create).lang("HV Conveyor Module").onRegister(GTItems.attach(new CoverPlaceBehavior(GTCovers.CONVEYORS[2])))).onRegister(GTItems.attach(new TooltipBehavior(lines -> {
            lines.add(class_2561.method_43471((String)"item.gtceu.conveyor.module.tooltip"));
            lines.add(class_2561.method_43469((String)"gtceu.universal.tooltip.item_transfer_rate", (Object[])new Object[]{64}));
        })))).onRegister(GTItems.compassNodeExist(GTCompassSections.COVERS, "conveyor", GTCompassNodes.COVER))).register();
        CONVEYOR_MODULE_EV = ((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("ev_conveyor_module", ComponentItem::create).lang("EV Conveyor Module").onRegister(GTItems.attach(new CoverPlaceBehavior(GTCovers.CONVEYORS[3])))).onRegister(GTItems.attach(new TooltipBehavior(lines -> {
            lines.add(class_2561.method_43471((String)"item.gtceu.conveyor.module.tooltip"));
            lines.add(class_2561.method_43469((String)"gtceu.universal.tooltip.item_transfer_rate_stacks", (Object[])new Object[]{3}));
        })))).onRegister(GTItems.compassNodeExist(GTCompassSections.COVERS, "conveyor", GTCompassNodes.COVER))).register();
        CONVEYOR_MODULE_IV = ((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("iv_conveyor_module", ComponentItem::create).lang("IV Conveyor Module").onRegister(GTItems.attach(new CoverPlaceBehavior(GTCovers.CONVEYORS[4])))).onRegister(GTItems.attach(new TooltipBehavior(lines -> {
            lines.add(class_2561.method_43471((String)"item.gtceu.conveyor.module.tooltip"));
            lines.add(class_2561.method_43469((String)"gtceu.universal.tooltip.item_transfer_rate_stacks", (Object[])new Object[]{8}));
        })))).onRegister(GTItems.compassNodeExist(GTCompassSections.COVERS, "conveyor", GTCompassNodes.COVER))).register();
        CONVEYOR_MODULE_LuV = ((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("luv_conveyor_module", ComponentItem::create).lang("LuV Conveyor Module").onRegister(GTItems.attach(new CoverPlaceBehavior(GTCovers.CONVEYORS[5])))).onRegister(GTItems.attach(new TooltipBehavior(lines -> {
            lines.add(class_2561.method_43471((String)"item.gtceu.conveyor.module.tooltip"));
            lines.add(class_2561.method_43469((String)"gtceu.universal.tooltip.item_transfer_rate_stacks", (Object[])new Object[]{16}));
        })))).onRegister(GTItems.compassNodeExist(GTCompassSections.COVERS, "conveyor", GTCompassNodes.COVER))).register();
        CONVEYOR_MODULE_ZPM = ((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("zpm_conveyor_module", ComponentItem::create).lang("ZPM Conveyor Module").onRegister(GTItems.attach(new CoverPlaceBehavior(GTCovers.CONVEYORS[6])))).onRegister(GTItems.attach(new TooltipBehavior(lines -> {
            lines.add(class_2561.method_43471((String)"item.gtceu.conveyor.module.tooltip"));
            lines.add(class_2561.method_43469((String)"gtceu.universal.tooltip.item_transfer_rate_stacks", (Object[])new Object[]{16}));
        })))).onRegister(GTItems.compassNodeExist(GTCompassSections.COVERS, "conveyor", GTCompassNodes.COVER))).register();
        CONVEYOR_MODULE_UV = ((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("uv_conveyor_module", ComponentItem::create).lang("UV Conveyor Module").onRegister(GTItems.attach(new CoverPlaceBehavior(GTCovers.CONVEYORS[7])))).onRegister(GTItems.attach(new TooltipBehavior(lines -> {
            lines.add(class_2561.method_43471((String)"item.gtceu.conveyor.module.tooltip"));
            lines.add(class_2561.method_43469((String)"gtceu.universal.tooltip.item_transfer_rate_stacks", (Object[])new Object[]{16}));
        })))).onRegister(GTItems.compassNodeExist(GTCompassSections.COVERS, "conveyor", GTCompassNodes.COVER))).register();
        CONVEYOR_MODULE_UHV = GTCEu.isHighTier() ? ((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("uhv_conveyor_module", ComponentItem::create).lang("UHV Conveyor Module").onRegister(GTItems.attach(new CoverPlaceBehavior(GTCovers.CONVEYORS[8])))).onRegister(GTItems.attach(new TooltipBehavior(lines -> {
            lines.add(class_2561.method_43471((String)"item.gtceu.conveyor.module.tooltip"));
            lines.add(class_2561.method_43469((String)"gtceu.universal.tooltip.item_transfer_rate_stacks", (Object[])new Object[]{16}));
        })))).onRegister(GTItems.compassNodeExist(GTCompassSections.COVERS, "conveyor", GTCompassNodes.COVER))).register() : null;
        CONVEYOR_MODULE_UEV = GTCEu.isHighTier() ? ((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("uev_conveyor_module", ComponentItem::create).lang("UEV Conveyor Module").onRegister(GTItems.attach(new CoverPlaceBehavior(GTCovers.CONVEYORS[9])))).onRegister(GTItems.attach(new TooltipBehavior(lines -> {
            lines.add(class_2561.method_43471((String)"item.gtceu.conveyor.module.tooltip"));
            lines.add(class_2561.method_43469((String)"gtceu.universal.tooltip.item_transfer_rate_stacks", (Object[])new Object[]{16}));
        })))).onRegister(GTItems.compassNodeExist(GTCompassSections.COVERS, "conveyor", GTCompassNodes.COVER))).register() : null;
        CONVEYOR_MODULE_UIV = GTCEu.isHighTier() ? ((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("uiv_conveyor_module", ComponentItem::create).lang("UIV Conveyor Module").onRegister(GTItems.attach(new CoverPlaceBehavior(GTCovers.CONVEYORS[10])))).onRegister(GTItems.attach(new TooltipBehavior(lines -> {
            lines.add(class_2561.method_43471((String)"item.gtceu.conveyor.module.tooltip"));
            lines.add(class_2561.method_43469((String)"gtceu.universal.tooltip.item_transfer_rate_stacks", (Object[])new Object[]{16}));
        })))).onRegister(GTItems.compassNodeExist(GTCompassSections.COVERS, "conveyor", GTCompassNodes.COVER))).register() : null;
        CONVEYOR_MODULE_UXV = GTCEu.isHighTier() ? ((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("uxv_conveyor_module", ComponentItem::create).lang("UXV Conveyor Module").onRegister(GTItems.attach(new CoverPlaceBehavior(GTCovers.CONVEYORS[11])))).onRegister(GTItems.attach(new TooltipBehavior(lines -> {
            lines.add(class_2561.method_43471((String)"item.gtceu.conveyor.module.tooltip"));
            lines.add(class_2561.method_43469((String)"gtceu.universal.tooltip.item_transfer_rate_stacks", (Object[])new Object[]{16}));
        })))).onRegister(GTItems.compassNodeExist(GTCompassSections.COVERS, "conveyor", GTCompassNodes.COVER))).register() : null;
        CONVEYOR_MODULE_OpV = GTCEu.isHighTier() ? ((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("opv_conveyor_module", ComponentItem::create).lang("OpV Conveyor Module").onRegister(GTItems.attach(new CoverPlaceBehavior(GTCovers.CONVEYORS[12])))).onRegister(GTItems.attach(new TooltipBehavior(lines -> {
            lines.add(class_2561.method_43471((String)"item.gtceu.conveyor.module.tooltip"));
            lines.add(class_2561.method_43469((String)"gtceu.universal.tooltip.item_transfer_rate_stacks", (Object[])new Object[]{16}));
        })))).onRegister(GTItems.compassNodeExist(GTCompassSections.COVERS, "conveyor", GTCompassNodes.COVER))).register() : null;
        ELECTRIC_PISTON_LV = ((ItemBuilder)GTRegistries.REGISTRATE.item("lv_electric_piston", class_1792::new).lang("LV Electric Piston").onRegister(GTItems.compassNodeExist(GTCompassSections.COMPONENTS, "piston", new CompassNode[0]))).register();
        ELECTRIC_PISTON_MV = ((ItemBuilder)GTRegistries.REGISTRATE.item("mv_electric_piston", class_1792::new).lang("MV Electric Piston").onRegister(GTItems.compassNodeExist(GTCompassSections.COMPONENTS, "piston", new CompassNode[0]))).register();
        ELECTRIC_PISTON_HV = ((ItemBuilder)GTRegistries.REGISTRATE.item("hv_electric_piston", class_1792::new).lang("HV Electric Piston").onRegister(GTItems.compassNodeExist(GTCompassSections.COMPONENTS, "piston", new CompassNode[0]))).register();
        ELECTRIC_PISTON_EV = ((ItemBuilder)GTRegistries.REGISTRATE.item("ev_electric_piston", class_1792::new).lang("EV Electric Piston").onRegister(GTItems.compassNodeExist(GTCompassSections.COMPONENTS, "piston", new CompassNode[0]))).register();
        ELECTRIC_PISTON_IV = ((ItemBuilder)GTRegistries.REGISTRATE.item("iv_electric_piston", class_1792::new).lang("IV Electric Piston").onRegister(GTItems.compassNodeExist(GTCompassSections.COMPONENTS, "piston", new CompassNode[0]))).register();
        ELECTRIC_PISTON_LUV = ((ItemBuilder)GTRegistries.REGISTRATE.item("luv_electric_piston", class_1792::new).lang("LuV Electric Piston").onRegister(GTItems.compassNodeExist(GTCompassSections.COMPONENTS, "piston", new CompassNode[0]))).register();
        ELECTRIC_PISTON_ZPM = ((ItemBuilder)GTRegistries.REGISTRATE.item("zpm_electric_piston", class_1792::new).lang("ZPM Electric Piston").onRegister(GTItems.compassNodeExist(GTCompassSections.COMPONENTS, "piston", new CompassNode[0]))).register();
        ELECTRIC_PISTON_UV = ((ItemBuilder)GTRegistries.REGISTRATE.item("uv_electric_piston", class_1792::new).lang("UV Electric Piston").onRegister(GTItems.compassNodeExist(GTCompassSections.COMPONENTS, "piston", new CompassNode[0]))).register();
        ELECTRIC_PISTON_UHV = GTCEu.isHighTier() ? ((ItemBuilder)GTRegistries.REGISTRATE.item("uhv_electric_piston", class_1792::new).lang("UHV Electric Piston").onRegister(GTItems.compassNodeExist(GTCompassSections.COMPONENTS, "piston", new CompassNode[0]))).register() : null;
        ELECTRIC_PISTON_UEV = GTCEu.isHighTier() ? ((ItemBuilder)GTRegistries.REGISTRATE.item("uev_electric_piston", class_1792::new).lang("UEV Electric Piston").onRegister(GTItems.compassNodeExist(GTCompassSections.COMPONENTS, "piston", new CompassNode[0]))).register() : null;
        ELECTRIC_PISTON_UIV = GTCEu.isHighTier() ? ((ItemBuilder)GTRegistries.REGISTRATE.item("uiv_electric_piston", class_1792::new).lang("UIV Electric Piston").onRegister(GTItems.compassNodeExist(GTCompassSections.COMPONENTS, "piston", new CompassNode[0]))).register() : null;
        ELECTRIC_PISTON_UXV = GTCEu.isHighTier() ? ((ItemBuilder)GTRegistries.REGISTRATE.item("uxv_electric_piston", class_1792::new).lang("UXV Electric Piston").onRegister(GTItems.compassNodeExist(GTCompassSections.COMPONENTS, "piston", new CompassNode[0]))).register() : null;
        ELECTRIC_PISTON_OpV = GTCEu.isHighTier() ? ((ItemBuilder)GTRegistries.REGISTRATE.item("opv_electric_piston", class_1792::new).lang("OpV Electric Piston").onRegister(GTItems.compassNodeExist(GTCompassSections.COMPONENTS, "piston", new CompassNode[0]))).register() : null;
        ROBOT_ARM_LV = ((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("lv_robot_arm", ComponentItem::create).lang("LV Robot Arm").onRegister(GTItems.attach(new CoverPlaceBehavior(GTCovers.ROBOT_ARMS[0])))).onRegister(GTItems.attach(new TooltipBehavior(lines -> {
            lines.add(class_2561.method_43471((String)"item.gtceu.robot.arm.tooltip"));
            lines.add(class_2561.method_43469((String)"gtceu.universal.tooltip.item_transfer_rate", (Object[])new Object[]{8}));
        })))).onRegister(GTItems.compassNodeExist(GTCompassSections.COVERS, "robot_arm", GTCompassNodes.COVER))).register();
        ROBOT_ARM_MV = ((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("mv_robot_arm", ComponentItem::create).lang("MV Robot Arm").onRegister(GTItems.attach(new CoverPlaceBehavior(GTCovers.ROBOT_ARMS[1])))).onRegister(GTItems.attach(new TooltipBehavior(lines -> {
            lines.add(class_2561.method_43471((String)"item.gtceu.robot.arm.tooltip"));
            lines.add(class_2561.method_43469((String)"gtceu.universal.tooltip.item_transfer_rate", (Object[])new Object[]{32}));
        })))).onRegister(GTItems.compassNodeExist(GTCompassSections.COVERS, "robot_arm", GTCompassNodes.COVER))).register();
        ROBOT_ARM_HV = ((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("hv_robot_arm", ComponentItem::create).lang("HV Robot Arm").onRegister(GTItems.attach(new CoverPlaceBehavior(GTCovers.ROBOT_ARMS[2])))).onRegister(GTItems.attach(new TooltipBehavior(lines -> {
            lines.add(class_2561.method_43471((String)"item.gtceu.robot.arm.tooltip"));
            lines.add(class_2561.method_43469((String)"gtceu.universal.tooltip.item_transfer_rate", (Object[])new Object[]{64}));
        })))).onRegister(GTItems.compassNodeExist(GTCompassSections.COVERS, "robot_arm", GTCompassNodes.COVER))).register();
        ROBOT_ARM_EV = ((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("ev_robot_arm", ComponentItem::create).lang("EV Robot Arm").onRegister(GTItems.attach(new CoverPlaceBehavior(GTCovers.ROBOT_ARMS[3])))).onRegister(GTItems.attach(new TooltipBehavior(lines -> {
            lines.add(class_2561.method_43471((String)"item.gtceu.robot.arm.tooltip"));
            lines.add(class_2561.method_43469((String)"gtceu.universal.tooltip.item_transfer_rate_stacks", (Object[])new Object[]{3}));
        })))).onRegister(GTItems.compassNodeExist(GTCompassSections.COVERS, "robot_arm", GTCompassNodes.COVER))).register();
        ROBOT_ARM_IV = ((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("iv_robot_arm", ComponentItem::create).lang("IV Robot Arm").onRegister(GTItems.attach(new CoverPlaceBehavior(GTCovers.ROBOT_ARMS[4])))).onRegister(GTItems.attach(new TooltipBehavior(lines -> {
            lines.add(class_2561.method_43471((String)"item.gtceu.robot.arm.tooltip"));
            lines.add(class_2561.method_43469((String)"gtceu.universal.tooltip.item_transfer_rate_stacks", (Object[])new Object[]{8}));
        })))).onRegister(GTItems.compassNodeExist(GTCompassSections.COVERS, "robot_arm", GTCompassNodes.COVER))).register();
        ROBOT_ARM_LuV = ((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("luv_robot_arm", ComponentItem::create).lang("LuV Robot Arm").onRegister(GTItems.attach(new CoverPlaceBehavior(GTCovers.ROBOT_ARMS[5])))).onRegister(GTItems.attach(new TooltipBehavior(lines -> {
            lines.add(class_2561.method_43471((String)"item.gtceu.robot.arm.tooltip"));
            lines.add(class_2561.method_43469((String)"gtceu.universal.tooltip.item_transfer_rate_stacks", (Object[])new Object[]{16}));
        })))).onRegister(GTItems.compassNodeExist(GTCompassSections.COVERS, "robot_arm", GTCompassNodes.COVER))).register();
        ROBOT_ARM_ZPM = ((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("zpm_robot_arm", ComponentItem::create).lang("ZPM Robot Arm").onRegister(GTItems.attach(new CoverPlaceBehavior(GTCovers.ROBOT_ARMS[6])))).onRegister(GTItems.attach(new TooltipBehavior(lines -> {
            lines.add(class_2561.method_43471((String)"item.gtceu.robot.arm.tooltip"));
            lines.add(class_2561.method_43469((String)"gtceu.universal.tooltip.item_transfer_rate_stacks", (Object[])new Object[]{16}));
        })))).onRegister(GTItems.compassNodeExist(GTCompassSections.COVERS, "robot_arm", GTCompassNodes.COVER))).register();
        ROBOT_ARM_UV = ((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("uv_robot_arm", ComponentItem::create).lang("UV Robot Arm").onRegister(GTItems.attach(new CoverPlaceBehavior(GTCovers.ROBOT_ARMS[7])))).onRegister(GTItems.attach(new TooltipBehavior(lines -> {
            lines.add(class_2561.method_43471((String)"item.gtceu.robot.arm.tooltip"));
            lines.add(class_2561.method_43469((String)"gtceu.universal.tooltip.item_transfer_rate_stacks", (Object[])new Object[]{16}));
        })))).onRegister(GTItems.compassNodeExist(GTCompassSections.COVERS, "robot_arm", GTCompassNodes.COVER))).register();
        ROBOT_ARM_UHV = GTCEu.isHighTier() ? ((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("uhv_robot_arm", ComponentItem::create).lang("UHV Robot Arm").onRegister(GTItems.attach(new CoverPlaceBehavior(GTCovers.ROBOT_ARMS[8])))).onRegister(GTItems.attach(new TooltipBehavior(lines -> {
            lines.add(class_2561.method_43471((String)"item.gtceu.robot.arm.tooltip"));
            lines.add(class_2561.method_43469((String)"gtceu.universal.tooltip.item_transfer_rate_stacks", (Object[])new Object[]{16}));
        })))).onRegister(GTItems.compassNodeExist(GTCompassSections.COVERS, "robot_arm", GTCompassNodes.COVER))).register() : null;
        ROBOT_ARM_UEV = GTCEu.isHighTier() ? ((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("uev_robot_arm", ComponentItem::create).lang("UEV Robot Arm").onRegister(GTItems.attach(new CoverPlaceBehavior(GTCovers.ROBOT_ARMS[9])))).onRegister(GTItems.attach(new TooltipBehavior(lines -> {
            lines.add(class_2561.method_43471((String)"item.gtceu.robot.arm.tooltip"));
            lines.add(class_2561.method_43469((String)"gtceu.universal.tooltip.item_transfer_rate_stacks", (Object[])new Object[]{16}));
        })))).onRegister(GTItems.compassNodeExist(GTCompassSections.COVERS, "robot_arm", GTCompassNodes.COVER))).register() : null;
        ROBOT_ARM_UIV = GTCEu.isHighTier() ? ((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("uiv_robot_arm", ComponentItem::create).lang("UIV Robot Arm").onRegister(GTItems.attach(new CoverPlaceBehavior(GTCovers.ROBOT_ARMS[10])))).onRegister(GTItems.attach(new TooltipBehavior(lines -> {
            lines.add(class_2561.method_43471((String)"item.gtceu.robot.arm.tooltip"));
            lines.add(class_2561.method_43469((String)"gtceu.universal.tooltip.item_transfer_rate_stacks", (Object[])new Object[]{16}));
        })))).onRegister(GTItems.compassNodeExist(GTCompassSections.COVERS, "robot_arm", GTCompassNodes.COVER))).register() : null;
        ROBOT_ARM_UXV = GTCEu.isHighTier() ? ((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("uxv_robot_arm", ComponentItem::create).lang("UXV Robot Arm").onRegister(GTItems.attach(new CoverPlaceBehavior(GTCovers.ROBOT_ARMS[11])))).onRegister(GTItems.attach(new TooltipBehavior(lines -> {
            lines.add(class_2561.method_43471((String)"item.gtceu.robot.arm.tooltip"));
            lines.add(class_2561.method_43469((String)"gtceu.universal.tooltip.item_transfer_rate_stacks", (Object[])new Object[]{16}));
        })))).onRegister(GTItems.compassNodeExist(GTCompassSections.COVERS, "robot_arm", GTCompassNodes.COVER))).register() : null;
        ROBOT_ARM_OpV = GTCEu.isHighTier() ? ((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("opv_robot_arm", ComponentItem::create).lang("OpV Robot Arm").onRegister(GTItems.attach(new CoverPlaceBehavior(GTCovers.ROBOT_ARMS[12])))).onRegister(GTItems.attach(new TooltipBehavior(lines -> {
            lines.add(class_2561.method_43471((String)"item.gtceu.robot.arm.tooltip"));
            lines.add(class_2561.method_43469((String)"gtceu.universal.tooltip.item_transfer_rate_stacks", (Object[])new Object[]{16}));
        })))).onRegister(GTItems.compassNodeExist(GTCompassSections.COVERS, "robot_arm", GTCompassNodes.COVER))).register() : null;
        FIELD_GENERATOR_LV = ((ItemBuilder)GTRegistries.REGISTRATE.item("lv_field_generator", class_1792::new).lang("LV Field Generator").onRegister(GTItems.compassNodeExist(GTCompassSections.COMPONENTS, "field_generator", new CompassNode[0]))).register();
        FIELD_GENERATOR_MV = ((ItemBuilder)GTRegistries.REGISTRATE.item("mv_field_generator", class_1792::new).lang("MV Field Generator").onRegister(GTItems.compassNodeExist(GTCompassSections.COMPONENTS, "field_generator", new CompassNode[0]))).register();
        FIELD_GENERATOR_HV = ((ItemBuilder)GTRegistries.REGISTRATE.item("hv_field_generator", class_1792::new).lang("HV Field Generator").onRegister(GTItems.compassNodeExist(GTCompassSections.COMPONENTS, "field_generator", new CompassNode[0]))).register();
        FIELD_GENERATOR_EV = ((ItemBuilder)GTRegistries.REGISTRATE.item("ev_field_generator", class_1792::new).lang("EV Field Generator").onRegister(GTItems.compassNodeExist(GTCompassSections.COMPONENTS, "field_generator", new CompassNode[0]))).register();
        FIELD_GENERATOR_IV = ((ItemBuilder)GTRegistries.REGISTRATE.item("iv_field_generator", class_1792::new).lang("IV Field Generator").onRegister(GTItems.compassNodeExist(GTCompassSections.COMPONENTS, "field_generator", new CompassNode[0]))).register();
        FIELD_GENERATOR_LuV = ((ItemBuilder)GTRegistries.REGISTRATE.item("luv_field_generator", class_1792::new).lang("LuV Field Generator").onRegister(GTItems.compassNodeExist(GTCompassSections.COMPONENTS, "field_generator", new CompassNode[0]))).register();
        FIELD_GENERATOR_ZPM = ((ItemBuilder)GTRegistries.REGISTRATE.item("zpm_field_generator", class_1792::new).lang("ZPM Field Generator").onRegister(GTItems.compassNodeExist(GTCompassSections.COMPONENTS, "field_generator", new CompassNode[0]))).register();
        FIELD_GENERATOR_UV = ((ItemBuilder)GTRegistries.REGISTRATE.item("uv_field_generator", class_1792::new).lang("UV Field Generator").onRegister(GTItems.compassNodeExist(GTCompassSections.COMPONENTS, "field_generator", new CompassNode[0]))).register();
        FIELD_GENERATOR_UHV = GTCEu.isHighTier() ? ((ItemBuilder)GTRegistries.REGISTRATE.item("uhv_field_generator", class_1792::new).lang("UHV Field Generator").onRegister(GTItems.compassNodeExist(GTCompassSections.COMPONENTS, "field_generator", new CompassNode[0]))).register() : null;
        FIELD_GENERATOR_UEV = GTCEu.isHighTier() ? ((ItemBuilder)GTRegistries.REGISTRATE.item("uev_field_generator", class_1792::new).lang("UEV Field Generator").onRegister(GTItems.compassNodeExist(GTCompassSections.COMPONENTS, "field_generator", new CompassNode[0]))).register() : null;
        FIELD_GENERATOR_UIV = GTCEu.isHighTier() ? ((ItemBuilder)GTRegistries.REGISTRATE.item("uiv_field_generator", class_1792::new).lang("UIV Field Generator").onRegister(GTItems.compassNodeExist(GTCompassSections.COMPONENTS, "field_generator", new CompassNode[0]))).register() : null;
        FIELD_GENERATOR_UXV = GTCEu.isHighTier() ? ((ItemBuilder)GTRegistries.REGISTRATE.item("uxv_field_generator", class_1792::new).lang("UXV Field Generator").onRegister(GTItems.compassNodeExist(GTCompassSections.COMPONENTS, "field_generator", new CompassNode[0]))).register() : null;
        FIELD_GENERATOR_OpV = GTCEu.isHighTier() ? ((ItemBuilder)GTRegistries.REGISTRATE.item("opv_field_generator", class_1792::new).lang("OpV Field Generator").onRegister(GTItems.compassNodeExist(GTCompassSections.COMPONENTS, "field_generator", new CompassNode[0]))).register() : null;
        EMITTER_LV = ((ItemBuilder)GTRegistries.REGISTRATE.item("lv_emitter", class_1792::new).lang("LV Emitter").onRegister(GTItems.compassNodeExist(GTCompassSections.COMPONENTS, "emitter", new CompassNode[0]))).register();
        EMITTER_MV = ((ItemBuilder)GTRegistries.REGISTRATE.item("mv_emitter", class_1792::new).lang("MV Emitter").onRegister(GTItems.compassNodeExist(GTCompassSections.COMPONENTS, "emitter", new CompassNode[0]))).register();
        EMITTER_HV = ((ItemBuilder)GTRegistries.REGISTRATE.item("hv_emitter", class_1792::new).lang("HV Emitter").onRegister(GTItems.compassNodeExist(GTCompassSections.COMPONENTS, "emitter", new CompassNode[0]))).register();
        EMITTER_EV = ((ItemBuilder)GTRegistries.REGISTRATE.item("ev_emitter", class_1792::new).lang("EV Emitter").onRegister(GTItems.compassNodeExist(GTCompassSections.COMPONENTS, "emitter", new CompassNode[0]))).register();
        EMITTER_IV = ((ItemBuilder)GTRegistries.REGISTRATE.item("iv_emitter", class_1792::new).lang("IV Emitter").onRegister(GTItems.compassNodeExist(GTCompassSections.COMPONENTS, "emitter", new CompassNode[0]))).register();
        EMITTER_LuV = ((ItemBuilder)GTRegistries.REGISTRATE.item("luv_emitter", class_1792::new).lang("LuV Emitter").onRegister(GTItems.compassNodeExist(GTCompassSections.COMPONENTS, "emitter", new CompassNode[0]))).register();
        EMITTER_ZPM = ((ItemBuilder)GTRegistries.REGISTRATE.item("zpm_emitter", class_1792::new).lang("ZPM Emitter").onRegister(GTItems.compassNodeExist(GTCompassSections.COMPONENTS, "emitter", new CompassNode[0]))).register();
        EMITTER_UV = ((ItemBuilder)GTRegistries.REGISTRATE.item("uv_emitter", class_1792::new).lang("UV Emitter").onRegister(GTItems.compassNodeExist(GTCompassSections.COMPONENTS, "emitter", new CompassNode[0]))).register();
        SENSOR_LV = ((ItemBuilder)GTRegistries.REGISTRATE.item("lv_sensor", class_1792::new).lang("LV Sensor").onRegister(GTItems.compassNodeExist(GTCompassSections.COMPONENTS, "sensor", new CompassNode[0]))).register();
        SENSOR_MV = ((ItemBuilder)GTRegistries.REGISTRATE.item("mv_sensor", class_1792::new).lang("MV Sensor").onRegister(GTItems.compassNodeExist(GTCompassSections.COMPONENTS, "sensor", new CompassNode[0]))).register();
        SENSOR_HV = ((ItemBuilder)GTRegistries.REGISTRATE.item("hv_sensor", class_1792::new).lang("HV Sensor").onRegister(GTItems.compassNodeExist(GTCompassSections.COMPONENTS, "sensor", new CompassNode[0]))).register();
        SENSOR_EV = ((ItemBuilder)GTRegistries.REGISTRATE.item("ev_sensor", class_1792::new).lang("EV Sensor").onRegister(GTItems.compassNodeExist(GTCompassSections.COMPONENTS, "sensor", new CompassNode[0]))).register();
        SENSOR_IV = ((ItemBuilder)GTRegistries.REGISTRATE.item("iv_sensor", class_1792::new).lang("IV Sensor").onRegister(GTItems.compassNodeExist(GTCompassSections.COMPONENTS, "sensor", new CompassNode[0]))).register();
        SENSOR_LuV = ((ItemBuilder)GTRegistries.REGISTRATE.item("luv_sensor", class_1792::new).lang("LuV Sensor").onRegister(GTItems.compassNodeExist(GTCompassSections.COMPONENTS, "sensor", new CompassNode[0]))).register();
        SENSOR_ZPM = ((ItemBuilder)GTRegistries.REGISTRATE.item("zpm_sensor", class_1792::new).lang("ZPM Sensor").onRegister(GTItems.compassNodeExist(GTCompassSections.COMPONENTS, "sensor", new CompassNode[0]))).register();
        SENSOR_UV = ((ItemBuilder)GTRegistries.REGISTRATE.item("uv_sensor", class_1792::new).lang("UV Sensor").onRegister(GTItems.compassNodeExist(GTCompassSections.COMPONENTS, "sensor", new CompassNode[0]))).register();
        SENSOR_UHV = GTCEu.isHighTier() ? ((ItemBuilder)GTRegistries.REGISTRATE.item("uhv_sensor", class_1792::new).lang("UHV Sensor").onRegister(GTItems.compassNodeExist(GTCompassSections.COMPONENTS, "sensor", new CompassNode[0]))).register() : null;
        SENSOR_UEV = GTCEu.isHighTier() ? ((ItemBuilder)GTRegistries.REGISTRATE.item("uev_sensor", class_1792::new).lang("UEV Sensor").onRegister(GTItems.compassNodeExist(GTCompassSections.COMPONENTS, "sensor", new CompassNode[0]))).register() : null;
        SENSOR_UIV = GTCEu.isHighTier() ? ((ItemBuilder)GTRegistries.REGISTRATE.item("uiv_sensor", class_1792::new).lang("UIV Sensor").onRegister(GTItems.compassNodeExist(GTCompassSections.COMPONENTS, "sensor", new CompassNode[0]))).register() : null;
        SENSOR_UXV = GTCEu.isHighTier() ? ((ItemBuilder)GTRegistries.REGISTRATE.item("uxv_sensor", class_1792::new).lang("UXV Sensor").onRegister(GTItems.compassNodeExist(GTCompassSections.COMPONENTS, "sensor", new CompassNode[0]))).register() : null;
        SENSOR_OpV = GTCEu.isHighTier() ? ((ItemBuilder)GTRegistries.REGISTRATE.item("opv_sensor", class_1792::new).lang("OpV Sensor").onRegister(GTItems.compassNodeExist(GTCompassSections.COMPONENTS, "sensor", new CompassNode[0]))).register() : null;
        TOOL_DATA_STICK = ((ItemBuilder)GTRegistries.REGISTRATE.item("data_stick", class_1792::new).lang("Data Stick").onRegister(GTItems.compassNode(GTCompassSections.COMPONENTS, new CompassNode[0]))).register();
        TOOL_DATA_ORB = ((ItemBuilder)GTRegistries.REGISTRATE.item("data_orb", class_1792::new).lang("Data Orb").onRegister(GTItems.compassNode(GTCompassSections.COMPONENTS, new CompassNode[0]))).register();
        GLASS_LENSES = new HashMap<MarkerMaterial, ItemEntry<class_1792>>();
        for (i = 0; i < MarkerMaterials.Color.VALUES.length; ++i) {
            MarkerMaterial color = MarkerMaterials.Color.VALUES[i];
            if (color == MarkerMaterials.Color.White) continue;
            GLASS_LENSES.put(color, (ItemEntry<class_1792>)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item(String.format("%s_glass_lens", color.toString()), class_1792::new).lang("Glass Lens (%s)".formatted(FormattingUtil.toEnglishName(color.getName()))).transform(GTItems.unificationItem(TagPrefix.lens, color))).onRegister(GTItems.compassNodeExist(GTCompassSections.MISC, "glass_lens", new CompassNode[0]))).register());
        }
        SILICON_BOULE = ((ItemBuilder)GTRegistries.REGISTRATE.item("silicon_boule", class_1792::new).lang("Monocrystalline Silicon Boule").onRegister(GTItems.compassNodeExist(GTCompassSections.CIRCUITS, "silicon_boule", new CompassNode[0]))).register();
        PHOSPHORUS_BOULE = ((ItemBuilder)GTRegistries.REGISTRATE.item("phosphorus_boule", class_1792::new).lang("Phosphorus-doped Monocrystalline Silicon Boule").onRegister(GTItems.compassNodeExist(GTCompassSections.CIRCUITS, "silicon_boule", new CompassNode[0]))).register();
        NAQUADAH_BOULE = ((ItemBuilder)GTRegistries.REGISTRATE.item("naquadah_boule", class_1792::new).lang("Naquadah-doped Monocrystalline Silicon Boule").onRegister(GTItems.compassNodeExist(GTCompassSections.CIRCUITS, "silicon_boule", new CompassNode[0]))).register();
        NEUTRONIUM_BOULE = ((ItemBuilder)GTRegistries.REGISTRATE.item("neutronium_boule", class_1792::new).lang("Neutronium-doped Monocrystalline Silicon Boule").onRegister(GTItems.compassNodeExist(GTCompassSections.CIRCUITS, "silicon_boule", new CompassNode[0]))).register();
        SILICON_WAFER = ((ItemBuilder)GTRegistries.REGISTRATE.item("silicon_wafer", class_1792::new).lang("Silicon Wafer").onRegister(GTItems.compassNodeExist(GTCompassSections.CIRCUITS, "wafer", new CompassNode[0]))).register();
        PHOSPHORUS_WAFER = ((ItemBuilder)GTRegistries.REGISTRATE.item("phosphorus_wafer", class_1792::new).lang("Phosphorus-doped Wafer").onRegister(GTItems.compassNodeExist(GTCompassSections.CIRCUITS, "wafer", new CompassNode[0]))).register();
        NAQUADAH_WAFER = ((ItemBuilder)GTRegistries.REGISTRATE.item("naquadah_wafer", class_1792::new).lang("Naquadah-doped Wafer").onRegister(GTItems.compassNodeExist(GTCompassSections.CIRCUITS, "wafer", new CompassNode[0]))).register();
        NEUTRONIUM_WAFER = ((ItemBuilder)GTRegistries.REGISTRATE.item("neutronium_wafer", class_1792::new).lang("Neutronium-doped Wafer").onRegister(GTItems.compassNodeExist(GTCompassSections.CIRCUITS, "wafer", new CompassNode[0]))).register();
        CENTRAL_PROCESSING_UNIT_WAFER = ((ItemBuilder)GTRegistries.REGISTRATE.item("cpu_wafer", class_1792::new).lang("CPU Wafer").onRegister(GTItems.compassNodeExist(GTCompassSections.CIRCUITS, "wafer", new CompassNode[0]))).register();
        RANDOM_ACCESS_MEMORY_WAFER = ((ItemBuilder)GTRegistries.REGISTRATE.item("ram_wafer", class_1792::new).lang("RAM Wafer").onRegister(GTItems.compassNodeExist(GTCompassSections.CIRCUITS, "wafer", new CompassNode[0]))).register();
        INTEGRATED_LOGIC_CIRCUIT_WAFER = ((ItemBuilder)GTRegistries.REGISTRATE.item("ilc_wafer", class_1792::new).lang("ILC Wafer").onRegister(GTItems.compassNodeExist(GTCompassSections.CIRCUITS, "wafer", new CompassNode[0]))).register();
        NANO_CENTRAL_PROCESSING_UNIT_WAFER = ((ItemBuilder)GTRegistries.REGISTRATE.item("nano_cpu_wafer", class_1792::new).lang("Nano CPU Wafer").onRegister(GTItems.compassNodeExist(GTCompassSections.CIRCUITS, "wafer", new CompassNode[0]))).register();
        QUBIT_CENTRAL_PROCESSING_UNIT_WAFER = ((ItemBuilder)GTRegistries.REGISTRATE.item("qbit_cpu_wafer", class_1792::new).lang("Qubit CPU Wafer").onRegister(GTItems.compassNodeExist(GTCompassSections.CIRCUITS, "wafer", new CompassNode[0]))).register();
        SIMPLE_SYSTEM_ON_CHIP_WAFER = ((ItemBuilder)GTRegistries.REGISTRATE.item("simple_soc_wafer", class_1792::new).lang("Simple SoC Wafer").onRegister(GTItems.compassNodeExist(GTCompassSections.CIRCUITS, "wafer", new CompassNode[0]))).register();
        SYSTEM_ON_CHIP_WAFER = ((ItemBuilder)GTRegistries.REGISTRATE.item("soc_wafer", class_1792::new).lang("SoC Wafer").onRegister(GTItems.compassNodeExist(GTCompassSections.CIRCUITS, "wafer", new CompassNode[0]))).register();
        ADVANCED_SYSTEM_ON_CHIP_WAFER = ((ItemBuilder)GTRegistries.REGISTRATE.item("advanced_soc_wafer", class_1792::new).lang("ASoC Wafer").onRegister(GTItems.compassNodeExist(GTCompassSections.CIRCUITS, "wafer", new CompassNode[0]))).register();
        HIGHLY_ADVANCED_SOC_WAFER = ((ItemBuilder)GTRegistries.REGISTRATE.item("highly_advanced_soc_wafer", class_1792::new).lang("HASoC Wafer").onRegister(GTItems.compassNodeExist(GTCompassSections.CIRCUITS, "wafer", new CompassNode[0]))).register();
        NAND_MEMORY_CHIP_WAFER = ((ItemBuilder)GTRegistries.REGISTRATE.item("nand_memory_wafer", class_1792::new).lang("NAND Memory Wafer").onRegister(GTItems.compassNodeExist(GTCompassSections.CIRCUITS, "wafer", new CompassNode[0]))).register();
        NOR_MEMORY_CHIP_WAFER = ((ItemBuilder)GTRegistries.REGISTRATE.item("nor_memory_wafer", class_1792::new).lang("NOR Memory Wafer").onRegister(GTItems.compassNodeExist(GTCompassSections.CIRCUITS, "wafer", new CompassNode[0]))).register();
        ULTRA_LOW_POWER_INTEGRATED_CIRCUIT_WAFER = ((ItemBuilder)GTRegistries.REGISTRATE.item("ulpic_wafer", class_1792::new).lang("ULPIC Wafer").onRegister(GTItems.compassNodeExist(GTCompassSections.CIRCUITS, "wafer", new CompassNode[0]))).register();
        LOW_POWER_INTEGRATED_CIRCUIT_WAFER = ((ItemBuilder)GTRegistries.REGISTRATE.item("lpic_wafer", class_1792::new).lang("LPIC Wafer").onRegister(GTItems.compassNodeExist(GTCompassSections.CIRCUITS, "wafer", new CompassNode[0]))).register();
        POWER_INTEGRATED_CIRCUIT_WAFER = ((ItemBuilder)GTRegistries.REGISTRATE.item("mpic_wafer", class_1792::new).lang("MPIC Wafer").onRegister(GTItems.compassNodeExist(GTCompassSections.CIRCUITS, "wafer", new CompassNode[0]))).register();
        HIGH_POWER_INTEGRATED_CIRCUIT_WAFER = ((ItemBuilder)GTRegistries.REGISTRATE.item("hpic_wafer", class_1792::new).lang("HPIC Wafer").onRegister(GTItems.compassNodeExist(GTCompassSections.CIRCUITS, "wafer", new CompassNode[0]))).register();
        ULTRA_HIGH_POWER_INTEGRATED_CIRCUIT_WAFER = ((ItemBuilder)GTRegistries.REGISTRATE.item("uhpic_wafer", class_1792::new).lang("UHPIC Wafer").onRegister(GTItems.compassNodeExist(GTCompassSections.CIRCUITS, "wafer", new CompassNode[0]))).register();
        ENGRAVED_CRYSTAL_CHIP = ((ItemBuilder)GTRegistries.REGISTRATE.item("engraved_crystal_chip", class_1792::new).lang("Engraved Crystal Chip").onRegister(GTItems.compassNode(GTCompassSections.MISC, new CompassNode[0]))).register();
        ENGRAVED_LAPOTRON_CHIP = ((ItemBuilder)GTRegistries.REGISTRATE.item("engraved_lapotron_crystal_chip", class_1792::new).lang("Engraved Lapotron Crystal Chip").onRegister(GTItems.compassNode(GTCompassSections.MISC, new CompassNode[0]))).register();
        CENTRAL_PROCESSING_UNIT = ((ItemBuilder)GTRegistries.REGISTRATE.item("cpu_chip", class_1792::new).lang("CPU Chip").onRegister(GTItems.compassNodeExist(GTCompassSections.CIRCUITS, "cpus", new CompassNode[0]))).register();
        RANDOM_ACCESS_MEMORY = GTRegistries.REGISTRATE.item("ram_chip", class_1792::new).lang("RAM Chip").register();
        INTEGRATED_LOGIC_CIRCUIT = ((ItemBuilder)GTRegistries.REGISTRATE.item("ilc_chip", class_1792::new).lang("IC Chip").onRegister(GTItems.compassNodeExist(GTCompassSections.CIRCUITS, "cpus", new CompassNode[0]))).register();
        NANO_CENTRAL_PROCESSING_UNIT = ((ItemBuilder)GTRegistries.REGISTRATE.item("nano_cpu_chip", class_1792::new).lang("Nano CPU Chip").onRegister(GTItems.compassNodeExist(GTCompassSections.CIRCUITS, "cpus", new CompassNode[0]))).register();
        QUBIT_CENTRAL_PROCESSING_UNIT = ((ItemBuilder)GTRegistries.REGISTRATE.item("qbit_cpu_chip", class_1792::new).lang("Qubit CPU Chip").onRegister(GTItems.compassNodeExist(GTCompassSections.CIRCUITS, "cpus", new CompassNode[0]))).register();
        SIMPLE_SYSTEM_ON_CHIP = ((ItemBuilder)GTRegistries.REGISTRATE.item("simple_soc", class_1792::new).lang("Simple SoC").onRegister(GTItems.compassNodeExist(GTCompassSections.CIRCUITS, "socs", new CompassNode[0]))).register();
        SYSTEM_ON_CHIP = ((ItemBuilder)GTRegistries.REGISTRATE.item("soc", class_1792::new).lang("SoC").onRegister(GTItems.compassNodeExist(GTCompassSections.CIRCUITS, "socs", new CompassNode[0]))).register();
        ADVANCED_SYSTEM_ON_CHIP = ((ItemBuilder)GTRegistries.REGISTRATE.item("advanced_soc", class_1792::new).lang("ASoC").onRegister(GTItems.compassNodeExist(GTCompassSections.CIRCUITS, "socs", new CompassNode[0]))).register();
        HIGHLY_ADVANCED_SOC = ((ItemBuilder)GTRegistries.REGISTRATE.item("highly_advanced_soc", class_1792::new).lang("HASoC").onRegister(GTItems.compassNodeExist(GTCompassSections.CIRCUITS, "socs", new CompassNode[0]))).register();
        NAND_MEMORY_CHIP = GTRegistries.REGISTRATE.item("nand_memory_chip", class_1792::new).lang("NAND Memory Chip").register();
        NOR_MEMORY_CHIP = GTRegistries.REGISTRATE.item("nor_memory_chip", class_1792::new).lang("NOR Memory Chip").register();
        ULTRA_LOW_POWER_INTEGRATED_CIRCUIT = GTRegistries.REGISTRATE.item("ulpic_chip", class_1792::new).lang("ULPIC Chip").register();
        LOW_POWER_INTEGRATED_CIRCUIT = GTRegistries.REGISTRATE.item("lpic_chip", class_1792::new).lang("LPIC Chip").register();
        POWER_INTEGRATED_CIRCUIT = GTRegistries.REGISTRATE.item("mpic_chip", class_1792::new).lang("MPIC Chip").register();
        HIGH_POWER_INTEGRATED_CIRCUIT = GTRegistries.REGISTRATE.item("hpic_chip", class_1792::new).lang("HPIC Chip").register();
        ULTRA_HIGH_POWER_INTEGRATED_CIRCUIT = GTRegistries.REGISTRATE.item("uhpic_chip", class_1792::new).lang("UHPIC Chip").register();
        RAW_CRYSTAL_CHIP = ((ItemBuilder)GTRegistries.REGISTRATE.item("raw_crystal_chip", class_1792::new).lang("Raw Crystal Chip").onRegister(GTItems.compassNode(GTCompassSections.MISC, new CompassNode[0]))).register();
        RAW_CRYSTAL_CHIP_PART = ((ItemBuilder)GTRegistries.REGISTRATE.item("raw_crystal_chip_parts", class_1792::new).lang("Raw Crystal Chip Parts").onRegister(GTItems.compassNode(GTCompassSections.MISC, new CompassNode[0]))).register();
        CRYSTAL_CENTRAL_PROCESSING_UNIT = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("crystal_cpu", class_1792::new).lang("Crystal CPU").onRegister(GTItems.compassNode(GTCompassSections.MISC, new CompassNode[0]))).onRegister(GTItems.compassNodeExist(GTCompassSections.CIRCUITS, "cpus", new CompassNode[0]))).register();
        CRYSTAL_SYSTEM_ON_CHIP = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("crystal_soc", class_1792::new).lang("Crystal SoC").onRegister(GTItems.compassNode(GTCompassSections.MISC, new CompassNode[0]))).onRegister(GTItems.compassNodeExist(GTCompassSections.CIRCUITS, "socs", new CompassNode[0]))).register();
        COATED_BOARD = ((ItemBuilder)GTRegistries.REGISTRATE.item("resin_circuit_board", class_1792::new).lang("Resin Circuit Board").onRegister(GTItems.compassNodeExist(GTCompassSections.CIRCUITS, "circuit_board", new CompassNode[0]))).register();
        PHENOLIC_BOARD = ((ItemBuilder)GTRegistries.REGISTRATE.item("phenolic_circuit_board", class_1792::new).lang("Phenolic Circuit Board").onRegister(GTItems.compassNodeExist(GTCompassSections.CIRCUITS, "circuit_board", new CompassNode[0]))).register();
        PLASTIC_BOARD = ((ItemBuilder)GTRegistries.REGISTRATE.item("plastic_circuit_board", class_1792::new).lang("Plastic Circuit Board").onRegister(GTItems.compassNodeExist(GTCompassSections.CIRCUITS, "circuit_board", new CompassNode[0]))).register();
        EPOXY_BOARD = ((ItemBuilder)GTRegistries.REGISTRATE.item("epoxy_circuit_board", class_1792::new).lang("Epoxy Circuit Board").onRegister(GTItems.compassNodeExist(GTCompassSections.CIRCUITS, "circuit_board", new CompassNode[0]))).register();
        FIBER_BOARD = ((ItemBuilder)GTRegistries.REGISTRATE.item("fiber_reinforced_circuit_board", class_1792::new).lang("Fiber-Reinforced Circuit Board").onRegister(GTItems.compassNodeExist(GTCompassSections.CIRCUITS, "circuit_board", new CompassNode[0]))).register();
        MULTILAYER_FIBER_BOARD = ((ItemBuilder)GTRegistries.REGISTRATE.item("multilayer_fiber_reinforced_circuit_board", class_1792::new).lang("Multi-layer Fiber-Reinforced Circuit Board").onRegister(GTItems.compassNodeExist(GTCompassSections.CIRCUITS, "circuit_board", new CompassNode[0]))).register();
        WETWARE_BOARD = ((ItemBuilder)GTRegistries.REGISTRATE.item("wetware_circuit_board", class_1792::new).lang("Wetware Circuit Board").onRegister(GTItems.compassNodeExist(GTCompassSections.CIRCUITS, "circuit_board", new CompassNode[0]))).register();
        BASIC_CIRCUIT_BOARD = ((ItemBuilder)GTRegistries.REGISTRATE.item("resin_printed_circuit_board", class_1792::new).lang("Resin Printed Circuit Board").onRegister(GTItems.compassNodeExist(GTCompassSections.CIRCUITS, "circuit_board", new CompassNode[0]))).register();
        GOOD_CIRCUIT_BOARD = ((ItemBuilder)GTRegistries.REGISTRATE.item("phenolic_printed_circuit_board", class_1792::new).lang("Phenolic Printed Circuit Board").onRegister(GTItems.compassNodeExist(GTCompassSections.CIRCUITS, "circuit_board", new CompassNode[0]))).register();
        PLASTIC_CIRCUIT_BOARD = ((ItemBuilder)GTRegistries.REGISTRATE.item("plastic_printed_circuit_board", class_1792::new).lang("Plastic Printed Circuit Board").onRegister(GTItems.compassNodeExist(GTCompassSections.CIRCUITS, "circuit_board", new CompassNode[0]))).register();
        ADVANCED_CIRCUIT_BOARD = ((ItemBuilder)GTRegistries.REGISTRATE.item("epoxy_printed_circuit_board", class_1792::new).lang("Epoxy Printed Circuit Board").onRegister(GTItems.compassNodeExist(GTCompassSections.CIRCUITS, "circuit_board", new CompassNode[0]))).register();
        EXTREME_CIRCUIT_BOARD = ((ItemBuilder)GTRegistries.REGISTRATE.item("fiber_reinforced_printed_circuit_board", class_1792::new).lang("Fiber-Reinforced Printed Circuit Board").onRegister(GTItems.compassNodeExist(GTCompassSections.CIRCUITS, "circuit_board", new CompassNode[0]))).register();
        ELITE_CIRCUIT_BOARD = ((ItemBuilder)GTRegistries.REGISTRATE.item("multilayer_fiber_reinforced_printed_circuit_board", class_1792::new).lang("Multi-layer Fiber-Reinforced Printed Circuit Board").onRegister(GTItems.compassNodeExist(GTCompassSections.CIRCUITS, "circuit_board", new CompassNode[0]))).register();
        WETWARE_CIRCUIT_BOARD = ((ItemBuilder)GTRegistries.REGISTRATE.item("wetware_printed_circuit_board", class_1792::new).lang("Wetware Printed Circuit Board").onRegister(GTItems.compassNodeExist(GTCompassSections.CIRCUITS, "circuit_board", new CompassNode[0]))).register();
        VACUUM_TUBE = ((ItemBuilder)GTRegistries.REGISTRATE.item("vacuum_tube", class_1792::new).lang("Vacuum Tube").tag(new class_6862[]{CustomTags.ULV_CIRCUITS}).onRegister(GTItems.compassNode(GTCompassSections.CIRCUITS, new CompassNode[0]))).register();
        GLASS_TUBE = ((ItemBuilder)GTRegistries.REGISTRATE.item("glass_tube", class_1792::new).lang("Glass Tube").onRegister(GTItems.compassNode(GTCompassSections.CIRCUITS, new CompassNode[0]))).register();
        TRANSISTOR = ((ItemBuilder)GTRegistries.REGISTRATE.item("transistor", class_1792::new).lang("Transistor").tag(new class_6862[]{CustomTags.TRANSISTORS}).onRegister(GTItems.compassNodeExist(GTCompassSections.CIRCUITS, "components", new CompassNode[0]))).register();
        RESISTOR = ((ItemBuilder)GTRegistries.REGISTRATE.item("resistor", class_1792::new).lang("Resistor").tag(new class_6862[]{CustomTags.RESISTORS}).onRegister(GTItems.compassNodeExist(GTCompassSections.CIRCUITS, "components", new CompassNode[0]))).register();
        CAPACITOR = ((ItemBuilder)GTRegistries.REGISTRATE.item("capacitor", class_1792::new).lang("Capacitor").tag(new class_6862[]{CustomTags.CAPACITORS}).onRegister(GTItems.compassNodeExist(GTCompassSections.CIRCUITS, "components", new CompassNode[0]))).register();
        DIODE = ((ItemBuilder)GTRegistries.REGISTRATE.item("diode", class_1792::new).lang("Diode").tag(new class_6862[]{CustomTags.DIODES}).onRegister(GTItems.compassNodeExist(GTCompassSections.CIRCUITS, "components", new CompassNode[0]))).register();
        INDUCTOR = ((ItemBuilder)GTRegistries.REGISTRATE.item("inductor", class_1792::new).lang("Inductor").tag(new class_6862[]{CustomTags.INDUCTORS}).onRegister(GTItems.compassNodeExist(GTCompassSections.CIRCUITS, "components", new CompassNode[0]))).register();
        SMD_TRANSISTOR = ((ItemBuilder)GTRegistries.REGISTRATE.item("smd_transistor", class_1792::new).lang("SMD Transistor").tag(new class_6862[]{CustomTags.TRANSISTORS}).onRegister(GTItems.compassNodeExist(GTCompassSections.CIRCUITS, "smd", new CompassNode[0]))).register();
        SMD_RESISTOR = ((ItemBuilder)GTRegistries.REGISTRATE.item("smd_resistor", class_1792::new).lang("SMD Resistor").tag(new class_6862[]{CustomTags.RESISTORS}).onRegister(GTItems.compassNodeExist(GTCompassSections.CIRCUITS, "smd", new CompassNode[0]))).register();
        SMD_CAPACITOR = ((ItemBuilder)GTRegistries.REGISTRATE.item("smd_capacitor", class_1792::new).lang("SMD Capacitor").tag(new class_6862[]{CustomTags.CAPACITORS}).onRegister(GTItems.compassNodeExist(GTCompassSections.CIRCUITS, "smd", new CompassNode[0]))).register();
        SMD_DIODE = ((ItemBuilder)GTRegistries.REGISTRATE.item("smd_diode", class_1792::new).lang("SMD Diode").tag(new class_6862[]{CustomTags.DIODES}).onRegister(GTItems.compassNodeExist(GTCompassSections.CIRCUITS, "smd", new CompassNode[0]))).register();
        SMD_INDUCTOR = ((ItemBuilder)GTRegistries.REGISTRATE.item("smd_inductor", class_1792::new).lang("SMD Inductor").tag(new class_6862[]{CustomTags.INDUCTORS}).onRegister(GTItems.compassNodeExist(GTCompassSections.CIRCUITS, "smd", new CompassNode[0]))).register();
        ADVANCED_SMD_TRANSISTOR = ((ItemBuilder)GTRegistries.REGISTRATE.item("advanced_smd_transistor", class_1792::new).lang("Advanced SMD Transistor").onRegister(GTItems.compassNodeExist(GTCompassSections.CIRCUITS, "smd", new CompassNode[0]))).register();
        ADVANCED_SMD_RESISTOR = ((ItemBuilder)GTRegistries.REGISTRATE.item("advanced_smd_resistor", class_1792::new).lang("Advanced SMD Resistor").onRegister(GTItems.compassNodeExist(GTCompassSections.CIRCUITS, "smd", new CompassNode[0]))).register();
        ADVANCED_SMD_CAPACITOR = ((ItemBuilder)GTRegistries.REGISTRATE.item("advanced_smd_capacitor", class_1792::new).lang("Advanced SMD Capacitor").onRegister(GTItems.compassNodeExist(GTCompassSections.CIRCUITS, "smd", new CompassNode[0]))).register();
        ADVANCED_SMD_DIODE = ((ItemBuilder)GTRegistries.REGISTRATE.item("advanced_smd_diode", class_1792::new).lang("Advanced SMD Diode").onRegister(GTItems.compassNodeExist(GTCompassSections.CIRCUITS, "smd", new CompassNode[0]))).register();
        ADVANCED_SMD_INDUCTOR = ((ItemBuilder)GTRegistries.REGISTRATE.item("advanced_smd_inductor", class_1792::new).lang("Advanced SMD Inductor").onRegister(GTItems.compassNodeExist(GTCompassSections.CIRCUITS, "smd", new CompassNode[0]))).register();
        ELECTRONIC_CIRCUIT_LV = ((ItemBuilder)GTRegistries.REGISTRATE.item("basic_electronic_circuit", class_1792::new).lang("Basic Electronic Circuit").tag(new class_6862[]{CustomTags.LV_CIRCUITS}).onRegister(GTItems.compassNode(GTCompassSections.CIRCUITS, new CompassNode[0]))).register();
        ELECTRONIC_CIRCUIT_MV = ((ItemBuilder)GTRegistries.REGISTRATE.item("good_electronic_circuit", class_1792::new).lang("Good Electronic Circuit").tag(new class_6862[]{CustomTags.MV_CIRCUITS}).onRegister(GTItems.compassNode(GTCompassSections.CIRCUITS, new CompassNode[0]))).register();
        INTEGRATED_CIRCUIT_LV = ((ItemBuilder)GTRegistries.REGISTRATE.item("basic_integrated_circuit", class_1792::new).lang("Basic Integrated Circuit").tag(new class_6862[]{CustomTags.LV_CIRCUITS}).onRegister(GTItems.compassNode(GTCompassSections.CIRCUITS, new CompassNode[0]))).register();
        INTEGRATED_CIRCUIT_MV = ((ItemBuilder)GTRegistries.REGISTRATE.item("good_integrated_circuit", class_1792::new).lang("Good Integrated Circuit").tag(new class_6862[]{CustomTags.MV_CIRCUITS}).onRegister(GTItems.compassNode(GTCompassSections.CIRCUITS, new CompassNode[0]))).register();
        INTEGRATED_CIRCUIT_HV = ((ItemBuilder)GTRegistries.REGISTRATE.item("advanced_integrated_circuit", class_1792::new).lang("Advanced Integrated Circuit").tag(new class_6862[]{CustomTags.HV_CIRCUITS}).onRegister(GTItems.compassNode(GTCompassSections.CIRCUITS, new CompassNode[0]))).register();
        NAND_CHIP_ULV = ((ItemBuilder)GTRegistries.REGISTRATE.item("nand_chip", class_1792::new).lang("NAND Chip").tag(new class_6862[]{CustomTags.ULV_CIRCUITS}).onRegister(GTItems.compassNode(GTCompassSections.CIRCUITS, new CompassNode[0]))).register();
        MICROPROCESSOR_LV = ((ItemBuilder)GTRegistries.REGISTRATE.item("microchip_processor", class_1792::new).lang("Microchip Processor").tag(new class_6862[]{CustomTags.LV_CIRCUITS}).onRegister(GTItems.compassNode(GTCompassSections.CIRCUITS, new CompassNode[0]))).register();
        PROCESSOR_MV = ((ItemBuilder)GTRegistries.REGISTRATE.item("micro_processor", class_1792::new).lang("Microprocessor").tag(new class_6862[]{CustomTags.MV_CIRCUITS}).onRegister(GTItems.compassNode(GTCompassSections.CIRCUITS, new CompassNode[0]))).register();
        PROCESSOR_ASSEMBLY_HV = ((ItemBuilder)GTRegistries.REGISTRATE.item("micro_processor_assembly", class_1792::new).lang("Microprocessor Assembly").tag(new class_6862[]{CustomTags.HV_CIRCUITS}).onRegister(GTItems.compassNode(GTCompassSections.CIRCUITS, new CompassNode[0]))).register();
        WORKSTATION_EV = ((ItemBuilder)GTRegistries.REGISTRATE.item("micro_processor_computer", class_1792::new).lang("Microprocessor Supercomputer").tag(new class_6862[]{CustomTags.EV_CIRCUITS}).onRegister(GTItems.compassNode(GTCompassSections.CIRCUITS, new CompassNode[0]))).register();
        MAINFRAME_IV = ((ItemBuilder)GTRegistries.REGISTRATE.item("micro_processor_mainframe", class_1792::new).lang("Microprocessor Mainframe").tag(new class_6862[]{CustomTags.IV_CIRCUITS}).onRegister(GTItems.compassNode(GTCompassSections.CIRCUITS, new CompassNode[0]))).register();
        NANO_PROCESSOR_HV = ((ItemBuilder)GTRegistries.REGISTRATE.item("nano_processor", class_1792::new).lang("Nanoprocessor").tag(new class_6862[]{CustomTags.HV_CIRCUITS}).onRegister(GTItems.compassNode(GTCompassSections.CIRCUITS, new CompassNode[0]))).register();
        NANO_PROCESSOR_ASSEMBLY_EV = ((ItemBuilder)GTRegistries.REGISTRATE.item("nano_processor_assembly", class_1792::new).lang("Nanoprocessor Assembly").tag(new class_6862[]{CustomTags.EV_CIRCUITS}).onRegister(GTItems.compassNode(GTCompassSections.CIRCUITS, new CompassNode[0]))).register();
        NANO_COMPUTER_IV = ((ItemBuilder)GTRegistries.REGISTRATE.item("nano_processor_computer", class_1792::new).lang("Nanoprocessor Supercomputer").tag(new class_6862[]{CustomTags.IV_CIRCUITS}).onRegister(GTItems.compassNode(GTCompassSections.CIRCUITS, new CompassNode[0]))).register();
        NANO_MAINFRAME_LUV = ((ItemBuilder)GTRegistries.REGISTRATE.item("nano_processor_mainframe", class_1792::new).lang("Nanoprocessor Mainframe").tag(new class_6862[]{CustomTags.LuV_CIRCUITS}).onRegister(GTItems.compassNode(GTCompassSections.CIRCUITS, new CompassNode[0]))).register();
        QUANTUM_PROCESSOR_EV = ((ItemBuilder)GTRegistries.REGISTRATE.item("quantum_processor", class_1792::new).lang("Quantum Processor").tag(new class_6862[]{CustomTags.EV_CIRCUITS}).onRegister(GTItems.compassNode(GTCompassSections.CIRCUITS, new CompassNode[0]))).register();
        QUANTUM_ASSEMBLY_IV = ((ItemBuilder)GTRegistries.REGISTRATE.item("quantum_processor_assembly", class_1792::new).lang("Quantum Processor Assembly").tag(new class_6862[]{CustomTags.IV_CIRCUITS}).onRegister(GTItems.compassNode(GTCompassSections.CIRCUITS, new CompassNode[0]))).register();
        QUANTUM_COMPUTER_LUV = ((ItemBuilder)GTRegistries.REGISTRATE.item("quantum_processor_computer", class_1792::new).lang("Quantum Processor Supercomputer").tag(new class_6862[]{CustomTags.LuV_CIRCUITS}).onRegister(GTItems.compassNode(GTCompassSections.CIRCUITS, new CompassNode[0]))).register();
        QUANTUM_MAINFRAME_ZPM = ((ItemBuilder)GTRegistries.REGISTRATE.item("quantum_processor_mainframe", class_1792::new).lang("Quantum Processor Mainframe").tag(new class_6862[]{CustomTags.ZPM_CIRCUITS}).onRegister(GTItems.compassNode(GTCompassSections.CIRCUITS, new CompassNode[0]))).register();
        CRYSTAL_PROCESSOR_IV = ((ItemBuilder)GTRegistries.REGISTRATE.item("crystal_processor", class_1792::new).lang("Crystal Processor").tag(new class_6862[]{CustomTags.IV_CIRCUITS}).onRegister(GTItems.compassNode(GTCompassSections.CIRCUITS, new CompassNode[0]))).register();
        CRYSTAL_ASSEMBLY_LUV = ((ItemBuilder)GTRegistries.REGISTRATE.item("crystal_processor_assembly", class_1792::new).lang("Crystal Processor Assembly").tag(new class_6862[]{CustomTags.LuV_CIRCUITS}).onRegister(GTItems.compassNode(GTCompassSections.CIRCUITS, new CompassNode[0]))).register();
        CRYSTAL_COMPUTER_ZPM = ((ItemBuilder)GTRegistries.REGISTRATE.item("crystal_processor_computer", class_1792::new).lang("Crystal Processor Supercomputer").tag(new class_6862[]{CustomTags.ZPM_CIRCUITS}).onRegister(GTItems.compassNode(GTCompassSections.CIRCUITS, new CompassNode[0]))).register();
        CRYSTAL_MAINFRAME_UV = ((ItemBuilder)GTRegistries.REGISTRATE.item("crystal_processor_mainframe", class_1792::new).lang("Crystal Processor Mainframe").tag(new class_6862[]{CustomTags.UV_CIRCUITS}).onRegister(GTItems.compassNode(GTCompassSections.CIRCUITS, new CompassNode[0]))).register();
        WETWARE_PROCESSOR_LUV = ((ItemBuilder)GTRegistries.REGISTRATE.item("wetware_processor", class_1792::new).lang("Wetware Processor").tag(new class_6862[]{CustomTags.LuV_CIRCUITS}).onRegister(GTItems.compassNode(GTCompassSections.CIRCUITS, new CompassNode[0]))).register();
        WETWARE_PROCESSOR_ASSEMBLY_ZPM = ((ItemBuilder)GTRegistries.REGISTRATE.item("wetware_processor_assembly", class_1792::new).lang("Wetware Processor Assembly").tag(new class_6862[]{CustomTags.ZPM_CIRCUITS}).onRegister(GTItems.compassNode(GTCompassSections.CIRCUITS, new CompassNode[0]))).register();
        WETWARE_SUPER_COMPUTER_UV = ((ItemBuilder)GTRegistries.REGISTRATE.item("wetware_processor_computer", class_1792::new).lang("Wetware Processor Supercomputer").tag(new class_6862[]{CustomTags.UV_CIRCUITS}).onRegister(GTItems.compassNode(GTCompassSections.CIRCUITS, new CompassNode[0]))).register();
        WETWARE_MAINFRAME_UHV = ((ItemBuilder)GTRegistries.REGISTRATE.item("wetware_processor_mainframe", class_1792::new).lang("Wetware Processor Mainframe").tag(new class_6862[]{CustomTags.UHV_CIRCUITS}).onRegister(GTItems.compassNode(GTCompassSections.CIRCUITS, new CompassNode[0]))).register();
        COMPONENT_GRINDER_DIAMOND = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("diamond_grinding_head", class_1792::new).lang("Diamond Grinding Head").onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Steel, 29030400L), new MaterialStack(GTMaterials.Diamond, 18144000L))))).onRegister(GTItems.compassNode(GTCompassSections.MISC, new CompassNode[0]))).register();
        COMPONENT_GRINDER_TUNGSTEN = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("tungsten_grinding_head", class_1792::new).lang("Tungsten Grinding Head").onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Tungsten, 14515200L), new MaterialStack(GTMaterials.VanadiumSteel, 29030400L), new MaterialStack(GTMaterials.Diamond, 3628800L))))).onRegister(GTItems.compassNode(GTCompassSections.MISC, new CompassNode[0]))).register();
        QUANTUM_EYE = ((ItemBuilder)GTRegistries.REGISTRATE.item("quantum_eye", class_1792::new).lang("Quantum Eye").onRegister(GTItems.compassNode(GTCompassSections.MISC, new CompassNode[0]))).register();
        QUANTUM_STAR = ((ItemBuilder)GTRegistries.REGISTRATE.item("quantum_star", class_1792::new).lang("Quantum Star").onRegister(GTItems.compassNode(GTCompassSections.MISC, new CompassNode[0]))).register();
        GRAVI_STAR = ((ItemBuilder)GTRegistries.REGISTRATE.item("gravi_star", class_1792::new).lang("Gravi-Star").onRegister(GTItems.compassNode(GTCompassSections.MISC, new CompassNode[0]))).register();
        ITEM_FILTER = ((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("item_filter", ComponentItem::create).onRegister(GTItems.attach(new ItemFilterBehaviour(SimpleItemFilter::loadFilter), new CoverPlaceBehavior(GTCovers.ITEM_FILTER)))).onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Zinc, 7257600L), new MaterialStack(GTMaterials.Steel, 3628800L))))).onRegister(GTItems.compassNode(GTCompassSections.COVERS, GTCompassNodes.COVER))).register();
        ORE_DICTIONARY_FILTER = ((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("item_tag_filter", ComponentItem::create).lang("Item Tag Filter").onRegister(GTItems.attach(new ItemFilterBehaviour(TagItemFilter::loadFilter), new CoverPlaceBehavior(GTCovers.ITEM_FILTER)))).onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Zinc, 7257600L))))).onRegister(GTItems.compassNode(GTCompassSections.COVERS, GTCompassNodes.COVER))).register();
        FLUID_FILTER = ((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("fluid_filter", ComponentItem::create).onRegister(GTItems.attach(new FluidFilterBehaviour(SimpleFluidFilter::loadFilter), new CoverPlaceBehavior(GTCovers.FLUID_FILTER)))).onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Zinc, 7257600L))))).onRegister(GTItems.compassNode(GTCompassSections.COVERS, GTCompassNodes.COVER))).register();
        TAG_FLUID_FILTER = ((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("fluid_tag_filter", ComponentItem::create).lang("Fluid Tag Filter").onRegister(GTItems.attach(new FluidFilterBehaviour(TagFluidFilter::loadFilter), new CoverPlaceBehavior(GTCovers.FLUID_FILTER)))).onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Zinc, 5443200L))))).onRegister(GTItems.compassNode(GTCompassSections.COVERS, GTCompassNodes.COVER))).register();
        COVER_MACHINE_CONTROLLER = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("machine_controller_cover", ComponentItem::create).lang("Machine Controller").onRegister(GTItems.attach(new CoverPlaceBehavior(GTCovers.MACHINE_CONTROLLER)))).onRegister(GTItems.compassNode(GTCompassSections.COVERS, GTCompassNodes.COVER))).register();
        COVER_ACTIVITY_DETECTOR = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("activity_detector_cover", ComponentItem::create).lang("Activity Detector").onRegister(GTItems.attach(new CoverPlaceBehavior(GTCovers.ACTIVITY_DETECTOR)))).onRegister(GTItems.compassNode(GTCompassSections.COVERS, GTCompassNodes.COVER))).register();
        COVER_ACTIVITY_DETECTOR_ADVANCED = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("advanced_activity_detector_cover", ComponentItem::create).lang("Advanced Activity Detector").onRegister(GTItems.attach(new CoverPlaceBehavior(GTCovers.ACTIVITY_DETECTOR_ADVANCED)))).onRegister(GTItems.compassNode(GTCompassSections.COVERS, GTCompassNodes.COVER))).register();
        COVER_FLUID_DETECTOR = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("fluid_detector_cover", ComponentItem::create).lang("Fluid Detector").onRegister(GTItems.attach(new CoverPlaceBehavior(GTCovers.FLUID_DETECTOR)))).onRegister(GTItems.compassNode(GTCompassSections.COVERS, GTCompassNodes.COVER))).register();
        COVER_FLUID_DETECTOR_ADVANCED = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("advanced_fluid_detector_cover", ComponentItem::create).lang("Advanced Fluid Detector").onRegister(GTItems.attach(new CoverPlaceBehavior(GTCovers.FLUID_DETECTOR_ADVANCED)))).onRegister(GTItems.compassNode(GTCompassSections.COVERS, GTCompassNodes.COVER))).register();
        COVER_ITEM_DETECTOR = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("item_detector_cover", ComponentItem::create).lang("Item Detector").onRegister(GTItems.attach(new CoverPlaceBehavior(GTCovers.ITEM_DETECTOR)))).onRegister(GTItems.compassNode(GTCompassSections.COVERS, GTCompassNodes.COVER))).register();
        COVER_ITEM_DETECTOR_ADVANCED = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("advanced_item_detector_cover", ComponentItem::create).lang("Advanced Item Detector").onRegister(GTItems.attach(new CoverPlaceBehavior(GTCovers.ITEM_DETECTOR_ADVANCED)))).onRegister(GTItems.compassNode(GTCompassSections.COVERS, GTCompassNodes.COVER))).register();
        COVER_ENERGY_DETECTOR = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("energy_detector_cover", ComponentItem::create).lang("Energy Detector").onRegister(GTItems.attach(new CoverPlaceBehavior(GTCovers.ENERGY_DETECTOR)))).onRegister(GTItems.compassNode(GTCompassSections.COVERS, GTCompassNodes.COVER))).register();
        COVER_ENERGY_DETECTOR_ADVANCED = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("advanced_energy_detector_cover", ComponentItem::create).lang("Advanced Energy Detector").onRegister(GTItems.attach(new CoverPlaceBehavior(GTCovers.ENERGY_DETECTOR_ADVANCED)))).onRegister(GTItems.compassNode(GTCompassSections.COVERS, GTCompassNodes.COVER))).register();
        COVER_MAINTENANCE_DETECTOR = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("maintenance_detector_cover", ComponentItem::create).lang("Maintenance Detector").onRegister(GTItems.attach(new CoverPlaceBehavior(GTCovers.MAINTENANCE_DETECTOR)))).onRegister(GTItems.compassNode(GTCompassSections.COVERS, GTCompassNodes.COVER))).register();
        COVER_SCREEN = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("computer_monitor_cover", ComponentItem::create).lang("Computer Monitor").onRegister(GTItems.attach(new CoverPlaceBehavior(GTCovers.COMPUTER_MONITOR)))).onRegister(GTItems.compassNode(GTCompassSections.COVERS, GTCompassNodes.COVER))).register();
        COVER_CRAFTING = ((ItemBuilder)GTRegistries.REGISTRATE.item("crafting_table_cover", ComponentItem::create).lang("Crafting Table Cover").onRegister(GTItems.compassNode(GTCompassSections.COVERS, GTCompassNodes.COVER))).register();
        COVER_SHUTTER = ((ItemBuilder)GTRegistries.REGISTRATE.item("shutter_module_cover", ComponentItem::create).lang("Shutter Module").onRegister(GTItems.compassNode(GTCompassSections.COVERS, GTCompassNodes.COVER))).register();
        COVER_INFINITE_WATER = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("infinite_water_cover", ComponentItem::create).lang("Infinite Water Cover").onRegister(GTItems.compassNode(GTCompassSections.COVERS, GTCompassNodes.COVER))).onRegister(GTItems.attach(new TooltipBehavior(lines -> lines.add(class_2561.method_43469((String)"gtceu.universal.tooltip.produces_fluid", (Object[])new Object[]{800}))), new CoverPlaceBehavior(GTCovers.INFINITE_WATER)))).register();
        COVER_ENDER_FLUID_LINK = ((ItemBuilder)GTRegistries.REGISTRATE.item("ender_fluid_link_cover", ComponentItem::create).lang("Ender Fluid Link").onRegister(GTItems.compassNode(GTCompassSections.COVERS, GTCompassNodes.COVER))).register();
        COVER_DIGITAL_INTERFACE = GTRegistries.REGISTRATE.item("digital_interface_cover", ComponentItem::create).lang("Digital Interface").register();
        COVER_DIGITAL_INTERFACE_WIRELESS = GTRegistries.REGISTRATE.item("wireless_digital_interface_cover", ComponentItem::create).lang("Wireless Digital Interface").register();
        COVER_FLUID_VOIDING = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("fluid_voiding_cover", ComponentItem::create).lang("Fluid Voiding Cover").onRegister(GTItems.attach(new CoverPlaceBehavior(GTCovers.FLUID_VOIDING)))).onRegister(GTItems.compassNode(GTCompassSections.COVERS, GTCompassNodes.COVER))).register();
        COVER_FLUID_VOIDING_ADVANCED = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("advanced_fluid_voiding_cover", ComponentItem::create).lang("Advanced Fluid Voiding Cover").onRegister(GTItems.attach(new CoverPlaceBehavior(GTCovers.FLUID_VOIDING_ADVANCED)))).onRegister(GTItems.compassNode(GTCompassSections.COVERS, GTCompassNodes.COVER))).register();
        COVER_ITEM_VOIDING = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("item_voiding_cover", ComponentItem::create).lang("Item Voiding Cover").onRegister(GTItems.attach(new CoverPlaceBehavior(GTCovers.ITEM_VOIDING)))).onRegister(GTItems.compassNode(GTCompassSections.COVERS, GTCompassNodes.COVER))).register();
        COVER_ITEM_VOIDING_ADVANCED = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("advanced_item_voiding_cover", ComponentItem::create).lang("Advanced Item Voiding Cover").onRegister(GTItems.attach(new CoverPlaceBehavior(GTCovers.ITEM_VOIDING_ADVANCED)))).onRegister(GTItems.compassNode(GTCompassSections.COVERS, GTCompassNodes.COVER))).register();
        COVER_FACADE = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("facade_cover", ComponentItem::create).lang("Cover Facade").onRegister(GTItems.attach(new FacadeItemBehaviour(), new CoverPlaceBehavior(GTCovers.FACADE)))).model(NonNullBiConsumer.noop()).onRegister(GTItems.compassNode(GTCompassSections.COVERS, GTCompassNodes.COVER))).register();
        COVER_SOLAR_PANEL = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("solar_panel", ComponentItem::create).lang("Solar Panel").onRegister(GTItems.attach(new TooltipBehavior(lines -> {
            lines.addAll(LangHandler.getMultiLang("metaitem.cover.solar.panel.tooltip"));
            lines.add(class_2561.method_43469((String)"gtceu.universal.tooltip.voltage_out", (Object[])new Object[]{1, GTValues.VNF[0]}));
        })))).onRegister(GTItems.compassNode(GTCompassSections.COVERS, GTCompassNodes.COVER))).register();
        COVER_SOLAR_PANEL_ULV = ((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("ulv_solar_panel", ComponentItem::create).lang("Ultra Low Voltage Solar Panel").onRegister(GTItems.attach(new TooltipBehavior(lines -> {
            lines.addAll(LangHandler.getMultiLang("metaitem.cover.solar.panel.tooltip"));
            lines.add(class_2561.method_43469((String)"gtceu.universal.tooltip.voltage_out", (Object[])new Object[]{GTValues.V[0], GTValues.VNF[0]}));
        })))).onRegister(GTItems.attach(new CoverPlaceBehavior(GTCovers.SOLAR_PANEL[0])))).onRegister(GTItems.compassNodeExist(GTCompassSections.COVERS, "solar_panel", GTCompassNodes.COVER))).register();
        COVER_SOLAR_PANEL_LV = ((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("lv_solar_panel", ComponentItem::create).lang("Low Voltage Solar Panel").onRegister(GTItems.attach(new TooltipBehavior(lines -> {
            lines.addAll(LangHandler.getMultiLang("metaitem.cover.solar.panel.tooltip"));
            lines.add(class_2561.method_43469((String)"gtceu.universal.tooltip.voltage_out", (Object[])new Object[]{GTValues.V[1], GTValues.VNF[1]}));
        })))).onRegister(GTItems.attach(new CoverPlaceBehavior(GTCovers.SOLAR_PANEL[1])))).onRegister(GTItems.compassNodeExist(GTCompassSections.COVERS, "solar_panel", GTCompassNodes.COVER))).register();
        COVER_SOLAR_PANEL_MV = ((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("mv_solar_panel", ComponentItem::create).lang("Medium Voltage Solar Panel").onRegister(GTItems.attach(new TooltipBehavior(lines -> {
            lines.addAll(LangHandler.getMultiLang("metaitem.cover.solar.panel.tooltip"));
            lines.add(class_2561.method_43469((String)"gtceu.universal.tooltip.voltage_out", (Object[])new Object[]{GTValues.V[2], GTValues.VNF[2]}));
        })))).onRegister(GTItems.attach(new CoverPlaceBehavior(GTCovers.SOLAR_PANEL[2])))).onRegister(GTItems.compassNodeExist(GTCompassSections.COVERS, "solar_panel", GTCompassNodes.COVER))).register();
        COVER_SOLAR_PANEL_HV = ((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("hv_solar_panel", ComponentItem::create).lang("High Voltage Solar Panel").onRegister(GTItems.attach(new TooltipBehavior(lines -> {
            lines.addAll(LangHandler.getMultiLang("metaitem.cover.solar.panel.tooltip"));
            lines.add(class_2561.method_43469((String)"gtceu.universal.tooltip.voltage_out", (Object[])new Object[]{GTValues.V[3], GTValues.VNF[3]}));
        })))).onRegister(GTItems.attach(new CoverPlaceBehavior(GTCovers.SOLAR_PANEL[3])))).onRegister(GTItems.compassNodeExist(GTCompassSections.COVERS, "solar_panel", GTCompassNodes.COVER))).register();
        COVER_SOLAR_PANEL_EV = ((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("ev_solar_panel", ComponentItem::create).lang("Extreme Voltage Solar Panel").onRegister(GTItems.attach(new TooltipBehavior(lines -> {
            lines.addAll(LangHandler.getMultiLang("metaitem.cover.solar.panel.tooltip"));
            lines.add(class_2561.method_43469((String)"gtceu.universal.tooltip.voltage_out", (Object[])new Object[]{GTValues.V[4], GTValues.VNF[4]}));
        })))).onRegister(GTItems.attach(new CoverPlaceBehavior(GTCovers.SOLAR_PANEL[4])))).onRegister(GTItems.compassNodeExist(GTCompassSections.COVERS, "solar_panel", GTCompassNodes.COVER))).register();
        COVER_SOLAR_PANEL_IV = ((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("iv_solar_panel", ComponentItem::create).lang("Insane Voltage Solar Panel").onRegister(GTItems.attach(new TooltipBehavior(lines -> {
            lines.addAll(LangHandler.getMultiLang("metaitem.cover.solar.panel.tooltip"));
            lines.add(class_2561.method_43469((String)"gtceu.universal.tooltip.voltage_out", (Object[])new Object[]{GTValues.V[5], GTValues.VNF[5]}));
        })))).onRegister(GTItems.attach(new CoverPlaceBehavior(GTCovers.SOLAR_PANEL[5])))).onRegister(GTItems.compassNodeExist(GTCompassSections.COVERS, "solar_panel", GTCompassNodes.COVER))).register();
        COVER_SOLAR_PANEL_LUV = ((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("luv_solar_panel", ComponentItem::create).lang("Ludicrous Voltage Solar Panel").onRegister(GTItems.attach(new TooltipBehavior(lines -> {
            lines.addAll(LangHandler.getMultiLang("metaitem.cover.solar.panel.tooltip"));
            lines.add(class_2561.method_43469((String)"gtceu.universal.tooltip.voltage_out", (Object[])new Object[]{GTValues.V[6], GTValues.VNF[6]}));
        })))).onRegister(GTItems.attach(new CoverPlaceBehavior(GTCovers.SOLAR_PANEL[6])))).onRegister(GTItems.compassNodeExist(GTCompassSections.COVERS, "solar_panel", GTCompassNodes.COVER))).register();
        COVER_SOLAR_PANEL_ZPM = ((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("zpm_solar_panel", ComponentItem::create).lang("Zero Point Module Solar Panel").onRegister(GTItems.attach(new TooltipBehavior(lines -> {
            lines.addAll(LangHandler.getMultiLang("metaitem.cover.solar.panel.tooltip"));
            lines.add(class_2561.method_43469((String)"gtceu.universal.tooltip.voltage_out", (Object[])new Object[]{GTValues.V[7], GTValues.VNF[7]}));
        })))).onRegister(GTItems.attach(new CoverPlaceBehavior(GTCovers.SOLAR_PANEL[7])))).onRegister(GTItems.compassNodeExist(GTCompassSections.COVERS, "solar_panel", GTCompassNodes.COVER))).register();
        COVER_SOLAR_PANEL_UV = ((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("uv_solar_panel", ComponentItem::create).lang("Ultimate Voltage Solar Panel").onRegister(GTItems.attach(new TooltipBehavior(lines -> {
            lines.addAll(LangHandler.getMultiLang("metaitem.cover.solar.panel.tooltip"));
            lines.add(class_2561.method_43469((String)"gtceu.universal.tooltip.voltage_out", (Object[])new Object[]{GTValues.V[8], GTValues.VNF[8]}));
        })))).onRegister(GTItems.attach(new CoverPlaceBehavior(GTCovers.SOLAR_PANEL[8])))).onRegister(GTItems.compassNodeExist(GTCompassSections.COVERS, "solar_panel", GTCompassNodes.COVER))).register();
        INTEGRATED_CIRCUIT = ((ItemBuilder)((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("programmed_circuit", ComponentItem::create).lang("Programmed Circuit").model(GTModels.overrideModel(GTCEu.id("circuit"), 33)).onRegister(GTItems.modelPredicate(GTCEu.id("circuit"), itemStack -> Float.valueOf((float)IntCircuitBehaviour.getCircuitConfiguration(itemStack) / 100.0f)))).onRegister(GTItems.attach(new IntCircuitBehaviour()))).onRegister(GTItems.compassNode(GTCompassSections.MISC, new CompassNode[0]))).register();
        GELLED_TOLUENE = ((ItemBuilder)GTRegistries.REGISTRATE.item("gelled_toluene", class_1792::new).onRegister(GTItems.compassNode(GTCompassSections.MISC, new CompassNode[0]))).register();
        BOTTLE_PURPLE_DRINK = ((ItemBuilder)GTRegistries.REGISTRATE.item("purple_drink", class_1792::new).lang("Purple Drink").properties(p -> p.method_19265(GTFoods.DRINK)).onRegister(GTItems.compassNode(GTCompassSections.MISC, new CompassNode[0]))).register();
        PLANT_BALL = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("plant_ball", ComponentItem::create).onRegister(GTItems.compassNode(GTCompassSections.MISC, new CompassNode[0]))).onRegister(GTItems.burnTime(75))).register();
        STICKY_RESIN = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("sticky_resin", ComponentItem::create).lang("Sticky Resin").onRegister(GTItems.compassNode(GTCompassSections.MISC, new CompassNode[0]))).onRegister(GTItems.burnTime(200))).register();
        BIO_CHAFF = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("bio_chaff", ComponentItem::create).onRegister(GTItems.compassNode(GTCompassSections.MISC, new CompassNode[0]))).onRegister(GTItems.burnTime(200))).register();
        ENERGIUM_DUST = ((ItemBuilder)GTRegistries.REGISTRATE.item("energium_dust", class_1792::new).onRegister(GTItems.compassNode(GTCompassSections.MISC, new CompassNode[0]))).register();
        PROSPECTOR_LV = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("prospector.lv", ComponentItem::create).lang("Ore Prospector (LV)").properties(p -> p.method_7889(1)).onRegister(GTItems.compassNodeExist(GTCompassSections.ITEMS, "prospector", new CompassNode[0]))).onRegister(GTItems.attach(ElectricStats.createElectricItem(100000L, 1L), new ProspectorScannerBehavior(2, GTValues.V[1] / 16L, ProspectorMode.ORE)))).register();
        PROSPECTOR_HV = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("prospector.hv", ComponentItem::create).lang("Advanced Prospector (HV)").properties(p -> p.method_7889(1)).onRegister(GTItems.compassNodeExist(GTCompassSections.ITEMS, "prospector", new CompassNode[0]))).onRegister(GTItems.attach(ElectricStats.createElectricItem(1600000L, 3L), new ProspectorScannerBehavior(3, GTValues.V[3] / 16L, ProspectorMode.ORE, ProspectorMode.FLUID, ConfigHolder.INSTANCE.machines.doBedrockOres ? ProspectorMode.BEDROCK_ORE : null)))).register();
        PROSPECTOR_LUV = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("prospector.luv", ComponentItem::create).lang("Super Prospector (LuV)").properties(p -> p.method_7889(1)).onRegister(GTItems.compassNodeExist(GTCompassSections.ITEMS, "prospector", new CompassNode[0]))).onRegister(GTItems.attach(ElectricStats.createElectricItem(1000000000L, 6L), new ProspectorScannerBehavior(5, GTValues.V[6] / 16L, ProspectorMode.ORE, ProspectorMode.FLUID, ConfigHolder.INSTANCE.machines.doBedrockOres ? ProspectorMode.BEDROCK_ORE : null)))).register();
        TERMINAL = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("terminal", ComponentItem::create).lang("Terminal").properties(p -> p.method_7889(1)).onRegister(GTItems.compassNode(GTCompassSections.ITEMS, new CompassNode[0]))).onRegister(GTItems.attach(new TerminalBehavior()))).register();
        DYE_ONLY_ITEMS = new ItemEntry[class_1767.values().length];
        for (i = 0; i < class_1767.values().length; ++i) {
            dyeColor = class_1767.values()[i];
            GTItems.DYE_ONLY_ITEMS[i] = ((ItemBuilder)GTRegistries.REGISTRATE.item("chemical_%s_dye".formatted(dyeColor.method_7792()), class_1792::new).lang("Chemical %s Dye".formatted(FormattingUtil.toEnglishName(dyeColor.method_7792()))).tag(new class_6862[]{TagUtil.createPlatformItemTag("dyes/" + dyeColor.method_7792(), dyeColor.method_7792() + "_dyes")}).onRegister(GTItems.compassNodeExist(GTCompassSections.MISC, "chemical_dye", new CompassNode[0]))).register();
        }
        SPRAY_CAN_DYES = new ItemEntry[class_1767.values().length];
        for (i = 0; i < class_1767.values().length; ++i) {
            dyeColor = class_1767.values()[i];
            GTItems.SPRAY_CAN_DYES[i] = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("%s_dye_spray_can".formatted(dyeColor.method_7792()), ComponentItem::create).lang("Spray Can (%s)".formatted(FormattingUtil.toEnglishName(dyeColor.method_7792()))).properties(p -> p.method_7889(1)).onRegister(GTItems.compassNodeExist(GTCompassSections.ITEMS, "empty_spray_can", new CompassNode[0]))).onRegister(GTItems.attach(new ColorSprayBehaviour(() -> SPRAY_EMPTY.asStack(), 512, i)))).register();
        }
        TURBINE_ROTOR = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("turbine_rotor", ComponentItem::create).properties(p -> p.method_7889(1)).model((ctx, prov) -> GTModels.createTextureModel((DataGenContext<class_1792, ? extends class_1792>)ctx, prov, GTCEu.id("item/tools/turbine"))).color(() -> IMaterialPartItem::getItemStackColor).onRegister(GTItems.compassNode(GTCompassSections.MISC, new CompassNode[0]))).onRegister(GTItems.attach(new TurbineRotorBehaviour()))).register();
        NEURO_PROCESSOR = ((ItemBuilder)GTRegistries.REGISTRATE.item("neuro_processing_unit", class_1792::new).lang("Neuro Processing Unit").onRegister(GTItems.compassNode(GTCompassSections.MISC, new CompassNode[0]))).register();
        STEM_CELLS = ((ItemBuilder)GTRegistries.REGISTRATE.item("stem_cells", class_1792::new).onRegister(GTItems.compassNode(GTCompassSections.MISC, new CompassNode[0]))).register();
        PETRI_DISH = ((ItemBuilder)GTRegistries.REGISTRATE.item("petri_dish", class_1792::new).onRegister(GTItems.compassNode(GTCompassSections.MISC, new CompassNode[0]))).register();
        VOLTAGE_COIL_ULV = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("ulv_voltage_coil", ComponentItem::create).lang("Ultra Low Voltage Coil").onRegister(GTItems.compassNodeExist(GTCompassSections.MISC, "coil", new CompassNode[0]))).onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Lead, 7257600L), new MaterialStack(GTMaterials.IronMagnetic, 1814400L))))).register();
        VOLTAGE_COIL_LV = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("lv_voltage_coil", ComponentItem::create).lang("Low Voltage Coil").onRegister(GTItems.compassNodeExist(GTCompassSections.MISC, "coil", new CompassNode[0]))).onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Steel, 7257600L), new MaterialStack(GTMaterials.IronMagnetic, 1814400L))))).register();
        VOLTAGE_COIL_MV = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("mv_voltage_coil", ComponentItem::create).lang("Medium Voltage Coil").onRegister(GTItems.compassNodeExist(GTCompassSections.MISC, "coil", new CompassNode[0]))).onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Aluminium, 7257600L), new MaterialStack(GTMaterials.SteelMagnetic, 1814400L))))).register();
        VOLTAGE_COIL_HV = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("hv_voltage_coil", ComponentItem::create).lang("High Voltage Coil").onRegister(GTItems.compassNodeExist(GTCompassSections.MISC, "coil", new CompassNode[0]))).onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.BlackSteel, 7257600L), new MaterialStack(GTMaterials.SteelMagnetic, 1814400L))))).register();
        VOLTAGE_COIL_EV = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("ev_voltage_coil", ComponentItem::create).lang("Extreme Voltage Coil").onRegister(GTItems.compassNodeExist(GTCompassSections.MISC, "coil", new CompassNode[0]))).onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.TungstenSteel, 7257600L), new MaterialStack(GTMaterials.NeodymiumMagnetic, 1814400L))))).register();
        VOLTAGE_COIL_IV = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("iv_voltage_coil", ComponentItem::create).lang("Insane Voltage Coil").onRegister(GTItems.compassNodeExist(GTCompassSections.MISC, "coil", new CompassNode[0]))).onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Iridium, 7257600L), new MaterialStack(GTMaterials.NeodymiumMagnetic, 1814400L))))).register();
        VOLTAGE_COIL_LuV = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("luv_voltage_coil", ComponentItem::create).lang("Ludicrous Voltage Coil").onRegister(GTItems.compassNodeExist(GTCompassSections.MISC, "coil", new CompassNode[0]))).onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Osmiridium, 7257600L), new MaterialStack(GTMaterials.SamariumMagnetic, 1814400L))))).register();
        VOLTAGE_COIL_ZPM = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("zpm_voltage_coil", ComponentItem::create).lang("Zero Point Module Voltage Coil").onRegister(GTItems.compassNodeExist(GTCompassSections.MISC, "coil", new CompassNode[0]))).onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Europium, 7257600L), new MaterialStack(GTMaterials.SamariumMagnetic, 1814400L))))).register();
        VOLTAGE_COIL_UV = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("uv_voltage_coil", ComponentItem::create).lang("Ultimate Voltage Coil").onRegister(GTItems.compassNodeExist(GTCompassSections.MISC, "coil", new CompassNode[0]))).onRegister(GTItems.materialInfo(new ItemMaterialInfo(new MaterialStack(GTMaterials.Tritanium, 7257600L), new MaterialStack(GTMaterials.SamariumMagnetic, 1814400L))))).register();
        POWER_THRUSTER = ((ItemBuilder)GTRegistries.REGISTRATE.item("power_thruster", class_1792::new).properties(p -> p.method_7894(class_1814.field_8907)).onRegister(GTItems.compassNode(GTCompassSections.MISC, new CompassNode[0]))).register();
        POWER_THRUSTER_ADVANCED = ((ItemBuilder)GTRegistries.REGISTRATE.item("advanced_power_thruster", class_1792::new).lang("Advanced Power Thruster").properties(p -> p.method_7894(class_1814.field_8903)).onRegister(GTItems.compassNode(GTCompassSections.MISC, new CompassNode[0]))).register();
        GRAVITATION_ENGINE = ((ItemBuilder)GTRegistries.REGISTRATE.item("gravitation_engine_unit", class_1792::new).lang("Gravitation Engine Unit").properties(p -> p.method_7894(class_1814.field_8904)).onRegister(GTItems.compassNode(GTCompassSections.MISC, new CompassNode[0]))).register();
        NAN_CERTIFICATE = ((ItemBuilder)GTRegistries.REGISTRATE.item("nan_certificate", class_1792::new).lang("Certificate of Not Being a Noob Anymore").properties(p -> p.method_7894(class_1814.field_8904)).onRegister(GTItems.compassNodeExist(GTCompassSections.MISC, "certificate_of_not_being_a_noob_anymore", new CompassNode[0]))).register();
        FERTILIZER = ((ItemBuilder)((ItemBuilder)GTRegistries.REGISTRATE.item("fertilizer", ComponentItem::create).onRegister(GTItems.attach(new FertilizerBehavior()))).onRegister(GTItems.compassNode(GTCompassSections.MISC, new CompassNode[0]))).register();
        BLACKLIGHT = ((ItemBuilder)GTRegistries.REGISTRATE.item("blacklight", class_1792::new).onRegister(GTItems.compassNode(GTCompassSections.MISC, new CompassNode[0]))).register();
    }
}

