/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.renderer.machine;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.client.renderer.machine.TieredHullMachineRenderer;
import com.gregtechceu.gtceu.common.machine.storage.QuantumTankMachine;
import com.gregtechceu.gtceu.core.mixins.GuiGraphicsAccessor;
import com.lowdragmc.lowdraglib.client.utils.RenderBufferUtils;
import com.lowdragmc.lowdraglib.client.utils.RenderUtils;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.util.TextFormattingUtil;
import com.lowdragmc.lowdraglib.side.fluid.FluidHelper;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1047;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1087;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4722;
import net.minecraft.class_811;

public class QuantumTankRenderer
extends TieredHullMachineRenderer {
    public QuantumTankRenderer(int tier) {
        super(tier, GTCEu.id("block/machine/quantum_tank"));
    }

    @Environment(value=EnvType.CLIENT)
    public boolean hasTESR(class_2586 blockEntity) {
        return true;
    }

    @Override
    public void renderItem(class_1799 stack, class_811 transformType, boolean leftHand, class_4587 poseStack, class_4597 buffer, int combinedLight, int combinedOverlay, class_1087 model) {
        model = this.getItemBakedModel();
        if (model != null && stack.method_7985()) {
            poseStack.method_22903();
            model.method_4709().method_3503(transformType).method_23075(leftHand, poseStack);
            poseStack.method_22904(-0.5, -0.5, -0.5);
            FluidStack tank = FluidStack.loadFromTag((class_2487)stack.method_7911("stored"));
            this.renderTank(poseStack, buffer, class_2350.field_11043, tank, FluidStack.empty());
            poseStack.method_22909();
        }
        super.renderItem(stack, transformType, leftHand, poseStack, buffer, combinedLight, combinedOverlay, model);
    }

    @Environment(value=EnvType.CLIENT)
    public void render(class_2586 blockEntity, float partialTicks, class_4587 poseStack, class_4597 buffer, int combinedLight, int combinedOverlay) {
        IMachineBlockEntity machineBlockEntity;
        MetaMachine metaMachine;
        if (blockEntity instanceof IMachineBlockEntity && (metaMachine = (machineBlockEntity = (IMachineBlockEntity)blockEntity).getMetaMachine()) instanceof QuantumTankMachine) {
            QuantumTankMachine machine = (QuantumTankMachine)metaMachine;
            this.renderTank(poseStack, buffer, machine.getFrontFacing(), machine.getStored(), machine.getLockedFluid().getFluid());
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void renderTank(class_4587 poseStack, class_4597 buffer, class_2350 frontFacing, FluidStack stored, FluidStack locked) {
        FluidStack fluid;
        FluidStack fluidStack = fluid = !stored.isEmpty() ? stored : locked;
        if (fluid.isEmpty()) {
            return;
        }
        class_1058 fluidTexture = FluidHelper.getStillTexture((FluidStack)fluid);
        if (fluidTexture == null) {
            fluidTexture = (class_1058)class_310.method_1551().method_1549(class_1059.field_5275).apply(class_1047.method_4539());
        }
        poseStack.method_22903();
        class_4588 builder = buffer.getBuffer(class_4722.method_24076());
        RenderBufferUtils.renderCubeFace((class_4587)poseStack, (class_4588)builder, (float)0.15625f, (float)0.15625f, (float)0.15625f, (float)0.84375f, (float)0.84375f, (float)0.84375f, (int)(FluidHelper.getColor((FluidStack)fluid) | 0xFF000000), (int)0xF000F0, (class_1058)fluidTexture);
        poseStack.method_22909();
        poseStack.method_22903();
        RenderSystem.disableDepthTest();
        poseStack.method_46416((float)(frontFacing.method_10148() * -1) / 16.0f, (float)(frontFacing.method_10164() * -1) / 16.0f, (float)(frontFacing.method_10165() * -1) / 16.0f);
        RenderUtils.moveToFace((class_4587)poseStack, (double)0.0, (double)0.0, (double)0.0, (class_2350)frontFacing);
        if (frontFacing.method_10166() == class_2350.class_2351.field_11052) {
            RenderUtils.rotateToFace((class_4587)poseStack, (class_2350)frontFacing, (class_2350)(frontFacing == class_2350.field_11036 ? class_2350.field_11035 : class_2350.field_11043));
        } else {
            RenderUtils.rotateToFace((class_4587)poseStack, (class_2350)frontFacing, null);
        }
        String amount = stored.isEmpty() ? "*" : TextFormattingUtil.formatLongToCompactString((long)(fluid.getAmount() / (FluidHelper.getBucket() / 1000L)), (int)4);
        poseStack.method_22905(0.015625f, 0.015625f, 0.0f);
        poseStack.method_46416(-32.0f, -32.0f, 0.0f);
        new TextTexture(amount).draw(GuiGraphicsAccessor.create(class_310.method_1551(), poseStack, class_4597.method_22991((class_287)class_289.method_1348().method_1349())), 0, 0, 0.0f, 24.0f, 64, 28);
        RenderSystem.enableDepthTest();
        poseStack.method_22909();
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public float reBakeCustomQuadsOffset() {
        return 0.0f;
    }
}

