/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.renderer.machine;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.client.renderer.machine.TieredHullMachineRenderer;
import com.gregtechceu.gtceu.common.machine.storage.QuantumChestMachine;
import com.gregtechceu.gtceu.core.mixins.GuiGraphicsAccessor;
import com.lowdragmc.lowdraglib.client.utils.RenderUtils;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.util.TextFormattingUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1087;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_811;
import net.minecraft.class_918;
import org.joml.Quaternionf;

public class QuantumChestRenderer
extends TieredHullMachineRenderer {
    public QuantumChestRenderer(int tier) {
        super(tier, GTCEu.id("block/machine/quantum_chest"));
    }

    @Environment(value=EnvType.CLIENT)
    public boolean hasTESR(class_2586 blockEntity) {
        return true;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void renderItem(class_1799 stack, class_811 transformType, boolean leftHand, class_4587 poseStack, class_4597 buffer, int combinedLight, int combinedOverlay, class_1087 model) {
        model = this.getItemBakedModel();
        if (model != null && stack.method_7985()) {
            poseStack.method_22903();
            model.method_4709().method_3503(transformType).method_23075(leftHand, poseStack);
            poseStack.method_22904(-0.5, -0.5, -0.5);
            class_1799 itemStack = class_1799.method_7915((class_2487)stack.method_7911("stored"));
            int storedAmount = stack.method_7948().method_10550("storedAmount");
            float tick = (float)class_310.method_1551().field_1687.method_8510() + class_310.method_1551().method_1488();
            this.renderChest(poseStack, buffer, class_2350.field_11043, itemStack, storedAmount, tick, class_1799.field_8037);
            poseStack.method_22909();
        }
        super.renderItem(stack, transformType, leftHand, poseStack, buffer, combinedLight, combinedOverlay, model);
    }

    @Environment(value=EnvType.CLIENT)
    public void render(class_2586 blockEntity, float partialTicks, class_4587 poseStack, class_4597 buffer, int combinedLight, int combinedOverlay) {
        IMachineBlockEntity machineBlockEntity;
        MetaMachine metaMachine;
        if (blockEntity instanceof IMachineBlockEntity && (metaMachine = (machineBlockEntity = (IMachineBlockEntity)blockEntity).getMetaMachine()) instanceof QuantumChestMachine) {
            QuantumChestMachine machine = (QuantumChestMachine)metaMachine;
            class_1937 level = machine.getLevel();
            class_2350 frontFacing = machine.getFrontFacing();
            float tick = (float)level.method_8510() + partialTicks;
            this.renderChest(poseStack, buffer, frontFacing, machine.getStored(), machine.getStoredAmount(), tick, machine.getLockedItem().getStackInSlot(0));
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void renderChest(class_4587 poseStack, class_4597 buffer, class_2350 frontFacing, class_1799 stored, int storedAmount, float tick, class_1799 locked) {
        class_1799 itemStack;
        class_1799 class_17992 = itemStack = !stored.method_7960() ? stored : locked;
        if (itemStack.method_7960()) {
            return;
        }
        class_918 itemRenderer = class_310.method_1551().method_1480();
        poseStack.method_22903();
        class_1087 bakedmodel = itemRenderer.method_4019(itemStack, (class_1937)class_310.method_1551().field_1687, null, class_1792.method_7880((class_1792)itemStack.method_7909()) + itemStack.method_7919());
        poseStack.method_22904(0.5, 0.5, 0.5);
        poseStack.method_22907(new Quaternionf().rotateAxis(tick * ((float)Math.PI * 2) / 80.0f, 0.0f, 1.0f, 0.0f));
        poseStack.method_22905(0.6f, 0.6f, 0.6f);
        itemRenderer.method_23179(itemStack, class_811.field_4319, false, poseStack, buffer, 0xF000F0, class_4608.field_21444, bakedmodel);
        poseStack.method_22909();
        poseStack.method_22903();
        RenderSystem.disableDepthTest();
        poseStack.method_46416((float)(frontFacing.method_10148() * -1) / 16.0f, (float)(frontFacing.method_10164() * -1) / 16.0f, (float)(frontFacing.method_10165() * -1) / 16.0f);
        RenderUtils.moveToFace((class_4587)poseStack, (double)0.0, (double)0.0, (double)0.0, (class_2350)frontFacing);
        if (frontFacing.method_10166() == class_2350.class_2351.field_11052) {
            RenderUtils.rotateToFace((class_4587)poseStack, (class_2350)frontFacing, (class_2350)(frontFacing == class_2350.field_11036 ? class_2350.field_11035 : class_2350.field_11043));
        } else {
            RenderUtils.rotateToFace((class_4587)poseStack, (class_2350)frontFacing, null);
        }
        String amount = stored.method_7960() ? "*" : TextFormattingUtil.formatLongToCompactString((long)storedAmount, (int)4);
        poseStack.method_22905(0.015625f, 0.015625f, 0.0f);
        poseStack.method_46416(-32.0f, -32.0f, 0.0f);
        new TextTexture(amount).draw(GuiGraphicsAccessor.create(class_310.method_1551(), poseStack, class_4597.method_22991((class_287)class_289.method_1348().method_1349())), 0, 0, 0.0f, 24.0f, 64, 28);
        RenderSystem.enableDepthTest();
        poseStack.method_22909();
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public float reBakeCustomQuadsOffset() {
        return 0.0f;
    }
}

