/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.renderer.item;

import com.google.gson.JsonElement;
import com.gregtechceu.gtceu.api.data.chemical.material.info.MaterialIconSet;
import com.gregtechceu.gtceu.api.data.chemical.material.info.MaterialIconType;
import com.gregtechceu.gtceu.api.item.TagPrefixItem;
import com.gregtechceu.gtceu.data.pack.GTDynamicResourcePack;
import com.gregtechceu.gtceu.utils.GradientUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.class_1011;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_4940;
import net.minecraft.class_7923;

public class TagPrefixItemRenderer {
    private static final Set<TagPrefixItemRenderer> MODELS = new HashSet<TagPrefixItemRenderer>();
    private final class_1792 item;
    private final MaterialIconType type;
    private final MaterialIconSet iconSet;

    public static void create(class_1792 item, MaterialIconType type, MaterialIconSet iconSet) {
        MODELS.add(new TagPrefixItemRenderer(item, type, iconSet));
    }

    public static void reinitModels() {
        for (TagPrefixItemRenderer model : MODELS) {
            class_2960 itemId = class_7923.field_41178.method_10221((Object)model.item);
            GTDynamicResourcePack.addItemModel(itemId, (Supplier<JsonElement>)new class_4940(model.type.getItemModelPath(model.iconSet, true)));
        }
    }

    public static void initTextures() {
        for (TagPrefixItemRenderer model : MODELS) {
            class_2960 itemId = class_7923.field_41178.method_10221((Object)model.item);
            class_3298 file1 = class_310.method_1551().method_1478().method_14486(GTDynamicResourcePack.getTextureLocation(null, model.type.getItemTexturePath(model.iconSet, true))).orElse(null);
            if (file1 == null) continue;
            try {
                InputStream stream1 = file1.method_14482();
                try {
                    class_1792 class_17922 = model.item;
                    if (!(class_17922 instanceof TagPrefixItem)) continue;
                    TagPrefixItem prefixItem = (TagPrefixItem)class_17922;
                    int materialRGBA = GradientUtil.argbToRgba(prefixItem.material.getMaterialARGB());
                    int materialSecondaryRGBA = GradientUtil.argbToRgba(prefixItem.material.getMaterialSecondaryARGB());
                    class_1011 image1 = class_1011.method_4309((InputStream)stream1);
                    try (class_1011 result = new class_1011(image1.method_4307(), image1.method_4323(), true);){
                        class_3298 file2;
                        for (int x = 0; x < image1.method_4307(); ++x) {
                            for (int y = 0; y < image1.method_4323(); ++y) {
                                int color = image1.method_4315(x, y);
                                result.method_4305(x, y, GradientUtil.multiplyBlendRGBA(color, materialRGBA));
                            }
                        }
                        if (prefixItem.material.getMaterialSecondaryARGB() != -1 && (file2 = (class_3298)class_310.method_1551().method_1478().method_14486(GTDynamicResourcePack.getTextureLocation(null, model.type.getItemTexturePath(model.iconSet, true).method_48331("_layer2"))).orElse(null)) != null) {
                            try (InputStream stream2 = file2.method_14482();){
                                class_1011 image2 = class_1011.method_4309((InputStream)stream2);
                                for (int x = 0; x < image1.method_4307(); ++x) {
                                    for (int y = 0; y < image1.method_4323(); ++y) {
                                        int color = image2.method_4315(x, y);
                                        result.method_35624(x, y, GradientUtil.multiplyBlendRGBA(color, materialSecondaryRGBA));
                                    }
                                }
                            }
                        }
                        GTDynamicResourcePack.addItemTexture(itemId, result.method_24036());
                    }
                }
                finally {
                    if (stream1 == null) continue;
                    stream1.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private TagPrefixItemRenderer(class_1792 item, MaterialIconType type, MaterialIconSet iconSet) {
        this.item = item;
        this.type = type;
        this.iconSet = iconSet;
    }
}

