/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.pattern;

import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.pattern.MultiblockState;
import com.gregtechceu.gtceu.api.pattern.predicates.SimplePredicate;
import com.lowdragmc.lowdraglib.utils.BlockInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_2561;

public class TraceabilityPredicate {
    public List<SimplePredicate> common = new ArrayList<SimplePredicate>();
    public List<SimplePredicate> limited = new ArrayList<SimplePredicate>();
    public boolean isController;

    public TraceabilityPredicate() {
    }

    public TraceabilityPredicate(TraceabilityPredicate predicate) {
        this.common.addAll(predicate.common);
        this.limited.addAll(predicate.limited);
        this.isController = predicate.isController;
    }

    public TraceabilityPredicate(Predicate<MultiblockState> predicate, Supplier<BlockInfo[]> candidates) {
        this.common.add(new SimplePredicate(predicate, candidates));
    }

    public TraceabilityPredicate(SimplePredicate simplePredicate) {
        if (simplePredicate.minCount != -1 || simplePredicate.maxCount != -1) {
            this.limited.add(simplePredicate);
        } else {
            this.common.add(simplePredicate);
        }
    }

    public TraceabilityPredicate setController() {
        this.isController = true;
        return this;
    }

    public TraceabilityPredicate sort() {
        this.limited.sort(Comparator.comparingInt(a -> a.minCount));
        return this;
    }

    public TraceabilityPredicate addTooltips(class_2561 ... tips) {
        if (tips.length > 0) {
            List<class_2561> tooltips = Arrays.stream(tips).toList();
            this.common.forEach(predicate -> {
                if (predicate.candidates == null) {
                    return;
                }
                if (predicate.toolTips == null) {
                    predicate.toolTips = new ArrayList<class_2561>();
                }
                predicate.toolTips.addAll(tooltips);
            });
            this.limited.forEach(predicate -> {
                if (predicate.candidates == null) {
                    return;
                }
                if (predicate.toolTips == null) {
                    predicate.toolTips = new ArrayList<class_2561>();
                }
                predicate.toolTips.addAll(tooltips);
            });
        }
        return this;
    }

    public TraceabilityPredicate setMinGlobalLimited(int min) {
        this.limited.addAll(this.common);
        this.common.clear();
        for (SimplePredicate predicate : this.limited) {
            predicate.minCount = min;
        }
        return this;
    }

    public TraceabilityPredicate setMinGlobalLimited(int min, int previewCount) {
        return this.setMinGlobalLimited(min).setPreviewCount(previewCount);
    }

    public TraceabilityPredicate setMaxGlobalLimited(int max) {
        this.limited.addAll(this.common);
        this.common.clear();
        for (SimplePredicate predicate : this.limited) {
            predicate.maxCount = max;
        }
        return this;
    }

    public TraceabilityPredicate setMaxGlobalLimited(int max, int previewCount) {
        return this.setMaxGlobalLimited(max).setPreviewCount(previewCount);
    }

    public TraceabilityPredicate setMinLayerLimited(int min) {
        this.limited.addAll(this.common);
        this.common.clear();
        for (SimplePredicate predicate : this.limited) {
            predicate.minLayerCount = min;
        }
        return this;
    }

    public TraceabilityPredicate setMinLayerLimited(int min, int previewCount) {
        return this.setMinLayerLimited(min).setPreviewCount(previewCount);
    }

    public TraceabilityPredicate setMaxLayerLimited(int max) {
        this.limited.addAll(this.common);
        this.common.clear();
        for (SimplePredicate predicate : this.limited) {
            predicate.maxLayerCount = max;
        }
        return this;
    }

    public TraceabilityPredicate setMaxLayerLimited(int max, int previewCount) {
        return this.setMaxLayerLimited(max).setPreviewCount(previewCount);
    }

    public TraceabilityPredicate setExactLimit(int limit) {
        return this.setMinGlobalLimited(limit).setMaxGlobalLimited(limit);
    }

    public TraceabilityPredicate setPreviewCount(int count) {
        this.common.forEach(predicate -> {
            predicate.previewCount = count;
        });
        this.limited.forEach(predicate -> {
            predicate.previewCount = count;
        });
        return this;
    }

    public TraceabilityPredicate disableRenderFormed() {
        this.common.forEach(predicate -> {
            predicate.disableRenderFormed = true;
        });
        this.limited.forEach(predicate -> {
            predicate.disableRenderFormed = true;
        });
        return this;
    }

    public TraceabilityPredicate setIO(IO io) {
        this.common.forEach(predicate -> {
            predicate.io = io;
        });
        this.limited.forEach(predicate -> {
            predicate.io = io;
        });
        return this;
    }

    public TraceabilityPredicate setNBTParser(String nbtParser) {
        this.common.forEach(predicate -> {
            predicate.nbtParser = nbtParser;
        });
        this.limited.forEach(predicate -> {
            predicate.nbtParser = nbtParser;
        });
        return this;
    }

    public TraceabilityPredicate setSlotName(String slotName) {
        this.common.forEach(predicate -> {
            predicate.slotName = slotName;
        });
        this.limited.forEach(predicate -> {
            predicate.slotName = slotName;
        });
        return this;
    }

    public boolean test(MultiblockState blockWorldState) {
        blockWorldState.io = IO.BOTH;
        boolean flag = false;
        for (SimplePredicate predicate2 : this.limited) {
            if (!predicate2.testLimited(blockWorldState)) continue;
            flag = true;
        }
        boolean bl = flag = flag || this.common.stream().anyMatch(predicate -> predicate.test(blockWorldState));
        if (flag) {
            blockWorldState.setError(null);
        }
        return flag;
    }

    public TraceabilityPredicate or(TraceabilityPredicate other) {
        if (other != null) {
            TraceabilityPredicate newPredicate = new TraceabilityPredicate(this);
            newPredicate.common.addAll(other.common);
            newPredicate.limited.addAll(other.limited);
            return newPredicate;
        }
        return this;
    }

    public boolean isAny() {
        return this.common.size() == 1 && this.limited.isEmpty() && this.common.get(0) == SimplePredicate.ANY;
    }

    public boolean addCache() {
        return !this.isAny();
    }

    public boolean isAir() {
        return this.common.size() == 1 && this.limited.isEmpty() && this.common.get(0) == SimplePredicate.AIR;
    }

    public boolean isSingle() {
        return !this.isAny() && !this.isAir() && this.common.size() + this.limited.size() == 1;
    }

    public boolean hasAir() {
        return this.common.contains(SimplePredicate.AIR);
    }
}

