/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.item.tool;

import com.google.common.collect.ImmutableList;
import com.gregtechceu.gtceu.api.item.tool.IGTToolDefinition;
import com.gregtechceu.gtceu.api.item.tool.aoe.AoESymmetrical;
import com.gregtechceu.gtceu.api.item.tool.behavior.IToolBehavior;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_1799;
import net.minecraft.class_1886;
import net.minecraft.class_1887;
import net.minecraft.class_2248;
import net.minecraft.class_2680;

public class ToolDefinitionBuilder {
    private final List<IToolBehavior> behaviours = new ArrayList<IToolBehavior>();
    private int damagePerAction = 1;
    private int damagePerCraftingAction = 1;
    private boolean suitableForBlockBreaking = false;
    private boolean suitableForAttacking = false;
    private boolean suitableForCrafting = false;
    private int baseDurability = 0;
    private float durabilityMultiplier = 1.0f;
    private int baseQuality = 0;
    private float attackDamage = 0.0f;
    private float baseEfficiency = 4.0f;
    private float efficiencyMultiplier = 1.0f;
    private boolean isEnchantable;
    private BiPredicate<class_1799, class_1887> canApplyEnchantment;
    private float attackSpeed = 0.0f;
    private boolean sneakBypassUse = false;
    private Supplier<class_1799> brokenStack = () -> class_1799.field_8037;
    private AoESymmetrical aoe = AoESymmetrical.none();
    private final Set<class_2248> effectiveBlocks = new ObjectOpenHashSet();
    private Predicate<class_2680> effectiveStates;
    private final Object2IntMap<class_1887> defaultEnchantments = new Object2IntArrayMap();

    public ToolDefinitionBuilder behaviors(IToolBehavior ... behaviours) {
        Collections.addAll(this.behaviours, behaviours);
        return this;
    }

    public ToolDefinitionBuilder blockBreaking() {
        this.suitableForBlockBreaking = true;
        return this;
    }

    public ToolDefinitionBuilder attacking() {
        this.suitableForAttacking = true;
        return this;
    }

    public ToolDefinitionBuilder crafting() {
        this.suitableForCrafting = true;
        return this;
    }

    public ToolDefinitionBuilder baseQuality() {
        return this.baseQuality(0);
    }

    public ToolDefinitionBuilder cannotAttack() {
        this.attackDamage = Float.MIN_VALUE;
        return this;
    }

    public ToolDefinitionBuilder noEnchant() {
        this.isEnchantable = false;
        return this;
    }

    public ToolDefinitionBuilder canApplyEnchantment(BiPredicate<class_1799, class_1887> canApplyEnchantment) {
        this.isEnchantable = true;
        this.canApplyEnchantment = canApplyEnchantment;
        return this;
    }

    public ToolDefinitionBuilder canApplyEnchantment(class_1886 ... enchantmentTypes) {
        this.isEnchantable = true;
        this.canApplyEnchantment = (stack, enchantment) -> {
            for (class_1886 type : enchantmentTypes) {
                if (enchantment.field_9083 != type) continue;
                return true;
            }
            return false;
        };
        return this;
    }

    public ToolDefinitionBuilder sneakBypassUse() {
        this.sneakBypassUse = true;
        return this;
    }

    public ToolDefinitionBuilder aoe(int additionalColumns, int additionalRows, int additionalDepth) {
        return this.aoe(AoESymmetrical.of(additionalColumns, additionalRows, additionalDepth));
    }

    public ToolDefinitionBuilder effectiveBlocks(class_2248 ... blocks) {
        Collections.addAll(this.effectiveBlocks, blocks);
        return this;
    }

    public ToolDefinitionBuilder effectiveStates(Predicate<class_2680> effectiveStates) {
        this.effectiveStates = effectiveStates;
        return this;
    }

    public ToolDefinitionBuilder defaultEnchantment(class_1887 enchantment, int level) {
        return this.defaultEnchantment(enchantment, level, 0);
    }

    public ToolDefinitionBuilder defaultEnchantment(class_1887 enchantment, int level, int growth) {
        this.defaultEnchantments.put((Object)enchantment, level);
        return this;
    }

    public IGTToolDefinition build() {
        return new IGTToolDefinition(){
            private final List<IToolBehavior> behaviors;
            private final int damagePerAction;
            private final int damagePerCraftingAction;
            private final boolean suitableForBlockBreaking;
            private final boolean suitableForAttacking;
            private final boolean suitableForCrafting;
            private final int baseDurability;
            private final float durabilityMultiplier;
            private final int baseQuality;
            private final float attackDamage;
            private final float baseEfficiency;
            private final float efficiencyMultiplier;
            private final boolean isEnchantable;
            private final BiPredicate<class_1799, class_1887> canApplyEnchantment;
            private final float attackSpeed;
            private final boolean sneakBypassUse;
            private final Supplier<class_1799> brokenStack;
            private final AoESymmetrical aoeSymmetrical;
            private final Predicate<class_2680> effectiveStatePredicate;
            private final Object2IntMap<class_1887> defaultEnchantments;
            {
                this.behaviors = ImmutableList.copyOf(ToolDefinitionBuilder.this.behaviours);
                this.damagePerAction = ToolDefinitionBuilder.this.damagePerAction;
                this.damagePerCraftingAction = ToolDefinitionBuilder.this.damagePerCraftingAction;
                this.suitableForBlockBreaking = ToolDefinitionBuilder.this.suitableForBlockBreaking;
                this.suitableForAttacking = ToolDefinitionBuilder.this.suitableForAttacking;
                this.suitableForCrafting = ToolDefinitionBuilder.this.suitableForCrafting;
                this.baseDurability = ToolDefinitionBuilder.this.baseDurability;
                this.durabilityMultiplier = ToolDefinitionBuilder.this.durabilityMultiplier;
                this.baseQuality = ToolDefinitionBuilder.this.baseQuality;
                this.attackDamage = ToolDefinitionBuilder.this.attackDamage;
                this.baseEfficiency = ToolDefinitionBuilder.this.baseEfficiency;
                this.efficiencyMultiplier = ToolDefinitionBuilder.this.efficiencyMultiplier;
                this.isEnchantable = ToolDefinitionBuilder.this.isEnchantable;
                this.canApplyEnchantment = ToolDefinitionBuilder.this.canApplyEnchantment;
                this.attackSpeed = ToolDefinitionBuilder.this.attackSpeed;
                this.sneakBypassUse = ToolDefinitionBuilder.this.sneakBypassUse;
                this.brokenStack = ToolDefinitionBuilder.this.brokenStack;
                this.aoeSymmetrical = ToolDefinitionBuilder.this.aoe;
                this.defaultEnchantments = ToolDefinitionBuilder.this.defaultEnchantments;
                Set<class_2248> effectiveBlocks = ToolDefinitionBuilder.this.effectiveBlocks;
                Predicate<class_2680> effectiveStates = ToolDefinitionBuilder.this.effectiveStates;
                Predicate<class_2680> effectiveStatePredicate = null;
                if (!effectiveBlocks.isEmpty()) {
                    effectiveStatePredicate = state -> effectiveBlocks.contains(state.method_26204());
                }
                if (effectiveStates != null) {
                    effectiveStatePredicate = effectiveStatePredicate == null ? effectiveStates : effectiveStatePredicate.or(effectiveStates);
                }
                this.effectiveStatePredicate = effectiveStatePredicate == null ? state -> false : effectiveStatePredicate;
            }

            @Override
            public List<IToolBehavior> getBehaviors() {
                return this.behaviors;
            }

            @Override
            public boolean isToolEffective(class_2680 state) {
                return this.effectiveStatePredicate.test(state);
            }

            @Override
            public int getDamagePerCraftingAction(class_1799 stack) {
                return this.damagePerCraftingAction;
            }

            @Override
            public int getDamagePerAction(class_1799 stack) {
                return this.damagePerAction;
            }

            @Override
            public boolean isSuitableForBlockBreak(class_1799 stack) {
                return this.suitableForBlockBreaking;
            }

            @Override
            public boolean isSuitableForAttacking(class_1799 stack) {
                return this.suitableForAttacking;
            }

            @Override
            public boolean isSuitableForCrafting(class_1799 stack) {
                return this.suitableForCrafting;
            }

            @Override
            public int getBaseDurability(class_1799 stack) {
                return this.baseDurability;
            }

            @Override
            public float getDurabilityMultiplier(class_1799 stack) {
                return this.durabilityMultiplier;
            }

            @Override
            public int getBaseQuality(class_1799 stack) {
                return this.baseQuality;
            }

            @Override
            public float getBaseDamage(class_1799 stack) {
                return this.attackDamage;
            }

            @Override
            public float getBaseEfficiency(class_1799 stack) {
                return this.baseEfficiency;
            }

            @Override
            public float getEfficiencyMultiplier(class_1799 stack) {
                return this.efficiencyMultiplier;
            }

            @Override
            public boolean isEnchantable(class_1799 stack) {
                return this.isEnchantable;
            }

            @Override
            public boolean canApplyEnchantment(class_1799 stack, class_1887 enchantment) {
                return this.canApplyEnchantment.test(stack, enchantment);
            }

            @Override
            public Object2IntMap<class_1887> getDefaultEnchantments(class_1799 stack) {
                return Object2IntMaps.unmodifiable(this.defaultEnchantments);
            }

            @Override
            public float getAttackSpeed(class_1799 stack) {
                return this.attackSpeed;
            }

            @Override
            public boolean doesSneakBypassUse() {
                return this.sneakBypassUse;
            }

            @Override
            public class_1799 getBrokenStack() {
                return this.brokenStack.get();
            }

            @Override
            public AoESymmetrical getAoEDefinition(class_1799 stack) {
                return this.aoeSymmetrical;
            }
        };
    }

    public ToolDefinitionBuilder damagePerAction(int damagePerAction) {
        this.damagePerAction = damagePerAction;
        return this;
    }

    public ToolDefinitionBuilder damagePerCraftingAction(int damagePerCraftingAction) {
        this.damagePerCraftingAction = damagePerCraftingAction;
        return this;
    }

    public ToolDefinitionBuilder baseDurability(int baseDurability) {
        this.baseDurability = baseDurability;
        return this;
    }

    public ToolDefinitionBuilder durabilityMultiplier(float durabilityMultiplier) {
        this.durabilityMultiplier = durabilityMultiplier;
        return this;
    }

    public ToolDefinitionBuilder baseQuality(int baseQuality) {
        this.baseQuality = baseQuality;
        return this;
    }

    public ToolDefinitionBuilder attackDamage(float attackDamage) {
        this.attackDamage = attackDamage;
        return this;
    }

    public ToolDefinitionBuilder baseEfficiency(float baseEfficiency) {
        this.baseEfficiency = baseEfficiency;
        return this;
    }

    public ToolDefinitionBuilder efficiencyMultiplier(float efficiencyMultiplier) {
        this.efficiencyMultiplier = efficiencyMultiplier;
        return this;
    }

    public ToolDefinitionBuilder attackSpeed(float attackSpeed) {
        this.attackSpeed = attackSpeed;
        return this;
    }

    public ToolDefinitionBuilder brokenStack(Supplier<class_1799> brokenStack) {
        this.brokenStack = brokenStack;
        return this;
    }

    public ToolDefinitionBuilder aoe(AoESymmetrical aoe) {
        this.aoe = aoe;
        return this;
    }
}

