/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.gui.widget;

import com.gregtechceu.gtceu.utils.GTUtil;
import com.lowdragmc.lowdraglib.gui.widget.PhantomFluidWidget;
import com.lowdragmc.lowdraglib.side.fluid.FluidHelper;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.lowdraglib.side.fluid.IFluidStorage;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2540;
import org.jetbrains.annotations.Nullable;

public class ScrollablePhantomFluidWidget
extends PhantomFluidWidget {
    private static final int SCROLL_ACTION_ID = 65537;
    private static final long MILLIBUCKETS = FluidHelper.getBucket() / 1000L;

    public ScrollablePhantomFluidWidget() {
    }

    public ScrollablePhantomFluidWidget(IFluidStorage fluidTank, int x, int y) {
        super(fluidTank, x, y);
    }

    public ScrollablePhantomFluidWidget(@Nullable IFluidStorage fluidTank, int x, int y, int width, int height) {
        super(fluidTank, x, y, width, height);
    }

    @Environment(value=EnvType.CLIENT)
    public boolean mouseWheelMove(double mouseX, double mouseY, double wheelDelta) {
        if (!this.isMouseOverElement(mouseX, mouseY)) {
            return false;
        }
        long delta = this.getModifiedChangeAmount(wheelDelta > 0.0 ? 1 : -1) * MILLIBUCKETS;
        this.writeClientAction(65537, buf -> buf.writeLong(delta));
        return true;
    }

    private long getModifiedChangeAmount(int amount) {
        if (GTUtil.isShiftDown()) {
            amount *= 10;
        }
        if (GTUtil.isCtrlDown()) {
            amount *= 100;
        }
        if (!GTUtil.isAltDown()) {
            amount *= 1000;
        }
        return amount;
    }

    public void handleClientAction(int id, class_2540 buffer) {
        switch (id) {
            case 65537: {
                this.handleScrollAction(buffer.readLong());
                break;
            }
            default: {
                super.handleClientAction(id, buffer);
            }
        }
        this.detectAndSendChanges();
    }

    private void handleScrollAction(long delta) {
        IFluidStorage tank = this.getFluidTank();
        if (tank == null) {
            return;
        }
        FluidStack fluid = tank.getFluid();
        if (fluid.isEmpty()) {
            return;
        }
        if (fluid.isEmpty()) {
            return;
        }
        fluid.setAmount(Math.min(Math.max(fluid.getAmount() + delta, 0L), tank.getCapacity()));
        if (fluid.getAmount() <= 0L) {
            tank.setFluid(FluidStack.empty());
        }
    }
}

