/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.worldgen;

import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.worldgen.BiomeWeightModifier;
import com.gregtechceu.gtceu.api.data.worldgen.IWorldGenLayer;
import com.gregtechceu.gtceu.api.data.worldgen.WorldGeneratorUtils;
import com.gregtechceu.gtceu.api.data.worldgen.generator.IndicatorGenerator;
import com.gregtechceu.gtceu.api.data.worldgen.generator.VeinGenerator;
import com.gregtechceu.gtceu.api.data.worldgen.generator.indicators.SurfaceIndicatorGenerator;
import com.gregtechceu.gtceu.api.data.worldgen.generator.veins.DikeVeinGenerator;
import com.gregtechceu.gtceu.api.data.worldgen.generator.veins.GeodeVeinGenerator;
import com.gregtechceu.gtceu.api.data.worldgen.generator.veins.LayeredVeinGenerator;
import com.gregtechceu.gtceu.api.data.worldgen.generator.veins.StandardVeinGenerator;
import com.gregtechceu.gtceu.api.data.worldgen.generator.veins.VeinedVeinGenerator;
import com.gregtechceu.gtceu.api.data.worldgen.ores.OreVeinUtil;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5843;
import net.minecraft.class_6328;
import net.minecraft.class_6795;
import net.minecraft.class_6862;
import net.minecraft.class_6885;
import net.minecraft.class_6895;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

@class_6328
@ParametersAreNonnullByDefault
public class GTOreDefinition {
    public static final Codec<GTOreDefinition> CODEC = class_2960.field_25139.flatXmap(rl -> Optional.ofNullable((GTOreDefinition)GTRegistries.ORE_VEINS.get(rl)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "No GTOreDefinition with id " + rl + " registered")), obj -> Optional.ofNullable((class_2960)GTRegistries.ORE_VEINS.getKey((GTOreDefinition)obj)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "GTOreDefinition " + obj + " not registered")));
    public static final Codec<GTOreDefinition> FULL_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("cluster_size").forGetter(ft -> ft.clusterSize), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("density").forGetter(ft -> Float.valueOf(ft.density)), (App)Codec.INT.fieldOf("weight").forGetter(ft -> ft.weight), (App)IWorldGenLayer.CODEC.fieldOf("layer").forGetter(ft -> ft.layer), (App)class_5321.method_39154((class_5321)class_7924.field_41223).listOf().fieldOf("dimension_filter").forGetter(ft -> new ArrayList<class_5321<class_1937>>(ft.dimensionFilter)), (App)class_6795.field_35725.fieldOf("height_range").forGetter(ft -> ft.range), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("discard_chance_on_air_exposure").forGetter(ft -> Float.valueOf(ft.discardChanceOnAirExposure)), (App)class_6895.method_40340((class_5321)class_7924.field_41236).optionalFieldOf("biomes", null).forGetter(ext -> ext.biomes == null ? null : ext.biomes.get()), (App)BiomeWeightModifier.CODEC.optionalFieldOf("weight_modifier", null).forGetter(ext -> ext.biomeWeightModifier), (App)VeinGenerator.DIRECT_CODEC.fieldOf("generator").forGetter(ft -> ft.veinGenerator), (App)Codec.list(IndicatorGenerator.DIRECT_CODEC).fieldOf("indicators").forGetter(ft -> ft.indicatorGenerators)).apply((Applicative)instance, (clusterSize, density, weight, layer, dimensionFilter, range, discardChanceOnAirExposure, biomes, biomeWeightModifier, veinGenerator, indicatorGenerators) -> new GTOreDefinition((int)clusterSize, density.floatValue(), (int)weight, (IWorldGenLayer)layer, (Set<class_5321<class_1937>>)new HashSet<class_5321<class_1937>>((Collection<class_5321<class_1937>>)dimensionFilter), (class_6795)range, discardChanceOnAirExposure.floatValue(), biomes == null ? null : () -> biomes, (BiomeWeightModifier)biomeWeightModifier, (VeinGenerator)veinGenerator, (List<IndicatorGenerator>)indicatorGenerators)));
    private final InferredProperties inferredProperties = new InferredProperties();
    private int clusterSize;
    private float density;
    private int weight;
    private IWorldGenLayer layer;
    private Set<class_5321<class_1937>> dimensionFilter;
    private class_6795 range;
    private float discardChanceOnAirExposure;
    private Supplier<class_6885<class_1959>> biomes;
    private BiomeWeightModifier biomeWeightModifier;
    private VeinGenerator veinGenerator;
    private List<IndicatorGenerator> indicatorGenerators;
    private int minimumYield;
    private int maximumYield;
    private int depletedYield;
    private int depletionChance;
    private int depletionAmount = 1;
    private List<Map.Entry<Integer, Material>> bedrockVeinMaterial;

    public GTOreDefinition(GTOreDefinition other) {
        this(other.clusterSize, other.density, other.weight, other.layer, Set.copyOf(other.dimensionFilter), other.range, other.discardChanceOnAirExposure, other.biomes, other.biomeWeightModifier, other.veinGenerator, List.copyOf(other.indicatorGenerators));
    }

    public GTOreDefinition(int clusterSize, float density, int weight, IWorldGenLayer layer, Set<class_5321<class_1937>> dimensionFilter, class_6795 range, float discardChanceOnAirExposure, @Nullable Supplier<class_6885<class_1959>> biomes, @Nullable BiomeWeightModifier biomeWeightModifier, @Nullable VeinGenerator veinGenerator, @Nullable List<IndicatorGenerator> indicatorGenerators) {
        this.clusterSize = clusterSize;
        this.density = density;
        this.weight = weight;
        this.layer = layer;
        this.dimensionFilter = dimensionFilter;
        this.range = range;
        this.discardChanceOnAirExposure = discardChanceOnAirExposure;
        this.biomes = biomes;
        this.biomeWeightModifier = biomeWeightModifier;
        this.veinGenerator = veinGenerator;
        this.indicatorGenerators = Objects.requireNonNullElseGet(indicatorGenerators, ArrayList::new);
        this.recomputeBedrockOres();
    }

    @HideFromJS
    public void register(class_2960 id) {
        if (GTRegistries.ORE_VEINS.containKey(id)) {
            GTRegistries.ORE_VEINS.replace(id, this);
        } else {
            GTRegistries.ORE_VEINS.register(id, this);
        }
    }

    private void recomputeBedrockOres() {
        this.maximumYield = (int)(this.density * 100.0f) * this.clusterSize;
        this.minimumYield = this.maximumYield / 7;
        this.depletedYield = (int)((float)this.clusterSize / this.density / 10.0f);
        this.depletionChance = (int)((float)this.weight * this.density / 5.0f);
    }

    public GTOreDefinition clusterSize(int clusterSize) {
        this.clusterSize = clusterSize;
        this.recomputeBedrockOres();
        return this;
    }

    public GTOreDefinition density(float density) {
        this.density = density;
        this.recomputeBedrockOres();
        return this;
    }

    public GTOreDefinition weight(int weight) {
        this.weight = weight;
        this.recomputeBedrockOres();
        return this;
    }

    public GTOreDefinition layer(IWorldGenLayer layer) {
        this.layer = layer;
        if (this.dimensionFilter == null || this.dimensionFilter.isEmpty()) {
            this.dimensions((class_2960[])layer.getLevels().toArray(class_2960[]::new));
        }
        return this;
    }

    public GTOreDefinition dimensions(class_2960 ... dimensions) {
        this.dimensionFilter = Arrays.stream(dimensions).map(location -> class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)location)).collect(Collectors.toSet());
        return this;
    }

    public GTOreDefinition biomes(String first, String ... biomes) {
        List<String> biomeList = Stream.of(Stream.of(first), Arrays.stream(biomes)).flatMap(Function.identity()).toList();
        this.biomes = OreVeinUtil.resolveBiomes(biomeList);
        return this;
    }

    public GTOreDefinition biomes(class_6862<class_1959> biomes) {
        this.biomes = () -> GTRegistries.builtinRegistry().method_46762(class_7924.field_41236).method_46735(biomes);
        return this;
    }

    public GTOreDefinition biomes(Supplier<class_6885<class_1959>> biomes) {
        this.biomes = biomes;
        return this;
    }

    public GTOreDefinition heightRangeUniform(int min, int max) {
        this.heightRange(class_6795.method_39634((class_5843)class_5843.method_33841((int)min), (class_5843)class_5843.method_33841((int)max)));
        this.inferredProperties.heightRange = Pair.of((Object)min, (Object)max);
        return this;
    }

    public GTOreDefinition heightRangeTriangle(int min, int max) {
        this.heightRange(class_6795.method_39637((class_5843)class_5843.method_33841((int)min), (class_5843)class_5843.method_33841((int)max)));
        this.inferredProperties.heightRange = Pair.of((Object)min, (Object)max);
        return this;
    }

    public GTOreDefinition heightRange(class_6795 range) {
        this.range = range;
        return this;
    }

    public GTOreDefinition standardVeinGenerator(Consumer<StandardVeinGenerator> config) {
        StandardVeinGenerator veinGenerator = new StandardVeinGenerator(this);
        config.accept(veinGenerator);
        this.veinGenerator = veinGenerator;
        return this;
    }

    public GTOreDefinition layeredVeinGenerator(Consumer<LayeredVeinGenerator> config) {
        LayeredVeinGenerator veinGenerator = new LayeredVeinGenerator(this);
        config.accept(veinGenerator);
        this.veinGenerator = veinGenerator;
        return this;
    }

    public GTOreDefinition geodeVeinGenerator(Consumer<GeodeVeinGenerator> config) {
        GeodeVeinGenerator veinGenerator = new GeodeVeinGenerator(this);
        config.accept(veinGenerator);
        this.veinGenerator = veinGenerator;
        return this;
    }

    public GTOreDefinition dikeVeinGenerator(Consumer<DikeVeinGenerator> config) {
        DikeVeinGenerator veinGenerator = new DikeVeinGenerator(this);
        if (this.inferredProperties.heightRange != null) {
            veinGenerator.minYLevel((Integer)this.inferredProperties.heightRange.getFirst());
            veinGenerator.maxYLevel((Integer)this.inferredProperties.heightRange.getSecond());
        }
        config.accept(veinGenerator);
        this.veinGenerator = veinGenerator;
        return this;
    }

    public GTOreDefinition veinedVeinGenerator(Consumer<VeinedVeinGenerator> config) {
        VeinedVeinGenerator veinGenerator = new VeinedVeinGenerator(this);
        if (this.inferredProperties.heightRange != null) {
            veinGenerator.minYLevel((Integer)this.inferredProperties.heightRange.getFirst());
            veinGenerator.maxYLevel((Integer)this.inferredProperties.heightRange.getSecond());
        }
        config.accept(veinGenerator);
        this.veinGenerator = veinGenerator;
        return this;
    }

    @Nullable
    public VeinGenerator veinGenerator(class_2960 id) {
        if (this.veinGenerator == null) {
            this.veinGenerator = WorldGeneratorUtils.VEIN_GENERATOR_FUNCTIONS.containsKey((Object)id) ? (VeinGenerator)((Function)WorldGeneratorUtils.VEIN_GENERATOR_FUNCTIONS.get((Object)id)).apply(this) : null;
        }
        return this.veinGenerator;
    }

    public GTOreDefinition surfaceIndicatorGenerator(Consumer<SurfaceIndicatorGenerator> config) {
        config.accept(this.getOrCreateIndicatorGenerator(SurfaceIndicatorGenerator.class, SurfaceIndicatorGenerator::new));
        return this;
    }

    private <T extends IndicatorGenerator> T getOrCreateIndicatorGenerator(Class<T> indicatorClass, Function<GTOreDefinition, T> constructor) {
        IndicatorGenerator existingGenerator = this.indicatorGenerators.stream().filter(indicatorClass::isInstance).map(indicatorClass::cast).findFirst().orElse(null);
        if (existingGenerator != null) {
            return (T)existingGenerator;
        }
        IndicatorGenerator generator = (IndicatorGenerator)constructor.apply(this);
        this.indicatorGenerators.add(generator);
        return (T)generator;
    }

    @HideFromJS
    public List<Map.Entry<Integer, Material>> getBedrockVeinMaterials() {
        if (this.bedrockVeinMaterial == null) {
            this.bedrockVeinMaterial = ConfigHolder.INSTANCE.machines.doBedrockOres ? this.veinGenerator().getValidMaterialsChances() : List.of();
        }
        return this.bedrockVeinMaterial;
    }

    public int clusterSize() {
        return this.clusterSize;
    }

    public float density() {
        return this.density;
    }

    public int weight() {
        return this.weight;
    }

    public IWorldGenLayer layer() {
        return this.layer;
    }

    public Set<class_5321<class_1937>> dimensionFilter() {
        return this.dimensionFilter;
    }

    public GTOreDefinition dimensionFilter(Set<class_5321<class_1937>> dimensionFilter) {
        this.dimensionFilter = dimensionFilter;
        return this;
    }

    public class_6795 range() {
        return this.range;
    }

    public GTOreDefinition range(class_6795 range) {
        this.range = range;
        return this;
    }

    public float discardChanceOnAirExposure() {
        return this.discardChanceOnAirExposure;
    }

    public GTOreDefinition discardChanceOnAirExposure(float discardChanceOnAirExposure) {
        this.discardChanceOnAirExposure = discardChanceOnAirExposure;
        return this;
    }

    public Supplier<class_6885<class_1959>> biomes() {
        return this.biomes;
    }

    public BiomeWeightModifier biomeWeightModifier() {
        return this.biomeWeightModifier;
    }

    public GTOreDefinition biomeWeightModifier(BiomeWeightModifier biomeWeightModifier) {
        this.biomeWeightModifier = biomeWeightModifier;
        return this;
    }

    public VeinGenerator veinGenerator() {
        return this.veinGenerator;
    }

    public GTOreDefinition veinGenerator(VeinGenerator veinGenerator) {
        this.veinGenerator = veinGenerator;
        return this;
    }

    public List<IndicatorGenerator> indicatorGenerators() {
        return this.indicatorGenerators;
    }

    public GTOreDefinition indicatorGenerators(List<IndicatorGenerator> indicatorGenerators) {
        this.indicatorGenerators = indicatorGenerators;
        return this;
    }

    public int minimumYield() {
        return this.minimumYield;
    }

    public int maximumYield() {
        return this.maximumYield;
    }

    public int depletedYield() {
        return this.depletedYield;
    }

    public int depletionChance() {
        return this.depletionChance;
    }

    public int depletionAmount() {
        return this.depletionAmount;
    }

    public GTOreDefinition minimumYield(int minimumYield) {
        this.minimumYield = minimumYield;
        return this;
    }

    public GTOreDefinition maximumYield(int maximumYield) {
        this.maximumYield = maximumYield;
        return this;
    }

    public GTOreDefinition depletedYield(int depletedYield) {
        this.depletedYield = depletedYield;
        return this;
    }

    public GTOreDefinition depletionChance(int depletionChance) {
        this.depletionChance = depletionChance;
        return this;
    }

    public GTOreDefinition depletionAmount(int depletionAmount) {
        this.depletionAmount = depletionAmount;
        return this;
    }

    public GTOreDefinition bedrockVeinMaterial(List<Map.Entry<Integer, Material>> bedrockVeinMaterial) {
        this.bedrockVeinMaterial = bedrockVeinMaterial;
        return this;
    }

    private static class InferredProperties {
        public Pair<Integer, Integer> heightRange = null;

        private InferredProperties() {
        }
    }
}

