/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.worldgen;

import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_3124;
import net.minecraft.class_3825;
import net.minecraft.class_5819;

public class GTLayerPattern {
    public static final Codec<GTLayerPattern> CODEC = Codec.list(Layer.CODEC).xmap(GTLayerPattern::new, pattern -> pattern.layers);
    public final List<Layer> layers;

    public GTLayerPattern(List<Layer> layers) {
        this.layers = layers;
    }

    public Layer rollNext(@Nullable Layer previous, class_5819 random) {
        int totalWeight = 0;
        for (Layer layer : this.layers) {
            if (layer == previous) continue;
            totalWeight += layer.weight;
        }
        int rolled = random.method_43048(totalWeight);
        for (Layer layer : this.layers) {
            if (layer == previous || (rolled -= layer.weight) >= 0) continue;
            return layer;
        }
        return null;
    }

    public static Builder builder(class_3825 ... rules) {
        return new Builder(rules);
    }

    public static class Layer {
        public static final Codec<Layer> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.list((Codec)Codec.either((Codec)class_3124.class_5876.field_29067.listOf(), GTRegistries.MATERIALS.codec())).fieldOf("targets").forGetter(layer -> layer.targets), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).fieldOf("min_size").forGetter(layer -> layer.minSize), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).fieldOf("max_size").forGetter(layer -> layer.maxSize), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).fieldOf("weight").forGetter(layer -> layer.weight)).apply((Applicative)instance, Layer::new));
        public final List<Either<List<class_3124.class_5876>, Material>> targets;
        public final int minSize;
        public final int maxSize;
        public final int weight;

        public Layer(List<Either<List<class_3124.class_5876>, Material>> targets, int minSize, int maxSize, int weight) {
            this.targets = targets;
            this.minSize = minSize;
            this.maxSize = maxSize;
            this.weight = weight;
        }

        public Either<List<class_3124.class_5876>, Material> rollBlock(class_5819 random) {
            if (this.targets.size() == 1) {
                return this.targets.get(0);
            }
            return this.targets.get(random.method_43048(this.targets.size()));
        }

        public static class Builder {
            private final List<Either<List<class_3124.class_5876>, Material>> targets = new ArrayList<Either<List<class_3124.class_5876>, Material>>();
            private int minSize = 1;
            private int maxSize = 1;
            private int weight = 1;
            private final class_3825[] rules;

            protected Builder(class_3825 ... rules) {
                this.rules = rules;
            }

            public Builder block(Supplier<? extends class_2248> block) {
                return this.state(block.get().method_9564());
            }

            public Builder state(Supplier<? extends class_2680> state) {
                return this.state(state.get());
            }

            public Builder state(class_2680 state) {
                this.targets.add((Either<List<class_3124.class_5876>, Material>)Either.left(Arrays.stream(this.rules).map(rule -> class_3124.method_33994((class_3825)rule, (class_2680)state)).toList()));
                return this;
            }

            public Builder mat(Material material) {
                this.targets.add((Either<List<class_3124.class_5876>, Material>)Either.right((Object)material));
                return this;
            }

            public Builder weight(int weight) {
                this.weight = weight;
                return this;
            }

            public Builder size(int min, int max) {
                this.minSize = min;
                this.maxSize = max;
                return this;
            }

            public Layer build() {
                return new Layer(this.targets, this.minSize, this.maxSize, this.weight);
            }
        }
    }

    public static class Builder {
        private final List<Layer> layers = new ArrayList<Layer>();
        private final class_3825[] rules;

        protected Builder(class_3825 ... rules) {
            this.rules = rules;
        }

        public Builder layer(Consumer<Layer.Builder> builder) {
            Layer.Builder layerBuilder = new Layer.Builder(this.rules);
            builder.accept(layerBuilder);
            this.layers.add(layerBuilder.build());
            return this;
        }

        public GTLayerPattern build() {
            return new GTLayerPattern(this.layers);
        }
    }
}

