/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.tag;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Table;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.addon.AddonFinder;
import com.gregtechceu.gtceu.api.addon.IGTAddon;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.info.MaterialFlags;
import com.gregtechceu.gtceu.api.data.chemical.material.info.MaterialIconType;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.IMaterialProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialStack;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.UnificationEntry;
import com.gregtechceu.gtceu.api.data.tag.TagType;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.common.data.GTBlocks;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.integration.kjs.GTRegistryObjectBuilderTypes;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.lowdragmc.lowdraglib.Platform;
import com.lowdragmc.lowdraglib.utils.LocalizationUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2498;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_3620;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import org.apache.logging.log4j.util.TriConsumer;

public class TagPrefix {
    public static final Map<String, TagPrefix> PREFIXES = new HashMap<String, TagPrefix>();
    public static final Map<TagPrefix, OreType> ORES = new HashMap<TagPrefix, OreType>();
    public static final Codec<TagPrefix> CODEC = Codec.STRING.flatXmap(str -> Optional.ofNullable(TagPrefix.get(str)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "invalid TagPrefix: " + str)), prefix -> DataResult.success((Object)prefix.name));
    public static final TagPrefix ore = TagPrefix.oreTagPrefix("stone").langValue("%s Ore").materialIconType(MaterialIconType.ore).miningToolTag((class_6862<class_2248>)class_3481.field_33715).unificationEnabled(true).generationCondition(Conditions.hasOreProperty).registerOre(() -> ((class_2248)class_2246.field_10340).method_9564());
    public static final TagPrefix oreGranite = TagPrefix.oreTagPrefix("granite").langValue("Granite %s Ore").materialIconType(MaterialIconType.ore).miningToolTag((class_6862<class_2248>)class_3481.field_33715).unificationEnabled(true).generationCondition(Conditions.hasOreProperty).registerOre(() -> ((class_2248)class_2246.field_10474).method_9564());
    public static final TagPrefix oreDiorite = TagPrefix.oreTagPrefix("diorite").langValue("Diorite %s Ore").materialIconType(MaterialIconType.ore).miningToolTag((class_6862<class_2248>)class_3481.field_33715).unificationEnabled(true).generationCondition(Conditions.hasOreProperty).registerOre(() -> ((class_2248)class_2246.field_10508).method_9564());
    public static final TagPrefix oreAndesite = TagPrefix.oreTagPrefix("andesite").langValue("Andesite %s Ore").materialIconType(MaterialIconType.ore).miningToolTag((class_6862<class_2248>)class_3481.field_33715).unificationEnabled(true).generationCondition(Conditions.hasOreProperty).registerOre(() -> ((class_2248)class_2246.field_10115).method_9564());
    public static final TagPrefix oreDeepslate = TagPrefix.oreTagPrefix("deepslate").langValue("Deepslate %s Ore").materialIconType(MaterialIconType.ore).miningToolTag((class_6862<class_2248>)class_3481.field_33715).unificationEnabled(true).generationCondition(Conditions.hasOreProperty).registerOre(() -> ((class_2248)class_2246.field_28888).method_9564());
    public static final TagPrefix oreTuff = TagPrefix.oreTagPrefix("tuff").langValue("Tuff %s Ore").materialIconType(MaterialIconType.ore).miningToolTag((class_6862<class_2248>)class_3481.field_33715).unificationEnabled(true).generationCondition(Conditions.hasOreProperty).registerOre(() -> ((class_2248)class_2246.field_27165).method_9564());
    public static final TagPrefix oreSand = TagPrefix.oreTagPrefix("sand").langValue("Sand %s Ore").materialIconType(MaterialIconType.ore).miningToolTag((class_6862<class_2248>)class_3481.field_33716).unificationEnabled(true).generationCondition(Conditions.hasOreProperty).registerOre(() -> ((class_2248)class_2246.field_10102).method_9564(), false, class_3620.field_15986, class_2498.field_11526, true);
    public static final TagPrefix oreRedSand = TagPrefix.oreTagPrefix("redSand").langValue("Red Sand %s Ore").materialIconType(MaterialIconType.ore).miningToolTag((class_6862<class_2248>)class_3481.field_33716).unificationEnabled(true).generationCondition(Conditions.hasOreProperty).registerOre(() -> ((class_2248)class_2246.field_10534).method_9564(), false, class_3620.field_15987, class_2498.field_11526, true);
    public static final TagPrefix oreGravel = TagPrefix.oreTagPrefix("gravel").langValue("Gravel %s Ore").materialIconType(MaterialIconType.ore).miningToolTag((class_6862<class_2248>)class_3481.field_33716).unificationEnabled(true).generationCondition(Conditions.hasOreProperty).registerOre(() -> ((class_2248)class_2246.field_10255).method_9564(), false, class_3620.field_16023, class_2498.field_11529, true);
    public static final TagPrefix oreBasalt = TagPrefix.oreTagPrefix("basalt").langValue("Basalt %s Ore").materialIconType(MaterialIconType.ore).miningToolTag((class_6862<class_2248>)class_3481.field_33715).unificationEnabled(true).generationCondition(Conditions.hasOreProperty).registerOre(() -> ((class_2248)class_2246.field_22091).method_9564(), true, class_3620.field_16009);
    public static final TagPrefix oreNetherrack = TagPrefix.oreTagPrefix("netherrack").langValue("Nether %s Ore").materialIconType(MaterialIconType.ore).miningToolTag((class_6862<class_2248>)class_3481.field_33715).unificationEnabled(true).generationCondition(Conditions.hasOreProperty).registerOre(() -> ((class_2248)class_2246.field_10515).method_9564(), true, class_3620.field_16012);
    public static final TagPrefix oreEndstone = TagPrefix.oreTagPrefix("endstone").langValue("End %s Ore").materialIconType(MaterialIconType.ore).miningToolTag((class_6862<class_2248>)class_3481.field_33715).unificationEnabled(true).generationCondition(Conditions.hasOreProperty).registerOre(() -> ((class_2248)class_2246.field_10471).method_9564(), true, class_3620.field_15986);
    public static final TagPrefix rawOre = new TagPrefix("raw", true).defaultTagPath(LoaderType.FORGE, "raw_materials/%s").defaultTagPath(LoaderType.FABRIC, "raw_%s_ores").unformattedTagPath(LoaderType.FORGE, "raw_materials").unformattedTagPath(LoaderType.FABRIC, "raw_ores").langValue("Raw %s").materialIconType(MaterialIconType.rawOre).unificationEnabled(true).generateItem(true).generationCondition(Conditions.hasOreProperty);
    public static final TagPrefix rawOreBlock = new TagPrefix("rawOreBlock").defaultTagPath(LoaderType.FORGE, "storage_blocks/raw_%s").defaultTagPath(LoaderType.FABRIC, "raw_%s_blocks").langValue("Block of Raw %s").materialIconType(MaterialIconType.rawOreBlock).miningToolTag((class_6862<class_2248>)class_3481.field_33715).unificationEnabled(true).generationCondition(Conditions.hasOreProperty);
    public static final TagPrefix crushedRefined = new TagPrefix("refinedOre").defaultTagPath(LoaderType.FORGE, "refined_ores/%s").defaultTagPath(LoaderType.FABRIC, "%s_refined_ores").defaultTagPath(LoaderType.FORGE, "refined_ores").defaultTagPath(LoaderType.FABRIC, "refined_ores").langValue("Refined %s Ore").materialIconType(MaterialIconType.crushedRefined).unificationEnabled(true).generateItem(true).generationCondition(Conditions.hasOreProperty);
    public static final TagPrefix crushedPurified = new TagPrefix("purifiedOre").defaultTagPath(LoaderType.FORGE, "purified_ores/%s").defaultTagPath(LoaderType.FABRIC, "%s_purified_ores").defaultTagPath(LoaderType.FORGE, "purified_ores").defaultTagPath(LoaderType.FABRIC, "purified_ores").langValue("Purified %s Ore").materialIconType(MaterialIconType.crushedPurified).unificationEnabled(true).generateItem(true).generationCondition(Conditions.hasOreProperty);
    public static final TagPrefix crushed = new TagPrefix("crushedOre").defaultTagPath(LoaderType.FORGE, "crushed_ores/%s").defaultTagPath(LoaderType.FABRIC, "%s_crushed_ores").unformattedTagPath(LoaderType.FORGE, "crushed_ores").unformattedTagPath(LoaderType.FABRIC, "crushed_ores").langValue("Crushed %s Ore").materialIconType(MaterialIconType.crushed).unificationEnabled(true).generateItem(true).generationCondition(Conditions.hasOreProperty).tooltip((mat, tooltips) -> tooltips.add(class_2561.method_43471((String)"metaitem.crushed.tooltip.purify")));
    public static final TagPrefix ingotHot = new TagPrefix("hotIngot").defaultTagPath(LoaderType.FORGE, "hot_ingots/%s").defaultTagPath(LoaderType.FABRIC, "%s_hot_ingots").unformattedTagPath(LoaderType.FORGE, "hot_ingots").unformattedTagPath(LoaderType.FABRIC, "hot_ingots").langValue("Hot %s Ingot").materialAmount(3628800L).materialIconType(MaterialIconType.ingotHot).unificationEnabled(true).generateItem(true).generationCondition(Conditions.hasBlastProperty.and(mat -> mat.getProperty(PropertyKey.BLAST).getBlastTemperature() > 1750));
    public static final TagPrefix ingot = new TagPrefix("ingot").defaultTagPath(LoaderType.FORGE, "ingots/%s").defaultTagPath(LoaderType.FABRIC, "%s_ingots").unformattedTagPath(LoaderType.FORGE, "ingots").unformattedTagPath(LoaderType.FABRIC, "ingots").materialAmount(3628800L).materialIconType(MaterialIconType.ingot).unificationEnabled(true).generateItem(true).generationCondition(Conditions.hasIngotProperty);
    public static final TagPrefix gem = new TagPrefix("gem").defaultTagPath(LoaderType.FORGE, "gems/%s").defaultTagPath(LoaderType.FABRIC, "%s_gems").unformattedTagPath(LoaderType.FORGE, "gems").unformattedTagPath(LoaderType.FABRIC, "gems").langValue("%s").materialAmount(3628800L).materialIconType(MaterialIconType.gem).unificationEnabled(true).generateItem(true).generationCondition(Conditions.hasGemProperty);
    public static final TagPrefix gemChipped = new TagPrefix("chippedGem").defaultTagPath(LoaderType.FORGE, "chipped_gems/%s").defaultTagPath(LoaderType.FABRIC, "%s_chipped_gems").unformattedTagPath(LoaderType.FORGE, "chipped_gems").unformattedTagPath(LoaderType.FABRIC, "chipped_gems").langValue("Chipped %s").materialAmount(907200L).materialIconType(MaterialIconType.gemChipped).unificationEnabled(true).generateItem(true).generationCondition(Conditions.hasGemProperty.and(unused -> ConfigHolder.INSTANCE.recipes.generateLowQualityGems));
    public static final TagPrefix gemFlawed = new TagPrefix("flawedGem").defaultTagPath(LoaderType.FORGE, "flawed_gems/%s").defaultTagPath(LoaderType.FABRIC, "%s_flawed_gems").unformattedTagPath(LoaderType.FORGE, "flawed_gems").unformattedTagPath(LoaderType.FABRIC, "flawed_gems").langValue("Flawed %s").materialAmount(1814400L).materialIconType(MaterialIconType.gemFlawed).unificationEnabled(true).generateItem(true).generationCondition(Conditions.hasGemProperty.and(unused -> ConfigHolder.INSTANCE.recipes.generateLowQualityGems));
    public static final TagPrefix gemFlawless = new TagPrefix("flawlessGem").defaultTagPath(LoaderType.FORGE, "flawless_gems/%s").defaultTagPath(LoaderType.FABRIC, "%s_flawless_gems").unformattedTagPath(LoaderType.FORGE, "flawless_gems").unformattedTagPath(LoaderType.FABRIC, "flawless_gems").langValue("Flawless %s").materialAmount(7257600L).maxStackSize(32).materialIconType(MaterialIconType.gemFlawless).unificationEnabled(true).generateItem(true).generationCondition(Conditions.hasGemProperty);
    public static final TagPrefix gemExquisite = new TagPrefix("exquisiteGem").defaultTagPath(LoaderType.FORGE, "exquisite_gems/%s").defaultTagPath(LoaderType.FABRIC, "%s_exquisite_gems").unformattedTagPath(LoaderType.FORGE, "exquisite_gems").unformattedTagPath(LoaderType.FABRIC, "exquisite_gems").langValue("Exquisite %s").materialAmount(14515200L).maxStackSize(16).materialIconType(MaterialIconType.gemExquisite).unificationEnabled(true).generateItem(true).generationCondition(Conditions.hasGemProperty);
    public static final TagPrefix dustSmall = new TagPrefix("smallDust").defaultTagPath(LoaderType.FORGE, "small_dusts/%s").defaultTagPath(LoaderType.FABRIC, "%s_small_dusts").unformattedTagPath(LoaderType.FORGE, "small_dusts").unformattedTagPath(LoaderType.FABRIC, "small_dusts").langValue("Small Pile of %s Dust").materialAmount(907200L).materialIconType(MaterialIconType.dustSmall).unificationEnabled(true).generateItem(true).generationCondition(Conditions.hasDustProperty);
    public static final TagPrefix dustTiny = new TagPrefix("tinyDust").defaultTagPath(LoaderType.FORGE, "tiny_dusts/%s").defaultTagPath(LoaderType.FABRIC, "%s_tiny_dusts").unformattedTagPath(LoaderType.FORGE, "tiny_dusts").unformattedTagPath(LoaderType.FABRIC, "tiny_dusts").langValue("Tiny Pile of %s Dust").materialAmount(403200L).materialIconType(MaterialIconType.dustTiny).unificationEnabled(true).generateItem(true).generationCondition(Conditions.hasDustProperty);
    public static final TagPrefix dustImpure = new TagPrefix("impureDust").defaultTagPath(LoaderType.FORGE, "impure_dusts/%s").defaultTagPath(LoaderType.FABRIC, "%s_impure_dusts").unformattedTagPath(LoaderType.FORGE, "impure_dusts").unformattedTagPath(LoaderType.FABRIC, "impure_dusts").langValue("Impure Pile of %s Dust").materialAmount(3628800L).materialIconType(MaterialIconType.dustImpure).unificationEnabled(true).generateItem(true).generationCondition(Conditions.hasOreProperty).tooltip((mat, tooltips) -> tooltips.add(class_2561.method_43471((String)"metaitem.dust.tooltip.purify")));
    public static final TagPrefix dustPure = new TagPrefix("pureDust").defaultTagPath(LoaderType.FORGE, "pure_dusts/%s").defaultTagPath(LoaderType.FABRIC, "%s_pure_dusts").unformattedTagPath(LoaderType.FORGE, "pure_dusts").unformattedTagPath(LoaderType.FABRIC, "pure_dusts").langValue("Purified Pile of %s Dust").materialAmount(3628800L).materialIconType(MaterialIconType.dustPure).unificationEnabled(true).generateItem(true).generationCondition(Conditions.hasOreProperty).tooltip((mat, tooltips) -> tooltips.add(class_2561.method_43471((String)"metaitem.dust.tooltip.purify")));
    public static final TagPrefix dust = new TagPrefix("dust").defaultTagPath(LoaderType.FORGE, "dusts/%s").defaultTagPath(LoaderType.FABRIC, "%s_dusts").unformattedTagPath(LoaderType.FORGE, "dusts").unformattedTagPath(LoaderType.FABRIC, "dusts").materialAmount(3628800L).materialIconType(MaterialIconType.dust).unificationEnabled(true).generateItem(true).generationCondition(Conditions.hasDustProperty);
    public static final TagPrefix nugget = new TagPrefix("nugget").defaultTagPath(LoaderType.FORGE, "nuggets/%s").defaultTagPath(LoaderType.FABRIC, "%s_nuggets").unformattedTagPath(LoaderType.FORGE, "nuggets").unformattedTagPath(LoaderType.FABRIC, "nuggets").materialAmount(403200L).materialIconType(MaterialIconType.nugget).unificationEnabled(true).generateItem(true).generationCondition(Conditions.hasIngotProperty);
    public static final TagPrefix plateDense = new TagPrefix("densePlate").defaultTagPath(LoaderType.FORGE, "dense_plates/%s").defaultTagPath(LoaderType.FABRIC, "%s_dense_plates").unformattedTagPath(LoaderType.FORGE, "dense_plates").unformattedTagPath(LoaderType.FABRIC, "dense_plates").langValue("Dense %s Plate").materialAmount(32659200L).maxStackSize(7).materialIconType(MaterialIconType.plateDense).unificationEnabled(true).generateItem(true).generationCondition(mat -> mat.hasFlag(MaterialFlags.GENERATE_DENSE) && !mat.hasFlag(MaterialFlags.NO_SMASHING));
    public static final TagPrefix plateDouble = new TagPrefix("doublePlate").defaultTagPath(LoaderType.FORGE, "double_plates/%s").defaultTagPath(LoaderType.FABRIC, "%s_double_plates").unformattedTagPath(LoaderType.FORGE, "double_plates").unformattedTagPath(LoaderType.FABRIC, "double_plates").langValue("Double %s Plate").materialAmount(7257600L).maxStackSize(32).materialIconType(MaterialIconType.plateDouble).unificationEnabled(true).generateItem(true).generationCondition(Conditions.hasIngotProperty.and(mat -> mat.hasFlag(MaterialFlags.GENERATE_PLATE) && !mat.hasFlag(MaterialFlags.NO_SMASHING)));
    public static final TagPrefix plate = new TagPrefix("plate").defaultTagPath(LoaderType.FORGE, "plates/%s").defaultTagPath(LoaderType.FABRIC, "%s_plates").unformattedTagPath(LoaderType.FORGE, "plates").unformattedTagPath(LoaderType.FABRIC, "plates").materialAmount(3628800L).materialIconType(MaterialIconType.plate).unificationEnabled(true).generateItem(true).generationCondition(mat -> mat.hasFlag(MaterialFlags.GENERATE_PLATE));
    public static final TagPrefix round = new TagPrefix("round").defaultTagPath(LoaderType.FORGE, "rounds/%s").defaultTagPath(LoaderType.FABRIC, "%s_rounds").unformattedTagPath(LoaderType.FORGE, "rounds").unformattedTagPath(LoaderType.FABRIC, "rounds").materialAmount(403200L).materialIconType(MaterialIconType.round).unificationEnabled(true).generateItem(true).generationCondition(mat -> mat.hasFlag(MaterialFlags.GENERATE_ROUND));
    public static final TagPrefix foil = new TagPrefix("foil").defaultTagPath(LoaderType.FORGE, "foils/%s").defaultTagPath(LoaderType.FABRIC, "%s_foils").unformattedTagPath(LoaderType.FORGE, "foils").unformattedTagPath(LoaderType.FABRIC, "foils").materialAmount(907200L).materialIconType(MaterialIconType.foil).unificationEnabled(true).generateItem(true).generationCondition(mat -> mat.hasFlag(MaterialFlags.GENERATE_FOIL));
    public static final TagPrefix rodLong = new TagPrefix("longRod").defaultTagPath(LoaderType.FORGE, "rods/long/%s").defaultTagPath(LoaderType.FABRIC, "%s_long_rods").unformattedTagPath(LoaderType.FORGE, "rods/long").unformattedTagPath(LoaderType.FABRIC, "long_rods").langValue("Long %s Rod").materialAmount(3628800L).materialIconType(MaterialIconType.stickLong).unificationEnabled(true).generateItem(true).generationCondition(mat -> mat.hasFlag(MaterialFlags.GENERATE_LONG_ROD));
    public static final TagPrefix rod = new TagPrefix("rod").defaultTagPath(LoaderType.FORGE, "rods/%s").defaultTagPath(LoaderType.FABRIC, "%s_rods").unformattedTagPath(LoaderType.FORGE, "rods").unformattedTagPath(LoaderType.FABRIC, "rods").langValue("%s Rod").materialAmount(1814400L).materialIconType(MaterialIconType.stick).unificationEnabled(true).generateItem(true).generationCondition(mat -> mat.hasFlag(MaterialFlags.GENERATE_ROD));
    public static final TagPrefix bolt = new TagPrefix("bolt").defaultTagPath(LoaderType.FORGE, "bolts/%s").defaultTagPath(LoaderType.FABRIC, "%s_bolts").unformattedTagPath(LoaderType.FORGE, "bolts").unformattedTagPath(LoaderType.FABRIC, "bolts").materialAmount(453600L).materialIconType(MaterialIconType.bolt).unificationEnabled(true).generateItem(true).generationCondition(mat -> mat.hasFlag(MaterialFlags.GENERATE_BOLT_SCREW));
    public static final TagPrefix screw = new TagPrefix("screw").defaultTagPath(LoaderType.FORGE, "screws/%s").defaultTagPath(LoaderType.FABRIC, "%s_screws").unformattedTagPath(LoaderType.FORGE, "screws").unformattedTagPath(LoaderType.FABRIC, "screws").materialAmount(403200L).materialIconType(MaterialIconType.screw).unificationEnabled(true).generateItem(true).generationCondition(mat -> mat.hasFlag(MaterialFlags.GENERATE_BOLT_SCREW));
    public static final TagPrefix ring = new TagPrefix("ring").defaultTagPath(LoaderType.FORGE, "rings/%s").defaultTagPath(LoaderType.FABRIC, "%s_rings").unformattedTagPath(LoaderType.FORGE, "rings").unformattedTagPath(LoaderType.FABRIC, "rings").materialAmount(907200L).materialIconType(MaterialIconType.ring).unificationEnabled(true).generateItem(true).generationCondition(mat -> mat.hasFlag(MaterialFlags.GENERATE_RING));
    public static final TagPrefix springSmall = new TagPrefix("smallSpring").defaultTagPath(LoaderType.FORGE, "small_springs/%s").defaultTagPath(LoaderType.FABRIC, "%s_small_springs").unformattedTagPath(LoaderType.FORGE, "small_springs").unformattedTagPath(LoaderType.FABRIC, "small_springs").langValue("Small %s Spring").materialAmount(907200L).materialIconType(MaterialIconType.springSmall).unificationEnabled(true).generateItem(true).generationCondition(mat -> mat.hasFlag(MaterialFlags.GENERATE_SPRING_SMALL) && !mat.hasFlag(MaterialFlags.NO_SMASHING));
    public static final TagPrefix spring = new TagPrefix("spring").defaultTagPath(LoaderType.FORGE, "springs/%s").defaultTagPath(LoaderType.FABRIC, "%s_springs").unformattedTagPath(LoaderType.FORGE, "springs").unformattedTagPath(LoaderType.FABRIC, "springs").materialAmount(3628800L).materialIconType(MaterialIconType.spring).unificationEnabled(true).generateItem(true).generationCondition(mat -> mat.hasFlag(MaterialFlags.GENERATE_SPRING) && !mat.hasFlag(MaterialFlags.NO_SMASHING));
    public static final TagPrefix wireFine = new TagPrefix("fineWire").defaultTagPath(LoaderType.FORGE, "fine_wires/%s").defaultTagPath(LoaderType.FABRIC, "%s_fine_wires").unformattedTagPath(LoaderType.FORGE, "fine_wires").unformattedTagPath(LoaderType.FABRIC, "fine_wires").langValue("Fine %s Wire").materialAmount(453600L).materialIconType(MaterialIconType.wireFine).unificationEnabled(true).generateItem(true).generationCondition(mat -> mat.hasFlag(MaterialFlags.GENERATE_FINE_WIRE));
    public static final TagPrefix rotor = new TagPrefix("rotor").defaultTagPath(LoaderType.FORGE, "rotors/%s").defaultTagPath(LoaderType.FABRIC, "%s_rotors").unformattedTagPath(LoaderType.FORGE, "rotors").unformattedTagPath(LoaderType.FABRIC, "rotors").materialAmount(14515200L).maxStackSize(16).materialIconType(MaterialIconType.rotor).unificationEnabled(true).generateItem(true).generationCondition(mat -> mat.hasFlag(MaterialFlags.GENERATE_ROTOR));
    public static final TagPrefix gearSmall = new TagPrefix("smallGear").defaultTagPath(LoaderType.FORGE, "small_gears/%s").defaultTagPath(LoaderType.FABRIC, "%s_small_gears").unformattedTagPath(LoaderType.FORGE, "small_gears").unformattedTagPath(LoaderType.FABRIC, "small_gears").langValue("Small %s Gear").materialAmount(3628800L).materialIconType(MaterialIconType.gearSmall).unificationEnabled(true).generateItem(true).generationCondition(mat -> mat.hasFlag(MaterialFlags.GENERATE_SMALL_GEAR));
    public static final TagPrefix gear = new TagPrefix("gear").defaultTagPath(LoaderType.FORGE, "gears/%s").defaultTagPath(LoaderType.FABRIC, "%s_gears").unformattedTagPath(LoaderType.FORGE, "gears").unformattedTagPath(LoaderType.FABRIC, "gears").materialAmount(14515200L).maxStackSize(16).materialIconType(MaterialIconType.gear).unificationEnabled(true).generateItem(true).generationCondition(mat -> mat.hasFlag(MaterialFlags.GENERATE_GEAR));
    public static final TagPrefix lens = new TagPrefix("lens").defaultTagPath(LoaderType.FORGE, "lenses/%s").defaultTagPath(LoaderType.FABRIC, "%s_lenses").unformattedTagPath(LoaderType.FORGE, "lenses").unformattedTagPath(LoaderType.FABRIC, "lenses").materialAmount(2721600L).materialIconType(MaterialIconType.lens).unificationEnabled(true).generateItem(true).generationCondition(mat -> mat.hasFlag(MaterialFlags.GENERATE_LENS));
    public static final TagPrefix dye = new TagPrefix("dye").defaultTagPath(LoaderType.FORGE, "dyes/%s").defaultTagPath(LoaderType.FABRIC, "%s_dyes").unformattedTagPath(LoaderType.FORGE, "dyes").unformattedTagPath(LoaderType.FABRIC, "dyes").materialAmount(-1L);
    public static final TagPrefix toolHeadBuzzSaw = new TagPrefix("buzzSawBlade").itemTable(() -> GTItems.MATERIAL_ITEMS).langValue("%s Buzzsaw Blade").materialAmount(14515200L).maxStackSize(16).materialIconType(MaterialIconType.toolHeadBuzzSaw).unificationEnabled(true).generateItem(true).generationCondition(Conditions.hasNoCraftingToolProperty.and(mat -> mat.hasFlag(MaterialFlags.GENERATE_PLATE)));
    public static final TagPrefix toolHeadScrewdriver = new TagPrefix("screwdriverTip").itemTable(() -> GTItems.MATERIAL_ITEMS).langValue("%s Screwdriver Tip").materialAmount(3628800L).maxStackSize(16).materialIconType(MaterialIconType.toolHeadScrewdriver).unificationEnabled(true).generateItem(true).generationCondition(Conditions.hasNoCraftingToolProperty.and(mat -> mat.hasFlag(MaterialFlags.GENERATE_LONG_ROD)));
    public static final TagPrefix toolHeadDrill = new TagPrefix("drillHead").itemTable(() -> GTItems.MATERIAL_ITEMS).langValue("%s Drill Head").materialAmount(14515200L).maxStackSize(16).materialIconType(MaterialIconType.toolHeadDrill).unificationEnabled(true).generateItem(true).generationCondition(Conditions.hasToolProperty.and(mat -> mat.hasFlag(MaterialFlags.GENERATE_PLATE)));
    public static final TagPrefix toolHeadChainsaw = new TagPrefix("chainsawHead").itemTable(() -> GTItems.MATERIAL_ITEMS).langValue("%s Chainsaw Head").materialAmount(7257600L).maxStackSize(16).materialIconType(MaterialIconType.toolHeadChainsaw).unificationEnabled(true).generateItem(true).generationCondition(Conditions.hasNoCraftingToolProperty.and(mat -> mat.hasFlag(MaterialFlags.GENERATE_PLATE)));
    public static final TagPrefix toolHeadWrench = new TagPrefix("wrenchTip").itemTable(() -> GTItems.MATERIAL_ITEMS).langValue("%s Wrench Tip").materialAmount(14515200L).maxStackSize(16).materialIconType(MaterialIconType.toolHeadWrench).unificationEnabled(true).generateItem(true).generationCondition(Conditions.hasNoCraftingToolProperty.and(mat -> mat.hasFlag(MaterialFlags.GENERATE_PLATE)));
    public static final TagPrefix turbineBlade = new TagPrefix("turbineBlade").itemTable(() -> GTItems.MATERIAL_ITEMS).langValue("%s Turbine Blade").materialAmount(36288000L).materialIconType(MaterialIconType.turbineBlade).unificationEnabled(true).generateItem(true).generationCondition(Conditions.hasRotorProperty.and(m -> m.hasFlags(MaterialFlags.GENERATE_BOLT_SCREW, MaterialFlags.GENERATE_PLATE) && !m.hasProperty(PropertyKey.GEM)));
    public static final TagPrefix block = new TagPrefix("block").defaultTagPath(LoaderType.FORGE, "storage_blocks/%s").defaultTagPath(LoaderType.FABRIC, "%s_blocks").unformattedTagPath(LoaderType.FORGE, "storage_blocks").langValue("Block of %s").materialAmount(32659200L).materialIconType(MaterialIconType.block).miningToolTag((class_6862<class_2248>)class_3481.field_33715).unificationEnabled(true);
    public static final TagPrefix rock = new TagPrefix("rock").defaultTagPath(LoaderType.FORGE, "%s").defaultTagPath(LoaderType.FABRIC, "%s").langValue("%s").miningToolTag((class_6862<class_2248>)class_3481.field_33715).unificationEnabled(true);
    public static final TagPrefix frameGt = new TagPrefix("frameGt").defaultTagPath(LoaderType.FORGE, "frames/%s").defaultTagPath(LoaderType.FABRIC, "%s_frames").langValue("%s Frame").materialAmount(7257600L).materialIconType(MaterialIconType.frameGt).miningToolTag(GTToolType.WRENCH.harvestTags.get(0)).unificationEnabled(true).generationCondition(material -> material.hasFlag(MaterialFlags.GENERATE_FRAME));
    public static final TagPrefix pipeTinyFluid = new TagPrefix("pipeTinyFluid").itemTable(() -> GTBlocks.FLUID_PIPE_BLOCKS).langValue("Tiny %s Fluid Pipe").miningToolTag(GTToolType.WRENCH.harvestTags.get(0)).materialAmount(1814400L).unificationEnabled(true);
    public static final TagPrefix pipeSmallFluid = new TagPrefix("pipeSmallFluid").itemTable(() -> GTBlocks.FLUID_PIPE_BLOCKS).langValue("Small %s Fluid Pipe").miningToolTag(GTToolType.WRENCH.harvestTags.get(0)).materialAmount(3628800L).unificationEnabled(true);
    public static final TagPrefix pipeNormalFluid = new TagPrefix("pipeNormalFluid").itemTable(() -> GTBlocks.FLUID_PIPE_BLOCKS).langValue("Normal %s Fluid Pipe").miningToolTag(GTToolType.WRENCH.harvestTags.get(0)).materialAmount(10886400L).unificationEnabled(true);
    public static final TagPrefix pipeLargeFluid = new TagPrefix("pipeLargeFluid").itemTable(() -> GTBlocks.FLUID_PIPE_BLOCKS).langValue("Large %s Fluid Pipe").miningToolTag(GTToolType.WRENCH.harvestTags.get(0)).materialAmount(21772800L).unificationEnabled(true);
    public static final TagPrefix pipeHugeFluid = new TagPrefix("pipeHugeFluid").itemTable(() -> GTBlocks.FLUID_PIPE_BLOCKS).langValue("Huge %s Fluid Pipe").miningToolTag(GTToolType.WRENCH.harvestTags.get(0)).materialAmount(43545600L).unificationEnabled(true);
    public static final TagPrefix pipeQuadrupleFluid = new TagPrefix("pipeQuadrupleFluid").itemTable(() -> GTBlocks.FLUID_PIPE_BLOCKS).langValue("Quadruple %s Fluid Pipe").miningToolTag(GTToolType.WRENCH.harvestTags.get(0)).materialAmount(14515200L).unificationEnabled(true);
    public static final TagPrefix pipeNonupleFluid = new TagPrefix("pipeNonupleFluid").itemTable(() -> GTBlocks.FLUID_PIPE_BLOCKS).langValue("Nonuple %s Fluid Pipe").miningToolTag(GTToolType.WRENCH.harvestTags.get(0)).materialAmount(32659200L).unificationEnabled(true);
    public static final TagPrefix pipeSmallItem = new TagPrefix("pipeSmallItem").itemTable(() -> GTBlocks.ITEM_PIPE_BLOCKS).langValue("Small %s Item Pipe").miningToolTag(GTToolType.WRENCH.harvestTags.get(0)).materialAmount(3628800L).unificationEnabled(true);
    public static final TagPrefix pipeNormalItem = new TagPrefix("pipeNormalItem").itemTable(() -> GTBlocks.ITEM_PIPE_BLOCKS).langValue("Normal %s Item Pipe").miningToolTag(GTToolType.WRENCH.harvestTags.get(0)).materialAmount(10886400L).unificationEnabled(true);
    public static final TagPrefix pipeLargeItem = new TagPrefix("pipeLargeItem").itemTable(() -> GTBlocks.ITEM_PIPE_BLOCKS).langValue("Large %s Item Pipe").miningToolTag(GTToolType.WRENCH.harvestTags.get(0)).materialAmount(21772800L).unificationEnabled(true);
    public static final TagPrefix pipeHugeItem = new TagPrefix("pipeHugeItem").itemTable(() -> GTBlocks.ITEM_PIPE_BLOCKS).langValue("Huge %s Item Pipe").miningToolTag(GTToolType.WRENCH.harvestTags.get(0)).materialAmount(43545600L).unificationEnabled(true);
    public static final TagPrefix pipeSmallRestrictive = new TagPrefix("pipeSmallRestrictive").itemTable(() -> GTBlocks.ITEM_PIPE_BLOCKS).langValue("Small Restrictive %s Item Pipe").miningToolTag(GTToolType.WRENCH.harvestTags.get(0)).materialAmount(3628800L).unificationEnabled(true);
    public static final TagPrefix pipeNormalRestrictive = new TagPrefix("pipeNormalRestrictive").itemTable(() -> GTBlocks.ITEM_PIPE_BLOCKS).langValue("Normal Restrictive %s Item Pipe").miningToolTag(GTToolType.WRENCH.harvestTags.get(0)).materialAmount(10886400L).unificationEnabled(true);
    public static final TagPrefix pipeLargeRestrictive = new TagPrefix("pipeLargeRestrictive").itemTable(() -> GTBlocks.ITEM_PIPE_BLOCKS).langValue("Large Restrictive %s Item Pipe").miningToolTag(GTToolType.WRENCH.harvestTags.get(0)).materialAmount(21772800L).unificationEnabled(true);
    public static final TagPrefix pipeHugeRestrictive = new TagPrefix("pipeHugeRestrictive").itemTable(() -> GTBlocks.ITEM_PIPE_BLOCKS).langValue("Huge Restrictive %s Item Pipe").miningToolTag(GTToolType.WRENCH.harvestTags.get(0)).materialAmount(43545600L).unificationEnabled(true);
    public static final TagPrefix wireGtHex = new TagPrefix("wireGtHex").itemTable(() -> GTBlocks.CABLE_BLOCKS).langValue("16x %s Wire").miningToolTag(GTToolType.WIRE_CUTTER.harvestTags.get(0)).materialAmount(29030400L).materialIconType(MaterialIconType.wire).unificationEnabled(true);
    public static final TagPrefix wireGtOctal = new TagPrefix("wireGtOctal").itemTable(() -> GTBlocks.CABLE_BLOCKS).langValue("8x %s Wire").miningToolTag(GTToolType.WIRE_CUTTER.harvestTags.get(0)).materialAmount(14515200L).materialIconType(MaterialIconType.wire).unificationEnabled(true);
    public static final TagPrefix wireGtQuadruple = new TagPrefix("wireGtQuadruple").itemTable(() -> GTBlocks.CABLE_BLOCKS).langValue("4x %s Wire").miningToolTag(GTToolType.WIRE_CUTTER.harvestTags.get(0)).materialAmount(7257600L).materialIconType(MaterialIconType.wire).unificationEnabled(true);
    public static final TagPrefix wireGtDouble = new TagPrefix("wireGtDouble").itemTable(() -> GTBlocks.CABLE_BLOCKS).langValue("2x %s Wire").miningToolTag(GTToolType.WIRE_CUTTER.harvestTags.get(0)).materialAmount(3628800L).materialIconType(MaterialIconType.wire).unificationEnabled(true);
    public static final TagPrefix wireGtSingle = new TagPrefix("wireGtSingle").itemTable(() -> GTBlocks.CABLE_BLOCKS).langValue("1x %s Wire").miningToolTag(GTToolType.WIRE_CUTTER.harvestTags.get(0)).materialAmount(1814400L).materialIconType(MaterialIconType.wire).unificationEnabled(true);
    public static final TagPrefix cableGtHex = new TagPrefix("cableGtHex").itemTable(() -> GTBlocks.CABLE_BLOCKS).langValue("16x %s Cable").miningToolTag(GTToolType.WIRE_CUTTER.harvestTags.get(0)).materialAmount(29030400L).unificationEnabled(true);
    public static final TagPrefix cableGtOctal = new TagPrefix("cableGtOctal").itemTable(() -> GTBlocks.CABLE_BLOCKS).langValue("8x %s Cable").miningToolTag(GTToolType.WIRE_CUTTER.harvestTags.get(0)).materialAmount(14515200L).unificationEnabled(true);
    public static final TagPrefix cableGtQuadruple = new TagPrefix("cableGtQuadruple").itemTable(() -> GTBlocks.CABLE_BLOCKS).langValue("4x %s Cable").miningToolTag(GTToolType.WIRE_CUTTER.harvestTags.get(0)).materialAmount(7257600L).unificationEnabled(true);
    public static final TagPrefix cableGtDouble = new TagPrefix("cableGtDouble").itemTable(() -> GTBlocks.CABLE_BLOCKS).langValue("2x %s Cable").miningToolTag(GTToolType.WIRE_CUTTER.harvestTags.get(0)).materialAmount(3628800L).unificationEnabled(true);
    public static final TagPrefix cableGtSingle = new TagPrefix("cableGtSingle").itemTable(() -> GTBlocks.CABLE_BLOCKS).langValue("1x %s Cable").miningToolTag(GTToolType.WIRE_CUTTER.harvestTags.get(0)).materialAmount(1814400L).unificationEnabled(true);
    public final String name;
    public final boolean invertedName;
    private final List<TagType> forgeTags = new ArrayList<TagType>();
    private final List<TagType> fabricTags = new ArrayList<TagType>();
    public String langValue;
    private long materialAmount = -1L;
    private boolean unificationEnabled;
    private boolean generateItem;
    @Nullable
    private Predicate<Material> generationCondition;
    @Nullable
    private MaterialIconType materialIconType;
    private Supplier<Table<TagPrefix, Material, ? extends Supplier<? extends class_1935>>> itemTable;
    @Nullable
    private BiConsumer<Material, List<class_2561>> tooltip;
    private final Map<Material, class_1935[]> ignoredMaterials = new HashMap<Material, class_1935[]>();
    private int maxStackSize = 64;
    private final List<MaterialStack> secondaryMaterials = new ArrayList<MaterialStack>();
    protected final Set<class_6862<class_2248>> miningToolTag = new HashSet<class_6862<class_2248>>();
    private static final Map<UnificationEntry, Long> MATERIAL_AMOUNT_MAP = ImmutableMap.ofEntries((Map.Entry[])new Map.Entry[]{Map.entry(new UnificationEntry(block, GTMaterials.Amethyst), 14515200L), Map.entry(new UnificationEntry(block, GTMaterials.Brick), 14515200L), Map.entry(new UnificationEntry(block, GTMaterials.CertusQuartz), 14515200L), Map.entry(new UnificationEntry(block, GTMaterials.Clay), 14515200L), Map.entry(new UnificationEntry(block, GTMaterials.Glowstone), 14515200L), Map.entry(new UnificationEntry(block, GTMaterials.NetherQuartz), 14515200L), Map.entry(new UnificationEntry(block, GTMaterials.Concrete), 3628800L), Map.entry(new UnificationEntry(block, GTMaterials.Glass), 3628800L), Map.entry(new UnificationEntry(block, GTMaterials.Ice), 3628800L), Map.entry(new UnificationEntry(block, GTMaterials.Obsidian), 3628800L), Map.entry(new UnificationEntry(rod, GTMaterials.Blaze), 14515200L), Map.entry(new UnificationEntry(rod, GTMaterials.Bone), 18144000L)});

    public static void init() {
        AddonFinder.getAddons().forEach(IGTAddon::registerTagPrefixes);
        if (GTCEu.isKubeJSLoaded()) {
            GTRegistryObjectBuilderTypes.registerFor(GTRegistryObjectBuilderTypes.TAG_PREFIX.registryKey);
        }
    }

    public static TagPrefix get(String name) {
        return PREFIXES.get(name);
    }

    public TagPrefix(String name) {
        this(name, false);
    }

    public TagPrefix(String name, boolean invertedName) {
        this.name = name;
        this.invertedName = invertedName;
        this.langValue = "%s " + FormattingUtil.toEnglishName(FormattingUtil.toLowerCaseUnder(name));
        PREFIXES.put(name, this);
    }

    public static TagPrefix oreTagPrefix(String name) {
        return new TagPrefix(name).prefixTagPath(LoaderType.FORGE, "ores/%s/%s").defaultTagPath(LoaderType.FORGE, "ores/%s").prefixOnlyTagPath(LoaderType.FORGE, "ores_in_ground/%s").unformattedTagPath(LoaderType.FORGE, "ores").prefixTagPath(LoaderType.FABRIC, "%s_%s_ores").defaultTagPath(LoaderType.FABRIC, "%s_ores").prefixOnlyTagPath(LoaderType.FABRIC, "%s_ores_in_ground").unformattedTagPath(LoaderType.FABRIC, "ores");
    }

    public void addSecondaryMaterial(MaterialStack secondaryMaterial) {
        Preconditions.checkNotNull((Object)secondaryMaterial, (Object)"secondaryMaterial");
        this.secondaryMaterials.add(secondaryMaterial);
    }

    public TagPrefix registerOre(Supplier<class_2680> stoneType) {
        return this.registerOre(stoneType, false);
    }

    public TagPrefix registerOre(Supplier<class_2680> stoneType, boolean isNether) {
        return this.registerOre(stoneType, isNether, class_3620.field_16023);
    }

    public TagPrefix registerOre(Supplier<class_2680> stoneType, boolean isNether, class_3620 color) {
        return this.registerOre(stoneType, isNether, color, class_2498.field_11544, false);
    }

    public TagPrefix registerOre(Supplier<class_2680> stoneType, boolean isNether, class_3620 color, boolean isSand) {
        return this.registerOre(stoneType, isNether, color, class_2498.field_11544, isSand);
    }

    public TagPrefix registerOre(Supplier<class_2680> stoneType, boolean isNether, class_3620 color, class_2498 soundType, boolean isSand) {
        ORES.put(this, new OreType(stoneType, isNether, isSand, color, soundType));
        return this;
    }

    public TagPrefix defaultTagPath(LoaderType loader, String path) {
        loader.apply(this, TagType.withDefaultFormatter(path));
        return this;
    }

    public TagPrefix prefixTagPath(LoaderType loader, String path) {
        loader.apply(this, TagType.withPrefixFormatter(path));
        return this;
    }

    public TagPrefix prefixOnlyTagPath(LoaderType loader, String path) {
        loader.apply(this, TagType.withPrefixOnlyFormatter(path));
        return this;
    }

    public TagPrefix unformattedTagPath(LoaderType loader, String path) {
        loader.apply(this, TagType.withNoFormatter(path));
        return this;
    }

    public TagPrefix customTagPath(LoaderType loader, String path, BiFunction<TagPrefix, Material, class_6862<class_1792>> formatter) {
        loader.apply(this, TagType.withCustomFormatter(path, formatter));
        return this;
    }

    public TagPrefix miningToolTag(class_6862<class_2248> tag) {
        this.miningToolTag.add(tag);
        return this;
    }

    public long getMaterialAmount(@Nullable Material material) {
        UnificationEntry key = new UnificationEntry(this, material);
        return MATERIAL_AMOUNT_MAP.getOrDefault(key, this.materialAmount);
    }

    public static TagPrefix getPrefix(String prefixName) {
        return TagPrefix.getPrefix(prefixName, null);
    }

    public static TagPrefix getPrefix(String prefixName, @Nullable TagPrefix replacement) {
        return PREFIXES.getOrDefault(prefixName, replacement);
    }

    public class_6862<class_1792>[] getItemParentTags() {
        return (class_6862[])(Platform.isForge() ? this.forgeTags : this.fabricTags).stream().filter(TagType::isParentTag).map(type -> type.getTag(this, null)).toArray(class_6862[]::new);
    }

    public class_6862<class_1792>[] getItemTags(@Nonnull Material mat) {
        return (class_6862[])(Platform.isForge() ? this.forgeTags : this.fabricTags).stream().filter(type -> !type.isParentTag()).map(type -> type.getTag(this, mat)).toArray(class_6862[]::new);
    }

    public class_6862<class_1792>[] getAllItemTags(@Nonnull Material mat) {
        return (class_6862[])(Platform.isForge() ? this.forgeTags : this.fabricTags).stream().map(type -> type.getTag(this, mat)).toArray(class_6862[]::new);
    }

    public class_6862<class_2248>[] getBlockTags(@Nonnull Material mat) {
        return (class_6862[])(Platform.isForge() ? this.forgeTags : this.fabricTags).stream().filter(type -> !type.isParentTag()).map(type -> type.getTag(this, mat)).map(itemTagKey -> class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)itemTagKey.comp_327())).toArray(class_6862[]::new);
    }

    public class_6862<class_2248>[] getAllBlockTags(@Nonnull Material mat) {
        return (class_6862[])(Platform.isForge() ? this.forgeTags : this.fabricTags).stream().map(type -> type.getTag(this, mat)).map(itemTagKey -> class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)itemTagKey.comp_327())).toArray(class_6862[]::new);
    }

    public boolean hasItemTable() {
        return this.itemTable != null;
    }

    public Supplier<class_1935> getItemFromTable(Material material) {
        return (Supplier)this.itemTable.get().get((Object)this, (Object)material);
    }

    public boolean doGenerateItem() {
        return this.generateItem;
    }

    public boolean doGenerateItem(Material material) {
        return this.generateItem && !this.isIgnored(material) && (this.generationCondition == null || this.generationCondition.test(material)) || this.hasItemTable() && this.itemTable.get() != null && this.getItemFromTable(material) != null;
    }

    public <T extends IMaterialProperty<T>> void executeHandler(PropertyKey<T> propertyKey, TriConsumer<TagPrefix, Material, T> handler) {
        for (Material material : GTRegistries.MATERIALS) {
            if (!material.hasProperty(propertyKey) || material.hasFlag(MaterialFlags.NO_UNIFICATION) || ChemicalHelper.get(this, material).method_7960()) continue;
            handler.accept((Object)this, (Object)material, material.getProperty(propertyKey));
        }
    }

    public String getUnlocalizedName() {
        return "tagprefix." + FormattingUtil.toLowerCaseUnderscore(this.name);
    }

    public class_5250 getLocalizedName(Material material) {
        return class_2561.method_43469((String)this.getUnlocalizedName(material), (Object[])new Object[]{material.getLocalizedName()});
    }

    public String getUnlocalizedName(Material material) {
        String localizationKey;
        String formattedPrefix = FormattingUtil.toLowerCaseUnderscore(this.name);
        String matSpecificKey = String.format("item.%s_%s", this.invertedName ? formattedPrefix : material.getName(), this.invertedName ? material.getName() : formattedPrefix);
        if (LocalizationUtils.exist((String)matSpecificKey)) {
            return matSpecificKey;
        }
        if (material.hasProperty(PropertyKey.POLYMER) && LocalizationUtils.exist((String)(localizationKey = String.format("tagprefix.polymer.%s", formattedPrefix)))) {
            return localizationKey;
        }
        return this.getUnlocalizedName();
    }

    public boolean isIgnored(Material material) {
        return this.ignoredMaterials.containsKey(material);
    }

    public void setIgnored(Material material, class_1935 ... items) {
        this.ignoredMaterials.put(material, items);
        if (items.length > 0) {
            ChemicalHelper.registerUnificationItems(this, material, items);
        }
    }

    public void removeIgnored(Material material) {
        this.ignoredMaterials.remove(material);
    }

    public Map<Material, class_1935[]> getIgnored() {
        return new HashMap<Material, class_1935[]>(this.ignoredMaterials);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TagPrefix tagPrefix = (TagPrefix)o;
        return this.name.equals(tagPrefix.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public static Collection<TagPrefix> values() {
        return PREFIXES.values();
    }

    public String toString() {
        return this.name;
    }

    public String name() {
        return this.name;
    }

    public boolean invertedName() {
        return this.invertedName;
    }

    public TagPrefix langValue(String langValue) {
        this.langValue = langValue;
        return this;
    }

    public String langValue() {
        return this.langValue;
    }

    public long materialAmount() {
        return this.materialAmount;
    }

    public TagPrefix materialAmount(long materialAmount) {
        this.materialAmount = materialAmount;
        return this;
    }

    public TagPrefix unificationEnabled(boolean unificationEnabled) {
        this.unificationEnabled = unificationEnabled;
        return this;
    }

    public TagPrefix generateItem(boolean generateItem) {
        this.generateItem = generateItem;
        return this;
    }

    @Nullable
    public Predicate<Material> generationCondition() {
        return this.generationCondition;
    }

    public TagPrefix generationCondition(@Nullable Predicate<Material> generationCondition) {
        this.generationCondition = generationCondition;
        return this;
    }

    @Nullable
    public MaterialIconType materialIconType() {
        return this.materialIconType;
    }

    public TagPrefix materialIconType(@Nullable MaterialIconType materialIconType) {
        this.materialIconType = materialIconType;
        return this;
    }

    public TagPrefix itemTable(Supplier<Table<TagPrefix, Material, ? extends Supplier<? extends class_1935>>> itemTable) {
        this.itemTable = itemTable;
        return this;
    }

    @Nullable
    public BiConsumer<Material, List<class_2561>> tooltip() {
        return this.tooltip;
    }

    public TagPrefix tooltip(@Nullable BiConsumer<Material, List<class_2561>> tooltip) {
        this.tooltip = tooltip;
        return this;
    }

    public int maxStackSize() {
        return this.maxStackSize;
    }

    public TagPrefix maxStackSize(int maxStackSize) {
        this.maxStackSize = maxStackSize;
        return this;
    }

    public List<MaterialStack> secondaryMaterials() {
        return this.secondaryMaterials;
    }

    public Set<class_6862<class_2248>> miningToolTag() {
        return this.miningToolTag;
    }

    public static enum LoaderType {
        FORGE((prefix, type) -> prefix.forgeTags.add((TagType)type)),
        FABRIC((prefix, type) -> prefix.fabricTags.add((TagType)type));

        private final BiConsumer<TagPrefix, TagType> applyTagType;

        private LoaderType(BiConsumer<TagPrefix, TagType> applyTagType) {
            this.applyTagType = applyTagType;
        }

        public void apply(TagPrefix prefix, TagType type) {
            this.applyTagType.accept(prefix, type);
        }
    }

    public record OreType(Supplier<class_2680> stoneType, boolean isNether, boolean isSand, class_3620 color, class_2498 sound) {
    }

    public static class Conditions {
        public static final Predicate<Material> hasToolProperty = mat -> mat.hasProperty(PropertyKey.TOOL);
        public static final Predicate<Material> hasNoCraftingToolProperty = hasToolProperty.and(mat -> !mat.getProperty(PropertyKey.TOOL).isIgnoreCraftingTools());
        public static final Predicate<Material> hasOreProperty = mat -> mat.hasProperty(PropertyKey.ORE);
        public static final Predicate<Material> hasGemProperty = mat -> mat.hasProperty(PropertyKey.GEM);
        public static final Predicate<Material> hasDustProperty = mat -> mat.hasProperty(PropertyKey.DUST);
        public static final Predicate<Material> hasIngotProperty = mat -> mat.hasProperty(PropertyKey.INGOT);
        public static final Predicate<Material> hasBlastProperty = mat -> mat.hasProperty(PropertyKey.BLAST);
        public static final Predicate<Material> hasRotorProperty = mat -> mat.hasProperty(PropertyKey.ROTOR);
    }
}

