/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.block;

import com.gregtechceu.gtceu.api.block.AppearanceBlock;
import com.gregtechceu.gtceu.api.block.BlockProperties;
import com.gregtechceu.gtceu.api.blockentity.PipeBlockEntity;
import com.gregtechceu.gtceu.api.capability.ICoverable;
import com.gregtechceu.gtceu.api.capability.IToolable;
import com.gregtechceu.gtceu.api.item.PipeBlockItem;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.item.tool.ToolHelper;
import com.gregtechceu.gtceu.api.pipenet.IAttachData;
import com.gregtechceu.gtceu.api.pipenet.IPipeNode;
import com.gregtechceu.gtceu.api.pipenet.IPipeType;
import com.gregtechceu.gtceu.client.model.PipeModel;
import com.gregtechceu.gtceu.client.renderer.block.PipeBlockRenderer;
import com.gregtechceu.gtceu.common.item.CoverPlaceBehavior;
import com.lowdragmc.lowdraglib.client.renderer.IBlockRendererProvider;
import com.lowdragmc.lowdraglib.pipelike.LevelPipeNet;
import com.lowdragmc.lowdraglib.pipelike.PipeNet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_173;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1838;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3726;
import net.minecraft.class_3727;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_6328;
import net.minecraft.class_8567;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@class_6328
public abstract class PipeBlock<PipeType extends Enum<PipeType>, NodeDataType extends IAttachData, WorldPipeNetType extends LevelPipeNet<NodeDataType, ? extends PipeNet<NodeDataType>>>
extends AppearanceBlock
implements class_2343,
IBlockRendererProvider {
    public final PipeType pipeType;

    public PipeBlock(class_4970.class_2251 properties, PipeType pipeType) {
        super(properties);
        this.pipeType = pipeType;
        this.method_9590((class_2680)this.method_9564().method_11657((class_2769)BlockProperties.SERVER_TICK, (Comparable)Boolean.valueOf(false)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder.method_11667(new class_2769[]{BlockProperties.SERVER_TICK}));
    }

    public final PipeBlockEntity<PipeType, NodeDataType> newBlockEntity(class_2338 pos, class_2680 state) {
        return (PipeBlockEntity)this.getBlockEntityType().method_11032(pos, state);
    }

    public abstract WorldPipeNetType getWorldPipeNet(class_3218 var1);

    public abstract class_2591<? extends PipeBlockEntity<PipeType, NodeDataType>> getBlockEntityType();

    public abstract NodeDataType createRawData(class_2680 var1, @Nullable class_1799 var2);

    public abstract NodeDataType getFallbackType();

    @Nullable
    public abstract PipeBlockRenderer getRenderer(class_2680 var1);

    protected abstract PipeModel getPipeModel();

    @Nullable
    public IPipeNode<PipeType, NodeDataType> getPileTile(class_1922 level, class_2338 pos) {
        IPipeNode pipeTile;
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof IPipeNode && ((IPipeType)(pipeTile = (IPipeNode)class_25862).getPipeType()).type().equals((Object)((IPipeType)this.pipeType).type())) {
            return pipeTile;
        }
        return null;
    }

    public void method_9567(class_1937 pLevel, class_2338 pPos, class_2680 pState, @Nullable class_1309 pPlacer, class_1799 pStack) {
        super.method_9567(pLevel, pPos, pState, pPlacer, pStack);
        IPipeNode<PipeType, NodeDataType> pipeNode = this.getPileTile((class_1922)pLevel, pPos);
        if (pipeNode != null && pLevel instanceof class_3218) {
            class_2350 attachSide;
            class_2338 attachPos;
            class_3218 serverLevel = (class_3218)pLevel;
            WorldPipeNetType net = this.getWorldPipeNet(serverLevel);
            if (net.getNetFromPos(pPos) == null) {
                net.addNode(pPos, ((IPipeType)this.pipeType).modifyProperties(this.createRawData(pState, pStack)), 0, 0, true);
            } else {
                net.updateData(pPos, ((IPipeType)this.pipeType).modifyProperties(this.createRawData(pState, pStack)));
            }
            if (PipeBlockItem.LAST_CONTEXT != null && !PipeBlockItem.LAST_CONTEXT.method_7717() && (attachPos = PipeBlockItem.LAST_CONTEXT.method_8037().method_10093(PipeBlockItem.LAST_CONTEXT.method_8038().method_10153())).method_10093(attachSide = PipeBlockItem.LAST_CONTEXT.method_8038()).equals((Object)pPos)) {
                IPipeNode<PipeType, NodeDataType> attachNode = this.getPileTile((class_1922)pLevel, attachPos);
                if (attachNode != null) {
                    if (attachNode.isBlocked(attachSide)) {
                        attachNode.setBlocked(attachSide, false);
                    }
                    if (pipeNode.isBlocked(attachSide.method_10153())) {
                        pipeNode.setBlocked(attachSide.method_10153(), false);
                    }
                } else if (pipeNode.isBlocked(attachSide.method_10153()) && pipeNode.canAttachTo(attachSide.method_10153())) {
                    pipeNode.setBlocked(attachSide.method_10153(), false);
                }
            }
            for (class_2350 side : class_2350.values()) {
                class_2338 attachPos2;
                IPipeNode<PipeType, NodeDataType> attachNode;
                if (!pipeNode.isBlocked(side) || (attachNode = this.getPileTile((class_1922)pLevel, attachPos2 = pPos.method_10093(side))) == null || attachNode.isBlocked(side.method_10153())) continue;
                pipeNode.setBlocked(side, false);
            }
            pipeNode.updateConnections();
        }
    }

    public void method_9615(class_2680 state, class_1937 level, class_2338 pos, class_2680 oldState, boolean isMoving) {
        class_3218 serverLevel;
        WorldPipeNetType net;
        super.method_9615(state, level, pos, oldState, isMoving);
        if (!oldState.method_27852(state.method_26204()) && level instanceof class_3218 && (net = this.getWorldPipeNet(serverLevel = (class_3218)level)).getNetFromPos(pos) == null) {
            net.addNode(pos, ((IPipeType)this.pipeType).modifyProperties(this.createRawData(state, null)), 0, 0, true);
        }
    }

    public void method_9612(class_2680 pState, class_1937 pLevel, class_2338 pPos, class_2248 pBlock, class_2338 pFromPos, boolean pIsMoving) {
        super.method_9612(pState, pLevel, pPos, pBlock, pFromPos, pIsMoving);
        IPipeNode<PipeType, NodeDataType> pipeNode = this.getPileTile((class_1922)pLevel, pPos);
        if (pipeNode != null) {
            pipeNode.onNeighborChanged(pBlock, pFromPos, pIsMoving);
        }
    }

    public void method_9536(class_2680 pState, class_1937 pLevel, class_2338 pPos, class_2680 pNewState, boolean pIsMoving) {
        if (pState.method_31709() && !pState.method_27852(pNewState.method_26204())) {
            pLevel.method_8455(pPos, (class_2248)this);
            pLevel.method_8544(pPos);
            if (pLevel instanceof class_3218) {
                class_3218 serverLevel = (class_3218)pLevel;
                this.getWorldPipeNet(serverLevel).removeNode(pPos);
            }
        }
    }

    public class_1269 method_9534(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_1799 itemStack = player.method_5998(hand);
        class_2586 entity = level.method_8321(pos);
        Set<GTToolType> types = ToolHelper.getToolTypes(itemStack);
        if (entity instanceof IToolable) {
            IToolable toolable = (IToolable)entity;
            if (!types.isEmpty() && ToolHelper.canUse(itemStack)) {
                Pair<GTToolType, class_1269> result = toolable.onToolClick(types, itemStack, new class_1838(player, hand, hit));
                if (result.getSecond() == class_1269.field_21466 && player instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)player;
                    ToolHelper.playToolSound((GTToolType)result.getFirst(), serverPlayer);
                    if (!serverPlayer.method_7337()) {
                        ToolHelper.damageItem(itemStack, (class_1309)serverPlayer, 1);
                    }
                }
                return (class_1269)result.getSecond();
            }
        }
        return class_1269.field_5811;
    }

    public boolean method_37403(class_2680 state, class_1922 level, class_2338 pos) {
        return false;
    }

    public class_265 method_9530(class_2680 pState, class_1922 pLevel, class_2338 pPos, class_3726 context) {
        int connections;
        block2: {
            class_265 shape;
            block3: {
                block4: {
                    class_1747 blockItem;
                    class_3727 entityCtx;
                    class_1297 class_12972;
                    IPipeNode<PipeType, NodeDataType> pipeNode = this.getPileTile(pLevel, pPos);
                    connections = 0;
                    if (pipeNode == null) break block2;
                    connections = pipeNode.getVisualConnections();
                    shape = this.getPipeModel().getShapes(connections);
                    shape = class_259.method_17786((class_265)shape, (class_265[])pipeNode.getCoverContainer().addCoverCollisionBoundingBox());
                    if (!(context instanceof class_3727) || !((class_12972 = (entityCtx = (class_3727)context).method_32480()) instanceof class_1657)) break block3;
                    class_1657 player = (class_1657)class_12972;
                    ICoverable coverable = pipeNode.getCoverContainer();
                    class_1799 held = player.method_6047();
                    if (GTToolType.WIRE_CUTTER.itemTags.stream().anyMatch(arg_0 -> ((class_1799)held).method_31573(arg_0))) break block4;
                    if (GTToolType.WRENCH.itemTags.stream().anyMatch(arg_0 -> ((class_1799)held).method_31573(arg_0))) break block4;
                    if (CoverPlaceBehavior.isCoverBehaviorItem(held, coverable::hasAnyCover, coverDef -> ICoverable.canPlaceCover(coverDef, coverable))) break block4;
                    class_1792 class_17922 = held.method_7909();
                    if (!(class_17922 instanceof class_1747) || !((class_17922 = (blockItem = (class_1747)class_17922).method_7711()) instanceof PipeBlock)) break block3;
                    PipeBlock pipeBlock = (PipeBlock)class_17922;
                    if (!((IPipeType)pipeBlock.pipeType).type().equals((Object)((IPipeType)this.pipeType).type())) break block3;
                }
                return class_259.method_1084((class_265)class_259.method_1077(), (class_265)shape);
            }
            return shape;
        }
        return this.getPipeModel().getShapes(connections);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 state, class_2591<T> blockEntityType) {
        if (blockEntityType == this.getBlockEntityType() && !level.field_9236 && ((Boolean)state.method_11654((class_2769)BlockProperties.SERVER_TICK)).booleanValue()) {
            return (pLevel, pPos, pState, pTile) -> {
                if (pTile instanceof IPipeNode) {
                    IPipeNode pipeNode = (IPipeNode)pTile;
                    pipeNode.serverTick();
                }
            };
        }
        return null;
    }

    @Override
    public class_2680 getBlockAppearance(class_2680 state, class_1920 level, class_2338 pos, class_2350 side, class_2680 sourceState, class_2338 sourcePos) {
        class_2680 appearance;
        IPipeNode<PipeType, NodeDataType> pipe = this.getPileTile((class_1922)level, pos);
        if (pipe != null && (appearance = pipe.getCoverContainer().getBlockAppearance(state, level, pos, side, sourceState, sourcePos)) != null) {
            return appearance;
        }
        return super.getBlockAppearance(state, level, pos, side, sourceState, sourcePos);
    }

    public List<class_1799> method_9560(class_2680 state, class_8567.class_8568 builder) {
        class_8567 context = builder.method_51874(class_181.field_1224, (Object)state).method_51875(class_173.field_1172);
        class_2586 tileEntity = (class_2586)context.method_51869(class_181.field_1228);
        if (tileEntity instanceof IPipeNode) {
            IPipeNode pipeTile = (IPipeNode)tileEntity;
            for (class_2350 direction : class_2350.values()) {
                pipeTile.getCoverContainer().removeCover(direction, null);
            }
        }
        return super.method_9560(state, builder);
    }
}

