/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity;

import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.entity.ai.AquaticAIFindWaterTarget;
import com.iafenvoy.iceandfire.entity.ai.AquaticAIGetInWater;
import com.iafenvoy.iceandfire.entity.ai.HippocampusAIWander;
import com.iafenvoy.iceandfire.entity.util.ChainBuffer;
import com.iafenvoy.iceandfire.entity.util.ICustomMoveController;
import com.iafenvoy.iceandfire.entity.util.ISyncMount;
import com.iafenvoy.iceandfire.registry.IafEntities;
import com.iafenvoy.iceandfire.registry.IafSounds;
import com.iafenvoy.iceandfire.registry.tag.IafItemTags;
import com.iafenvoy.iceandfire.screen.handler.HippocampusScreenHandler;
import com.iafenvoy.uranus.animation.Animation;
import com.iafenvoy.uranus.animation.AnimationHandler;
import com.iafenvoy.uranus.animation.IAnimatedEntity;
import com.iafenvoy.uranus.data.EntityPropertyDelegate;
import net.minecraft.class_1263;
import net.minecraft.class_1265;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1313;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1321;
import net.minecraft.class_1335;
import net.minecraft.class_1341;
import net.minecraft.class_1352;
import net.minecraft.class_1391;
import net.minecraft.class_1408;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1890;
import net.minecraft.class_1924;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_3908;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5146;
import net.minecraft.class_5425;
import net.minecraft.class_5766;
import net.minecraft.class_7;
import org.jetbrains.annotations.Nullable;

public class EntityHippocampus
extends class_1321
implements class_3908,
ISyncMount,
IAnimatedEntity,
ICustomMoveController,
class_1265,
class_5146 {
    public static final int INV_SLOT_SADDLE = 0;
    public static final int INV_SLOT_CHEST = 1;
    public static final int INV_SLOT_ARMOR = 2;
    public static final int INV_BASE_COUNT = 3;
    private static final class_2940<Integer> VARIANT = class_2945.method_12791(EntityHippocampus.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> SADDLE = class_2945.method_12791(EntityHippocampus.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> ARMOR = class_2945.method_12791(EntityHippocampus.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> CHESTED = class_2945.method_12791(EntityHippocampus.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Byte> CONTROL_STATE = class_2945.method_12791(EntityHippocampus.class, (class_2941)class_2943.field_13319);
    private static final int FLAG_SITTING = 1;
    private static final int FLAG_TAME = 4;
    private static final class_2561 CONTAINER_TITLE = class_2561.method_43471((String)"entity.iceandfire.hippocampus");
    public static Animation ANIMATION_SPEAK;
    public float onLandProgress;
    public ChainBuffer tail_buffer;
    public class_1277 inventory;
    public float sitProgress;
    private int animationTick;
    private Animation currentAnimation;

    public EntityHippocampus(class_1299<? extends EntityHippocampus> entityType, class_1937 worldIn) {
        super(entityType, worldIn);
        ANIMATION_SPEAK = Animation.create((int)15);
        this.method_5941(class_7.field_18, 0.0f);
        this.field_6207 = new HippoMoveControl(this);
        this.method_49477(1.0f);
        if (worldIn.field_9236) {
            this.tail_buffer = new ChainBuffer();
        }
        this.createInventory();
    }

    public static int getIntFromArmor(class_1799 stack) {
        if (!stack.method_7960() && stack.method_7909() == class_1802.field_8578) {
            return 1;
        }
        if (!stack.method_7960() && stack.method_7909() == class_1802.field_8560) {
            return 2;
        }
        if (!stack.method_7960() && stack.method_7909() == class_1802.field_8807) {
            return 3;
        }
        return 0;
    }

    public static class_5132.class_5133 bakeAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 40.0).method_26868(class_5134.field_23719, 0.3).method_26868(class_5134.field_23721, 1.0);
    }

    protected class_1408 method_5965(class_1937 level) {
        return new class_5766((class_1308)this, level);
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new AquaticAIFindWaterTarget((class_1308)this, 10, true));
        this.field_6201.method_6277(2, (class_1352)new AquaticAIGetInWater((class_1308)this, 1.0));
        this.field_6201.method_6277(3, (class_1352)new HippocampusAIWander((class_1314)this, 1.0));
        this.field_6201.method_6277(4, (class_1352)new class_1341((class_1429)this, 1.0));
        this.addBehaviourGoals();
    }

    protected void addBehaviourGoals() {
        this.field_6201.method_6277(0, (class_1352)new class_1391((class_1314)this, 1.0, class_1856.method_8106(IafItemTags.TEMPT_HIPPOCAMPUS), false));
    }

    public int method_6110() {
        return 2;
    }

    public float method_6149(class_2338 pos) {
        return this.method_37908().method_8320(pos.method_10074()).method_27852(class_2246.field_10382) ? 10.0f : (float)this.method_37908().method_22339(pos) - 0.5f;
    }

    public class_1310 method_6046() {
        return class_1310.field_6292;
    }

    public boolean method_5722(class_1297 entityIn) {
        if (this.method_6181()) {
            class_1309 livingentity = this.method_35057();
            if (entityIn == livingentity) {
                return true;
            }
            if (entityIn instanceof class_1321) {
                class_1321 tameable = (class_1321)entityIn;
                return tameable.method_6171(livingentity);
            }
            if (livingentity != null) {
                return livingentity.method_5722(entityIn);
            }
        }
        return super.method_5722(entityIn);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(VARIANT, (Object)0);
        this.field_6011.method_12784(ARMOR, (Object)0);
        this.field_6011.method_12784(SADDLE, (Object)Boolean.FALSE);
        this.field_6011.method_12784(CHESTED, (Object)Boolean.FALSE);
        this.field_6011.method_12784(CONTROL_STATE, (Object)0);
    }

    public class_1309 method_5642() {
        class_1297 entity = this.method_31483();
        if (entity instanceof class_1308) {
            class_1308 mob = (class_1308)entity;
            return mob;
        }
        if (this.method_6725() && (entity = this.method_31483()) instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            return player;
        }
        return null;
    }

    public class_1799 method_24523(class_1799 itemStackIn) {
        if (itemStackIn == null) {
            return class_1799.field_8037;
        }
        class_1304 equipmentSlot = EntityHippocampus.method_32326((class_1799)itemStackIn);
        int j = equipmentSlot.method_5927() - 500 + 2;
        if (j >= 0 && j < this.inventory.method_5439()) {
            this.inventory.method_5447(j, itemStackIn);
            return itemStackIn;
        }
        return class_1799.field_8037;
    }

    protected void method_16078() {
        super.method_16078();
        if (this.inventory != null && !this.method_37908().field_9236) {
            for (int i = 0; i < this.inventory.method_5439(); ++i) {
                class_1799 itemstack = this.inventory.method_5438(i);
                if (itemstack.method_7960() || class_1890.method_8221((class_1799)itemstack)) continue;
                this.method_5775(itemstack);
            }
        }
        if (this.isChested()) {
            if (!this.method_37908().field_9236) {
                this.method_5706((class_1935)class_2246.field_10034);
            }
            this.setChested(false);
        }
    }

    protected void dropChestItems() {
        for (int i = 3; i < 18; ++i) {
            if (this.inventory.method_5438(i).method_7960()) continue;
            if (!this.method_37908().field_9236) {
                this.method_5699(this.inventory.method_5438(i), 1.0f);
            }
            this.inventory.method_5441(i);
        }
    }

    private void updateControlState(int i, boolean newState) {
        byte prevState = (Byte)this.field_6011.method_12789(CONTROL_STATE);
        if (newState) {
            this.field_6011.method_12778(CONTROL_STATE, (Object)((byte)(prevState | 1 << i)));
        } else {
            this.field_6011.method_12778(CONTROL_STATE, (Object)((byte)(prevState & ~(1 << i))));
        }
    }

    @Override
    public byte getControlState() {
        return (Byte)this.field_6011.method_12789(CONTROL_STATE);
    }

    @Override
    public void setControlState(byte state) {
        this.field_6011.method_12778(CONTROL_STATE, (Object)state);
    }

    public boolean method_5860(class_1297 rider) {
        return true;
    }

    public void method_5865(class_1297 passenger, class_1297.class_4738 callback) {
        super.method_5865(passenger, callback);
        if (this.method_5626(passenger)) {
            this.field_6283 = this.method_36454();
            this.method_5636(passenger.method_36454());
        }
        double ymod1 = (double)this.onLandProgress * -0.02;
        passenger.method_5814(this.method_23317(), this.method_23318() + (double)0.6f + ymod1, this.method_23321());
    }

    public void method_6007() {
        boolean inWater;
        super.method_6007();
        if (!this.method_37908().field_9236 && this.field_5974.method_43048(900) == 0 && this.field_6213 == 0) {
            this.method_6025(1.0f);
        }
        AnimationHandler.INSTANCE.updateAnimations((class_1297)this);
        if (this.method_5642() != null && this.field_6012 % 20 == 0) {
            this.method_5642().method_6092(new class_1293(class_1294.field_5923, 30, 0, true, false));
        }
        if (this.method_37908().field_9236) {
            this.tail_buffer.calculateChainSwingBuffer(40.0f, 10, 1.0f, (class_1309)this);
        }
        if (!(inWater = this.method_5799()) && this.onLandProgress < 20.0f) {
            this.onLandProgress += 1.0f;
        } else if (inWater && this.onLandProgress > 0.0f) {
            this.onLandProgress -= 1.0f;
        }
        boolean sitting = this.method_24345();
        if (sitting && this.sitProgress < 20.0f) {
            this.sitProgress += 0.5f;
        } else if (!sitting && this.sitProgress > 0.0f) {
            this.sitProgress -= 0.5f;
        }
    }

    protected void method_49481(class_1657 player, class_243 travelVector) {
        super.method_49481(player, travelVector);
        class_241 vec2 = this.getRiddenRotation((class_1309)player);
        this.method_5710(vec2.field_1342, vec2.field_1343);
        this.field_6283 = this.field_6241 = this.method_36454();
        this.field_5982 = this.field_6241;
        if (this.method_5787()) {
            class_243 vec3 = this.method_18798();
            if (this.isGoingUp()) {
                if (!this.method_5799() && this.method_24828()) {
                    this.method_6043();
                } else if (this.method_5799()) {
                    this.method_18799(vec3.method_1031(0.0, (double)0.04f, 0.0));
                }
            }
            if (this.isGoingDown() && this.method_5799()) {
                this.method_18799(vec3.method_1031(0.0, (double)-0.025f, 0.0));
            }
        }
    }

    protected class_243 method_49482(class_1657 player, class_243 travelVector) {
        float f = player.field_6212 * 0.5f;
        float f1 = player.field_6250;
        if (f1 <= 0.0f) {
            f1 *= 0.25f;
        }
        return new class_243((double)f, 0.0, (double)f1);
    }

    protected class_241 getRiddenRotation(class_1309 entity) {
        return new class_241(entity.method_36455() * 0.5f, entity.method_36454());
    }

    protected float method_49485(class_1657 player) {
        float speed = (float)this.method_26825(class_5134.field_23719) * 0.6f;
        speed = this.method_5799() ? (speed *= ((Double)IafCommonConfig.INSTANCE.hippocampus.swimSpeedMod.getValue()).floatValue()) : (speed *= 0.2f);
        return speed;
    }

    public boolean isGoingUp() {
        return ((Byte)this.field_6011.method_12789(CONTROL_STATE) & 1) == 1;
    }

    public boolean isGoingDown() {
        return ((Byte)this.field_6011.method_12789(CONTROL_STATE) >> 1 & 1) == 1;
    }

    public boolean isBlinking() {
        return this.field_6012 % 50 > 43;
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10569("Variant", this.getVariant());
        compound.method_10556("Chested", this.isChested());
        compound.method_10556("Saddled", this.method_6725());
        compound.method_10569("Armor", this.method_6096());
        class_2499 nbttaglist = new class_2499();
        for (int i = 0; i < this.inventory.method_5439(); ++i) {
            class_1799 itemstack = this.inventory.method_5438(i);
            if (itemstack.method_7960()) continue;
            class_2487 CompoundNBT = new class_2487();
            CompoundNBT.method_10567("Slot", (byte)i);
            itemstack.method_7953(CompoundNBT);
            nbttaglist.add((Object)CompoundNBT);
        }
        compound.method_10566("Items", (class_2520)nbttaglist);
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.setVariant(compound.method_10550("Variant"));
        this.setChested(compound.method_10577("Chested"));
        this.setSaddled(compound.method_10577("Saddled"));
        this.setArmor(compound.method_10550("Armor"));
        if (this.inventory != null) {
            class_2499 nbttaglist = compound.method_10554("Items", 10);
            this.createInventory();
            for (int i = 0; i < nbttaglist.size(); ++i) {
                class_2487 CompoundNBT = nbttaglist.method_10602(i);
                int j = CompoundNBT.method_10571("Slot") & 0xFF;
                this.inventory.method_5447(j, class_1799.method_7915((class_2487)CompoundNBT));
            }
        }
    }

    protected int getInventorySize() {
        return this.isChested() ? 18 : 3;
    }

    protected void createInventory() {
        class_1277 simplecontainer = this.inventory;
        this.inventory = new class_1277(this.getInventorySize());
        if (simplecontainer != null) {
            simplecontainer.method_5488((class_1265)this);
            int i = Math.min(simplecontainer.method_5439(), this.inventory.method_5439());
            for (int j = 0; j < i; ++j) {
                class_1799 itemstack = simplecontainer.method_5438(j);
                if (itemstack.method_7960()) continue;
                this.inventory.method_5447(j, itemstack.method_7972());
            }
        }
        this.inventory.method_5489((class_1265)this);
        this.updateContainerEquipment();
    }

    protected void updateContainerEquipment() {
        if (!this.method_37908().field_9236) {
            this.setSaddled(!this.inventory.method_5438(0).method_7960());
            this.setChested(!this.inventory.method_5438(1).method_7960());
            this.setArmor(EntityHippocampus.getIntFromArmor(this.inventory.method_5438(2)));
        }
    }

    public boolean hasInventoryChanged(class_1263 pInventory) {
        return this.inventory != pInventory;
    }

    public boolean method_6765() {
        return this.method_5805() && !this.method_6109() && this.method_6181();
    }

    public void method_6576(class_3419 pSource) {
        this.inventory.method_5447(0, new class_1799((class_1935)class_1802.field_8175));
    }

    public boolean method_6725() {
        return (Boolean)this.field_6011.method_12789(SADDLE);
    }

    public void setSaddled(boolean saddle) {
        this.field_6011.method_12778(SADDLE, (Object)saddle);
    }

    public boolean isChested() {
        return (Boolean)this.field_6011.method_12789(CHESTED);
    }

    public void setChested(boolean chested) {
        this.field_6011.method_12778(CHESTED, (Object)chested);
        if (!chested) {
            this.dropChestItems();
        }
    }

    public int method_6096() {
        return (Integer)this.field_6011.method_12789(ARMOR);
    }

    public void setArmor(int armorType) {
        this.field_6011.method_12778(ARMOR, (Object)armorType);
        double armorValue = switch (armorType) {
            case 1 -> 10.0;
            case 2 -> 20.0;
            case 3 -> 30.0;
            default -> 0.0;
        };
        this.method_5996(class_5134.field_23724).method_6192(armorValue);
    }

    public int getVariant() {
        return (Integer)this.field_6011.method_12789(VARIANT);
    }

    public void setVariant(int variant) {
        this.field_6011.method_12778(VARIANT, (Object)variant);
    }

    public class_1315 method_5943(class_5425 worldIn, class_1266 difficultyIn, class_3730 reason, class_1315 spawnDataIn, class_2487 dataTag) {
        class_1315 data = super.method_5943(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.setVariant(this.method_6051().method_43048(6));
        return data;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{IAnimatedEntity.NO_ANIMATION, ANIMATION_SPEAK};
    }

    public class_1296 method_5613(class_3218 serverWorld, class_1296 ageable) {
        if (ageable instanceof EntityHippocampus) {
            EntityHippocampus hippo = new EntityHippocampus((class_1299<? extends EntityHippocampus>)((class_1299)IafEntities.HIPPOCAMPUS.get()), this.method_37908());
            hippo.setVariant(this.method_6051().method_43056() ? this.getVariant() : ((EntityHippocampus)ageable).getVariant());
            return hippo;
        }
        return null;
    }

    public void method_6091(class_243 pTravelVector) {
        if (this.method_5787() && this.method_5799()) {
            this.method_5724(0.1f, pTravelVector);
            this.method_5784(class_1313.field_6308, this.method_18798());
            this.method_18799(this.method_18798().method_1021(0.9));
        } else {
            super.method_6091(pTravelVector);
        }
    }

    public boolean method_6481(class_1799 stack) {
        return stack.method_31573(IafItemTags.BREED_HIPPOCAMPUS);
    }

    public void method_5966() {
        if (this.getAnimation() == IAnimatedEntity.NO_ANIMATION) {
            this.setAnimation(ANIMATION_SPEAK);
        }
        super.method_5966();
    }

    protected void method_6013(class_1282 source) {
        if (this.getAnimation() == IAnimatedEntity.NO_ANIMATION) {
            this.setAnimation(ANIMATION_SPEAK);
        }
        super.method_6013(source);
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 itemstack = player.method_5998(hand);
        if (itemstack.method_31573(IafItemTags.BREED_HIPPOCAMPUS) && this.method_5618() == 0 && !this.method_6479()) {
            this.method_24346(false);
            this.method_6480(player);
            this.method_5783(class_3417.field_20614, 1.0f, 1.0f);
            if (!player.method_7337()) {
                itemstack.method_7934(1);
            }
            return class_1269.field_5812;
        }
        if (itemstack.method_31573(IafItemTags.HEAL_HIPPOCAMPUS)) {
            int i;
            if (!this.method_37908().field_9236) {
                this.method_6025(5.0f);
                this.method_5783(class_3417.field_20614, 1.0f, 1.0f);
                for (i = 0; i < 3; ++i) {
                    this.method_37908().method_8406((class_2394)new class_2392(class_2398.field_11218, itemstack), this.method_23317() + (double)(this.field_5974.method_43057() * this.method_17681() * 2.0f) - (double)this.method_17681(), this.method_23318() + (double)(this.field_5974.method_43057() * this.method_17682()), this.method_23321() + (double)(this.field_5974.method_43057() * this.method_17681() * 2.0f) - (double)this.method_17681(), 0.0, 0.0, 0.0);
                }
                if (!player.method_7337()) {
                    itemstack.method_7934(1);
                }
            }
            if (!this.method_6181() && this.method_6051().method_43048(3) == 0) {
                this.method_6170(player);
                for (i = 0; i < 6; ++i) {
                    this.method_37908().method_8406((class_2394)class_2398.field_11201, this.method_23317() + (double)(this.field_5974.method_43057() * this.method_17681() * 2.0f) - (double)this.method_17681(), this.method_23318() + (double)(this.field_5974.method_43057() * this.method_17682()), this.method_23321() + (double)(this.field_5974.method_43057() * this.method_17681() * 2.0f) - (double)this.method_17681(), 0.0, 0.0, 0.0);
                }
            }
            return class_1269.field_5812;
        }
        if (this.method_6171((class_1309)player) && itemstack.method_7909() == class_1802.field_8600) {
            this.method_24346(!this.method_24345());
            return class_1269.field_5812;
        }
        if (this.method_6171((class_1309)player) && itemstack.method_7960() && player.method_5715()) {
            this.openInventory(player);
            return class_1269.method_29236((boolean)this.method_37908().field_9236);
        }
        if (this.method_6171((class_1309)player) && this.method_6725() && !this.method_6109() && !player.method_5765()) {
            this.doPlayerRide(player);
            return class_1269.field_5812;
        }
        return super.method_5992(player, hand);
    }

    protected void doPlayerRide(class_1657 pPlayer) {
        this.method_24346(false);
        if (!this.method_37908().field_9236) {
            pPlayer.method_36456(this.method_36454());
            pPlayer.method_36457(this.method_36455());
            pPlayer.method_5804((class_1297)this);
        }
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
        return new HippocampusScreenHandler(syncId, (class_1263)this.inventory, inv, this, new EntityPropertyDelegate(this.method_5628()));
    }

    public void openInventory(class_1657 player) {
        player.method_17355((class_3908)this);
    }

    @Override
    public void up(boolean up) {
        this.updateControlState(0, up);
    }

    @Override
    public void down(boolean down) {
        this.updateControlState(1, down);
    }

    @Override
    public void attack(boolean attack) {
    }

    @Override
    public void strike(boolean strike) {
    }

    @Override
    public void dismount(boolean dismount) {
        this.updateControlState(2, dismount);
    }

    protected class_3414 method_5994() {
        return (class_3414)IafSounds.HIPPOCAMPUS_IDLE.get();
    }

    protected class_3414 method_6011(class_1282 damageSourceIn) {
        return (class_3414)IafSounds.HIPPOCAMPUS_HURT.get();
    }

    protected class_3414 method_6002() {
        return (class_3414)IafSounds.HIPPOCAMPUS_DIE.get();
    }

    public boolean method_5947() {
        return true;
    }

    public class_1657 getRidingPlayer() {
        class_1309 class_13092 = this.method_5642();
        if (class_13092 instanceof class_1657) {
            class_1657 player = (class_1657)class_13092;
            return player;
        }
        return null;
    }

    public int getInventoryColumns() {
        return 5;
    }

    public void method_5453(class_1263 pInvBasic) {
        boolean flag = this.method_6725();
        this.updateContainerEquipment();
        if (this.field_6012 > 20 && !flag && this.method_6725()) {
            this.method_5783(class_3417.field_14704, 0.5f, 1.0f);
        }
    }

    public class_1924 method_48926() {
        return this.method_37908();
    }

    public void method_5773() {
        super.method_5773();
        this.method_5855(this.method_5748());
    }

    class HippoMoveControl
    extends class_1335 {
        private final EntityHippocampus hippo;

        public HippoMoveControl(EntityHippocampus entityHippocampus) {
            super((class_1308)entityHippocampus);
            this.hippo = EntityHippocampus.this;
        }

        private void updateSpeed() {
            if (this.hippo.method_5799()) {
                this.hippo.method_18799(this.hippo.method_18798().method_1031(0.0, 0.005, 0.0));
            } else if (this.hippo.method_24828()) {
                this.hippo.method_6125(Math.max(this.hippo.method_6029() / 4.0f, 0.06f));
            }
        }

        public void method_6240() {
            this.updateSpeed();
            if (this.field_6374 == class_1335.class_1336.field_6378 && !this.hippo.method_5942().method_6357()) {
                double d2;
                double d1;
                double d0 = this.field_6370 - this.hippo.method_23317();
                double distance = Math.sqrt(d0 * d0 + (d1 = this.field_6369 - this.hippo.method_23318()) * d1 + (d2 = this.field_6367 - this.hippo.method_23321()) * d2);
                if (distance < (double)1.0E-5f) {
                    this.field_6371.method_6125(0.0f);
                } else {
                    d1 /= distance;
                    float minRotation = (float)(class_3532.method_15349((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                    this.hippo.method_36456(this.method_6238(this.hippo.method_36454(), minRotation, 90.0f));
                    this.hippo.field_6283 = this.hippo.method_36454();
                    float maxSpeed = (float)(this.field_6372 * this.hippo.method_26825(class_5134.field_23719));
                    maxSpeed *= 0.6f;
                    maxSpeed = this.hippo.method_5799() ? (maxSpeed *= ((Double)IafCommonConfig.INSTANCE.hippocampus.swimSpeedMod.getValue()).floatValue()) : (maxSpeed *= 0.2f);
                    this.hippo.method_6125(class_3532.method_16439((float)0.125f, (float)this.hippo.method_6029(), (float)maxSpeed));
                    this.hippo.method_18799(this.hippo.method_18798().method_1031(0.0, (double)this.hippo.method_6029() * d1 * 0.1, 0.0));
                }
            } else {
                this.hippo.method_6125(0.0f);
            }
        }
    }
}

