/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity;

import com.google.common.collect.ImmutableList;
import com.iafenvoy.iceandfire.IceAndFire;
import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.data.DragonColor;
import com.iafenvoy.iceandfire.data.DragonType;
import com.iafenvoy.iceandfire.entity.EntityDragonBase;
import com.iafenvoy.iceandfire.entity.block.BlockEntityEggInIce;
import com.iafenvoy.iceandfire.entity.util.IBlacklistedFromStatues;
import com.iafenvoy.iceandfire.entity.util.IDeadMob;
import com.iafenvoy.iceandfire.item.ItemDragonEgg;
import com.iafenvoy.iceandfire.registry.IafBlocks;
import com.iafenvoy.iceandfire.registry.IafSounds;
import com.iafenvoy.uranus.object.BlockUtil;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1306;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1538;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3321;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_8103;
import net.minecraft.server.MinecraftServer;

public class EntityDragonEgg
extends class_1309
implements IBlacklistedFromStatues,
IDeadMob {
    protected static final class_2940<Optional<UUID>> OWNER_UNIQUE_ID = class_2945.method_12791(EntityDragonEgg.class, (class_2941)class_2943.field_13313);
    private static final class_2940<String> DRAGON_TYPE = class_2945.method_12791(EntityDragonEgg.class, (class_2941)class_2943.field_13326);
    private static final class_2940<Integer> DRAGON_AGE = class_2945.method_12791(EntityDragonEgg.class, (class_2941)class_2943.field_13327);

    public EntityDragonEgg(class_1299<EntityDragonEgg> type, class_1937 worldIn) {
        super(type, worldIn);
    }

    public static class_5132.class_5133 bakeAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 10.0).method_26868(class_5134.field_23719, 0.0);
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10582("Color", this.getEggType().name());
        tag.method_10569("DragonAge", this.getDragonAge());
        try {
            if (this.getOwnerId() == null) {
                tag.method_10582("OwnerUUID", "");
            } else {
                tag.method_10582("OwnerUUID", this.getOwnerId().toString());
            }
        }
        catch (Exception e) {
            IceAndFire.LOGGER.error("An error occurred while trying to read the NBT data of a dragon egg", (Throwable)e);
        }
    }

    public void method_5749(class_2487 tag) {
        String s;
        super.method_5749(tag);
        this.setEggType(DragonColor.getById(tag.method_10558("Color")));
        this.setDragonAge(tag.method_10550("DragonAge"));
        if (tag.method_10573("OwnerUUID", 8)) {
            s = tag.method_10558("OwnerUUID");
        } else {
            String s1 = tag.method_10558("Owner");
            UUID converedUUID = class_3321.method_14546((MinecraftServer)this.method_5682(), (String)s1);
            String string = s = converedUUID == null ? s1 : converedUUID.toString();
        }
        if (!s.isEmpty()) {
            this.setOwnerId(UUID.fromString(s));
        }
    }

    protected void method_5693() {
        super.method_5693();
        this.method_5841().method_12784(DRAGON_TYPE, (Object)DragonColor.RED.toString());
        this.method_5841().method_12784(DRAGON_AGE, (Object)0);
        this.method_5841().method_12784(OWNER_UNIQUE_ID, Optional.empty());
    }

    public UUID getOwnerId() {
        return ((Optional)this.field_6011.method_12789(OWNER_UNIQUE_ID)).orElse(null);
    }

    public void setOwnerId(UUID p_184754_1_) {
        this.field_6011.method_12778(OWNER_UNIQUE_ID, Optional.ofNullable(p_184754_1_));
    }

    public DragonColor getEggType() {
        return DragonColor.getById((String)this.method_5841().method_12789(DRAGON_TYPE));
    }

    public void setEggType(DragonColor newtype) {
        this.method_5841().method_12778(DRAGON_TYPE, (Object)newtype.name());
    }

    public boolean method_5679(class_1282 i) {
        return i.method_5529() != null && super.method_5679(i);
    }

    public int getDragonAge() {
        return (Integer)this.method_5841().method_12789(DRAGON_AGE);
    }

    public void setDragonAge(int i) {
        this.method_5841().method_12778(DRAGON_AGE, (Object)i);
    }

    public void method_5773() {
        super.method_5773();
        if (!this.method_37908().field_9236) {
            this.method_5855(200);
            this.updateEggCondition();
        }
    }

    public void updateEggCondition() {
        DragonType dragonType = this.getEggType().dragonType();
        if (dragonType == DragonType.FIRE) {
            if (BlockUtil.isBurning((class_2680)this.method_37908().method_8320(this.method_24515()))) {
                this.setDragonAge(this.getDragonAge() + 1);
            }
        } else if (dragonType == DragonType.ICE) {
            class_2680 state = this.method_37908().method_8320(this.method_24515());
            if (state.method_27852(class_2246.field_10382) && this.method_6051().method_43048(500) == 0) {
                this.method_37908().method_8501(this.method_24515(), ((class_2248)IafBlocks.EGG_IN_ICE.get()).method_9564());
                this.method_37908().method_8486(this.method_23317(), this.method_23318() + (double)this.method_5751(), this.method_23321(), class_3417.field_15081, this.method_5634(), 2.5f, 1.0f, false);
                class_2586 class_25862 = this.method_37908().method_8321(this.method_24515());
                if (class_25862 instanceof BlockEntityEggInIce) {
                    BlockEntityEggInIce eggInIce = (BlockEntityEggInIce)class_25862;
                    eggInIce.type = this.getEggType();
                    eggInIce.ownerUUID = this.getOwnerId();
                }
                this.method_5650(class_1297.class_5529.field_26999);
            }
        } else if (dragonType == DragonType.LIGHTNING) {
            boolean isRainingAt;
            class_2338.class_2339 mutablePosition = new class_2338.class_2339(this.method_23317(), this.method_23318(), this.method_23321());
            boolean bl = isRainingAt = this.method_37908().method_8520((class_2338)mutablePosition) || this.method_37908().method_8520((class_2338)mutablePosition.method_10102(this.method_23317(), this.method_23318() + (double)this.method_17682(), this.method_23321()));
            if (this.method_37908().method_8311(this.method_24515().method_10084()) && isRainingAt) {
                this.setDragonAge(this.getDragonAge() + 1);
            }
        }
        if (this.getDragonAge() > (Integer)IafCommonConfig.INSTANCE.dragon.eggBornTime.getValue()) {
            this.method_37908().method_8501(this.method_24515(), class_2246.field_10124.method_9564());
            EntityDragonBase dragon = (EntityDragonBase)dragonType.getEntity().method_5883(this.method_37908());
            if (this.method_16914()) {
                assert (dragon != null);
                dragon.method_5665(this.method_5797());
            }
            assert (dragon != null);
            dragon.setVariant(this.getEggType().name());
            dragon.setGender(this.method_6051().method_43056());
            dragon.method_5814((double)this.method_24515().method_10263() + 0.5, this.method_24515().method_10264() + 1, (double)this.method_24515().method_10260() + 0.5);
            dragon.setHunger(50);
            if (!this.method_37908().method_8608()) {
                this.method_37908().method_8649((class_1297)dragon);
            }
            if (this.method_16914()) {
                dragon.method_5665(this.method_5797());
            }
            dragon.method_6173(true);
            dragon.method_6174(this.getOwnerId());
            if (dragonType == DragonType.LIGHTNING) {
                class_1538 bolt = (class_1538)class_1299.field_6112.method_5883(this.method_37908());
                assert (bolt != null);
                bolt.method_5814(this.method_23317(), this.method_23318(), this.method_23321());
                bolt.method_29498(true);
                if (!this.method_37908().method_8608()) {
                    this.method_37908().method_8649((class_1297)bolt);
                }
                this.method_37908().method_8486(this.method_23317(), this.method_23318() + (double)this.method_5751(), this.method_23321(), class_3417.field_14865, this.method_5634(), 2.5f, 1.0f, false);
            } else if (dragonType == DragonType.FIRE) {
                this.method_37908().method_8486(this.method_23317(), this.method_23318() + (double)this.method_5751(), this.method_23321(), class_3417.field_15102, this.method_5634(), 2.5f, 1.0f, false);
            }
            this.method_37908().method_8486(this.method_23317(), this.method_23318() + (double)this.method_5751(), this.method_23321(), (class_3414)IafSounds.EGG_HATCH.get(), this.method_5634(), 2.5f, 1.0f, false);
            this.method_5650(class_1297.class_5529.field_26999);
        }
    }

    public class_3414 method_6011(class_1282 damageSourceIn) {
        return null;
    }

    public Iterable<class_1799> method_5661() {
        return ImmutableList.of();
    }

    public class_1799 method_6118(class_1304 slotIn) {
        return class_1799.field_8037;
    }

    public void method_5673(class_1304 slotIn, class_1799 stack) {
    }

    public boolean method_5643(class_1282 var1, float var2) {
        if (var1.method_48789(class_8103.field_42246) && this.getEggType().dragonType() == DragonType.FIRE) {
            return false;
        }
        if (!(this.method_37908().field_9236 || var1.method_48789(class_8103.field_42242) || this.method_31481())) {
            this.method_5870((class_1935)this.getItem().method_7909(), 1);
        }
        this.method_5650(class_1297.class_5529.field_26998);
        return true;
    }

    private class_1799 getItem() {
        return new class_1799((class_1935)ItemDragonEgg.EGGS.getOrDefault(this.getEggType(), class_1802.field_8162));
    }

    public boolean method_5810() {
        return false;
    }

    public class_1306 method_6068() {
        return class_1306.field_6183;
    }

    protected void method_6087(class_1297 entity) {
    }

    @Override
    public boolean canBeTurnedToStone() {
        return false;
    }

    public void onPlayerPlace(class_1657 player) {
        this.setOwnerId(player.method_5667());
    }

    @Override
    public boolean isMobDead() {
        return true;
    }
}

