/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.placements;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.class_1959;
import net.minecraft.class_2382;
import net.minecraft.class_2794;
import net.minecraft.class_6874;
import net.minecraft.class_6875;
import net.minecraft.class_6880;
import net.minecraft.class_7869;
import twilightforest.init.TFLandmark;
import twilightforest.init.TFStructurePlacementTypes;
import twilightforest.util.LegacyLandmarkPlacements;
import twilightforest.world.components.chunkgenerators.ChunkGeneratorTwilight;

public class BiomeForcedLandmarkPlacement
extends class_6874 {
    public static final Codec<BiomeForcedLandmarkPlacement> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)TFLandmark.CODEC.fieldOf("landmark_set").forGetter(p -> p.landmark), (App)Codec.intRange((int)-32, (int)256).fieldOf("scan_elevation").forGetter(p -> p.scanHeight)).apply((Applicative)inst, BiomeForcedLandmarkPlacement::new));
    private final TFLandmark landmark;
    private final int scanHeight;

    public BiomeForcedLandmarkPlacement(TFLandmark landmark, int biomeScanHeight) {
        super(class_2382.field_11176, class_6874.class_7154.field_37782, 1.0f, 0, Optional.empty());
        this.landmark = landmark;
        this.scanHeight = biomeScanHeight;
    }

    public boolean isTFPlacementChunk(class_2794 chunkGen, class_7869 state, int chunkX, int chunkZ) {
        if (chunkGen instanceof ChunkGeneratorTwilight) {
            ChunkGeneratorTwilight twilightGenerator = (ChunkGeneratorTwilight)chunkGen;
            return twilightGenerator.isLandmarkPickedForChunk(this.landmark, (class_6880<class_1959>)chunkGen.method_12098().method_38109(chunkX << 2, this.scanHeight, chunkZ << 2, state.method_46713().method_42371()), chunkX, chunkZ, state.method_46714());
        }
        if (!LegacyLandmarkPlacements.chunkHasLandmarkCenter(chunkX, chunkZ)) {
            return false;
        }
        return LegacyLandmarkPlacements.pickVarietyLandmark(chunkX, chunkZ, state.method_46714()) == this.landmark;
    }

    protected boolean method_40168(class_7869 state, int chunkX, int chunkZ) {
        if (!LegacyLandmarkPlacements.chunkHasLandmarkCenter(chunkX, chunkZ)) {
            return false;
        }
        return LegacyLandmarkPlacements.pickVarietyLandmark(chunkX, chunkZ, state.method_46714()) == this.landmark;
    }

    public class_6875<?> method_40166() {
        return (class_6875)TFStructurePlacementTypes.FORCED_LANDMARK_PLACEMENT_TYPE.get();
    }

    public TFLandmark getLandmark() {
        return this.landmark;
    }
}

