/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.courtyard;

import net.minecraft.class_2350;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3485;
import net.minecraft.class_3773;
import net.minecraft.class_5819;
import net.minecraft.class_6130;
import net.minecraft.class_6625;
import twilightforest.enums.Diagonals;
import twilightforest.util.BoundingBoxUtils;
import twilightforest.world.components.structures.TFStructureComponent;
import twilightforest.world.components.structures.courtyard.CourtyardPathPiece;
import twilightforest.world.components.structures.courtyard.CourtyardTerraceBrazier;
import twilightforest.world.components.structures.courtyard.CourtyardTerraceDuct;
import twilightforest.world.components.structures.courtyard.CourtyardTerraceStatue;
import twilightforest.world.components.structures.courtyard.CourtyardWall;
import twilightforest.world.components.structures.courtyard.CourtyardWallCornerInner;
import twilightforest.world.components.structures.courtyard.CourtyardWallCornerOuter;
import twilightforest.world.components.structures.courtyard.CourtyardWallPadder;
import twilightforest.world.components.structures.courtyard.NagaCourtyardHedgeCapComponent;
import twilightforest.world.components.structures.courtyard.NagaCourtyardHedgeCapPillarComponent;
import twilightforest.world.components.structures.courtyard.NagaCourtyardHedgeCornerComponent;
import twilightforest.world.components.structures.courtyard.NagaCourtyardHedgeIntersectionComponent;
import twilightforest.world.components.structures.courtyard.NagaCourtyardHedgeLineComponent;
import twilightforest.world.components.structures.courtyard.NagaCourtyardHedgePadderComponent;
import twilightforest.world.components.structures.courtyard.NagaCourtyardHedgeTJunctionComponent;

public abstract class StructureMazeGenerator
extends TFStructureComponent {
    protected final int[][] maze;
    private final int[][] cornerClipping = new int[4][2];
    private final int widthInCellCount;
    private final int heightInCellCount;
    private final class_3485 structureManager;
    protected class_3341 sizeConstraints;

    public StructureMazeGenerator(class_3485 structureManager, class_3773 piece, class_2487 nbt) {
        super(piece, nbt);
        this.widthInCellCount = nbt.method_10550("mazeWidth");
        this.heightInCellCount = nbt.method_10550("mazeHeight");
        this.maze = new int[this.widthInCellCount - 1][this.heightInCellCount - 1];
        class_2499 mazeX = nbt.method_10554("maze", 9);
        for (int x = 0; x < this.widthInCellCount - 1; ++x) {
            class_2520 mazeY = mazeX.method_10534(x);
            if (!(mazeY instanceof class_2499)) continue;
            for (int y = 0; y < this.heightInCellCount - 1; ++y) {
                this.maze[x][y] = ((class_2499)mazeY).method_10600(y);
            }
        }
        this.sizeConstraints = BoundingBoxUtils.NBTToBoundingBox(nbt.method_10562("constraints"));
        this.structureManager = structureManager;
    }

    StructureMazeGenerator(class_3773 type, class_5819 rand, int i, int widthInCellCount, int heightInCellCount, int x, int y, int z, class_3485 structureManager) {
        super(type, i, x, y, z);
        this.widthInCellCount = widthInCellCount;
        this.heightInCellCount = heightInCellCount;
        this.structureManager = structureManager;
        this.maze = new int[widthInCellCount - 1][heightInCellCount - 1];
        StructureMazeGenerator.generateMaze(this.maze, this.cornerClipping, rand, this.widthInCellCount, this.heightInCellCount, 2);
        this.sizeConstraints = this.method_14935();
    }

    public void method_14918(class_3443 structureComponent, class_6130 list, class_5819 random) {
        super.method_14918(structureComponent, list, random);
        int offset = 6;
        class_2470[] rotations = class_2470.values();
        this.processInnerWallsAndFloor(structureComponent, list, random, 6, rotations);
        this.processOuterWalls(structureComponent, list, random, 6, rotations);
    }

    private static void generateMaze(int[][] maze, int[][] cornerClippings, class_5819 random, int widthInCellCount, int heightInCellCount, int maximumClipping) {
        int x;
        WallFacing[][] rotations = new WallFacing[maze.length][maze[0].length];
        for (int x2 = 0; x2 < widthInCellCount - 1; ++x2) {
            for (int y = 0; y < heightInCellCount - 1; ++y) {
                rotations[x2][y] = WallFacing.values()[random.method_43048(WallFacing.values().length)];
                int[] nArray = maze[x2];
                int n = y;
                nArray[n] = nArray[n] | rotations[x2][y].BYTE;
            }
        }
        int[][] mazeLocal = (int[][])maze.clone();
        int halfWayPointX = widthInCellCount / 2 - 1;
        int halfWayPointY = heightInCellCount / 2 - 1;
        for (int y = 0; y < heightInCellCount - 1; ++y) {
            for (x = 0; x < widthInCellCount - 1; ++x) {
                if (x == halfWayPointX && y == halfWayPointY) continue;
                if (rotations[x][y] == WallFacing.WEST && x > 0) {
                    if (!rotations[x][y].unpackAndTest(maze[x - 1][y])) {
                        int[] nArray = maze[x - 1];
                        int n = y;
                        nArray[n] = nArray[n] | rotations[x][y].OPPOSITE;
                    } else {
                        int[] nArray = maze[x];
                        int n = y;
                        nArray[n] = nArray[n] & rotations[x][y].INVERTED;
                        int[] nArray2 = maze[x - 1];
                        int n2 = y;
                        nArray2[n2] = nArray2[n2] & rotations[x - 1][y].INVERTED_OPPOSITE;
                    }
                }
                if (rotations[x][y] == WallFacing.NORTH && y > 0) {
                    if (!rotations[x][y].unpackAndTest(maze[x][y - 1])) {
                        int[] nArray = maze[x];
                        int n = y - 1;
                        nArray[n] = nArray[n] | rotations[x][y].OPPOSITE;
                    } else {
                        int[] nArray = maze[x];
                        int n = y;
                        nArray[n] = nArray[n] & rotations[x][y].INVERTED;
                        int[] nArray3 = maze[x];
                        int n3 = y - 1;
                        nArray3[n3] = nArray3[n3] & rotations[x][y - 1].INVERTED_OPPOSITE;
                    }
                }
                if (rotations[x][y] == WallFacing.EAST && x < widthInCellCount - 2) {
                    if (!rotations[x][y].unpackAndTest(maze[x + 1][y])) {
                        int[] nArray = maze[x + 1];
                        int n = y;
                        nArray[n] = nArray[n] | rotations[x][y].OPPOSITE;
                    } else {
                        int[] nArray = maze[x];
                        int n = y;
                        nArray[n] = nArray[n] & rotations[x][y].INVERTED;
                        int[] nArray4 = maze[x + 1];
                        int n4 = y;
                        nArray4[n4] = nArray4[n4] & rotations[x + 1][y].INVERTED_OPPOSITE;
                    }
                }
                if (rotations[x][y] != WallFacing.SOUTH || y >= heightInCellCount - 2) continue;
                if (!rotations[x][y].unpackAndTest(maze[x][y + 1])) {
                    int[] nArray = maze[x];
                    int n = y + 1;
                    nArray[n] = nArray[n] | rotations[x][y].OPPOSITE;
                    continue;
                }
                int[] nArray = maze[x];
                int n = y;
                nArray[n] = nArray[n] & rotations[x][y].INVERTED;
                int[] nArray5 = maze[x];
                int n5 = y + 1;
                nArray5[n5] = nArray5[n5] & rotations[x][y + 1].INVERTED_OPPOSITE;
            }
        }
        WallFacing[] y = WallFacing.values();
        x = y.length;
        for (int i = 0; i < x; ++i) {
            WallFacing facing = y[i];
            int[] nArray = maze[halfWayPointX + facing.xOffset];
            int n = halfWayPointY + facing.zOffset;
            nArray[n] = nArray[n] & facing.INVERTED_OPPOSITE;
        }
        maze[halfWayPointX][halfWayPointY] = 16;
        for (int x3 = 1; x3 < maze.length; ++x3) {
            for (int y2 = 1; y2 < maze[x3].length; ++y2) {
                if (mazeLocal[x3][y2] != 0) continue;
                if (mazeLocal[x3 - 1][y2] == 0) {
                    int[] nArray = maze[x3];
                    int n = y2;
                    nArray[n] = nArray[n] | WallFacing.WEST.BYTE;
                    int[] nArray6 = maze[x3 - 1];
                    int n6 = y2;
                    nArray6[n6] = nArray6[n6] | WallFacing.WEST.OPPOSITE;
                }
                if (mazeLocal[x3][y2 - 1] != 0) continue;
                int[] nArray = maze[x3];
                int n = y2;
                nArray[n] = nArray[n] | WallFacing.NORTH.BYTE;
                int[] nArray7 = maze[x3];
                int n7 = y2 - 1;
                nArray7[n7] = nArray7[n7] | WallFacing.NORTH.OPPOSITE;
            }
        }
        for (Diagonals diagonals : Diagonals.values()) {
            cornerClippings[diagonals.ordinal()][0] = random.method_43048(maximumClipping) + 1;
            cornerClippings[diagonals.ordinal()][1] = random.method_43048(maximumClipping) + 1;
            for (int y3 = 0; y3 < cornerClippings[diagonals.ordinal()][0]; ++y3) {
                for (int x4 = 0; x4 < cornerClippings[diagonals.ordinal()][1]; ++x4) {
                    int[] nArray = maze[diagonals.operationX.convert(x4, widthInCellCount - 2)];
                    int n = diagonals.operationY.convert(y3, heightInCellCount - 2);
                    nArray[n] = nArray[n] | 0x10;
                }
            }
        }
    }

    private void processInnerWallsAndFloor(class_3443 structureComponent, class_6130 list, class_5819 random, int offset, class_2470[] rotations) {
        for (int x = 0; x < this.widthInCellCount - 1; ++x) {
            for (int y = 0; y < this.heightInCellCount - 1; ++y) {
                CourtyardPathPiece path2;
                boolean eastSouthHasNoTerraceOrIsSafe;
                NagaCourtyardHedgeLineComponent structureLine;
                NagaCourtyardHedgePadderComponent padding2;
                NagaCourtyardHedgePadderComponent padding;
                boolean yCenter;
                boolean xCenter = x == this.widthInCellCount / 2 - 1;
                boolean bl = yCenter = y == this.heightInCellCount / 2 - 1;
                if (!xCenter && !yCenter && (this.maze[x][y] & 0x10) == 16) continue;
                int rotation = 0;
                int xBB = this.sizeConstraints.method_35415() + x * 12 + offset;
                int yBB = this.sizeConstraints.method_35416() + 1;
                int zBB = this.sizeConstraints.method_35417() + y * 12 + offset;
                if (!xCenter || !yCenter) {
                    Object structure;
                    switch (this.maze[x][y] & 0xF) {
                        case 2: {
                            ++rotation;
                        }
                        case 1: {
                            ++rotation;
                        }
                        case 8: {
                            ++rotation;
                        }
                        case 4: {
                            class_2470 rotationCap = rotations[rotation];
                            if (random.method_43056()) {
                                structure = new NagaCourtyardHedgeCapComponent(this.structureManager, x * this.widthInCellCount + y, xBB, yBB, zBB, rotationCap);
                                break;
                            }
                            structure = new NagaCourtyardHedgeCapPillarComponent(this.structureManager, x * this.widthInCellCount + y, xBB, yBB, zBB, rotationCap);
                            break;
                        }
                        case 9: {
                            ++rotation;
                        }
                        case 12: {
                            ++rotation;
                        }
                        case 6: {
                            ++rotation;
                        }
                        case 3: {
                            class_2470 rotationCorner = rotations[rotation];
                            structure = new NagaCourtyardHedgeCornerComponent(this.structureManager, this.maze[x][y], xBB, yBB, zBB, rotationCorner);
                            break;
                        }
                        case 13: {
                            ++rotation;
                        }
                        case 14: {
                            ++rotation;
                        }
                        case 7: {
                            ++rotation;
                        }
                        case 11: {
                            class_2470 rotationT = rotations[rotation];
                            structure = new NagaCourtyardHedgeTJunctionComponent(this.structureManager, this.maze[x][y], xBB, yBB, zBB, rotationT);
                            break;
                        }
                        case 10: {
                            ++rotation;
                        }
                        case 5: {
                            class_2470 rotationLine = rotations[rotation];
                            structure = new NagaCourtyardHedgeLineComponent(this.structureManager, this.maze[x][y], xBB, yBB, zBB, rotationLine);
                            break;
                        }
                        case 15: {
                            structure = new NagaCourtyardHedgeIntersectionComponent(this.structureManager, this.maze[x][y], xBB, yBB, zBB, class_2470.field_11467);
                            break;
                        }
                        default: {
                            structure = random.method_43048(150) == 0 ? new CourtyardTerraceStatue(this.maze[x][y], xBB - 6, yBB - 3, zBB - 6, class_2470.field_11467, this.structureManager) : (random.method_43056() ? new CourtyardTerraceBrazier(this.maze[x][y], xBB - 6, yBB - 3, zBB - 6, class_2470.field_11467, this.structureManager) : new CourtyardTerraceDuct(this.maze[x][y], xBB - 6, yBB - 3, zBB - 6, class_2470.field_11467, this.structureManager));
                        }
                    }
                    list.method_35462((class_3443)structure);
                    structure.method_14918(structureComponent, list, random);
                }
                xBB = this.sizeConstraints.method_35415() + x * 12 + offset;
                zBB = this.sizeConstraints.method_35417() + y * 12 + offset;
                boolean connectWest = WallFacing.WEST.unpackAndTest(this.maze[x][y]);
                boolean connectNorth = WallFacing.NORTH.unpackAndTest(this.maze[x][y]);
                boolean connectEast = WallFacing.EAST.unpackAndTest(this.maze[x][y]);
                boolean connectSouth = WallFacing.SOUTH.unpackAndTest(this.maze[x][y]);
                if (connectWest) {
                    padding = new NagaCourtyardHedgePadderComponent(this.structureManager, this.maze[x][y], xBB - 1, yBB, zBB, class_2470.field_11467);
                    list.method_35462((class_3443)padding);
                    padding.method_14918(structureComponent, list, random);
                    if (x > 0 && (this.maze[x - 1][y] & 0x10) != 16) {
                        padding2 = new NagaCourtyardHedgePadderComponent(this.structureManager, this.maze[x][y], xBB - 7, yBB, zBB, class_2470.field_11467);
                        list.method_35462((class_3443)padding2);
                        padding2.method_14918(structureComponent, list, random);
                    }
                    structureLine = new NagaCourtyardHedgeLineComponent(this.structureManager, this.maze[x][y], xBB - 6, yBB, zBB, class_2470.field_11467);
                    list.method_35462((class_3443)structureLine);
                    structureLine.method_14918(structureComponent, list, random);
                }
                if (connectNorth) {
                    padding = new NagaCourtyardHedgePadderComponent(this.structureManager, this.maze[x][y], xBB + 4, yBB, zBB - 1, class_2470.field_11463);
                    list.method_35462((class_3443)padding);
                    padding.method_14918(structureComponent, list, random);
                    if (y > 0 && (this.maze[x][y - 1] & 0x10) != 16) {
                        padding2 = new NagaCourtyardHedgePadderComponent(this.structureManager, this.maze[x][y], xBB + 4, yBB, zBB - 7, class_2470.field_11463);
                        list.method_35462((class_3443)padding2);
                        padding2.method_14918(structureComponent, list, random);
                    }
                    structureLine = new NagaCourtyardHedgeLineComponent(this.structureManager, this.maze[x][y], xBB, yBB, zBB - 6, class_2470.field_11463);
                    list.method_35462((class_3443)structureLine);
                    structureLine.method_14918(structureComponent, list, random);
                }
                if ((x >= this.widthInCellCount - 2 || (this.maze[x + 1][y] & 0x10) == 16) && connectEast) {
                    padding = new NagaCourtyardHedgePadderComponent(this.structureManager, this.maze[x][y], xBB + 5, yBB, zBB, class_2470.field_11467);
                    list.method_35462((class_3443)padding);
                    padding.method_14918(structureComponent, list, random);
                    structureLine = new NagaCourtyardHedgeLineComponent(this.structureManager, this.maze[x][y], xBB + 6, yBB, zBB, class_2470.field_11467);
                    list.method_35462((class_3443)structureLine);
                    structureLine.method_14918(structureComponent, list, random);
                }
                if ((y >= this.heightInCellCount - 2 || (this.maze[x][y + 1] & 0x10) == 16) && connectSouth) {
                    padding = new NagaCourtyardHedgePadderComponent(this.structureManager, this.maze[x][y], xBB + 4, yBB, zBB + 5, class_2470.field_11463);
                    list.method_35462((class_3443)padding);
                    padding.method_14918(structureComponent, list, random);
                    structureLine = new NagaCourtyardHedgeLineComponent(this.structureManager, this.maze[x][y], xBB, yBB, zBB + 6, class_2470.field_11463);
                    list.method_35462((class_3443)structureLine);
                    structureLine.method_14918(structureComponent, list, random);
                }
                boolean hasNoTerrace = (this.maze[x][y] & 0xF) != 0;
                boolean westHasNoTerraceOrIsSafe = x == 0 || (this.maze[x - 1][y] & 0x10) == 16 || (this.maze[x - 1][y] & 0xF) != 0;
                boolean northHasNoTerraceOrIsSafe = y == 0 || (this.maze[x][y - 1] & 0x10) == 16 || (this.maze[x][y - 1] & 0xF) != 0;
                boolean eastHasNoTerraceOrIsSafe = x == this.widthInCellCount - 2 || (this.maze[x + 1][y] & 0x10) == 16;
                boolean southHasNoTerraceOrIsSafe = y == this.heightInCellCount - 2 || (this.maze[x][y + 1] & 0x10) == 16;
                boolean westNorthHasNoTerraceOrIsSafe = x == 0 || y == 0 || this.maze[x - 1][y - 1] != 0;
                boolean westSouthHasNoTerraceOrIsSafe = x == 0 || y >= this.heightInCellCount - 2 || this.maze[x - 1][y + 1] != 0;
                boolean eastNorthHasNoTerraceOrIsSafe = x >= this.widthInCellCount - 2 || y == 0 || this.maze[x + 1][y - 1] != 0;
                boolean bl2 = eastSouthHasNoTerraceOrIsSafe = x >= this.widthInCellCount - 2 || y >= this.heightInCellCount - 2 || this.maze[x + 1][y + 1] != 0;
                if (xCenter && yCenter) {
                    CourtyardPathPiece path = new CourtyardPathPiece(this.maze[x][y], xBB - 1, yBB - 1, zBB - 1, this.structureManager);
                    list.method_35462((class_3443)path);
                    path.method_14918(structureComponent, list, random);
                }
                if (hasNoTerrace && westHasNoTerraceOrIsSafe && !connectWest) {
                    path2 = new CourtyardPathPiece(this.maze[x][y], xBB - 7, yBB - 1, zBB - 1, this.structureManager);
                    list.method_35462((class_3443)path2);
                    path2.method_14918(structureComponent, list, random);
                }
                if (hasNoTerrace && northHasNoTerraceOrIsSafe && !connectNorth) {
                    path2 = new CourtyardPathPiece(this.maze[x][y], xBB - 1, yBB - 1, zBB - 7, this.structureManager);
                    list.method_35462((class_3443)path2);
                    path2.method_14918(structureComponent, list, random);
                }
                if (hasNoTerrace && eastHasNoTerraceOrIsSafe) {
                    path2 = new CourtyardPathPiece(this.maze[x][y], xBB + 5, yBB - 1, zBB - 1, this.structureManager);
                    list.method_35462((class_3443)path2);
                    path2.method_14918(structureComponent, list, random);
                }
                if (hasNoTerrace && southHasNoTerraceOrIsSafe) {
                    path2 = new CourtyardPathPiece(this.maze[x][y], xBB - 1, yBB - 1, zBB + 5, this.structureManager);
                    list.method_35462((class_3443)path2);
                    path2.method_14918(structureComponent, list, random);
                }
                if (hasNoTerrace && westHasNoTerraceOrIsSafe && northHasNoTerraceOrIsSafe && westNorthHasNoTerraceOrIsSafe) {
                    path2 = new CourtyardPathPiece(this.maze[x][y], xBB - 7, yBB - 1, zBB - 7, this.structureManager);
                    list.method_35462((class_3443)path2);
                    path2.method_14918(structureComponent, list, random);
                }
                if (hasNoTerrace && westHasNoTerraceOrIsSafe && southHasNoTerraceOrIsSafe && westSouthHasNoTerraceOrIsSafe) {
                    path2 = new CourtyardPathPiece(this.maze[x][y], xBB - 7, yBB - 1, zBB + 5, this.structureManager);
                    list.method_35462((class_3443)path2);
                    path2.method_14918(structureComponent, list, random);
                }
                if (hasNoTerrace && eastHasNoTerraceOrIsSafe && northHasNoTerraceOrIsSafe && eastNorthHasNoTerraceOrIsSafe) {
                    path2 = new CourtyardPathPiece(this.maze[x][y], xBB + 5, yBB - 1, zBB - 7, this.structureManager);
                    list.method_35462((class_3443)path2);
                    path2.method_14918(structureComponent, list, random);
                }
                if (!hasNoTerrace || !eastHasNoTerraceOrIsSafe || !southHasNoTerraceOrIsSafe || !eastSouthHasNoTerraceOrIsSafe) continue;
                path2 = new CourtyardPathPiece(this.maze[x][y], xBB + 5, yBB - 1, zBB + 5, this.structureManager);
                list.method_35462((class_3443)path2);
                path2.method_14918(structureComponent, list, random);
            }
        }
    }

    private void processOuterWalls(class_3443 structureComponent, class_6130 list, class_5819 random, int offset, class_2470[] rotations) {
        for (Diagonals diagonal : Diagonals.values()) {
            int zBoundX = diagonal.isTop() ? this.sizeConstraints.method_35417() + this.cornerClipping[diagonal.ordinal()][0] * 12 - 3 : this.sizeConstraints.method_35420() - this.cornerClipping[diagonal.ordinal()][0] * 12 + 1;
            CourtyardWallPadder paddingStartX = new CourtyardWallPadder(this.cornerClipping[diagonal.ordinal()][1] * 2 + 1, diagonal.isLeft() ? this.sizeConstraints.method_35415() + 2 : this.sizeConstraints.method_35418() - 2, this.sizeConstraints.method_35416() + 1, zBoundX, class_2470.field_11467, this.structureManager);
            list.method_35462((class_3443)paddingStartX);
            paddingStartX.method_14918(structureComponent, list, random);
            int xPadOffset = diagonal.isLeft() ? 11 : -1;
            for (int i = 0; i < this.cornerClipping[diagonal.ordinal()][1] - 1; ++i) {
                int xBound = diagonal.isLeft() ? this.sizeConstraints.method_35415() + i * 12 + 3 : this.sizeConstraints.method_35418() - i * 12 - 13;
                CourtyardWall wall = new CourtyardWall(i * 2, xBound, this.sizeConstraints.method_35416() + 1, zBoundX, class_2470.field_11467, this.structureManager);
                list.method_35462((class_3443)wall);
                wall.method_14918(structureComponent, list, random);
                CourtyardWallPadder padding = new CourtyardWallPadder(i * 2 + 1, xBound + xPadOffset, this.sizeConstraints.method_35416() + 1, zBoundX, class_2470.field_11467, this.structureManager);
                list.method_35462((class_3443)padding);
                padding.method_14918(structureComponent, list, random);
            }
            int xBoundZ = diagonal.isLeft() ? this.sizeConstraints.method_35415() + this.cornerClipping[diagonal.ordinal()][1] * 12 - 1 : this.sizeConstraints.method_35418() - this.cornerClipping[diagonal.ordinal()][1] * 12 + 3;
            CourtyardWallPadder paddingStartZ = new CourtyardWallPadder(this.cornerClipping[diagonal.ordinal()][1] * 2 + 1, xBoundZ, this.sizeConstraints.method_35416() + 1, diagonal.isTop() ? this.sizeConstraints.method_35417() + 2 : this.sizeConstraints.method_35420() - 2, class_2470.field_11463, this.structureManager);
            list.method_35462((class_3443)paddingStartZ);
            paddingStartZ.method_14918(structureComponent, list, random);
            int zPadOffset = diagonal.isTop() ? 11 : -1;
            for (int i = 0; i < this.cornerClipping[diagonal.ordinal()][0] - 1; ++i) {
                int zBound = diagonal.isTop() ? this.sizeConstraints.method_35417() + i * 12 + 3 : this.sizeConstraints.method_35420() - i * 12 - 13;
                CourtyardWall wall = new CourtyardWall(i * 2, xBoundZ, this.sizeConstraints.method_35416() + 1, zBound, class_2470.field_11463, this.structureManager);
                list.method_35462((class_3443)wall);
                wall.method_14918(structureComponent, list, random);
                CourtyardWallPadder padding = new CourtyardWallPadder(i * 2 + 1, xBoundZ, this.sizeConstraints.method_35416() + 1, zBound + zPadOffset, class_2470.field_11463, this.structureManager);
                list.method_35462((class_3443)padding);
                padding.method_14918(structureComponent, list, random);
            }
            int wallCornerInnerX = this.sizeConstraints.method_35415() + diagonal.operationX.convert(this.cornerClipping[diagonal.ordinal()][1], this.widthInCellCount - 1) * 12;
            int wallCornerInnerZ = this.sizeConstraints.method_35417() + diagonal.operationY.convert(this.cornerClipping[diagonal.ordinal()][0], this.heightInCellCount - 1) * 12;
            class_2470 cornerRotation = rotations[diagonal.ordinal() % rotations.length];
            boolean shiftX = cornerRotation == class_2470.field_11464 || cornerRotation == class_2470.field_11465;
            boolean shiftZ = cornerRotation == class_2470.field_11463 || cornerRotation == class_2470.field_11464;
            CourtyardWallCornerOuter corner1 = new CourtyardWallCornerOuter(diagonal.ordinal() * 3, wallCornerInnerX + (shiftZ ? (shiftX ? 1 : 7) : (shiftX ? -3 : 3)), this.sizeConstraints.method_35416() + 1, (diagonal.isTop() ? this.sizeConstraints.method_35417() : this.sizeConstraints.method_35420() - 1) + (shiftZ ? (shiftX ? 4 : 0) : (shiftX ? 1 : -3)), cornerRotation, this.structureManager);
            list.method_35462((class_3443)corner1);
            corner1.method_14918(structureComponent, list, random);
            CourtyardWallCornerOuter corner2 = new CourtyardWallCornerOuter(diagonal.ordinal() * 3 + 1, (diagonal.isLeft() ? this.sizeConstraints.method_35415() : this.sizeConstraints.method_35418() - 1) + (shiftZ ? (shiftX ? 1 : 4) : (shiftX ? -3 : 0)), this.sizeConstraints.method_35416() + 1, wallCornerInnerZ + (shiftZ ? (shiftX ? 7 : 3) : (shiftX ? 1 : -3)), cornerRotation, this.structureManager);
            list.method_35462((class_3443)corner2);
            corner2.method_14918(structureComponent, list, random);
            CourtyardWallCornerInner innerCorner = new CourtyardWallCornerInner(diagonal.ordinal() * 3 + 3, wallCornerInnerX + (shiftZ ? (shiftX ? -1 : 13) : (shiftX ? -9 : 5)), this.sizeConstraints.method_35416() + 1, wallCornerInnerZ + (shiftZ ? (shiftX ? 13 : 5) : (shiftX ? -1 : -9)), cornerRotation, this.structureManager);
            list.method_35462((class_3443)innerCorner);
            innerCorner.method_14918(structureComponent, list, random);
        }
        for (int i = this.cornerClipping[3][1]; i < this.widthInCellCount - 1 - this.cornerClipping[0][1]; ++i) {
            CourtyardWall wall = new CourtyardWall(i, this.sizeConstraints.method_35415() + i * 12 + offset - 3, this.sizeConstraints.method_35416() + 1, this.sizeConstraints.method_35417() - 3, class_2470.field_11467, this.structureManager);
            list.method_35462((class_3443)wall);
            wall.method_14918(structureComponent, list, random);
            CourtyardWallPadder padding = new CourtyardWallPadder(i, this.sizeConstraints.method_35415() + i * 12 + offset - 4, this.sizeConstraints.method_35416() + 1, this.sizeConstraints.method_35417() - 3, class_2470.field_11467, this.structureManager);
            list.method_35462((class_3443)padding);
            padding.method_14918(structureComponent, list, random);
        }
        CourtyardWallPadder padding2 = new CourtyardWallPadder(this.widthInCellCount - 1 - this.cornerClipping[0][1], this.sizeConstraints.method_35415() + (this.widthInCellCount - 1 - this.cornerClipping[0][1]) * 12 + offset - 4, this.sizeConstraints.method_35416() + 1, this.sizeConstraints.method_35417() - 3, class_2470.field_11467, this.structureManager);
        list.method_35462((class_3443)padding2);
        padding2.method_14918(structureComponent, list, random);
        for (int i = this.cornerClipping[2][1]; i < this.widthInCellCount - 1 - this.cornerClipping[1][1]; ++i) {
            CourtyardWall wall = new CourtyardWall(i, this.sizeConstraints.method_35415() + i * 12 + offset - 3, this.sizeConstraints.method_35416() + 1, this.sizeConstraints.method_35420() + 1, class_2470.field_11467, this.structureManager);
            list.method_35462((class_3443)wall);
            wall.method_14918(structureComponent, list, random);
            CourtyardWallPadder padding = new CourtyardWallPadder(i, this.sizeConstraints.method_35415() + i * 12 + offset - 4, this.sizeConstraints.method_35416() + 1, this.sizeConstraints.method_35420() + 1, class_2470.field_11467, this.structureManager);
            list.method_35462((class_3443)padding);
            padding.method_14918(structureComponent, list, random);
        }
        CourtyardWallPadder padding5 = new CourtyardWallPadder(this.widthInCellCount - 1 - this.cornerClipping[1][1], this.sizeConstraints.method_35415() + (this.widthInCellCount - 1 - this.cornerClipping[1][1]) * 12 + offset - 4, this.sizeConstraints.method_35416() + 1, this.sizeConstraints.method_35420() + 1, class_2470.field_11467, this.structureManager);
        list.method_35462((class_3443)padding5);
        padding5.method_14918(structureComponent, list, random);
        for (int i = this.cornerClipping[3][0]; i < this.heightInCellCount - 1 - this.cornerClipping[2][0]; ++i) {
            CourtyardWall wall = new CourtyardWall(i, this.sizeConstraints.method_35415() - 1, this.sizeConstraints.method_35416() + 1, this.sizeConstraints.method_35417() + i * 12 + offset - 3, class_2470.field_11463, this.structureManager);
            list.method_35462((class_3443)wall);
            wall.method_14918(structureComponent, list, random);
            CourtyardWallPadder padding = new CourtyardWallPadder(i, this.sizeConstraints.method_35415() - 1, this.sizeConstraints.method_35416() + 1, this.sizeConstraints.method_35417() + i * 12 + offset - 4, class_2470.field_11463, this.structureManager);
            list.method_35462((class_3443)padding);
            padding.method_14918(structureComponent, list, random);
        }
        CourtyardWallPadder padding8 = new CourtyardWallPadder(this.heightInCellCount - 1 - this.cornerClipping[2][0], this.sizeConstraints.method_35415() - 1, this.sizeConstraints.method_35416() + 1, this.sizeConstraints.method_35417() + (this.heightInCellCount - 1 - this.cornerClipping[2][0]) * 12 + offset - 4, class_2470.field_11463, this.structureManager);
        list.method_35462((class_3443)padding8);
        padding8.method_14918(structureComponent, list, random);
        for (int i = this.cornerClipping[0][0]; i < this.heightInCellCount - 1 - this.cornerClipping[1][0]; ++i) {
            CourtyardWall wall = new CourtyardWall(i, this.sizeConstraints.method_35418() + 3, this.sizeConstraints.method_35416() + 1, this.sizeConstraints.method_35417() + i * 12 + offset - 3, class_2470.field_11463, this.structureManager);
            list.method_35462((class_3443)wall);
            wall.method_14918(structureComponent, list, random);
            CourtyardWallPadder padding = new CourtyardWallPadder(i, this.sizeConstraints.method_35418() + 3, this.sizeConstraints.method_35416() + 1, this.sizeConstraints.method_35417() + i * 12 + offset - 4, class_2470.field_11463, this.structureManager);
            list.method_35462((class_3443)padding);
            padding.method_14918(structureComponent, list, random);
        }
        CourtyardWallPadder padding11 = new CourtyardWallPadder(this.heightInCellCount - 1 - this.cornerClipping[1][0], this.sizeConstraints.method_35418() + 3, this.sizeConstraints.method_35416() + 1, this.sizeConstraints.method_35417() + (this.heightInCellCount - 1 - this.cornerClipping[1][0]) * 12 + offset - 4, class_2470.field_11463, this.structureManager);
        list.method_35462((class_3443)padding11);
        padding11.method_14918(structureComponent, list, random);
    }

    private static String getStringFromFacings(int directions) {
        return switch (directions & 0xF) {
            case 2 -> " \u2577 ";
            case 1 -> " \u2576\u2500";
            case 8 -> " \u2575 ";
            case 4 -> "\u2500\u2574 ";
            case 9 -> " \u2514\u2500";
            case 12 -> "\u2500\u2518 ";
            case 6 -> "\u2500\u2510 ";
            case 3 -> " \u250c\u2500";
            case 13 -> "\u2500\u2534\u2500";
            case 14 -> "\u2500\u2524 ";
            case 7 -> "\u2500\u252c\u2500";
            case 11 -> " \u251c\u2500";
            case 10 -> " \u2502 ";
            case 5 -> "\u2500\u2500\u2500";
            case 15 -> "\u2500\u253c\u2500";
            default -> " \u2022 ";
        };
    }

    @Override
    protected void method_14943(class_6625 ctx, class_2487 tagCompound) {
        super.method_14943(ctx, tagCompound);
        class_2499 mazeX = new class_2499();
        for (int x = 0; x < this.widthInCellCount - 1; ++x) {
            class_2499 mazeY = new class_2499();
            for (int y = 0; y < this.heightInCellCount - 1; ++y) {
                mazeY.add((Object)class_2497.method_23247((int)this.maze[x][y]));
            }
            mazeX.add((Object)mazeY);
        }
        tagCompound.method_10569("mazeWidth", this.widthInCellCount);
        tagCompound.method_10569("mazeHeight", this.heightInCellCount);
        tagCompound.method_10566("maze", (class_2520)mazeX);
        tagCompound.method_10566("constraints", (class_2520)BoundingBoxUtils.boundingBoxToNBT(this.sizeConstraints));
    }

    protected static enum WallFacing {
        EAST(1, 4, 14, 11, class_2350.field_11034, 1, 0),
        SOUTH(2, 8, 13, 7, class_2350.field_11035, 0, 1),
        WEST(4, 1, 11, 14, class_2350.field_11039, -1, 0),
        NORTH(8, 2, 7, 13, class_2350.field_11043, 0, -1);

        private final int BYTE;
        private final int OPPOSITE;
        private final int INVERTED;
        private final int INVERTED_OPPOSITE;
        private final int xOffset;
        private final int zOffset;

        private WallFacing(int bite, int oppositeBite, int inverted, int invertedOpposite, class_2350 enumFacing, int xOffset, int zOffset) {
            this.BYTE = bite;
            this.OPPOSITE = oppositeBite;
            this.INVERTED = inverted;
            this.INVERTED_OPPOSITE = invertedOpposite;
            this.xOffset = xOffset;
            this.zOffset = zOffset;
        }

        private boolean unpackAndTest(int directions) {
            return (this.BYTE & directions) == this.BYTE;
        }
    }
}

