/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.layer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import java.util.function.LongFunction;
import net.minecraft.class_156;
import net.minecraft.class_1959;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import twilightforest.init.TFDimensionSettings;
import twilightforest.init.custom.BiomeLayerStack;
import twilightforest.init.custom.BiomeLayerTypes;
import twilightforest.world.components.layer.vanillalegacy.Area;
import twilightforest.world.components.layer.vanillalegacy.BiomeLayerFactory;
import twilightforest.world.components.layer.vanillalegacy.BiomeLayerType;
import twilightforest.world.components.layer.vanillalegacy.area.LazyArea;
import twilightforest.world.components.layer.vanillalegacy.context.BigContext;
import twilightforest.world.components.layer.vanillalegacy.context.LazyAreaContext;
import twilightforest.world.components.layer.vanillalegacy.traits.AreaTransformer1;

public record KeyBiomesLayer(List<class_5321<class_1959>> keyBiomes) implements AreaTransformer1
{
    private static final Random RANDOM = new Random();

    @Override
    public int getParentX(int x) {
        return x | 3;
    }

    @Override
    public int getParentY(int z) {
        return z | 3;
    }

    @Override
    public class_5321<class_1959> applyPixel(BigContext<?> context, Area layer, int x, int z) {
        RANDOM.setSeed(TFDimensionSettings.seed + (long)(x & 0xFFFFFFFC) * 25117L + (long)(z & 0xFFFFFFFC) * 151121L);
        int ox = RANDOM.nextInt(2) + 1;
        int oz = RANDOM.nextInt(2) + 1;
        RANDOM.setSeed(TFDimensionSettings.seed + (long)(x / 8) * 25117L + (long)(z / 8) * 151121L);
        int offset = RANDOM.nextInt(3);
        if ((x & 3) == ox && (z & 3) == oz) {
            if ((x & 4) == 0) {
                if ((z & 4) == 0) {
                    return this.getKeyBiomeFor(offset);
                }
                return this.getKeyBiomeFor(offset + 1);
            }
            if ((z & 4) == 0) {
                return this.getKeyBiomeFor(offset + 2);
            }
            return this.getKeyBiomeFor(offset + 3);
        }
        return layer.getBiome(x, z);
    }

    private class_5321<class_1959> getKeyBiomeFor(int index) {
        return this.keyBiomes.get(index & 3);
    }

    public static final class Factory
    implements BiomeLayerFactory {
        public static final Codec<Factory> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.LONG.fieldOf("salt").forGetter(Factory::salt), (App)class_5321.method_39154((class_5321)class_7924.field_41236).listOf().comapFlatMap(list -> class_156.method_33141((List)list, (int)4), Function.identity()).fieldOf("key_biomes").forGetter(Factory::keyBiomes), (App)BiomeLayerStack.HOLDER_CODEC.fieldOf("parent").forGetter(Factory::parent)).apply((Applicative)inst, Factory::new));
        private final long salt;
        private final List<class_5321<class_1959>> keyBiomes;
        private final class_6880<BiomeLayerFactory> parent;
        private final KeyBiomesLayer instance;

        public Factory(long salt, List<class_5321<class_1959>> keyBiomes, class_6880<BiomeLayerFactory> parent) {
            this.salt = salt;
            this.keyBiomes = keyBiomes;
            this.parent = parent;
            this.instance = new KeyBiomesLayer(keyBiomes);
        }

        @Override
        public LazyArea build(LongFunction<LazyAreaContext> contextFactory) {
            return this.instance.run(contextFactory.apply(this.salt), ((BiomeLayerFactory)this.parent.comp_349()).build(contextFactory));
        }

        @Override
        public BiomeLayerType getType() {
            return (BiomeLayerType)BiomeLayerTypes.KEY_BIOMES.get();
        }

        public long salt() {
            return this.salt;
        }

        public List<class_5321<class_1959>> keyBiomes() {
            return this.keyBiomes;
        }

        public class_6880<BiomeLayerFactory> parent() {
            return this.parent;
        }
    }
}

