/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.loot.modifiers;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.fabricators_of_create.porting_lib.loot.IGlobalLootModifier;
import io.github.fabricators_of_create.porting_lib.loot.LootModifier;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_47;
import net.minecraft.class_5341;
import org.jetbrains.annotations.NotNull;
import twilightforest.block.GiantBlock;
import twilightforest.capabilities.CapabilityList;
import twilightforest.capabilities.giant_pick.GiantPickMineCapability;
import twilightforest.item.GiantPickItem;

public class GiantToolGroupingModifier
extends LootModifier {
    public static final Map<class_2248, class_1792> CONVERSIONS = new HashMap<class_2248, class_1792>();
    public static final Codec<GiantToolGroupingModifier> CODEC = RecordCodecBuilder.create(inst -> LootModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, GiantToolGroupingModifier::new));

    public GiantToolGroupingModifier(class_5341[] conditions) {
        super(conditions);
    }

    @NotNull
    protected ObjectArrayList<class_1799> doApply(ObjectArrayList<class_1799> generatedLoot, class_47 context) {
        Object object = context.method_35508(class_181.field_1226);
        if (object instanceof class_1657) {
            class_1657 player = (class_1657)object;
            class_2680 state = (class_2680)context.method_35508(class_181.field_1224);
            if (CONVERSIONS.containsKey(state.method_26204())) {
                GiantPickMineCapability giantPickMineCapability = (GiantPickMineCapability)CapabilityList.GIANT_PICK_MINE.get((Object)player);
                int blockConversion = giantPickMineCapability.getGiantBlockConversion();
                giantPickMineCapability.setGiantBlockConversion(blockConversion - 1);
                if (blockConversion == 64) {
                    return ObjectArrayList.of((Object[])new class_1799[]{new class_1799((class_1935)CONVERSIONS.get(state.method_26204()))});
                }
                return new ObjectArrayList();
            }
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }

    public static boolean breakBlock(class_1937 world, class_1657 player, class_2338 pos, class_2680 state, class_2586 blockEntity) {
        GiantPickMineCapability capability;
        class_3222 serverPlayer;
        if (player instanceof class_3222 && GiantToolGroupingModifier.canHarvestWithGiantPick((class_1657)(serverPlayer = (class_3222)player), state) && GiantToolGroupingModifier.shouldBreakGiantBlock((class_1657)serverPlayer, capability = (GiantPickMineCapability)CapabilityList.GIANT_PICK_MINE.get((Object)serverPlayer))) {
            capability.setBreaking(true);
            boolean allTheSame = CONVERSIONS.containsKey(state.method_26204());
            for (class_2338 offsetPos : GiantBlock.getVolume(pos)) {
                if (!allTheSame || serverPlayer.method_37908().method_8320(offsetPos).method_27852(state.method_26204())) continue;
                allTheSame = false;
            }
            capability.setGiantBlockConversion(allTheSame ? 64 : 0);
            serverPlayer.method_37908().method_20290(2001, pos, class_2248.method_9507((class_2680)state));
            serverPlayer.field_13974.method_14266(pos);
            for (class_2338 offsetPos : GiantBlock.getVolume(pos)) {
                if (offsetPos.equals((Object)pos) || !serverPlayer.method_37908().method_8320(offsetPos).method_27852(state.method_26204())) continue;
                class_2338 newPos = new class_2338((class_2382)offsetPos);
                serverPlayer.method_37908().method_20290(2001, newPos, class_2248.method_9507((class_2680)serverPlayer.method_37908().method_8320(newPos)));
                serverPlayer.field_13974.method_14266(newPos);
            }
            capability.setBreaking(false);
            return false;
        }
        return true;
    }

    private static boolean canHarvestWithGiantPick(class_1657 player, class_2680 state) {
        return player.method_6047().method_7909() instanceof GiantPickItem;
    }

    private static boolean shouldBreakGiantBlock(class_1657 player, GiantPickMineCapability capability) {
        return capability.getMining() == player.method_37908().method_8510() && !capability.getBreaking();
    }
}

