/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.events;

import io.github.fabricators_of_create.porting_lib.entity.events.LivingEntityEvents;
import io.github.fabricators_of_create.porting_lib.entity.events.living.LivingDamageEvent;
import me.pepperbell.simplenetworking.S2CPacket;
import net.fabricmc.fabric.api.entity.event.v1.ServerEntityWorldChangeEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.networking.v1.EntityTrackingEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_8103;
import twilightforest.TFConfig;
import twilightforest.block.TFPortalBlock;
import twilightforest.capabilities.CapabilityList;
import twilightforest.capabilities.fan.FeatherFanFallCapability;
import twilightforest.capabilities.shield.IShieldCapability;
import twilightforest.capabilities.thrown.YetiThrowCapability;
import twilightforest.network.TFPacketHandler;
import twilightforest.network.UpdateShieldPacket;

public class CapabilityEvents {
    private static final String NBT_TAG_TWILIGHT = "twilightforest_banished";

    public static void init() {
        LivingEntityEvents.LivingTickEvent.TICK.register(CapabilityEvents::updateCaps);
        LivingDamageEvent.DAMAGE.register(CapabilityEvents::livingAttack);
        ServerPlayerEvents.AFTER_RESPAWN.register(CapabilityEvents::onPlayerRespawn);
        ServerEntityWorldChangeEvents.AFTER_PLAYER_CHANGE_WORLD.register(CapabilityEvents::playerPortals);
        EntityTrackingEvents.START_TRACKING.register(CapabilityEvents::onStartTracking);
    }

    public static void updateCaps(LivingEntityEvents.LivingTickEvent event) {
        class_1309 entity = event.getEntity();
        CapabilityList.SHIELDS.maybeGet((Object)entity).ifPresent(IShieldCapability::update);
        CapabilityList.FEATHER_FAN_FALLING.maybeGet((Object)entity).ifPresent(FeatherFanFallCapability::update);
        CapabilityList.YETI_THROWN.maybeGet((Object)entity).ifPresent(YetiThrowCapability::update);
    }

    public static void livingAttack(LivingDamageEvent event) {
        class_1309 class_13092 = event.getEntity();
        if (class_13092 instanceof class_1657) {
            class_1657 player = (class_1657)class_13092;
            if (player.method_31549().field_7480) {
                return;
            }
        }
        if (!event.getEntity().method_37908().method_8608() && !event.getSource().method_48789(class_8103.field_42241)) {
            CapabilityList.SHIELDS.maybeGet((Object)event.getEntity()).ifPresent(cap -> {
                if (cap.shieldsLeft() > 0) {
                    cap.breakShield();
                    event.setCanceled(true);
                }
            });
        }
    }

    public static void onPlayerRespawn(class_3222 oldPlayer, class_3222 serverPlayer, boolean alive) {
        if (alive) {
            CapabilityEvents.updateCapabilities(serverPlayer, (class_1297)serverPlayer);
        }
        if (((Boolean)TFConfig.COMMON_CONFIG.DIMENSION.newPlayersSpawnInTF.get()).booleanValue() && serverPlayer.method_26280() == null) {
            class_2487 tagCompound = serverPlayer.getCustomData();
            class_2487 playerData = tagCompound.method_10562("PlayerPersisted");
            playerData.method_10556(NBT_TAG_TWILIGHT, false);
            tagCompound.method_10566("PlayerPersisted", (class_2520)playerData);
            CapabilityEvents.banishNewbieToTwilightZone((class_1657)serverPlayer);
        }
    }

    public static void playerLogsIn(class_3222 player) {
        CapabilityEvents.updateCapabilities(player, (class_1297)player);
        CapabilityEvents.banishNewbieToTwilightZone((class_1657)player);
    }

    public static void playerPortals(class_3222 player, class_3218 origin, class_3218 destination) {
        CapabilityEvents.updateCapabilities(player, (class_1297)player);
    }

    public static void onStartTracking(class_1297 trackedEntity, class_3222 player) {
        CapabilityEvents.updateCapabilities(player, trackedEntity);
    }

    private static void updateCapabilities(class_3222 clientTarget, class_1297 shielded) {
        CapabilityList.SHIELDS.maybeGet((Object)shielded).ifPresent(cap -> {
            if (cap.shieldsLeft() > 0) {
                TFPacketHandler.CHANNEL.sendToClient((S2CPacket)new UpdateShieldPacket(shielded, (IShieldCapability)cap), clientTarget);
            }
        });
    }

    private static void banishNewbieToTwilightZone(class_1657 player) {
        class_2487 tagCompound = player.getCustomData();
        class_2487 playerData = tagCompound.method_10562("PlayerPersisted");
        boolean shouldBanishPlayer = (Boolean)TFConfig.COMMON_CONFIG.DIMENSION.newPlayersSpawnInTF.get() != false && !playerData.method_10577(NBT_TAG_TWILIGHT);
        playerData.method_10556(NBT_TAG_TWILIGHT, true);
        tagCompound.method_10566("PlayerPersisted", (class_2520)playerData);
        if (shouldBanishPlayer) {
            TFPortalBlock.attemptSendEntity((class_1297)player, true, (Boolean)TFConfig.COMMON_CONFIG.DIMENSION.portalForNewPlayerSpawn.get());
        }
    }
}

