/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.data.custom.stalactites.entry;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import it.unimi.dsi.fastutil.Pair;
import java.lang.reflect.Type;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3518;
import net.minecraft.class_7923;
import twilightforest.data.custom.stalactites.entry.StalactiteReloadListener;

public record Stalactite(Map<class_2248, Integer> ores, float sizeVariation, int maxLength, int weight) {
    private static StalactiteReloadListener STALACTITE_CONFIG;

    public static void reloadStalactites() {
        STALACTITE_CONFIG = new StalactiteReloadListener();
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)STALACTITE_CONFIG);
    }

    public static StalactiteReloadListener getStalactiteConfig() {
        if (STALACTITE_CONFIG == null) {
            throw new IllegalStateException("Can not retrieve Stalactites yet!");
        }
        return STALACTITE_CONFIG;
    }

    public static enum HollowHillType {
        SMALL,
        MEDIUM,
        LARGE;

    }

    public static class Serializer
    implements JsonDeserializer<Stalactite>,
    JsonSerializer<Stalactite> {
        public Stalactite deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonobject = class_3518.method_15295((JsonElement)json, (String)"stalactite");
            float size = class_3518.method_15259((JsonObject)jsonobject, (String)"size_variation");
            int maxLength = class_3518.method_15260((JsonObject)jsonobject, (String)"max_length");
            int weight = class_3518.method_15260((JsonObject)jsonobject, (String)"weight");
            return new Stalactite(this.deserializeBlockMap(jsonobject), size, maxLength, weight);
        }

        private Map<class_2248, Integer> deserializeBlockMap(JsonObject json) {
            JsonArray array = class_3518.method_15261((JsonObject)json, (String)"blocks");
            HashMap<class_2248, Integer> map = new HashMap<class_2248, Integer>();
            array.forEach(jsonElement -> map.put((class_2248)class_7923.field_41175.method_10223(class_2960.method_12829((String)class_3518.method_15265((JsonObject)jsonElement.getAsJsonObject(), (String)"block"))), class_3518.method_15260((JsonObject)jsonElement.getAsJsonObject(), (String)"weight")));
            return map;
        }

        public JsonElement serialize(Stalactite stalactite, Type type, JsonSerializationContext context) {
            JsonObject jsonobject = new JsonObject();
            JsonArray array = new JsonArray();
            List<Pair> blockWeights = stalactite.ores().entrySet().stream().map(e -> Pair.of((Object)class_7923.field_41175.method_10221((Object)((class_2248)e.getKey())), (Object)((Integer)e.getValue()))).sorted(Comparator.comparing(Pair::left)).toList();
            for (Pair entry : blockWeights) {
                JsonObject entryObject = new JsonObject();
                entryObject.add("block", context.serialize((Object)((class_2960)entry.left()).method_12832()));
                entryObject.add("weight", context.serialize(entry.right()));
                array.add((JsonElement)entryObject);
            }
            jsonobject.add("blocks", (JsonElement)array);
            jsonobject.add("size_variation", context.serialize((Object)Float.valueOf(stalactite.sizeVariation())));
            jsonobject.add("max_length", context.serialize((Object)stalactite.maxLength()));
            jsonobject.add("weight", context.serialize((Object)stalactite.weight()));
            return jsonobject;
        }
    }
}

