/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.model.block.giantblock;

import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.model.FabricBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.class_1058;
import net.minecraft.class_1086;
import net.minecraft.class_1087;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3665;
import net.minecraft.class_5819;
import net.minecraft.class_777;
import net.minecraft.class_783;
import net.minecraft.class_787;
import net.minecraft.class_796;
import net.minecraft.class_806;
import net.minecraft.class_809;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import twilightforest.block.GiantBlock;
import twilightforest.util.Vec2i;

public class GiantBlockModel
implements class_1087,
FabricBakedModel {
    private static final class_796 FACE_BAKERY = new class_796();
    private final class_1058[] textures;
    private final class_1058 particle;
    private final class_806 overrides;
    private final class_809 transforms;

    public GiantBlockModel(class_1058[] texture, class_1058 particle, class_806 overrides, class_809 transforms) {
        this.textures = texture;
        this.particle = particle;
        this.overrides = overrides;
        this.transforms = transforms;
    }

    public void emitBlockQuads(class_1920 blockView, class_2680 state, class_2338 pos, Supplier<class_5819> randomSupplier, RenderContext context) {
        QuadEmitter emitter = context.getEmitter();
        context.pushTransform(quad -> !Iterables.contains(GiantBlock.getVolume(pos), (Object)pos.method_10081(quad.cullFace().method_10163())));
        for (class_2350 side : class_2350.values()) {
            Vec2i coords = this.calculateOffset(side, pos.method_10081((class_2382)this.magicOffsetFromDir(side)));
            class_1058 sprite = this.textures[this.textures.length > 1 ? side.ordinal() : 0];
            emitter.fromVanilla(FACE_BAKERY.method_3468(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(16.0f, 16.0f, 16.0f), new class_783(side, side.ordinal(), side.name(), new class_787(new float[]{0.0f + (float)coords.x, 0.0f + (float)coords.z, 4.0f + (float)coords.x, 4.0f + (float)coords.z}, 0)), sprite, side, (class_3665)class_1086.field_5350, null, false, new class_2960(sprite.method_45852().method_12836(), sprite.method_45852().method_12832() + "_" + side.name().toLowerCase(Locale.ROOT))), RendererAccess.INSTANCE.getRenderer().materialFinder().find(), side);
            emitter.emit();
        }
        context.popTransform();
    }

    public void emitItemQuads(class_1799 stack, Supplier<class_5819> randomSupplier, RenderContext context) {
    }

    private class_2338 magicOffsetFromDir(class_2350 side) {
        return switch (side) {
            default -> new class_2338(0, 0, -1);
            case class_2350.field_11033 -> new class_2338(0, 0, 2);
            case class_2350.field_11043, class_2350.field_11035 -> new class_2338(0, 1, 0);
            case class_2350.field_11039, class_2350.field_11034 -> new class_2338(0, 1, -1);
        };
    }

    private Vec2i calculateOffset(class_2350 side, class_2338 pos) {
        int offsetY;
        int offsetX;
        int x = pos.method_10263();
        int y = pos.method_10264();
        int z = pos.method_10260();
        if (side.method_10166().method_10178()) {
            offsetX = x % 4;
            offsetY = (side.method_10164() * z + 1) % 4;
        } else if (side.method_10166() == class_2350.class_2351.field_11051) {
            offsetX = x % 4;
            offsetY = -y % 4;
        } else {
            offsetX = (z + 1) % 4;
            offsetY = -y % 4;
        }
        if (side == class_2350.field_11043 || side == class_2350.field_11034) {
            offsetX = (4 - offsetX - 1) % 4;
        }
        if (offsetX < 0) {
            offsetX += 16;
        }
        if (offsetY < 0) {
            offsetY += 16;
        }
        return new Vec2i(offsetX % 4 * 4, offsetY % 4 * 4);
    }

    public List<class_777> method_4707(@Nullable class_2680 blockState, @Nullable class_2350 direction, class_5819 randomSource) {
        return null;
    }

    public boolean method_4708() {
        return true;
    }

    public boolean method_4712() {
        return true;
    }

    public boolean method_24304() {
        return true;
    }

    public boolean method_4713() {
        return false;
    }

    public class_1058 method_4711() {
        return this.particle;
    }

    public class_806 method_4710() {
        return this.overrides;
    }

    @NotNull
    public class_809 method_4709() {
        return this.transforms;
    }

    @NotNull
    public boolean isVanillaAdapter() {
        return false;
    }
}

