/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_2902;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3922;
import net.minecraft.class_4066;
import net.minecraft.class_5819;
import net.minecraft.class_757;
import net.minecraft.class_761;
import net.minecraft.class_765;
import org.apache.commons.lang3.tuple.Pair;
import twilightforest.TFConfig;
import twilightforest.block.CloudBlock;
import twilightforest.client.renderer.TFWeatherRenderer;
import twilightforest.util.Vec2i;

@Environment(value=EnvType.CLIENT)
public class CloudEvents {
    private static final List<PrecipitationRenderHelper> RENDER_HELPER = new ArrayList<PrecipitationRenderHelper>();

    public static void register() {
        ClientTickEvents.END_CLIENT_TICK.register(CloudEvents::clientTick);
        WorldRenderEvents.AFTER_SETUP.register(CloudEvents::renderCloudBlockPrecipitation);
    }

    public static void clientTick(class_310 mc) {
        if (!mc.method_1493() && mc.field_1687 != null && TFConfig.getClientCloudBlockPrecipitationDistance() > 0) {
            class_243 vec3 = mc.field_1773.method_19418().method_19326();
            if (mc.field_1687.method_8510() % 10L == 0L) {
                RENDER_HELPER.clear();
                double camX = vec3.method_10216();
                double camY = vec3.method_10214();
                double camZ = vec3.method_10215();
                int floorX = class_3532.method_15357((double)camX);
                int floorY = class_3532.method_15357((double)camY);
                int floorZ = class_3532.method_15357((double)camZ);
                int renderDistance = class_310.method_1517() ? 10 : 5;
                int precipitationDistance = TFConfig.getClientCloudBlockPrecipitationDistance();
                for (int roofZ = floorZ - renderDistance; roofZ <= floorZ + renderDistance; ++roofZ) {
                    for (int roofX = floorX - renderDistance; roofX <= floorX + renderDistance; ++roofX) {
                        int lastBadYLevel = Integer.MIN_VALUE;
                        for (int roofY = floorY - renderDistance; roofY < floorY + precipitationDistance + renderDistance; ++roofY) {
                            CloudBlock cloudBlock;
                            Pair<class_1959.class_1963, Float> precipitationRainLevelPair;
                            class_2248 class_22482;
                            boolean skipLoop = roofY == lastBadYLevel + 1;
                            class_2338 pos = new class_2338(roofX, roofY, roofZ);
                            if (class_2902.class_2903.field_13197.method_16402().test(mc.field_1687.method_8320(pos))) {
                                lastBadYLevel = roofY;
                            }
                            if (skipLoop || !((class_22482 = mc.field_1687.method_8320(pos).method_26204()) instanceof CloudBlock) || (precipitationRainLevelPair = (cloudBlock = (CloudBlock)class_22482).getCurrentPrecipitation(pos, (class_1937)mc.field_1687, mc.field_1687.method_8430(1.0f))).getLeft() == class_1959.class_1963.field_9384) continue;
                            int highestRainyBlock = roofY;
                            int y = roofY - 1;
                            while (y > roofY - precipitationDistance && !class_2902.class_2903.field_13197.method_16402().test(mc.field_1687.method_8320(pos.method_33096(y)))) {
                                highestRainyBlock = y--;
                            }
                            if (highestRainyBlock == roofY) continue;
                            RENDER_HELPER.add(new PrecipitationRenderHelper(pos, (class_1959.class_1963)precipitationRainLevelPair.getLeft(), ((Float)precipitationRainLevelPair.getRight()).floatValue(), highestRainyBlock));
                        }
                    }
                }
            }
            class_5819 randomsource = class_5819.method_43049((long)((long)mc.field_1769.field_4073 * 312987231L));
            class_2338 particlePos = null;
            int particleCount = 100 / (mc.field_1690.method_42475().method_41753() == class_4066.field_18198 ? 2 : 1);
            boolean yetToMakeASound = true;
            class_2338 camPos = class_2338.method_49638((class_2374)vec3);
            ArrayList<Vec2i> particleChecks = new ArrayList<Vec2i>();
            for (int i = 0; i < particleCount; ++i) {
                particleChecks.add(new Vec2i(randomsource.method_43048(21) - 10 + camPos.method_10263(), randomsource.method_43048(21) - 10 + camPos.method_10260()));
            }
            block5: for (PrecipitationRenderHelper helper : RENDER_HELPER) {
                if (helper.precipitation() != class_1959.class_1963.field_9382) continue;
                for (Vec2i vec2 : particleChecks) {
                    if (vec2.x != helper.cloudPos().method_10263() || vec2.z != helper.cloudPos().method_10260()) continue;
                    class_2338 highestRainyPos = helper.cloudPos().method_33096(helper.rainOnY());
                    if (!class_2902.class_2903.field_13197.method_16402().test(mc.field_1687.method_8320(highestRainyPos.method_10074()))) continue;
                    if (yetToMakeASound && particlePos != null && randomsource.method_43048(3) < mc.field_1769.field_20793++) {
                        mc.field_1769.field_20793 = 0;
                        if (particlePos.method_10264() > camPos.method_10264() + 1 && mc.field_1687.method_8598(class_2902.class_2903.field_13197, camPos).method_10264() > class_3532.method_15375((float)camPos.method_10264())) {
                            mc.field_1687.method_45446(particlePos, class_3417.field_15020, class_3419.field_15252, 0.1f, 0.5f, false);
                        } else {
                            mc.field_1687.method_45446(particlePos, class_3417.field_14946, class_3419.field_15252, 0.2f, 1.0f, false);
                        }
                        yetToMakeASound = false;
                    }
                    if (highestRainyPos.method_10264() <= mc.field_1687.method_31607() || highestRainyPos.method_10264() > camPos.method_10264() + 10 || highestRainyPos.method_10264() < camPos.method_10264() - 10) continue;
                    particlePos = highestRainyPos.method_10074();
                    if (mc.field_1690.method_42475().method_41753() == class_4066.field_18199) continue block5;
                    double particleX = randomsource.method_43058();
                    double particleZ = randomsource.method_43058();
                    class_2680 blockstate = mc.field_1687.method_8320(particlePos);
                    class_3610 fluidstate = mc.field_1687.method_8316(particlePos);
                    class_265 voxelshape = blockstate.method_26220((class_1922)mc.field_1687, particlePos);
                    double voxelMax = voxelshape.method_1102(class_2350.class_2351.field_11052, particleX, particleZ);
                    double fluidMax = fluidstate.method_15763((class_1922)mc.field_1687, particlePos);
                    double particleY = Math.max(voxelMax, fluidMax);
                    class_2400 particleoptions = !fluidstate.method_15767(class_3486.field_15518) && !blockstate.method_27852(class_2246.field_10092) && !class_3922.method_23896((class_2680)blockstate) ? class_2398.field_11242 : class_2398.field_11251;
                    mc.field_1687.method_8406((class_2394)particleoptions, (double)particlePos.method_10263() + particleX, (double)particlePos.method_10264() + particleY, (double)particlePos.method_10260() + particleZ, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public static void renderCloudBlockPrecipitation(WorldRenderContext context) {
        if (TFConfig.getClientCloudBlockPrecipitationDistance() > 0 && !RENDER_HELPER.isEmpty()) {
            class_310 minecraft = class_310.method_1551();
            if (minecraft.field_1687 == null) {
                return;
            }
            float partialTick = context.tickDelta();
            class_765 lightTexture = minecraft.field_1773.method_22974();
            int ticks = minecraft.field_1769.field_4073;
            lightTexture.method_3316();
            class_243 vec3 = context.camera().method_19326();
            double camX = vec3.method_10216();
            double camY = vec3.method_10214();
            double camZ = vec3.method_10215();
            int floorX = class_3532.method_15357((double)camX);
            int floorY = class_3532.method_15357((double)camY);
            int floorZ = class_3532.method_15357((double)camZ);
            class_289 tesselator = class_289.method_1348();
            class_287 bufferbuilder = tesselator.method_1349();
            RenderSystem.disableCull();
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
            RenderSystem.depthMask((boolean)class_310.method_29611());
            int renderDistance = class_310.method_1517() ? 10 : 5;
            int tesselatorCheck = -1;
            float fullTick = (float)ticks + partialTick;
            RenderSystem.setShader(class_757::method_34546);
            class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
            for (PrecipitationRenderHelper helper : RENDER_HELPER) {
                class_2338 pos = helper.cloudPos();
                int roofX = pos.method_10263();
                int roofZ = pos.method_10260();
                int botY = Math.max(helper.rainOnY(), floorY - renderDistance);
                int topY = Math.min(pos.method_10264(), floorY + renderDistance);
                if (topY - botY <= 0) continue;
                int rainS = class_3532.method_15340((int)((roofZ - floorZ + 16) * 32 + roofX - floorX + 16), (int)0, (int)1023);
                double rainX = (double)TFWeatherRenderer.rainxs[rainS] * 0.5;
                double rainZ = (double)TFWeatherRenderer.rainzs[rainS] * 0.5;
                mutableBlockPos.method_10102((double)roofX, camY, (double)roofZ);
                class_5819 random = class_5819.method_43049((long)((long)roofX * (long)roofX * 3121L + (long)roofX * 45238971L ^ (long)roofZ * (long)roofZ * 418711L + (long)roofZ * 13761L));
                if (helper.precipitation() == class_1959.class_1963.field_9382) {
                    if (tesselatorCheck != 0) {
                        if (tesselatorCheck >= 0) {
                            tesselator.method_1350();
                        }
                        tesselatorCheck = 0;
                        RenderSystem.setShaderTexture((int)0, (class_2960)TFWeatherRenderer.RAIN_TEXTURES);
                        bufferbuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1584);
                    }
                    int offset = ticks + roofX * roofX * 3121 + roofX * 45238971 + roofZ * roofZ * 418711 + roofZ * 13761 & 0x1F;
                    float uvOffset = -((float)offset + partialTick) / 32.0f * (3.0f + random.method_43057());
                    double xDiff = (double)roofX + 0.5 - camX;
                    double zDiff = (double)roofZ + 0.5 - camZ;
                    float distance = (float)Math.sqrt(xDiff * xDiff + zDiff * zDiff) / (float)renderDistance;
                    float alpha = ((1.0f - distance * distance) * 0.5f + 0.5f) * helper.precipitationLevel();
                    mutableBlockPos.method_10103(roofX, Math.max(helper.rainOnY(), floorY), roofZ);
                    int lightColor = class_761.method_23794((class_1920)minecraft.field_1687, (class_2338)mutableBlockPos);
                    bufferbuilder.method_22912((double)roofX - camX - rainX + 0.5, (double)topY - camY, (double)roofZ - camZ - rainZ + 0.5).method_22913(0.0f, (float)botY * 0.25f + uvOffset).method_22915(1.0f, 1.0f, 1.0f, alpha).method_22916(lightColor).method_1344();
                    bufferbuilder.method_22912((double)roofX - camX + rainX + 0.5, (double)topY - camY, (double)roofZ - camZ + rainZ + 0.5).method_22913(1.0f, (float)botY * 0.25f + uvOffset).method_22915(1.0f, 1.0f, 1.0f, alpha).method_22916(lightColor).method_1344();
                    bufferbuilder.method_22912((double)roofX - camX + rainX + 0.5, (double)botY - camY, (double)roofZ - camZ + rainZ + 0.5).method_22913(1.0f, (float)topY * 0.25f + uvOffset).method_22915(1.0f, 1.0f, 1.0f, alpha).method_22916(lightColor).method_1344();
                    bufferbuilder.method_22912((double)roofX - camX - rainX + 0.5, (double)botY - camY, (double)roofZ - camZ - rainZ + 0.5).method_22913(0.0f, (float)topY * 0.25f + uvOffset).method_22915(1.0f, 1.0f, 1.0f, alpha).method_22916(lightColor).method_1344();
                    continue;
                }
                if (helper.precipitation() != class_1959.class_1963.field_9383) continue;
                if (tesselatorCheck != 1) {
                    if (tesselatorCheck == 0) {
                        tesselator.method_1350();
                    }
                    tesselatorCheck = 1;
                    RenderSystem.setShaderTexture((int)0, (class_2960)TFWeatherRenderer.SNOW_TEXTURES);
                    bufferbuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1584);
                }
                float offset = -((float)(ticks & 0x1FF) + partialTick) / 512.0f;
                float uOffset = (float)(random.method_43058() + (double)fullTick * 0.01 * (double)((float)random.method_43059()));
                float vOffset = (float)(random.method_43058() + (double)(fullTick * (float)random.method_43059()) * 0.001);
                double xDiff = (double)roofX + 0.5 - camX;
                double zDiff = (double)roofZ + 0.5 - camZ;
                float distance = (float)Math.sqrt(xDiff * xDiff + zDiff * zDiff) / (float)renderDistance;
                float alpha = ((1.0f - distance * distance) * 0.3f + 0.5f) * helper.precipitationLevel();
                mutableBlockPos.method_10103(roofX, Math.max(helper.rainOnY(), floorY), roofZ);
                int lightColor = class_761.method_23794((class_1920)minecraft.field_1687, (class_2338)mutableBlockPos);
                int v = lightColor >> 16 & 0xFFFF;
                int u = lightColor & 0xFFFF;
                v = (v * 3 + 240) / 4;
                u = (u * 3 + 240) / 4;
                bufferbuilder.method_22912((double)roofX - camX - rainX + 0.5, (double)topY - camY, (double)roofZ - camZ - rainZ + 0.5).method_22913(0.0f + uOffset, (float)botY * 0.25f + offset + vOffset).method_22915(1.0f, 1.0f, 1.0f, alpha).method_22921(u, v).method_1344();
                bufferbuilder.method_22912((double)roofX - camX + rainX + 0.5, (double)topY - camY, (double)roofZ - camZ + rainZ + 0.5).method_22913(1.0f + uOffset, (float)botY * 0.25f + offset + vOffset).method_22915(1.0f, 1.0f, 1.0f, alpha).method_22921(u, v).method_1344();
                bufferbuilder.method_22912((double)roofX - camX + rainX + 0.5, (double)botY - camY, (double)roofZ - camZ + rainZ + 0.5).method_22913(1.0f + uOffset, (float)topY * 0.25f + offset + vOffset).method_22915(1.0f, 1.0f, 1.0f, alpha).method_22921(u, v).method_1344();
                bufferbuilder.method_22912((double)roofX - camX - rainX + 0.5, (double)botY - camY, (double)roofZ - camZ - rainZ + 0.5).method_22913(0.0f + uOffset, (float)topY * 0.25f + offset + vOffset).method_22915(1.0f, 1.0f, 1.0f, alpha).method_22921(u, v).method_1344();
            }
            if (tesselatorCheck >= 0) {
                tesselator.method_1350();
            }
            RenderSystem.enableCull();
            RenderSystem.disableBlend();
            lightTexture.method_3315();
        }
    }

    record PrecipitationRenderHelper(class_2338 cloudPos, class_1959.class_1963 precipitation, float precipitationLevel, int rainOnY) {
    }
}

