/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.world.structures.piece;

import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2794;
import net.minecraft.class_3341;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_6625;
import org.betterx.betternether.BlocksHelper;
import org.betterx.betternether.MHelper;
import org.betterx.betternether.registry.NetherStructurePieces;
import org.betterx.betternether.world.structures.piece.CustomPiece;

public class DestructionPiece
extends CustomPiece {
    private final class_2338.class_2339 POS = new class_2338.class_2339();
    private final class_2338 center;
    private final int radius;
    private final int radSqr;
    private int minY;
    private int maxY;

    public DestructionPiece(class_3341 bounds, class_5819 random) {
        super(NetherStructurePieces.DESTRUCTION_PIECE, random.method_43054(), bounds);
        this.radius = random.method_43048(5) + 1;
        this.radSqr = this.radius * this.radius;
        this.center = new class_2338(MHelper.randRange(bounds.method_35415(), bounds.method_35418(), random), MHelper.randRange(bounds.method_35416(), bounds.method_35419(), random), MHelper.randRange(bounds.method_35417(), bounds.method_35420(), random));
        this.makeBoundingBox();
    }

    public DestructionPiece(class_6625 context, class_2487 tag) {
        super(NetherStructurePieces.DESTRUCTION_PIECE, tag);
        this.center = class_2512.method_10691((class_2487)tag.method_10562("center"));
        this.radius = tag.method_10550("radius");
        this.radSqr = this.radius * this.radius;
        this.makeBoundingBox();
    }

    protected void method_14943(class_6625 structurePieceSerializationContext, class_2487 tag) {
        tag.method_10566("center", (class_2520)class_2512.method_10692((class_2338)this.center));
        tag.method_10569("radius", this.radius);
    }

    public void method_14931(class_5281 world, class_5138 structureAccessor, class_2794 chunkGenerator, class_5819 random, class_3341 blockBox, class_1923 chunkPos, class_2338 blockPos) {
        for (int x = blockBox.method_35420(); x <= blockBox.method_35417(); ++x) {
            int px = x - this.center.method_10263();
            px *= px;
            for (int z = blockBox.method_35416(); z <= blockBox.method_35419(); ++z) {
                int pz = z - this.center.method_10260();
                pz *= pz;
                for (int y = this.minY; y <= this.maxY; ++y) {
                    int py = y - this.center.method_10264() << 1;
                    if (px + (py *= py) + pz > this.radSqr + random.method_43048(this.radius)) continue;
                    this.POS.method_10103(x, y, z);
                    if (world.method_22347((class_2338)this.POS)) continue;
                    if (random.method_43056()) {
                        BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)this.POS, field_15314);
                        continue;
                    }
                    int dist = BlocksHelper.downRay((class_1936)world, (class_2338)this.POS, this.maxY - 5);
                    if (dist <= 0) continue;
                    class_2680 state = world.method_8320((class_2338)this.POS);
                    BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)this.POS, field_15314);
                    this.POS.method_33098(this.POS.method_10264() - dist);
                    BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)this.POS, state);
                }
            }
        }
    }

    private void makeBoundingBox() {
        int x1 = this.center.method_10263() - this.radius;
        int x2 = this.center.method_10263() + this.radius;
        this.minY = Math.max(22, this.center.method_10264() - this.radius);
        if (this.minY < 38) {
            this.minY = 38;
        }
        this.maxY = Math.min(96, this.center.method_10264() + this.radius);
        int z1 = this.center.method_10260() - this.radius;
        int z2 = this.center.method_10260() + this.radius;
        this.field_15315 = new class_3341(x1, this.minY, z1, x2, this.maxY, z2);
    }
}

