/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.animation;

import icyllis.modernui.animation.Animator;
import icyllis.modernui.animation.AnimatorListener;
import icyllis.modernui.util.StateSet;
import icyllis.modernui.view.View;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetbrains.annotations.ApiStatus;

public class StateListAnimator
implements Cloneable {
    private ArrayList<int[]> mSpecs = new ArrayList();
    private ArrayList<Animator> mAnimators = new ArrayList();
    private int mLastMatch = -1;
    private Animator mRunningAnimator;
    private WeakReference<View> mViewRef;
    private AnimatorListener mAnimatorListener;

    public StateListAnimator() {
        this.initAnimatorListener();
    }

    private void initAnimatorListener() {
        this.mAnimatorListener = new AnimatorListener(){

            @Override
            public void onAnimationEnd(@Nonnull Animator animation) {
                animation.setTarget(null);
                if (StateListAnimator.this.mRunningAnimator == animation) {
                    StateListAnimator.this.mRunningAnimator = null;
                }
            }
        };
    }

    public void addState(@Nonnull int[] spec, @Nonnull Animator animator) {
        animator.addListener(this.mAnimatorListener);
        this.mSpecs.add(spec);
        this.mAnimators.add(animator);
    }

    @Nullable
    private View getTarget() {
        return this.mViewRef == null ? null : (View)this.mViewRef.get();
    }

    @ApiStatus.Internal
    public void setTarget(@Nullable View view) {
        View current = this.getTarget();
        if (current == view) {
            return;
        }
        if (current != null) {
            this.clearTarget();
        }
        if (view != null) {
            this.mViewRef = new WeakReference<View>(view);
        }
    }

    private void clearTarget() {
        for (Animator animator : this.mAnimators) {
            animator.setTarget(null);
        }
        this.mViewRef = null;
        this.mLastMatch = -1;
        this.mRunningAnimator = null;
    }

    @ApiStatus.Internal
    public void setState(@Nonnull int[] state) {
        int match = -1;
        int size = this.mSpecs.size();
        for (int i = 0; i < size; ++i) {
            int[] spec = this.mSpecs.get(i);
            if (!StateSet.stateSetMatches(spec, state)) continue;
            match = i;
            break;
        }
        if (match == this.mLastMatch) {
            return;
        }
        if (this.mLastMatch != -1) {
            this.cancel();
        }
        this.mLastMatch = match;
        if (match != -1) {
            this.start(this.mAnimators.get(match));
        }
    }

    private void start(@Nonnull Animator animator) {
        animator.setTarget(this.getTarget());
        this.mRunningAnimator = animator;
        this.mRunningAnimator.start();
    }

    private void cancel() {
        if (this.mRunningAnimator != null) {
            this.mRunningAnimator.cancel();
            this.mRunningAnimator = null;
        }
    }

    public void jumpToCurrentState() {
        if (this.mRunningAnimator != null) {
            this.mRunningAnimator.end();
        }
    }

    public StateListAnimator clone() {
        try {
            StateListAnimator clone = (StateListAnimator)super.clone();
            int size = this.mSpecs.size();
            clone.mSpecs = new ArrayList(size);
            clone.mAnimators = new ArrayList(size);
            clone.mLastMatch = -1;
            clone.mRunningAnimator = null;
            clone.mViewRef = null;
            clone.initAnimatorListener();
            for (int i = 0; i < size; ++i) {
                Animator animatorClone = this.mAnimators.get(i).clone();
                animatorClone.removeListener(this.mAnimatorListener);
                clone.addState(this.mSpecs.get(i), animatorClone);
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
    }
}

