/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.animation;

import icyllis.modernui.animation.Animator;
import icyllis.modernui.animation.AnimatorListener;
import icyllis.modernui.animation.Keyframe;
import icyllis.modernui.animation.KeyframeSet;
import icyllis.modernui.animation.ObjectAnimator;
import icyllis.modernui.animation.PropertyValuesHolder;
import icyllis.modernui.animation.TimeInterpolator;
import icyllis.modernui.view.View;
import icyllis.modernui.view.ViewGroup;
import icyllis.modernui.view.ViewParent;
import icyllis.modernui.view.ViewTreeObserver;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class LayoutTransition {
    public static final int CHANGE_APPEARING = 0;
    public static final int CHANGE_DISAPPEARING = 1;
    public static final int APPEARING = 2;
    public static final int DISAPPEARING = 3;
    public static final int CHANGING = 4;
    private static final int FLAG_APPEARING = 1;
    private static final int FLAG_DISAPPEARING = 2;
    private static final int FLAG_CHANGE_APPEARING = 4;
    private static final int FLAG_CHANGE_DISAPPEARING = 8;
    private static final int FLAG_CHANGING = 16;
    private static ObjectAnimator defaultChange;
    private static volatile ObjectAnimator defaultChangeIn;
    private static ObjectAnimator defaultChangeOut;
    private static ObjectAnimator defaultFadeIn;
    private static ObjectAnimator defaultFadeOut;
    private static final long DEFAULT_DURATION = 300L;
    private static final TimeInterpolator sAppearingInterpolator;
    private static final TimeInterpolator sDisappearingInterpolator;
    private static final TimeInterpolator sChangingAppearingInterpolator;
    private static final TimeInterpolator sChangingDisappearingInterpolator;
    private static final TimeInterpolator sChangingInterpolator;
    private Animator mDisappearingAnim;
    private Animator mAppearingAnim;
    private Animator mChangingAppearingAnim;
    private Animator mChangingDisappearingAnim;
    private Animator mChangingAnim;
    private long mChangingAppearingDuration = 300L;
    private long mChangingDisappearingDuration = 300L;
    private long mChangingDuration = 300L;
    private long mAppearingDuration = 300L;
    private long mDisappearingDuration = 300L;
    private long mAppearingDelay = 300L;
    private long mDisappearingDelay = 0L;
    private long mChangingAppearingDelay = 0L;
    private long mChangingDisappearingDelay = 300L;
    private long mChangingDelay = 0L;
    private long mChangingAppearingStagger = 0L;
    private long mChangingDisappearingStagger = 0L;
    private long mChangingStagger = 0L;
    private TimeInterpolator mAppearingInterpolator = sAppearingInterpolator;
    private TimeInterpolator mDisappearingInterpolator = sDisappearingInterpolator;
    private TimeInterpolator mChangingAppearingInterpolator = sChangingAppearingInterpolator;
    private TimeInterpolator mChangingDisappearingInterpolator = sChangingDisappearingInterpolator;
    private TimeInterpolator mChangingInterpolator = sChangingInterpolator;
    private final HashMap<View, Animator> pendingAnimations = new HashMap();
    private final LinkedHashMap<View, Animator> currentChangingAnimations = new LinkedHashMap();
    private final LinkedHashMap<View, Animator> currentAppearingAnimations = new LinkedHashMap();
    private final LinkedHashMap<View, Animator> currentDisappearingAnimations = new LinkedHashMap();
    private final HashMap<View, View.OnLayoutChangeListener> layoutChangeListenerMap = new HashMap();
    private long staggerDelay;
    private int mTransitionTypes = 15;
    private CopyOnWriteArrayList<TransitionListener> mListeners;
    private boolean mAnimateParentHierarchy = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public LayoutTransition() {
        if (defaultChangeIn == null) {
            Class<LayoutTransition> clazz = LayoutTransition.class;
            // MONITORENTER : icyllis.modernui.animation.LayoutTransition.class
            if (defaultChangeIn == null) {
                this.initDefaultAnimators();
            }
            // MONITOREXIT : clazz
        }
        this.mChangingAppearingAnim = defaultChangeIn;
        this.mChangingDisappearingAnim = defaultChangeOut;
        this.mChangingAnim = defaultChange;
        this.mAppearingAnim = defaultFadeIn;
        this.mDisappearingAnim = defaultFadeOut;
    }

    private void initDefaultAnimators() {
        PropertyValuesHolder pvhLeft = PropertyValuesHolder.ofInt(View.LEFT, 0, 1);
        PropertyValuesHolder pvhTop = PropertyValuesHolder.ofInt(View.TOP, 0, 1);
        PropertyValuesHolder pvhRight = PropertyValuesHolder.ofInt(View.RIGHT, 0, 1);
        PropertyValuesHolder pvhBottom = PropertyValuesHolder.ofInt(View.BOTTOM, 0, 1);
        PropertyValuesHolder pvhScrollX = PropertyValuesHolder.ofInt(View.SCROLL_X, 0, 1);
        PropertyValuesHolder pvhScrollY = PropertyValuesHolder.ofInt(View.SCROLL_Y, 0, 1);
        defaultChangeIn = ObjectAnimator.ofPropertyValuesHolder(null, pvhLeft, pvhTop, pvhRight, pvhBottom, pvhScrollX, pvhScrollY);
        defaultChangeIn.setDuration(300L);
        defaultChangeIn.setStartDelay(this.mChangingAppearingDelay);
        defaultChangeIn.setInterpolator(this.mChangingAppearingInterpolator);
        defaultChangeOut = defaultChangeIn.clone();
        defaultChangeOut.setStartDelay(this.mChangingDisappearingDelay);
        defaultChangeOut.setInterpolator(this.mChangingDisappearingInterpolator);
        defaultChange = defaultChangeIn.clone();
        defaultChange.setStartDelay(this.mChangingDelay);
        defaultChange.setInterpolator(this.mChangingInterpolator);
        defaultFadeIn = ObjectAnimator.ofFloat(null, View.ALPHA, 0.0f, 1.0f);
        defaultFadeIn.setDuration(300L);
        defaultFadeIn.setStartDelay(this.mAppearingDelay);
        defaultFadeIn.setInterpolator(this.mAppearingInterpolator);
        defaultFadeOut = ObjectAnimator.ofFloat(null, View.ALPHA, 1.0f, 0.0f);
        defaultFadeOut.setDuration(300L);
        defaultFadeOut.setStartDelay(this.mDisappearingDelay);
        defaultFadeOut.setInterpolator(this.mDisappearingInterpolator);
    }

    public void setDuration(long duration) {
        this.mChangingAppearingDuration = duration;
        this.mChangingDisappearingDuration = duration;
        this.mChangingDuration = duration;
        this.mAppearingDuration = duration;
        this.mDisappearingDuration = duration;
    }

    public void enableTransitionType(int transitionType) {
        switch (transitionType) {
            case 2: {
                this.mTransitionTypes |= 1;
                break;
            }
            case 3: {
                this.mTransitionTypes |= 2;
                break;
            }
            case 0: {
                this.mTransitionTypes |= 4;
                break;
            }
            case 1: {
                this.mTransitionTypes |= 8;
                break;
            }
            case 4: {
                this.mTransitionTypes |= 0x10;
            }
        }
    }

    public void disableTransitionType(int transitionType) {
        switch (transitionType) {
            case 2: {
                this.mTransitionTypes &= 0xFFFFFFFE;
                break;
            }
            case 3: {
                this.mTransitionTypes &= 0xFFFFFFFD;
                break;
            }
            case 0: {
                this.mTransitionTypes &= 0xFFFFFFFB;
                break;
            }
            case 1: {
                this.mTransitionTypes &= 0xFFFFFFF7;
                break;
            }
            case 4: {
                this.mTransitionTypes &= 0xFFFFFFEF;
            }
        }
    }

    public boolean isTransitionTypeEnabled(int transitionType) {
        return switch (transitionType) {
            case 2 -> {
                if ((this.mTransitionTypes & 1) == 1) {
                    yield true;
                }
                yield false;
            }
            case 3 -> {
                if ((this.mTransitionTypes & 2) == 2) {
                    yield true;
                }
                yield false;
            }
            case 0 -> {
                if ((this.mTransitionTypes & 4) == 4) {
                    yield true;
                }
                yield false;
            }
            case 1 -> {
                if ((this.mTransitionTypes & 8) == 8) {
                    yield true;
                }
                yield false;
            }
            case 4 -> {
                if ((this.mTransitionTypes & 0x10) == 16) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    public void setStartDelay(int transitionType, long delay) {
        switch (transitionType) {
            case 0: {
                this.mChangingAppearingDelay = delay;
                break;
            }
            case 1: {
                this.mChangingDisappearingDelay = delay;
                break;
            }
            case 4: {
                this.mChangingDelay = delay;
                break;
            }
            case 2: {
                this.mAppearingDelay = delay;
                break;
            }
            case 3: {
                this.mDisappearingDelay = delay;
            }
        }
    }

    public long getStartDelay(int transitionType) {
        return switch (transitionType) {
            case 0 -> this.mChangingAppearingDelay;
            case 1 -> this.mChangingDisappearingDelay;
            case 4 -> this.mChangingDelay;
            case 2 -> this.mAppearingDelay;
            case 3 -> this.mDisappearingDelay;
            default -> 0L;
        };
    }

    public void setDuration(int transitionType, long duration) {
        switch (transitionType) {
            case 0: {
                this.mChangingAppearingDuration = duration;
                break;
            }
            case 1: {
                this.mChangingDisappearingDuration = duration;
                break;
            }
            case 4: {
                this.mChangingDuration = duration;
                break;
            }
            case 2: {
                this.mAppearingDuration = duration;
                break;
            }
            case 3: {
                this.mDisappearingDuration = duration;
            }
        }
    }

    public long getDuration(int transitionType) {
        return switch (transitionType) {
            case 0 -> this.mChangingAppearingDuration;
            case 1 -> this.mChangingDisappearingDuration;
            case 4 -> this.mChangingDuration;
            case 2 -> this.mAppearingDuration;
            case 3 -> this.mDisappearingDuration;
            default -> 0L;
        };
    }

    public void setStagger(int transitionType, long duration) {
        switch (transitionType) {
            case 0: {
                this.mChangingAppearingStagger = duration;
                break;
            }
            case 1: {
                this.mChangingDisappearingStagger = duration;
                break;
            }
            case 4: {
                this.mChangingStagger = duration;
            }
        }
    }

    public long getStagger(int transitionType) {
        return switch (transitionType) {
            case 0 -> this.mChangingAppearingStagger;
            case 1 -> this.mChangingDisappearingStagger;
            case 4 -> this.mChangingStagger;
            default -> 0L;
        };
    }

    public void setInterpolator(int transitionType, TimeInterpolator interpolator) {
        switch (transitionType) {
            case 0: {
                this.mChangingAppearingInterpolator = interpolator;
                break;
            }
            case 1: {
                this.mChangingDisappearingInterpolator = interpolator;
                break;
            }
            case 4: {
                this.mChangingInterpolator = interpolator;
                break;
            }
            case 2: {
                this.mAppearingInterpolator = interpolator;
                break;
            }
            case 3: {
                this.mDisappearingInterpolator = interpolator;
            }
        }
    }

    public TimeInterpolator getInterpolator(int transitionType) {
        return switch (transitionType) {
            case 0 -> this.mChangingAppearingInterpolator;
            case 1 -> this.mChangingDisappearingInterpolator;
            case 4 -> this.mChangingInterpolator;
            case 2 -> this.mAppearingInterpolator;
            case 3 -> this.mDisappearingInterpolator;
            default -> null;
        };
    }

    public void setAnimator(int transitionType, Animator animator) {
        switch (transitionType) {
            case 0: {
                this.mChangingAppearingAnim = animator;
                break;
            }
            case 1: {
                this.mChangingDisappearingAnim = animator;
                break;
            }
            case 4: {
                this.mChangingAnim = animator;
                break;
            }
            case 2: {
                this.mAppearingAnim = animator;
                break;
            }
            case 3: {
                this.mDisappearingAnim = animator;
            }
        }
    }

    public Animator getAnimator(int transitionType) {
        return switch (transitionType) {
            case 0 -> this.mChangingAppearingAnim;
            case 1 -> this.mChangingDisappearingAnim;
            case 4 -> this.mChangingAnim;
            case 2 -> this.mAppearingAnim;
            case 3 -> this.mDisappearingAnim;
            default -> null;
        };
    }

    private void runChangeTransition(ViewGroup parent, View newView, int changeReason) {
        long duration;
        Animator baseAnimator = null;
        ObjectAnimator parentAnimator = null;
        switch (changeReason) {
            case 2: {
                baseAnimator = this.mChangingAppearingAnim;
                duration = this.mChangingAppearingDuration;
                parentAnimator = defaultChangeIn;
                break;
            }
            case 3: {
                baseAnimator = this.mChangingDisappearingAnim;
                duration = this.mChangingDisappearingDuration;
                parentAnimator = defaultChangeOut;
                break;
            }
            case 4: {
                baseAnimator = this.mChangingAnim;
                duration = this.mChangingDuration;
                parentAnimator = defaultChange;
                break;
            }
            default: {
                duration = 0L;
            }
        }
        if (baseAnimator == null) {
            return;
        }
        this.staggerDelay = 0L;
        ViewTreeObserver observer = parent.getViewTreeObserver();
        if (!observer.isAlive()) {
            return;
        }
        int numChildren = parent.getChildCount();
        for (int i = 0; i < numChildren; ++i) {
            View child = parent.getChildAt(i);
            if (child == newView) continue;
            this.setupChangeAnimation(parent, changeReason, baseAnimator, duration, child);
        }
        if (this.mAnimateParentHierarchy) {
            ViewGroup tempParent = parent;
            while (tempParent != null) {
                ViewParent parentParent = tempParent.getParent();
                if (parentParent instanceof ViewGroup) {
                    this.setupChangeAnimation((ViewGroup)parentParent, changeReason, parentAnimator, duration, tempParent);
                    tempParent = (ViewGroup)parentParent;
                    continue;
                }
                tempParent = null;
            }
        }
        CleanupCallback callback = new CleanupCallback(this.layoutChangeListenerMap, parent);
        observer.addOnPreDrawListener(callback);
        parent.addOnAttachStateChangeListener(callback);
    }

    public void setAnimateParentHierarchy(boolean animateParentHierarchy) {
        this.mAnimateParentHierarchy = animateParentHierarchy;
    }

    private void setupChangeAnimation(final ViewGroup parent, final int changeReason, Animator baseAnimator, final long duration, final View child) {
        if (this.layoutChangeListenerMap.get(child) != null) {
            return;
        }
        if (child.getWidth() == 0 && child.getHeight() == 0) {
            return;
        }
        final Animator anim = baseAnimator.clone();
        anim.setTarget(child);
        anim.setupStartValues();
        Animator currentAnimation = this.pendingAnimations.get(child);
        if (currentAnimation != null) {
            currentAnimation.cancel();
            this.pendingAnimations.remove(child);
        }
        this.pendingAnimations.put(child, anim);
        child.postOnAnimationDelayed(() -> this.pendingAnimations.remove(child), duration + 100L);
        final View.OnLayoutChangeListener listener = new View.OnLayoutChangeListener(){

            @Override
            public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                Animator pendingAnimation;
                anim.setupEndValues();
                if (anim instanceof ObjectAnimator) {
                    ObjectAnimator anim2 = (ObjectAnimator)anim;
                    boolean valuesDiffer = false;
                    for (PropertyValuesHolder pvh : anim2.getValues()) {
                        if (pvh.mKeyframes instanceof KeyframeSet) {
                            Keyframe[] keyframes = ((KeyframeSet)pvh.mKeyframes).mKeyframes;
                            if (keyframes[0].getValue().equals(keyframes[keyframes.length - 1].getValue())) continue;
                            valuesDiffer = true;
                            continue;
                        }
                        if (pvh.mKeyframes.getValue(0.0f).equals(pvh.mKeyframes.getValue(1.0f))) continue;
                        valuesDiffer = true;
                    }
                    if (!valuesDiffer) {
                        return;
                    }
                }
                long startDelay = 0L;
                switch (changeReason) {
                    case 2: {
                        startDelay = LayoutTransition.this.mChangingAppearingDelay + LayoutTransition.this.staggerDelay;
                        LayoutTransition.this.staggerDelay += LayoutTransition.this.mChangingAppearingStagger;
                        if (LayoutTransition.this.mChangingAppearingInterpolator == sChangingAppearingInterpolator) break;
                        anim.setInterpolator(LayoutTransition.this.mChangingAppearingInterpolator);
                        break;
                    }
                    case 3: {
                        startDelay = LayoutTransition.this.mChangingDisappearingDelay + LayoutTransition.this.staggerDelay;
                        LayoutTransition.this.staggerDelay += LayoutTransition.this.mChangingDisappearingStagger;
                        if (LayoutTransition.this.mChangingDisappearingInterpolator == sChangingDisappearingInterpolator) break;
                        anim.setInterpolator(LayoutTransition.this.mChangingDisappearingInterpolator);
                        break;
                    }
                    case 4: {
                        startDelay = LayoutTransition.this.mChangingDelay + LayoutTransition.this.staggerDelay;
                        LayoutTransition.this.staggerDelay += LayoutTransition.this.mChangingStagger;
                        if (LayoutTransition.this.mChangingInterpolator == sChangingInterpolator) break;
                        anim.setInterpolator(LayoutTransition.this.mChangingInterpolator);
                    }
                }
                anim.setStartDelay(startDelay);
                anim.setDuration(duration);
                Animator prevAnimation = LayoutTransition.this.currentChangingAnimations.get(child);
                if (prevAnimation != null) {
                    prevAnimation.cancel();
                }
                if ((pendingAnimation = LayoutTransition.this.pendingAnimations.get(child)) != null) {
                    LayoutTransition.this.pendingAnimations.remove(child);
                }
                LayoutTransition.this.currentChangingAnimations.put(child, anim);
                parent.requestTransitionStart(LayoutTransition.this);
                child.removeOnLayoutChangeListener(this);
                LayoutTransition.this.layoutChangeListenerMap.remove(child);
            }
        };
        anim.addListener(new AnimatorListener(){

            @Override
            public void onAnimationStart(@Nonnull Animator animator) {
                if (LayoutTransition.this.hasListeners()) {
                    for (TransitionListener listener2 : LayoutTransition.this.mListeners) {
                        listener2.startTransition(LayoutTransition.this, parent, child, changeReason == 2 ? 0 : (changeReason == 3 ? 1 : 4));
                    }
                }
            }

            @Override
            public void onAnimationEnd(@Nonnull Animator animator) {
                LayoutTransition.this.currentChangingAnimations.remove(child);
                if (LayoutTransition.this.hasListeners()) {
                    for (TransitionListener listener2 : LayoutTransition.this.mListeners) {
                        listener2.endTransition(LayoutTransition.this, parent, child, changeReason == 2 ? 0 : (changeReason == 3 ? 1 : 4));
                    }
                }
            }

            @Override
            public void onAnimationCancel(@Nonnull Animator animator) {
                child.removeOnLayoutChangeListener(listener);
                LayoutTransition.this.layoutChangeListenerMap.remove(child);
            }
        });
        child.addOnLayoutChangeListener(listener);
        this.layoutChangeListenerMap.put(child, listener);
    }

    public void startChangingAnimations() {
        LinkedHashMap currentAnimCopy = (LinkedHashMap)this.currentChangingAnimations.clone();
        for (Animator anim : currentAnimCopy.values()) {
            if (anim instanceof ObjectAnimator) {
                ((ObjectAnimator)anim).setCurrentPlayTime(0L);
            }
            anim.start();
        }
    }

    public void endChangingAnimations() {
        LinkedHashMap currentAnimCopy = (LinkedHashMap)this.currentChangingAnimations.clone();
        for (Animator anim : currentAnimCopy.values()) {
            anim.start();
            anim.end();
        }
        this.currentChangingAnimations.clear();
    }

    public boolean isChangingLayout() {
        return !this.currentChangingAnimations.isEmpty();
    }

    public boolean isRunning() {
        return !this.currentChangingAnimations.isEmpty() || !this.currentAppearingAnimations.isEmpty() || !this.currentDisappearingAnimations.isEmpty();
    }

    public void cancel() {
        LinkedHashMap currentAnimCopy;
        if (!this.currentChangingAnimations.isEmpty()) {
            currentAnimCopy = (LinkedHashMap)this.currentChangingAnimations.clone();
            for (Animator anim : currentAnimCopy.values()) {
                anim.cancel();
            }
            this.currentChangingAnimations.clear();
        }
        if (!this.currentAppearingAnimations.isEmpty()) {
            currentAnimCopy = (LinkedHashMap)this.currentAppearingAnimations.clone();
            for (Animator anim : currentAnimCopy.values()) {
                anim.end();
            }
            this.currentAppearingAnimations.clear();
        }
        if (!this.currentDisappearingAnimations.isEmpty()) {
            currentAnimCopy = (LinkedHashMap)this.currentDisappearingAnimations.clone();
            for (Animator anim : currentAnimCopy.values()) {
                anim.end();
            }
            this.currentDisappearingAnimations.clear();
        }
    }

    public void cancel(int transitionType) {
        switch (transitionType) {
            case 0: 
            case 1: 
            case 4: {
                if (this.currentChangingAnimations.isEmpty()) break;
                LinkedHashMap currentAnimCopy = (LinkedHashMap)this.currentChangingAnimations.clone();
                for (Animator anim : currentAnimCopy.values()) {
                    anim.cancel();
                }
                this.currentChangingAnimations.clear();
                break;
            }
            case 2: {
                if (this.currentAppearingAnimations.isEmpty()) break;
                LinkedHashMap currentAnimCopy = (LinkedHashMap)this.currentAppearingAnimations.clone();
                for (Animator anim : currentAnimCopy.values()) {
                    anim.end();
                }
                this.currentAppearingAnimations.clear();
                break;
            }
            case 3: {
                if (this.currentDisappearingAnimations.isEmpty()) break;
                LinkedHashMap currentAnimCopy = (LinkedHashMap)this.currentDisappearingAnimations.clone();
                for (Animator anim : currentAnimCopy.values()) {
                    anim.end();
                }
                this.currentDisappearingAnimations.clear();
            }
        }
    }

    private void runAppearingTransition(final ViewGroup parent, final View child) {
        Animator currentAnimation = this.currentDisappearingAnimations.get(child);
        if (currentAnimation != null) {
            currentAnimation.cancel();
        }
        if (this.mAppearingAnim == null) {
            if (this.hasListeners()) {
                for (TransitionListener listener : this.mListeners) {
                    listener.endTransition(this, parent, child, 2);
                }
            }
            return;
        }
        Animator anim = this.mAppearingAnim.clone();
        anim.setTarget(child);
        anim.setStartDelay(this.mAppearingDelay);
        anim.setDuration(this.mAppearingDuration);
        if (this.mAppearingInterpolator != sAppearingInterpolator) {
            anim.setInterpolator(this.mAppearingInterpolator);
        }
        if (anim instanceof ObjectAnimator) {
            ((ObjectAnimator)anim).setCurrentPlayTime(0L);
        }
        anim.addListener(new AnimatorListener(){

            @Override
            public void onAnimationEnd(@Nonnull Animator anim) {
                LayoutTransition.this.currentAppearingAnimations.remove(child);
                if (LayoutTransition.this.hasListeners()) {
                    for (TransitionListener listener : LayoutTransition.this.mListeners) {
                        listener.endTransition(LayoutTransition.this, parent, child, 2);
                    }
                }
            }
        });
        this.currentAppearingAnimations.put(child, anim);
        anim.start();
    }

    private void runDisappearingTransition(final ViewGroup parent, final View child) {
        Animator currentAnimation = this.currentAppearingAnimations.get(child);
        if (currentAnimation != null) {
            currentAnimation.cancel();
        }
        if (this.mDisappearingAnim == null) {
            if (this.hasListeners()) {
                for (TransitionListener listener : this.mListeners) {
                    listener.endTransition(this, parent, child, 3);
                }
            }
            return;
        }
        Animator anim = this.mDisappearingAnim.clone();
        anim.setStartDelay(this.mDisappearingDelay);
        anim.setDuration(this.mDisappearingDuration);
        if (this.mDisappearingInterpolator != sDisappearingInterpolator) {
            anim.setInterpolator(this.mDisappearingInterpolator);
        }
        anim.setTarget(child);
        final float preAnimAlpha = child.getTransitionAlpha();
        anim.addListener(new AnimatorListener(){

            @Override
            public void onAnimationEnd(@Nonnull Animator anim) {
                LayoutTransition.this.currentDisappearingAnimations.remove(child);
                child.setTransitionAlpha(preAnimAlpha);
                if (LayoutTransition.this.hasListeners()) {
                    for (TransitionListener listener : LayoutTransition.this.mListeners) {
                        listener.endTransition(LayoutTransition.this, parent, child, 3);
                    }
                }
            }
        });
        if (anim instanceof ObjectAnimator) {
            ((ObjectAnimator)anim).setCurrentPlayTime(0L);
        }
        this.currentDisappearingAnimations.put(child, anim);
        anim.start();
    }

    private void addChild(@Nonnull ViewGroup parent, View child, boolean changesLayout) {
        if (parent.getWindowVisibility() != 0) {
            return;
        }
        if ((this.mTransitionTypes & 1) == 1) {
            this.cancel(3);
        }
        if (changesLayout && (this.mTransitionTypes & 4) == 4) {
            this.cancel(0);
            this.cancel(4);
        }
        if (this.hasListeners() && (this.mTransitionTypes & 1) == 1) {
            for (TransitionListener listener : this.mListeners) {
                listener.startTransition(this, parent, child, 2);
            }
        }
        if (changesLayout && (this.mTransitionTypes & 4) == 4) {
            this.runChangeTransition(parent, child, 2);
        }
        if ((this.mTransitionTypes & 1) == 1) {
            this.runAppearingTransition(parent, child);
        }
    }

    private boolean hasListeners() {
        return this.mListeners != null && !this.mListeners.isEmpty();
    }

    public void layoutChange(@Nonnull ViewGroup parent) {
        if (parent.getWindowVisibility() != 0) {
            return;
        }
        if ((this.mTransitionTypes & 0x10) == 16 && !this.isRunning()) {
            this.runChangeTransition(parent, null, 4);
        }
    }

    public void addChild(ViewGroup parent, View child) {
        this.addChild(parent, child, true);
    }

    public void showChild(ViewGroup parent, View child, int oldVisibility) {
        this.addChild(parent, child, oldVisibility == 8);
    }

    private void removeChild(@Nonnull ViewGroup parent, View child, boolean changesLayout) {
        if (parent.getWindowVisibility() != 0) {
            return;
        }
        if ((this.mTransitionTypes & 2) == 2) {
            this.cancel(2);
        }
        if (changesLayout && (this.mTransitionTypes & 8) == 8) {
            this.cancel(1);
            this.cancel(4);
        }
        if (this.hasListeners() && (this.mTransitionTypes & 2) == 2) {
            for (TransitionListener listener : this.mListeners) {
                listener.startTransition(this, parent, child, 3);
            }
        }
        if (changesLayout && (this.mTransitionTypes & 8) == 8) {
            this.runChangeTransition(parent, child, 3);
        }
        if ((this.mTransitionTypes & 2) == 2) {
            this.runDisappearingTransition(parent, child);
        }
    }

    public void removeChild(ViewGroup parent, View child) {
        this.removeChild(parent, child, true);
    }

    public void hideChild(ViewGroup parent, View child, int newVisibility) {
        this.removeChild(parent, child, newVisibility == 8);
    }

    public void addTransitionListener(TransitionListener listener) {
        if (this.mListeners == null) {
            this.mListeners = new CopyOnWriteArrayList();
        }
        this.mListeners.add(listener);
    }

    public void removeTransitionListener(TransitionListener listener) {
        if (this.mListeners == null) {
            return;
        }
        this.mListeners.remove(listener);
    }

    @Nullable
    public List<TransitionListener> getTransitionListeners() {
        return this.mListeners;
    }

    static {
        sAppearingInterpolator = TimeInterpolator.ACCELERATE_DECELERATE;
        sDisappearingInterpolator = TimeInterpolator.ACCELERATE_DECELERATE;
        sChangingAppearingInterpolator = TimeInterpolator.DECELERATE;
        sChangingDisappearingInterpolator = TimeInterpolator.DECELERATE;
        sChangingInterpolator = TimeInterpolator.DECELERATE;
    }

    private static final class CleanupCallback
    implements ViewTreeObserver.OnPreDrawListener,
    View.OnAttachStateChangeListener {
        final Map<View, View.OnLayoutChangeListener> layoutChangeListenerMap;
        final ViewGroup parent;

        CleanupCallback(Map<View, View.OnLayoutChangeListener> listenerMap, ViewGroup parent) {
            this.layoutChangeListenerMap = listenerMap;
            this.parent = parent;
        }

        private void cleanup() {
            this.parent.getViewTreeObserver().removeOnPreDrawListener(this);
            this.parent.removeOnAttachStateChangeListener(this);
            int count = this.layoutChangeListenerMap.size();
            if (count > 0) {
                Set<View> views = this.layoutChangeListenerMap.keySet();
                for (View view : views) {
                    View.OnLayoutChangeListener listener = this.layoutChangeListenerMap.get(view);
                    view.removeOnLayoutChangeListener(listener);
                }
                this.layoutChangeListenerMap.clear();
            }
        }

        @Override
        public void onViewAttachedToWindow(View v) {
        }

        @Override
        public void onViewDetachedFromWindow(View v) {
            this.cleanup();
        }

        @Override
        public boolean onPreDraw() {
            this.cleanup();
            return true;
        }
    }

    public static interface TransitionListener {
        public void startTransition(LayoutTransition var1, ViewGroup var2, View var3, int var4);

        public void endTransition(LayoutTransition var1, ViewGroup var2, View var3, int var4);
    }
}

