/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.animation;

import icyllis.modernui.animation.TimeInterpolator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class Keyframe {
    boolean mHasValue;
    boolean mValueWasSetOnStart;
    float mFraction;
    @Nullable
    private TimeInterpolator mInterpolator;

    @Nonnull
    public static Keyframe ofInt(float fraction, int value) {
        return new IntKeyframe(fraction, value);
    }

    @Nonnull
    public static Keyframe ofInt(float fraction) {
        return new IntKeyframe(fraction);
    }

    @Nonnull
    public static Keyframe ofFloat(float fraction, float value) {
        return new FloatKeyframe(fraction, value);
    }

    @Nonnull
    public static Keyframe ofFloat(float fraction) {
        return new FloatKeyframe(fraction);
    }

    @Nonnull
    public static Keyframe ofObject(float fraction, Object value) {
        return new ObjectKeyframe(fraction, value);
    }

    @Nonnull
    public static Keyframe ofObject(float fraction) {
        return new ObjectKeyframe(fraction, null);
    }

    public boolean hasValue() {
        return this.mHasValue;
    }

    public abstract Object getValue();

    public abstract void setValue(Object var1);

    public float getFraction() {
        return this.mFraction;
    }

    public void setFraction(float fraction) {
        this.mFraction = fraction;
    }

    @Nullable
    public TimeInterpolator getInterpolator() {
        return this.mInterpolator;
    }

    public void setInterpolator(@Nullable TimeInterpolator interpolator) {
        this.mInterpolator = interpolator;
    }

    @Nonnull
    public abstract Keyframe copy();

    static final class IntKeyframe
    extends Keyframe {
        int mValue;

        IntKeyframe(float fraction, int value) {
            this.mFraction = fraction;
            this.mValue = value;
            this.mHasValue = true;
        }

        IntKeyframe(float fraction) {
            this.mFraction = fraction;
        }

        public int getIntValue() {
            return this.mValue;
        }

        @Override
        public Integer getValue() {
            return this.mValue;
        }

        @Override
        public void setValue(Object value) {
            if (value instanceof Integer) {
                this.mValue = (Integer)value;
                this.mHasValue = true;
            }
        }

        @Override
        @Nonnull
        public IntKeyframe copy() {
            IntKeyframe kfClone = this.mHasValue ? new IntKeyframe(this.getFraction(), this.mValue) : new IntKeyframe(this.getFraction());
            kfClone.setInterpolator(this.getInterpolator());
            kfClone.mValueWasSetOnStart = this.mValueWasSetOnStart;
            return kfClone;
        }
    }

    static final class FloatKeyframe
    extends Keyframe {
        float mValue;

        FloatKeyframe(float fraction, float value) {
            this.mFraction = fraction;
            this.mValue = value;
            this.mHasValue = true;
        }

        FloatKeyframe(float fraction) {
            this.mFraction = fraction;
        }

        public float getFloatValue() {
            return this.mValue;
        }

        @Override
        public Float getValue() {
            return Float.valueOf(this.mValue);
        }

        @Override
        public void setValue(Object value) {
            if (value instanceof Float) {
                this.mValue = ((Float)value).floatValue();
                this.mHasValue = true;
            }
        }

        @Override
        @Nonnull
        public FloatKeyframe copy() {
            FloatKeyframe kfClone = this.mHasValue ? new FloatKeyframe(this.getFraction(), this.mValue) : new FloatKeyframe(this.getFraction());
            kfClone.setInterpolator(this.getInterpolator());
            kfClone.mValueWasSetOnStart = this.mValueWasSetOnStart;
            return kfClone;
        }
    }

    static final class ObjectKeyframe
    extends Keyframe {
        Object mValue;

        ObjectKeyframe(float fraction, Object value) {
            this.mFraction = fraction;
            this.mValue = value;
            this.mHasValue = value != null;
        }

        @Override
        public Object getValue() {
            return this.mValue;
        }

        @Override
        public void setValue(Object value) {
            this.mValue = value;
            this.mHasValue = value != null;
        }

        @Override
        @Nonnull
        public ObjectKeyframe copy() {
            ObjectKeyframe kfClone = new ObjectKeyframe(this.getFraction(), this.hasValue() ? this.mValue : null);
            kfClone.mValueWasSetOnStart = this.mValueWasSetOnStart;
            kfClone.setInterpolator(this.getInterpolator());
            return kfClone;
        }
    }
}

