/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.vulkan;

import icyllis.arc3d.engine.BackendFormat;
import icyllis.arc3d.engine.BackendImage;
import icyllis.arc3d.vulkan.VkBackendFormat;
import icyllis.arc3d.vulkan.VulkanAllocation;
import icyllis.arc3d.vulkan.VulkanImageDesc;
import icyllis.arc3d.vulkan.VulkanImageMutableState;
import javax.annotation.Nonnull;

public final class VulkanBackendImage
extends BackendImage {
    private static final int DEFAULT_USAGE_FLAGS = 23;
    private long mImage;
    public int mLevelCount = 0;
    public long mMemoryHandle = -1L;
    private VulkanAllocation mAlloc;
    private final VulkanImageDesc mInfo;
    final VulkanImageMutableState mState;
    private final BackendFormat mBackendFormat;

    public VulkanBackendImage(int width, int height, VulkanImageDesc desc) {
        this(width, height, desc, null, VkBackendFormat.make(desc.mFormat));
    }

    VulkanBackendImage(int width, int height, VulkanImageDesc desc, VulkanImageMutableState state, BackendFormat backendFormat) {
        super(desc, state);
        this.mInfo = desc;
        this.mState = state;
        this.mBackendFormat = backendFormat;
    }

    @Override
    public int getBackend() {
        return 1;
    }

    @Override
    public boolean isExternal() {
        return this.mBackendFormat.isExternal();
    }

    @Override
    public void setVkImageLayout(int layout) {
        this.mState.setImageLayout(layout);
    }

    @Override
    public void setVkQueueFamilyIndex(int queueFamilyIndex) {
        this.mState.setQueueFamilyIndex(queueFamilyIndex);
    }

    @Override
    @Nonnull
    public BackendFormat getBackendFormat() {
        return this.mBackendFormat;
    }

    @Override
    public boolean isProtected() {
        return this.mInfo.isProtected();
    }

    @Override
    public boolean isSameImage(BackendImage image) {
        if (image instanceof VulkanBackendImage) {
            VulkanBackendImage t = (VulkanBackendImage)image;
            return this.mImage == t.mImage;
        }
        return false;
    }
}

