/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.vulkan;

import icyllis.arc3d.engine.BackendFormat;
import icyllis.arc3d.vulkan.VKUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.lwjgl.system.NativeType;

@Immutable
public final class VkBackendFormat
extends BackendFormat {
    private static final Int2ObjectMap<VkBackendFormat> FORMATS = new Int2ObjectOpenHashMap(25);
    private final int mFormat;

    VkBackendFormat(@NativeType(value="VkFormat") int format) {
        this.mFormat = format;
    }

    @Nonnull
    public static VkBackendFormat make(@NativeType(value="VkFormat") int format) {
        int key = format;
        VkBackendFormat backendFormat = (VkBackendFormat)FORMATS.get(key);
        if (backendFormat != null) {
            return backendFormat;
        }
        backendFormat = new VkBackendFormat(format);
        if (backendFormat.getBytesPerBlock() != 0) {
            FORMATS.put(key, (Object)backendFormat);
        }
        return backendFormat;
    }

    @Override
    public int getBackend() {
        return 1;
    }

    @Override
    public int getChannelFlags() {
        return VKUtil.vkFormatChannels(this.mFormat);
    }

    @Override
    public int getVkFormat() {
        return this.mFormat;
    }

    @Override
    public boolean isSRGB() {
        return this.mFormat == 43;
    }

    @Override
    public int getCompressionType() {
        return VKUtil.vkFormatCompressionType(this.mFormat);
    }

    @Override
    public int getBytesPerBlock() {
        return VKUtil.vkFormatBytesPerBlock(this.mFormat);
    }

    @Override
    public int getDepthBits() {
        return VKUtil.vkFormatDepthBits(this.mFormat);
    }

    @Override
    public int getStencilBits() {
        return VKUtil.vkFormatStencilBits(this.mFormat);
    }

    @Override
    public int getFormatKey() {
        return this.mFormat;
    }

    public int hashCode() {
        return this.mFormat;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.mFormat == ((VkBackendFormat)o).mFormat;
    }

    public String toString() {
        return "{backend=Vulkan, format=" + VKUtil.vkFormatName(this.mFormat) + "}";
    }
}

