/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.opengl;

import icyllis.arc3d.engine.ManagedResource;
import icyllis.arc3d.opengl.GLDevice;
import javax.annotation.Nonnull;

public final class GLProgram
extends ManagedResource {
    private int mProgram;

    public GLProgram(@Nonnull GLDevice device, int program) {
        super(device);
        assert (program != 0);
        this.mProgram = program;
    }

    @Override
    protected void deallocate() {
        ((GLDevice)this.getDevice()).executeRenderCall(dev -> {
            if (this.mProgram != 0) {
                dev.getGL().glDeleteProgram(this.mProgram);
            }
            this.discard();
        });
    }

    public void discard() {
        this.mProgram = 0;
    }

    public int getProgram() {
        return this.mProgram;
    }
}

